/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.simpleapi.sql.mysql.queries;

import com.bencodez.votingplugin.simpleapi.sql.mysql.queries.QueryUtils;
import java.util.ArrayList;
import java.util.List;

public class CreateTableQuery {
    private List<String> columns = new ArrayList<String>();
    private boolean ifNotExists = false;
    private String primaryKey;
    private String table;

    public CreateTableQuery(String table) {
        this.table = table;
    }

    public String build() {
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE TABLE ");
        if (this.ifNotExists) {
            builder.append("IF NOT EXISTS ");
        }
        builder.append(this.table).append(" (").append(QueryUtils.separate(this.columns, ","));
        if (this.primaryKey != null) {
            builder.append(",PRIMARY KEY(");
            builder.append(this.primaryKey);
            builder.append(")");
        }
        builder.append(")");
        return builder.toString();
    }

    public CreateTableQuery column(String column, String settings) {
        this.columns.add(column + " " + settings);
        return this;
    }

    public CreateTableQuery ifNotExists() {
        this.ifNotExists = true;
        return this;
    }

    public CreateTableQuery primaryKey(String column) {
        this.primaryKey = column;
        return this;
    }
}

