/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.simpleapi.sql.mysql;

import com.bencodez.votingplugin.simpleapi.sql.mysql.ConnectionManager;
import com.bencodez.votingplugin.simpleapi.sql.mysql.config.MysqlConfig;
import java.sql.SQLException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public abstract class MySQL {
    private ConnectionManager connectionManager;
    private int maxConnections;
    private ExecutorService threadPool;

    public MySQL() {
        this.threadPool = Executors.newFixedThreadPool(10);
        this.maxConnections = 1;
    }

    public MySQL(int maxConnections) {
        this.maxConnections = maxConnections;
        this.threadPool = Executors.newFixedThreadPool(Math.max(1, maxConnections));
    }

    public boolean connect(MysqlConfig config) {
        this.maxConnections = Math.max(1, config.getMaxThreads());
        if (this.threadPool != null) {
            this.threadPool.shutdown();
        }
        this.threadPool = Executors.newFixedThreadPool(this.maxConnections);
        this.connectionManager = new ConnectionManager(config.getHostName(), String.valueOf(config.getPort()), config.getUser(), config.getPass(), config.getDatabase(), this.maxConnections, config.isUseSSL(), config.getLifeTime(), config.getLine() == null ? "" : config.getLine(), config.isPublicKeyRetrieval(), config.isUseMariaDB());
        if (config.getMinimumIdle() > 0) {
            this.connectionManager.setMinimumIdle(config.getMinimumIdle());
        }
        if (config.getIdleTimeoutMs() > 0L) {
            this.connectionManager.setIdleTimeoutMs(config.getIdleTimeoutMs());
        }
        if (config.getKeepaliveMs() > 0L) {
            this.connectionManager.setKeepaliveMs(config.getKeepaliveMs());
        }
        if (config.getValidationMs() > 0L) {
            this.connectionManager.setValidationMs(config.getValidationMs());
        }
        if (config.getLeakDetectMs() > 0L) {
            this.connectionManager.setLeakDetectMs(config.getLeakDetectMs());
        }
        if (config.getConnectionTimeout() > 0) {
            this.connectionManager.setConnectionTimeout(config.getConnectionTimeout());
        }
        if (config.getLifeTime() > 0L) {
            this.connectionManager.setMaxLifetimeMs(config.getLifeTime());
        }
        if (config.getPoolName() != null && !config.getPoolName().isEmpty()) {
            this.connectionManager.setPoolName(config.getPoolName());
        }
        boolean ok = this.connectionManager.open();
        if (config.isDebug()) {
            if (ok) {
                this.debug("MySQL connected. host=" + config.getHostName() + " db=" + config.getDatabase() + " maxPool=" + this.maxConnections);
            } else {
                this.debug("MySQL connection failed. Check host/port/credentials and timeouts.");
            }
        }
        return ok;
    }

    public abstract void debug(SQLException var1);

    public abstract void debug(String var1);

    public void disconnect() {
        if (this.connectionManager != null) {
            this.connectionManager.close();
        }
        if (this.threadPool != null) {
            this.threadPool.shutdown();
        }
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public abstract void severe(String var1);
}

