/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.simpleapi.sql.mysql;

import com.bencodez.votingplugin.simpleapi.hikari.HikariConfig;
import com.bencodez.votingplugin.simpleapi.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import lombok.Generated;

public class ConnectionManager {
    private int connectionTimeout = 50000;
    private String database;
    private HikariDataSource dataSource;
    private String host;
    private int maximumPoolsize = 5;
    private long maxLifetimeMs = 0L;
    private long idleTimeoutMs = 600000L;
    private long keepaliveMs = 300000L;
    private long validationMs = 5000L;
    private long leakDetectMs = 20000L;
    private int minimumIdle = -1;
    private String password;
    private String port;
    private boolean publicKeyRetrieval;
    private String str = "";
    private String username;
    private boolean useSSL = false;
    private boolean useMariaDB = false;
    private String mysqlDriver = "";
    private String poolName = "SimpleAPI-Hikari";

    public ConnectionManager(String host, String port, String username, String password, String database) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.database = database;
    }

    public ConnectionManager(String host, String port, String username, String password, String database, int maxConnections, boolean useSSL, long lifeTime, String str, boolean publicKeyRetrieval, boolean useMariaDB) {
        this(host, port, username, password, database);
        this.maximumPoolsize = maxConnections;
        this.useSSL = useSSL;
        this.maxLifetimeMs = lifeTime;
        this.str = str == null ? "" : str;
        this.publicKeyRetrieval = publicKeyRetrieval;
        this.useMariaDB = useMariaDB;
    }

    public boolean isClosed() {
        return this.dataSource == null || this.dataSource.isClosed();
    }

    public void close() {
        if (!this.isClosed()) {
            this.dataSource.close();
        }
    }

    public Connection getConnection() {
        try {
            if (this.isClosed()) {
                this.open();
            }
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.open();
            return null;
        }
    }

    private String getMysqlDriverName() {
        String className = this.useMariaDB ? "org.mariadb.jdbc.Driver" : "com.mysql.cj.jdbc.Driver";
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException ignored) {
            className = "com.mysql.cj.jdbc.Driver";
            try {
                Class.forName(className);
            }
            catch (ClassNotFoundException ignored1) {
                try {
                    className = "com.mysql.jdbc.Driver";
                    Class.forName(className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        return className;
    }

    public boolean open() {
        if (this.mysqlDriver.isEmpty()) {
            this.mysqlDriver = this.getMysqlDriverName();
        }
        try {
            HikariConfig cfg = new HikariConfig();
            cfg.setDriverClassName(this.mysqlDriver);
            cfg.setUsername(this.username);
            cfg.setPassword(this.password);
            String base = this.mysqlDriver.equals("org.mariadb.jdbc.Driver") ? String.format("jdbc:mariadb://%s:%s/%s", this.host, this.port, this.database) : String.format("jdbc:mysql://%s:%s/%s", this.host, this.port, this.database);
            String url = base + "?useSSL=" + this.useSSL + "&allowMultiQueries=true&rewriteBatchedStatements=true&useDynamicCharsetInfo=false&allowPublicKeyRetrieval=" + this.publicKeyRetrieval + "&tcpKeepAlive=true&connectTimeout=10000&socketTimeout=30000&serverTimezone=UTC" + (this.str == null ? "" : this.str);
            cfg.setJdbcUrl(url);
            int maxPool = Math.max(1, this.maximumPoolsize);
            cfg.setMaximumPoolSize(maxPool);
            int minIdle = this.minimumIdle >= 0 ? Math.min(this.minimumIdle, maxPool) : Math.min(2, maxPool);
            cfg.setMinimumIdle(Math.max(0, minIdle));
            cfg.setConnectionTimeout(Math.max(1000L, (long)this.connectionTimeout));
            long effectiveMaxLife = this.maxLifetimeMs > 0L ? this.maxLifetimeMs : 1500000L;
            cfg.setMaxLifetime(effectiveMaxLife);
            long effectiveIdle = Math.min(this.idleTimeoutMs, Math.max(1000L, effectiveMaxLife - 60000L));
            cfg.setIdleTimeout(effectiveIdle);
            if (this.keepaliveMs > 0L) {
                cfg.setKeepaliveTime(this.keepaliveMs);
            }
            if (this.validationMs > 0L) {
                cfg.setValidationTimeout(this.validationMs);
            }
            if (this.leakDetectMs > 0L) {
                cfg.setLeakDetectionThreshold(this.leakDetectMs);
            }
            cfg.setConnectionTestQuery("SELECT 1");
            cfg.addDataSourceProperty("cachePrepStmts", true);
            cfg.addDataSourceProperty("prepStmtCacheSize", 500);
            cfg.addDataSourceProperty("prepStmtCacheSqlLimit", 2048);
            cfg.addDataSourceProperty("useServerPrepStmts", true);
            cfg.setAutoCommit(true);
            cfg.setPoolName("SimpleAPI-Hikari");
            this.dataSource = new HikariDataSource(cfg);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Generated
    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Generated
    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @Generated
    public String getDatabase() {
        return this.database;
    }

    @Generated
    public void setDatabase(String database) {
        this.database = database;
    }

    @Generated
    public HikariDataSource getDataSource() {
        return this.dataSource;
    }

    @Generated
    public void setDataSource(HikariDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public void setHost(String host) {
        this.host = host;
    }

    @Generated
    public int getMaximumPoolsize() {
        return this.maximumPoolsize;
    }

    @Generated
    public void setMaximumPoolsize(int maximumPoolsize) {
        this.maximumPoolsize = maximumPoolsize;
    }

    @Generated
    public long getMaxLifetimeMs() {
        return this.maxLifetimeMs;
    }

    @Generated
    public void setMaxLifetimeMs(long maxLifetimeMs) {
        this.maxLifetimeMs = maxLifetimeMs;
    }

    @Generated
    public long getIdleTimeoutMs() {
        return this.idleTimeoutMs;
    }

    @Generated
    public void setIdleTimeoutMs(long idleTimeoutMs) {
        this.idleTimeoutMs = idleTimeoutMs;
    }

    @Generated
    public long getKeepaliveMs() {
        return this.keepaliveMs;
    }

    @Generated
    public void setKeepaliveMs(long keepaliveMs) {
        this.keepaliveMs = keepaliveMs;
    }

    @Generated
    public long getValidationMs() {
        return this.validationMs;
    }

    @Generated
    public void setValidationMs(long validationMs) {
        this.validationMs = validationMs;
    }

    @Generated
    public long getLeakDetectMs() {
        return this.leakDetectMs;
    }

    @Generated
    public void setLeakDetectMs(long leakDetectMs) {
        this.leakDetectMs = leakDetectMs;
    }

    @Generated
    public int getMinimumIdle() {
        return this.minimumIdle;
    }

    @Generated
    public void setMinimumIdle(int minimumIdle) {
        this.minimumIdle = minimumIdle;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public String getPort() {
        return this.port;
    }

    @Generated
    public void setPort(String port) {
        this.port = port;
    }

    @Generated
    public boolean isPublicKeyRetrieval() {
        return this.publicKeyRetrieval;
    }

    @Generated
    public void setPublicKeyRetrieval(boolean publicKeyRetrieval) {
        this.publicKeyRetrieval = publicKeyRetrieval;
    }

    @Generated
    public String getStr() {
        return this.str;
    }

    @Generated
    public void setStr(String str) {
        this.str = str;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public boolean isUseSSL() {
        return this.useSSL;
    }

    @Generated
    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    @Generated
    public boolean isUseMariaDB() {
        return this.useMariaDB;
    }

    @Generated
    public void setUseMariaDB(boolean useMariaDB) {
        this.useMariaDB = useMariaDB;
    }

    @Generated
    public String getMysqlDriver() {
        return this.mysqlDriver;
    }

    @Generated
    public void setMysqlDriver(String mysqlDriver) {
        this.mysqlDriver = mysqlDriver;
    }

    @Generated
    public String getPoolName() {
        return this.poolName;
    }

    @Generated
    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }
}

