/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.simpleapi.skull;

import com.bencodez.votingplugin.simpleapi.skull.SkullCache;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public abstract class SkullCacheHandler {
    private int skullDelayTime = 4000;
    Queue<String> skullsToLoad = new ConcurrentLinkedQueue<String>();
    private boolean pause = false;
    private String bedrockPrefix = ".";
    private ScheduledExecutorService timer = Executors.newScheduledThreadPool(1);

    public SkullCacheHandler() {
    }

    public SkullCacheHandler(int skullDelayTime) {
        this.skullDelayTime = skullDelayTime;
    }

    public void addToCache(UUID uuid, String name) {
        String text = uuid.toString() + "/" + name;
        if (uuid.toString().charAt(14) == '3') {
            this.debugLog("Can't cache skull of offline player uuid: " + uuid.toString() + "/" + name);
            return;
        }
        if (name.startsWith(this.bedrockPrefix)) {
            this.debugLog("Can't cache skull of bedrock player");
            return;
        }
        if (!this.skullsToLoad.contains(text) && !SkullCache.isLoaded(uuid)) {
            if (name.length() <= 16) {
                this.skullsToLoad.add(text);
            } else {
                this.debugLog("Player name too long to preload skull: " + uuid.toString() + "/" + name);
            }
        }
    }

    public void changeApiProfileURL(String url) {
        SkullCache.setApi_profile_link(url);
    }

    public void close() {
        this.timer.shutdownNow();
    }

    public abstract void debugException(Exception var1);

    public abstract void debugLog(String var1);

    public void flushCache() {
        SkullCache.flushWeek();
    }

    public ItemStack getSkull(UUID uuid, String playerName) {
        ItemStack skullItem;
        try {
            Material skullMaterial = Material.valueOf((String)"PLAYER_HEAD");
            skullItem = new ItemStack(skullMaterial);
        }
        catch (IllegalArgumentException e) {
            Material skullMaterial = Material.valueOf((String)"SKULL_ITEM");
            skullItem = new ItemStack(skullMaterial, 1, 3);
        }
        if (playerName.length() > 16 || this.pause && !SkullCache.isLoaded(uuid) || uuid.toString().charAt(14) == '3') {
            return skullItem;
        }
        try {
            return SkullCache.getSkull(uuid, playerName);
        }
        catch (Exception e) {
            this.pauseCaching();
            return skullItem;
        }
    }

    public abstract void log(String var1);

    public void pauseCaching() {
        this.log("Pausing skull caching due to hitting rate limit or an error, increasing delay for caching");
        this.pause = true;
        this.skullDelayTime += 3000;
        this.timer.schedule(new Runnable(){

            @Override
            public void run() {
                SkullCacheHandler.this.unPuase();
            }
        }, 15L, TimeUnit.MINUTES);
    }

    public void startTimer() {
        this.timer.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                if (!SkullCacheHandler.this.skullsToLoad.isEmpty() && !SkullCacheHandler.this.pause) {
                    String text = SkullCacheHandler.this.skullsToLoad.remove();
                    try {
                        String[] data = text.split("/");
                        String uuid = data[0];
                        String name = data[1];
                        SkullCache.cacheSkull(UUID.fromString(uuid), name);
                        SkullCacheHandler.this.debugLog("Loaded skull: " + uuid + "/" + name);
                    }
                    catch (Exception e) {
                        SkullCacheHandler.this.debugLog("Failed to load skull: " + text);
                        SkullCacheHandler.this.debugException(e);
                        SkullCacheHandler.this.pauseCaching();
                    }
                }
            }
        }, 20000L, this.skullDelayTime, TimeUnit.MILLISECONDS);
    }

    private void unPuase() {
        this.pause = false;
    }

    @Generated
    public int getSkullDelayTime() {
        return this.skullDelayTime;
    }

    @Generated
    public String getBedrockPrefix() {
        return this.bedrockPrefix;
    }

    @Generated
    public void setBedrockPrefix(String bedrockPrefix) {
        this.bedrockPrefix = bedrockPrefix;
    }
}

