/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.simpleapi.skull;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.net.ssl.HttpsURLConnection;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;

public class SkullCache {
    private static final ConcurrentHashMap<UUID, ItemStack> skullMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<UUID, Long> timeMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, ItemStack> skullBase64Map = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Long> timeBase64Map = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, ItemStack> skullURLMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Long> timeURLMap = new ConcurrentHashMap();
    private static JsonParser parser = new JsonParser();
    private static String api_profile_link = "https://sessionserver.mojang.com/session/minecraft/profile/";

    public static void cacheSkull(OfflinePlayer offlinePlayer) throws IOException {
        SkullCache.cacheSkull(offlinePlayer.getUniqueId(), offlinePlayer.getName());
    }

    public static void cacheSkull(Player player) throws IOException {
        SkullCache.cacheSkull(player.getUniqueId(), player.getName());
    }

    public static void cacheSkull(UUID uuid, String name) throws IOException {
        skullMap.put(uuid, SkullCache.itemWithUuid(uuid, name));
        timeMap.put(uuid, System.currentTimeMillis());
    }

    public static void cacheSkullBase64(String base64) {
        skullBase64Map.put(base64, SkullCache.itemWithBase64(base64));
        timeBase64Map.put(base64, System.currentTimeMillis());
    }

    public static void cacheSkulls(HashMap<UUID, String> uuids) {
        new Thread(() -> {
            long start = System.currentTimeMillis();
            for (Map.Entry entry : uuids.entrySet()) {
                try {
                    skullMap.put((UUID)entry.getKey(), SkullCache.itemWithUuid((UUID)entry.getKey(), (String)entry.getValue()));
                    timeMap.put((UUID)entry.getKey(), System.currentTimeMillis());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            Inventory inventory = Bukkit.createInventory(null, (int)54, (String)"Skull Cache Test");
            int i = 0;
            for (Map.Entry entry : uuids.entrySet()) {
                if (i >= Math.min(54, uuids.size())) continue;
                try {
                    inventory.setItem(i, SkullCache.getSkull((UUID)entry.getKey(), (String)entry.getValue()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++i;
            }
            inventory.clear();
            Bukkit.getLogger().log(Level.INFO, ChatColor.GREEN + "[SkullCache] Cached " + uuids.size() + " skulls in " + (System.currentTimeMillis() - start) + "ms.");
        }).start();
    }

    public static void cacheSkulls(OfflinePlayer[] offlinePlayers) {
        HashMap<UUID, String> map = new HashMap<UUID, String>();
        for (OfflinePlayer p : offlinePlayers) {
            map.put(p.getUniqueId(), p.getName());
        }
        SkullCache.cacheSkulls(map);
    }

    public static void cacheSkulls(Player[] players) {
        HashMap<UUID, String> map = new HashMap<UUID, String>();
        for (Player p : players) {
            map.put(p.getUniqueId(), p.getName());
        }
        SkullCache.cacheSkulls(map);
    }

    public static void cacheSkullURL(String url) {
        skullURLMap.put(url, SkullCache.itemWithURL(url));
        timeURLMap.put(url, System.currentTimeMillis());
    }

    public static void flush(long milliseconds) {
        for (UUID uuid : skullMap.keySet()) {
            if (System.currentTimeMillis() - timeMap.get(uuid) <= milliseconds) continue;
            skullMap.remove(uuid);
            timeMap.remove(uuid);
        }
        for (String base64 : skullBase64Map.keySet()) {
            if (System.currentTimeMillis() - timeBase64Map.get(base64) <= milliseconds) continue;
            skullBase64Map.remove(base64);
            timeBase64Map.remove(base64);
        }
        for (String url : skullURLMap.keySet()) {
            if (System.currentTimeMillis() - timeURLMap.get(url) <= milliseconds) continue;
            skullURLMap.remove(url);
            timeURLMap.remove(url);
        }
    }

    public static void flushWeek() {
        SkullCache.flush(604800000L);
    }

    public static String getContent(String link) throws IOException {
        try {
            String inputLine;
            URL url = new URL(link);
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String outputLine = "";
            while ((inputLine = br.readLine()) != null) {
                outputLine = outputLine + inputLine;
            }
            br.close();
            return outputLine;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getSkinUrl(String uuid) throws IOException {
        String json = SkullCache.getContent(api_profile_link + uuid);
        JsonObject o = parser.parse(json).getAsJsonObject();
        String jsonBase64 = o.get("properties").getAsJsonArray().get(0).getAsJsonObject().get("value").getAsString();
        o = parser.parse(new String(Base64.getDecoder().decode(jsonBase64))).getAsJsonObject();
        String skinUrl = o.get("textures").getAsJsonObject().get("SKIN").getAsJsonObject().get("url").getAsString();
        return skinUrl;
    }

    public static ItemStack getSkull(OfflinePlayer offlinePlayer) throws IOException {
        return SkullCache.getSkull(offlinePlayer.getUniqueId(), offlinePlayer.getName());
    }

    public static ItemStack getSkull(Player player) throws IOException {
        return SkullCache.getSkull(player.getUniqueId(), player.getName());
    }

    public static ItemStack getSkull(String url) {
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
        if (url == null || url.isEmpty()) {
            return skull;
        }
        SkullMeta skullMeta = (SkullMeta)skull.getItemMeta();
        PlayerProfile profile = Bukkit.getServer().createPlayerProfile(UUID.randomUUID());
        try {
            profile.getTextures().setSkin(new URL(url));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        skullMeta.setOwnerProfile(profile);
        skull.setItemMeta((ItemMeta)skullMeta);
        return skull;
    }

    public static ItemStack getSkull(String url, UUID uuid) throws MalformedURLException, IOException {
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
        if (url == null || url.isEmpty()) {
            return skull;
        }
        SkullMeta skullMeta = (SkullMeta)skull.getItemMeta();
        PlayerProfile profile = Bukkit.getServer().createPlayerProfile(uuid);
        profile.getTextures().setSkin(new URL(SkullCache.getSkinUrl(uuid.toString())));
        skullMeta.setOwnerProfile(profile);
        skull.setItemMeta((ItemMeta)skullMeta);
        return skull;
    }

    public static ItemStack getSkull(UUID uuid, String name) throws IOException {
        timeMap.put(uuid, System.currentTimeMillis());
        ItemStack skull = skullMap.get(uuid);
        if (skull == null) {
            skull = SkullCache.itemWithUuid(uuid, name);
            SkullCache.cacheSkull(uuid, name);
        }
        return skull;
    }

    public static ItemStack getSkullBase64(String base64) {
        timeBase64Map.put(base64, System.currentTimeMillis());
        ItemStack skull = skullBase64Map.get(base64);
        if (skull == null) {
            skull = SkullCache.itemWithBase64(base64);
            SkullCache.cacheSkullBase64(base64);
        }
        return skull;
    }

    public static ItemStack[] getSkulls(HashMap<UUID, String> players) throws IOException {
        ItemStack[] itemStacks = new ItemStack[players.size()];
        int i = 0;
        for (Map.Entry<UUID, String> entry : players.entrySet()) {
            timeMap.put(entry.getKey(), System.currentTimeMillis());
            itemStacks[i] = SkullCache.getSkull(entry.getKey(), entry.getValue());
            ++i;
        }
        return itemStacks;
    }

    public static ItemStack[] getSkulls(OfflinePlayer[] offlinePlayers) throws IOException {
        HashMap<UUID, String> map = new HashMap<UUID, String>();
        for (OfflinePlayer p : offlinePlayers) {
            map.put(p.getUniqueId(), p.getName());
        }
        return SkullCache.getSkulls(map);
    }

    public static ItemStack[] getSkulls(Player[] players) throws IOException {
        HashMap<UUID, String> map = new HashMap<UUID, String>();
        for (Player p : players) {
            map.put(p.getUniqueId(), p.getName());
        }
        return SkullCache.getSkulls(map);
    }

    public static ItemStack getSkullURL(String url) {
        timeURLMap.put(url, System.currentTimeMillis());
        ItemStack skull = skullURLMap.get(url);
        if (skull == null) {
            skull = SkullCache.itemWithURL(url);
            SkullCache.cacheSkullURL(url);
        }
        return skull;
    }

    public static String getUrlFromBase64(String base64) {
        String decoded = new String(Base64.getDecoder().decode(base64));
        return decoded.substring("{\"textures\":{\"SKIN\":{\"url\":\"".length(), decoded.length() - "\"}}}".length());
    }

    public static boolean isLoaded(UUID uuid) {
        return skullMap.containsKey(uuid);
    }

    public static ItemStack itemWithBase64(String base64) {
        return SkullCache.getSkull(SkullCache.getUrlFromBase64(base64));
    }

    public static ItemStack itemWithURL(String url) {
        return SkullCache.getSkull(url);
    }

    public static ItemStack itemWithUuid(UUID id, String playerName) throws IOException {
        SkullCache.notNull(id, "id");
        return SkullCache.getSkull(SkullCache.getSkinUrl(id.toString()), id);
    }

    private static void notNull(Object o, String name) {
        if (o == null) {
            throw new NullPointerException(name + " should not be null!");
        }
    }

    @Generated
    public static String getApi_profile_link() {
        return api_profile_link;
    }

    @Generated
    public static void setApi_profile_link(String api_profile_link) {
        SkullCache.api_profile_link = api_profile_link;
    }
}

