/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.simpleapi.servercomm.sockets;

import com.bencodez.votingplugin.simpleapi.encryption.EncryptionHandler;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import lombok.Generated;

public abstract class SocketServer
extends Thread {
    private boolean debug = false;
    private EncryptionHandler encryptionHandler;
    private String host;
    private int port;
    private boolean running = true;
    private ServerSocket server;
    private int restartCount = 0;

    public SocketServer(String version, String host, int port, EncryptionHandler handle, boolean debug) {
        super(version);
        this.host = host;
        this.port = port;
        this.encryptionHandler = handle;
        this.debug = debug;
        try {
            this.server = new ServerSocket();
            this.server.bind(new InetSocketAddress(host, port));
            this.start();
        }
        catch (IOException e) {
            System.out.println("Failed to bind to " + host + ":" + port);
            e.printStackTrace();
            this.close();
        }
    }

    private void restartServer() {
        if (this.restartCount > 5) {
            this.logger("Failed to restart server socket on " + this.host + ":" + this.port + " after 10 attempts, closing server");
            this.close();
            return;
        }
        try {
            this.server.close();
            this.server = new ServerSocket();
            this.server.bind(new InetSocketAddress(this.host, this.port));
        }
        catch (Exception e) {
            this.logger("Failed to restart server socket on " + this.host + ":" + this.port);
            e.printStackTrace();
        }
        ++this.restartCount;
    }

    public void close() {
        try {
            this.running = false;
            this.server.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public abstract void logger(String var1);

    public abstract void onReceive(String[] var1);

    @Override
    public void run() {
        while (this.running) {
            try {
                Socket socket = this.server.accept();
                socket.setSoTimeout(5000);
                DataInputStream dis = new DataInputStream(socket.getInputStream());
                String msg = this.encryptionHandler.decrypt(dis.readUTF());
                if (this.debug) {
                    this.logger("Debug: Socket Receiving: " + msg);
                }
                this.onReceive(msg.split("%line%"));
                dis.close();
                socket.close();
            }
            catch (EOFException e) {
                this.logger("Error occured while receiving socket message, enable debug to see more: " + e.getMessage());
                if (!this.debug) continue;
                e.printStackTrace();
            }
            catch (Exception ex) {
                this.logger("Error occured while receiving socket message");
                ex.printStackTrace();
                this.restartServer();
            }
        }
    }

    @Generated
    public boolean isDebug() {
        return this.debug;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public int getPort() {
        return this.port;
    }
}

