/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.simpleapi.servercomm.sockets;

import com.bencodez.votingplugin.simpleapi.encryption.EncryptionHandler;
import com.bencodez.votingplugin.simpleapi.servercomm.sockets.SocketReceiver;
import com.bencodez.votingplugin.simpleapi.servercomm.sockets.SocketServer;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public abstract class SocketHandler {
    private ArrayList<SocketReceiver> receiving;
    private SocketServer server;
    private ScheduledExecutorService timer = Executors.newSingleThreadScheduledExecutor();

    public SocketHandler(String threadName, String host, int port, EncryptionHandler handle) {
        this.start(threadName, host, port, handle, false);
    }

    public SocketHandler(String threadName, String host, int port, EncryptionHandler handle, boolean debug) {
        this.start(threadName, host, port, handle, debug);
    }

    public void add(SocketReceiver receive) {
        this.receiving.add(receive);
    }

    public void closeConnection() {
        this.server.close();
        this.server = null;
        if (this.timer != null) {
            this.timer.shutdownNow();
            this.timer = null;
        }
    }

    public abstract void log(String var1);

    public void start(String threadName, String host, int port, EncryptionHandler handle, boolean debug) {
        this.receiving = new ArrayList();
        this.server = new SocketServer(threadName, host, port, handle, debug){

            @Override
            public void logger(String str) {
                SocketHandler.this.log(str);
            }

            @Override
            public void onReceive(final String[] data) {
                if (data.length > 0) {
                    for (final SocketReceiver r : SocketHandler.this.receiving) {
                        if (r.getSocketDelay() > 0) {
                            SocketHandler.this.timer.schedule(new Runnable(){

                                @Override
                                public void run() {
                                    r.onReceive(data[0], data);
                                }
                            }, (long)r.getSocketDelay(), TimeUnit.MILLISECONDS);
                            continue;
                        }
                        SocketHandler.this.timer.submit(new Runnable(){

                            @Override
                            public void run() {
                                r.onReceive(data[0], data);
                            }
                        });
                    }
                } else {
                    SocketHandler.this.log("Socket data invalid");
                }
            }
        };
        this.log("Loading socket server: " + this.server.getHost() + ":" + this.server.getPort());
    }

    @Generated
    public ArrayList<SocketReceiver> getReceiving() {
        return this.receiving;
    }

    @Generated
    public SocketServer getServer() {
        return this.server;
    }
}

