/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.simpleapi.servercomm.sockets;

import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import com.bencodez.votingplugin.simpleapi.encryption.EncryptionHandler;
import java.io.DataOutputStream;
import java.net.Socket;

public class ClientHandler {
    private Socket clientSocket;
    private boolean debug = false;
    private EncryptionHandler encryptionHandler;
    private String host;
    private int port;

    public ClientHandler(String host, int port, EncryptionHandler handle) {
        this.host = host;
        this.port = port;
        this.encryptionHandler = handle;
    }

    public ClientHandler(String host, int port, EncryptionHandler handle, boolean debug) {
        this.host = host;
        this.port = port;
        this.encryptionHandler = handle;
        this.debug = debug;
    }

    private void connect() {
        try {
            if (this.clientSocket != null) {
                this.clientSocket.close();
            }
            this.clientSocket = new Socket(this.host, this.port);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(boolean debug, String ... msgs) {
        if (debug) {
            System.out.println("Socket Sending: " + ArrayUtils.makeStringList(ArrayUtils.convert(msgs)));
        }
        String msg = msgs[0];
        for (int i = 1; i < msgs.length; ++i) {
            msg = msg + "%line%";
            msg = msg + msgs[i];
        }
        this.connect();
        if (this.clientSocket == null || this.clientSocket.isClosed()) {
            System.out.println("Failed to connect to " + this.host + ":" + this.port + " to send message: " + msg);
            return;
        }
        String encrypted = this.encryptionHandler.encrypt(msg);
        try (DataOutputStream ds = new DataOutputStream(this.clientSocket.getOutputStream());){
            ds.writeUTF(encrypted);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        finally {
            this.stopConnection();
        }
    }

    public void sendMessage(String ... msgs) {
        this.sendMessage(this.debug, msgs);
    }

    public void stopConnection() {
        try {
            if (this.clientSocket != null) {
                this.clientSocket.close();
                this.clientSocket = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

