/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.simpleapi.servercomm.redis;

import com.bencodez.votingplugin.simpleapi.servercomm.redis.RedisListener;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public abstract class RedisHandler {
    private final JedisPool publishPool;
    private final JedisPool subscribePool;
    private final Map<RedisListener, Thread> listenerThreads = new ConcurrentHashMap<RedisListener, Thread>();

    public RedisHandler(String host, int port, String username, String password) {
        int timeout = 2000;
        if (username.isEmpty() && password.isEmpty()) {
            this.publishPool = new JedisPool((GenericObjectPoolConfig<Jedis>)new JedisPoolConfig(), host, port, timeout);
            this.subscribePool = new JedisPool((GenericObjectPoolConfig<Jedis>)new JedisPoolConfig(), host, port, timeout);
        } else if (username.isEmpty()) {
            this.publishPool = new JedisPool((GenericObjectPoolConfig<Jedis>)new JedisPoolConfig(), host, port, timeout, password);
            this.subscribePool = new JedisPool((GenericObjectPoolConfig<Jedis>)new JedisPoolConfig(), host, port, timeout, password);
        } else {
            this.publishPool = new JedisPool((GenericObjectPoolConfig<Jedis>)new JedisPoolConfig(), host, port, timeout, username, password);
            this.subscribePool = new JedisPool((GenericObjectPoolConfig<Jedis>)new JedisPoolConfig(), host, port, timeout, username, password);
        }
    }

    public void close() {
        this.debug("Shutting down RedisHandler");
        for (Map.Entry<RedisListener, Thread> entry : this.listenerThreads.entrySet()) {
            RedisListener listener = entry.getKey();
            Thread thread = entry.getValue();
            try {
                this.debug("Unsubscribing Redis listener on channel: " + listener.getChannel());
                listener.unsubscribe();
            }
            catch (Exception e) {
                this.debug("Failed to unsubscribe listener: " + e.getMessage());
            }
            try {
                if (thread == null || !thread.isAlive()) continue;
                thread.join(2000L);
            }
            catch (InterruptedException e) {
                this.debug("Interrupted while waiting for Redis listener thread to finish: " + e.getMessage());
            }
        }
        this.listenerThreads.clear();
        this.publishPool.close();
        this.subscribePool.close();
    }

    public void loadListener(RedisListener listener) {
        Thread thread = new Thread(() -> {
            try (Jedis jedis = this.subscribePool.getResource();){
                this.debug("Starting Redis subscription for channel: " + listener.getChannel());
                jedis.subscribe(listener, listener.getChannel());
            }
            catch (Exception e) {
                this.debug("Redis subscribe error on channel " + listener.getChannel() + ": " + e.getMessage());
            }
        }, "RedisSubscribeThread-" + listener.getChannel());
        thread.setDaemon(true);
        this.listenerThreads.put(listener, thread);
        thread.start();
    }

    public abstract void debug(String var1);

    protected abstract void onMessage(String var1, String[] var2);

    public void sendMessage(String channel, String ... message) {
        String str = String.join((CharSequence)":", message);
        try (Jedis jedis = this.publishPool.getResource();){
            this.debug("Redis Send: " + channel + ", " + str);
            jedis.publish(channel, str);
        }
    }
}

