/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.simpleapi.servercomm.pluginmessage;

import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import com.bencodez.votingplugin.simpleapi.encryption.EncryptionHandler;
import com.bencodez.votingplugin.simpleapi.servercomm.pluginmessage.PluginMessageHandler;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class PluginMessage
implements PluginMessageListener {
    private boolean debug = false;
    private EncryptionHandler encryptionHandler;
    private JavaPlugin plugin;
    private ScheduledExecutorService timer = Executors.newSingleThreadScheduledExecutor();
    public ArrayList<PluginMessageHandler> pluginMessages = new ArrayList();
    private String bungeeChannel;

    public PluginMessage(JavaPlugin plugin, String bungeeChannel) {
        this.plugin = plugin;
        this.bungeeChannel = bungeeChannel;
    }

    public void add(PluginMessageHandler handle) {
        this.pluginMessages.add(handle);
    }

    public ArrayList<PluginMessageHandler> getPluginMessages() {
        return this.pluginMessages;
    }

    public void shutdown() {
        this.timer.shutdown();
    }

    public void onPluginMessageReceived(String channel, Player player, byte[] message) {
        if (!channel.equals(this.bungeeChannel)) {
            return;
        }
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message);
        String data = "";
        String subChannel1 = "";
        if (this.encryptionHandler != null) {
            try {
                subChannel1 = this.encryptionHandler.decrypt(in.readUTF());
            }
            catch (Exception e) {
                if (this.debug) {
                    e.printStackTrace();
                }
                this.plugin.getLogger().warning("Error reading plugin message: " + e.getMessage());
                return;
            }
        } else {
            subChannel1 = in.readUTF();
        }
        String subChannel = subChannel1;
        int size = in.readInt();
        if (size < 0 || size > message.length) {
            this.plugin.getLogger().warning("Invalid message size: " + size);
            return;
        }
        try {
            data = this.encryptionHandler != null ? this.encryptionHandler.decrypt(in.readUTF()) : in.readUTF();
            String[] list = data.split("/a/");
            ArrayList<String> list1 = new ArrayList<String>();
            for (String s : list) {
                list1.add(s);
            }
            this.timer.submit(() -> this.onReceive(subChannel, list1));
        }
        catch (Exception e) {
            if (this.debug) {
                e.printStackTrace();
            }
            this.plugin.getLogger().warning("Error reading plugin message: " + e.getMessage());
        }
    }

    public void onReceive(String subChannel, ArrayList<String> list) {
        if (this.debug) {
            this.plugin.getLogger().info("BungeeDebug: Received plugin message: " + subChannel + ", " + ArrayUtils.makeStringList(list));
        }
        for (PluginMessageHandler handle : this.pluginMessages) {
            if (handle.getSubChannel() != null && !handle.getSubChannel().equalsIgnoreCase(subChannel)) continue;
            handle.onRecieve(subChannel, list);
        }
    }

    public void sendPluginMessage(String channel, String ... messageData) {
        ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteOutStream);
        try {
            if (this.encryptionHandler != null) {
                out.writeUTF(this.encryptionHandler.encrypt(channel));
            } else {
                out.writeUTF(channel);
            }
            out.writeInt(messageData.length);
            String data = "";
            for (String message : messageData) {
                data = data + message + "/a/";
            }
            if (this.encryptionHandler != null) {
                out.writeUTF(this.encryptionHandler.encrypt(data));
            } else {
                out.writeUTF(data);
            }
            if (this.debug) {
                this.plugin.getLogger().info("BungeeDebug: Sending plugin message: " + channel + ", " + ArrayUtils.makeStringList(ArrayUtils.convert(messageData)));
            }
            Bukkit.getServer().sendPluginMessage((Plugin)this.plugin, this.bungeeChannel, byteOutStream.toByteArray());
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Generated
    public boolean isDebug() {
        return this.debug;
    }

    @Generated
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Generated
    public EncryptionHandler getEncryptionHandler() {
        return this.encryptionHandler;
    }

    @Generated
    public void setEncryptionHandler(EncryptionHandler encryptionHandler) {
        this.encryptionHandler = encryptionHandler;
    }

    @Generated
    public String getBungeeChannel() {
        return this.bungeeChannel;
    }

    @Generated
    public void setBungeeChannel(String bungeeChannel) {
        this.bungeeChannel = bungeeChannel;
    }
}

