/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.simpleapi.servercomm.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.sql.DataSource;

public class BackendMessenger {
    private final String myServerId;
    private final String CHANNEL;
    private final DataSource ds;
    private Connection lockConn;
    private Connection workConn;
    private Connection pubConn;
    private volatile boolean running = true;
    private long lastSeenId = 0L;
    private final Consumer<BackendMessage> onMessage;
    private String tableName;

    public BackendMessenger(String tableName, DataSource dataSource, String serverId, Consumer<BackendMessage> onMessage) throws SQLException {
        this.ds = dataSource;
        this.myServerId = serverId;
        this.CHANNEL = "backend-channel-" + serverId;
        this.onMessage = onMessage;
        this.tableName = tableName;
        this.ensureSchema(tableName);
        this.initConnections();
        this.startListener();
    }

    private void ensureSchema(String tableName) throws SQLException {
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + "_message_queue (id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT, source VARCHAR(36) NOT NULL, destination VARCHAR(36) NOT NULL, created_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP, payload LONGTEXT NOT NULL, PRIMARY KEY (id), INDEX idx_dest_id (destination, id)) ENGINE=InnoDB;";
        try (Connection conn = this.ds.getConnection();
             Statement stmt = conn.createStatement();){
            stmt.execute(ddl);
        }
    }

    private void initConnections() throws SQLException {
        this.lockConn = this.ds.getConnection();
        this.workConn = this.ds.getConnection();
        this.pubConn = this.ds.getConnection();
        if (!this.acquireLock(this.lockConn, this.CHANNEL, 10)) {
            throw new IllegalStateException("Could not acquire " + this.CHANNEL + " lock on startup");
        }
    }

    private void startListener() {
        Thread t = new Thread(() -> {
            while (this.running) {
                try {
                    if (!this.acquireLock(this.lockConn, this.CHANNEL, 300)) continue;
                    this.fetchBatch().forEach(this.onMessage);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.reconnectOnError();
                }
            }
        }, "BackendMessenger-Listener-" + this.myServerId);
        t.setDaemon(true);
        t.start();
    }

    private void deleteMessageById(long id) throws SQLException {
        String delSql = "DELETE FROM " + this.tableName + "_message_queue WHERE id = ?";
        try (PreparedStatement del = this.workConn.prepareStatement(delSql);){
            del.setLong(1, id);
            del.executeUpdate();
        }
    }

    private List<BackendMessage> fetchBatch() throws SQLException {
        String sql = "SELECT id, source, payload FROM " + this.tableName + "_message_queue WHERE destination = ? AND id > ? ORDER BY id";
        ArrayList<BackendMessage> results = new ArrayList<BackendMessage>();
        try (PreparedStatement ps = this.workConn.prepareStatement(sql);){
            ps.setString(1, this.myServerId);
            ps.setLong(2, this.lastSeenId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    long id = rs.getLong("id");
                    String from = rs.getString("source");
                    String payload = rs.getString("payload");
                    results.add(new BackendMessage(id, from, payload));
                    this.lastSeenId = id;
                    this.deleteMessageById(id);
                }
            }
        }
        return results;
    }

    public synchronized void sendToProxy(String payload) throws SQLException {
        String insertSql = "INSERT INTO " + this.tableName + "_message_queue (source, destination, payload) VALUES (?, 'proxy', ?)";
        try (PreparedStatement ins = this.pubConn.prepareStatement(insertSql);){
            ins.setString(1, this.myServerId);
            ins.setString(2, payload);
            ins.executeUpdate();
        }
        try (PreparedStatement rel = this.pubConn.prepareStatement("SELECT RELEASE_LOCK(?)");){
            rel.setString(1, "proxy-channel");
            rel.executeQuery();
        }
    }

    private boolean acquireLock(Connection conn, String name, int timeout) throws SQLException {
        try (PreparedStatement ps = conn.prepareStatement("SELECT GET_LOCK(?, ?)");){
            boolean bl;
            block12: {
                ps.setString(1, name);
                ps.setInt(2, timeout);
                ResultSet rs = ps.executeQuery();
                try {
                    boolean bl2 = bl = rs.next() && rs.getInt(1) == 1;
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
    }

    private void reconnectOnError() {
        try {
            if (this.lockConn != null) {
                this.lockConn.close();
            }
            if (this.workConn != null) {
                this.workConn.close();
            }
            if (this.pubConn != null) {
                this.pubConn.close();
            }
            this.initConnections();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void shutdown() {
        this.running = false;
        this.closeQuiet(this.lockConn);
        this.closeQuiet(this.workConn);
        this.closeQuiet(this.pubConn);
    }

    private void closeQuiet(Connection c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static class BackendMessage {
        public final long id;
        public final String fromServerId;
        public final String payload;

        public BackendMessage(long id, String fromServerId, String payload) {
            this.id = id;
            this.fromServerId = fromServerId;
            this.payload = payload;
        }
    }
}

