/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.simpleapi.servercomm.mqtt;

import com.bencodez.votingplugin.simpleapi.servercomm.mqtt.MqttServerComm;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class MqttHandler {
    private final MqttServerComm mqtt;
    private final ConcurrentHashMap<String, RpcCallback> pendingRpcs = new ConcurrentHashMap();
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private int defaultQos;

    public MqttHandler(MqttServerComm mqtt, int defaultQos) {
        this.mqtt = mqtt;
        this.setDefaultQos(defaultQos);
    }

    public MqttHandler(MqttServerComm mqtt) {
        this(mqtt, 2);
    }

    public void setDefaultQos(int qos) {
        if (qos < 0 || qos > 2) {
            throw new IllegalArgumentException("QoS must be 0, 1, or 2");
        }
        this.defaultQos = qos;
    }

    public void connect() throws Exception {
        this.mqtt.connect();
    }

    public void disconnect() throws Exception {
        this.mqtt.disconnect();
        this.scheduler.shutdownNow();
    }

    public boolean isConnected() {
        return this.mqtt.isConnected();
    }

    public void publish(String topic, String message) throws Exception {
        this.mqtt.publish(topic, message, this.defaultQos, false);
    }

    public void subscribe(String topicFilter, MessageHandler handler) throws Exception {
        this.mqtt.subscribe(topicFilter, this.defaultQos, (topic, msg) -> handler.onMessage(topic, new String(msg.getPayload())));
    }

    public void unsubscribe(String topicFilter) throws Exception {
        this.mqtt.unsubscribe(topicFilter);
    }

    public void request(String topic, String message, long timeoutMillis, RpcCallback callback) throws Exception {
        String requestId = UUID.randomUUID().toString();
        this.pendingRpcs.put(requestId, callback);
        this.scheduler.schedule(() -> {
            RpcCallback cb = this.pendingRpcs.remove(requestId);
            if (cb != null) {
                cb.onComplete(null, new Exception("RPC timeout"));
            }
        }, timeoutMillis, TimeUnit.MILLISECONDS);
        this.mqtt.publish(topic + "/" + requestId, message, this.defaultQos, false);
    }

    public void handleRpcResponse(String topic, String payload) {
        String[] parts = topic.split("/");
        if (parts.length == 0) {
            return;
        }
        String requestId = parts[parts.length - 1];
        RpcCallback cb = this.pendingRpcs.remove(requestId);
        if (cb != null) {
            cb.onComplete(new RpcResponse(requestId, payload), null);
        }
    }

    public static interface MessageHandler {
        public void onMessage(String var1, String var2);
    }

    public static interface RpcCallback {
        public void onComplete(RpcResponse var1, Exception var2);
    }

    public static class RpcResponse {
        private final String requestId;
        private final String payload;

        public RpcResponse(String requestId, String payload) {
            this.requestId = requestId;
            this.payload = payload;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public String getPayload() {
            return this.payload;
        }
    }
}

