/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.simpleapi.scheduler;

import com.bencodez.votingplugin.simpleapi.folialib.FoliaLib;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class BukkitScheduler {
    private FoliaLib foliaLib;

    public BukkitScheduler(JavaPlugin plugin) {
        this.foliaLib = new FoliaLib(plugin);
    }

    public void executeOrScheduleSync(Plugin plugin, Runnable task) {
        this.getFoliaLib().getImpl().runNextTick(run -> task.run());
    }

    public void executeOrScheduleSync(Plugin plugin, Runnable task, Entity entity) {
        if (entity == null) {
            this.executeOrScheduleSync(plugin, task);
            return;
        }
        this.getFoliaLib().getImpl().runAtEntity(entity, run -> task.run());
    }

    public void executeOrScheduleSync(Plugin plugin, Runnable task, Location location) {
        this.getFoliaLib().getImpl().runAtLocation(location, run -> task.run());
    }

    public void runTask(Plugin plugin, Runnable task) {
        this.getFoliaLib().getImpl().runNextTick(run -> task.run());
    }

    public void runTask(Plugin plugin, Runnable task, Entity entity) {
        if (entity == null) {
            this.runTask(plugin, task);
            return;
        }
        this.getFoliaLib().getImpl().runAtEntity(entity, run -> task.run());
    }

    public void runTask(Plugin plugin, Runnable task, Location location) {
        this.getFoliaLib().getImpl().runAtLocation(location, run -> task.run());
    }

    public void runTaskAsynchronously(Plugin plugin, Runnable task) {
        this.getFoliaLib().getImpl().runAsync(run -> task.run());
    }

    public void runTaskLater(Plugin plugin, Runnable task, long delay) {
        this.getFoliaLib().getImpl().runLater(run -> task.run(), delay, TimeUnit.SECONDS);
    }

    public void runTaskLater(Plugin plugin, Runnable task, long delay, Entity entity) {
        if (entity == null) {
            this.runTaskLater(plugin, task, delay);
            return;
        }
        this.getFoliaLib().getImpl().runAtEntityLater(entity, run -> task.run(), delay, TimeUnit.SECONDS);
    }

    public void runTaskLater(Plugin plugin, Runnable task, long delay, Location location) {
        this.getFoliaLib().getImpl().runAtLocationLater(location, run -> task.run(), delay, TimeUnit.SECONDS);
    }

    public void runTaskLater(Plugin plugin, Runnable task, long delay, TimeUnit time) {
        this.getFoliaLib().getImpl().runLater(run -> task.run(), delay, time);
    }

    public void runTaskLaterAsynchronously(Plugin plugin, Runnable task, long delay) {
        this.getFoliaLib().getImpl().runLaterAsync(run -> task.run(), delay, TimeUnit.SECONDS);
    }

    public void runTaskTimer(Plugin plugin, Runnable task, long delay, long period) {
        this.getFoliaLib().getImpl().runTimer(run -> task.run(), delay, period, TimeUnit.SECONDS);
    }

    public void runTaskTimer(Plugin plugin, Runnable task, long delay, long period, Entity entity) {
        if (entity == null) {
            this.runTaskTimer(plugin, task, delay, period);
            return;
        }
        this.getFoliaLib().getImpl().runTimer(run -> task.run(), delay, period, TimeUnit.SECONDS);
    }

    public void runTaskTimer(Plugin plugin, Runnable task, long delay, long period, Location location) {
        this.getFoliaLib().getImpl().runAtLocationTimer(location, run -> task.run(), delay, period, TimeUnit.SECONDS);
    }

    public void runTaskTimerAsynchronously(Plugin plugin, Runnable task, long delay, long period) {
        this.getFoliaLib().getImpl().runTimerAsync(run -> task.run(), delay, period, TimeUnit.SECONDS);
    }

    @Generated
    public FoliaLib getFoliaLib() {
        return this.foliaLib;
    }
}

