/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.simpleapi.player;

import com.bencodez.votingplugin.simpleapi.serverhandle.CraftBukkitHandle;
import com.bencodez.votingplugin.simpleapi.serverhandle.IServerHandle;
import com.bencodez.votingplugin.simpleapi.serverhandle.SpigotHandle;
import com.google.common.collect.Iterables;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PlayerUtils {
    private static IServerHandle serverHandle = PlayerUtils.loadHandle();
    private static final BlockFace[] axis = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};
    private static final BlockFace[] radial = new BlockFace[]{BlockFace.NORTH, BlockFace.NORTH_EAST, BlockFace.EAST, BlockFace.SOUTH_EAST, BlockFace.SOUTH, BlockFace.SOUTH_WEST, BlockFace.WEST, BlockFace.NORTH_WEST};

    public static boolean canBreakBlock(Player p, Block b) {
        BlockBreakEvent block = new BlockBreakEvent(b, p);
        Bukkit.getPluginManager().callEvent((Event)block);
        return !block.isCancelled();
    }

    public static boolean canInteract(Player p, Block clickedBlock, Action action, ItemStack item, BlockFace clickedFace) {
        PlayerInteractEvent event = new PlayerInteractEvent(p, action, item, clickedBlock, clickedFace);
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.useItemInHand().equals((Object)Event.Result.DENY);
    }

    public static UUID fetchUUID(String playerName) throws Exception {
        URL url = new URL("https://api.mojang.com/users/profiles/minecraft/" + playerName);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.connect();
        if (connection.getResponseCode() == 400) {
            return null;
        }
        InputStream inputStream = connection.getInputStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        JsonElement element = JsonParser.parseReader((Reader)bufferedReader);
        JsonObject object = element.getAsJsonObject();
        String uuidAsString = object.get("id").getAsString();
        return PlayerUtils.parseUUIDFromString(uuidAsString);
    }

    public static Object getPlayerMeta(JavaPlugin plugin, Player player, String str) {
        for (MetadataValue meta : player.getMetadata(str)) {
            if (!meta.getOwningPlugin().equals(plugin)) continue;
            return meta.value();
        }
        return null;
    }

    public static Player getRandomOnlinePlayer() {
        Iterator iterator = Bukkit.getOnlinePlayers().iterator();
        if (iterator.hasNext()) {
            Player player = (Player)iterator.next();
            return player;
        }
        return null;
    }

    public static Player getRandomPlayer() {
        return (Player)Iterables.getFirst((Iterable)Bukkit.getOnlinePlayers(), null);
    }

    public static Inventory getTopInventory(Player player) {
        InventoryView oInv = player.getOpenInventory();
        if (oInv == null) {
            return null;
        }
        try {
            Method method = InventoryView.class.getDeclaredMethod("getTopInventory", new Class[0]);
            return (Inventory)method.invoke((Object)oInv, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return oInv.getTopInventory();
        }
    }

    public static boolean hasEitherPermission(CommandSender sender, String perm) {
        if (!(sender instanceof Player) || perm.equals("")) {
            return true;
        }
        boolean hasPerm = false;
        for (String permission : perm.split("\\|")) {
            if (!sender.hasPermission(permission)) continue;
            hasPerm = true;
        }
        return hasPerm;
    }

    public static boolean isPlayer(CommandSender sender) {
        return sender instanceof Player;
    }

    public static boolean isPlayerOnline(String playerName) {
        if (playerName == null) {
            return false;
        }
        Player player = Bukkit.getPlayerExact((String)playerName);
        return player != null;
    }

    public static IServerHandle loadHandle() {
        try {
            Class.forName("org.spigotmc.SpigotConfig");
            return new SpigotHandle();
        }
        catch (Exception ex) {
            serverHandle = new CraftBukkitHandle();
            return serverHandle;
        }
    }

    private static UUID parseUUIDFromString(String uuidAsString) {
        String[] parts = new String[]{"0x" + uuidAsString.substring(0, 8), "0x" + uuidAsString.substring(8, 12), "0x" + uuidAsString.substring(12, 16), "0x" + uuidAsString.substring(16, 20), "0x" + uuidAsString.substring(20, 32)};
        long mostSigBits = Long.decode(parts[0]);
        mostSigBits <<= 16;
        mostSigBits |= Long.decode(parts[1]).longValue();
        mostSigBits <<= 16;
        long leastSigBits = Long.decode(parts[3]);
        leastSigBits <<= 48;
        return new UUID(mostSigBits |= Long.decode(parts[2]).longValue(), leastSigBits |= Long.decode(parts[4]).longValue());
    }

    public static void setPlayerMeta(final JavaPlugin plugin, Player player, String str, final Object value) {
        player.removeMetadata(str, (Plugin)plugin);
        player.setMetadata(str, new MetadataValue(){

            public boolean asBoolean() {
                return false;
            }

            public byte asByte() {
                return 0;
            }

            public double asDouble() {
                return 0.0;
            }

            public float asFloat() {
                return 0.0f;
            }

            public int asInt() {
                return 0;
            }

            public long asLong() {
                return 0L;
            }

            public short asShort() {
                return 0;
            }

            public String asString() {
                return null;
            }

            public Plugin getOwningPlugin() {
                return plugin;
            }

            public void invalidate() {
            }

            public Object value() {
                return value;
            }
        });
    }

    public static BlockFace yawToFace(float yaw, boolean useSubCardinalDirections) {
        if (useSubCardinalDirections) {
            return radial[Math.round(yaw / 45.0f) & 7].getOppositeFace();
        }
        return axis[Math.round(yaw / 90.0f) & 3].getOppositeFace();
    }

    @Generated
    public static IServerHandle getServerHandle() {
        return serverHandle;
    }
}

