/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.simpleapi.messages;

import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import com.bencodez.votingplugin.simpleapi.messages.hover.HoverEventSupport;
import com.bencodez.votingplugin.simpleapi.player.PlayerUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.entity.Player;

public class MessageAPI {
    private static final HoverEventSupport hoverEventSupport = HoverEventSupport.findInstance();
    public static final char COLOR_CHAR = '\u00a7';

    public static String colorize(String format) {
        if (format == null) {
            return null;
        }
        format = format.replace("{AQUA}", "\u00a7b").replace("{BLACK}", "\u00a70").replace("{BLUE}", "\u00a79").replace("{DARK_AQUA}", "\u00a73").replace("{DARK_BLUE}", "\u00a71").replace("{DARK_GRAY}", "\u00a78").replace("{DARK_GREEN}", "\u00a72").replace("{DARK_PURPLE}", "\u00a75").replace("{DARK_RED}", "\u00a74").replace("{GOLD}", "\u00a76").replace("{GRAY}", "\u00a77").replace("{GREEN}", "\u00a7a").replace("{LIGHT_PURPLE}", "\u00a7d").replace("{RED}", "\u00a7c").replace("{WHITE}", "\u00a7f").replace("{YELLOW}", "\u00a7e").replace("{BOLD}", "\u00a7l").replace("{ITALIC}", "\u00a7o").replace("{MAGIC}", "\u00a7k").replace("{RESET}", "\u00a7r").replace("{STRIKE}", "\u00a7m").replace("{STRIKETHROUGH}", "\u00a7m").replace("{UNDERLINE}", "\u00a7n");
        format = MessageAPI.translateHexColorCodes("&#", "#", format);
        format = MessageAPI.translateHexColorCodes("&#", "", format);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)format);
    }

    public static String compToString(TextComponent comp) {
        return MessageAPI.colorize(comp.toPlainText());
    }

    public static boolean contains(String str1, String str2) {
        return str1.contains(str2);
    }

    public static boolean containsIgnorecase(String str1, String str2) {
        if (str1 == null || str2 == null) {
            return false;
        }
        return str1.toLowerCase().contains(str2.toLowerCase());
    }

    public static boolean containsJson(String msg) {
        return MessageAPI.contains(msg, "[Text=\"");
    }

    public static String getProgressBar(int current, int max, int totalBars, String symbol, String completedColor, String notCompletedColor) {
        int i;
        float percent = (float)current / (float)max;
        int progressBars = (int)((float)totalBars * percent);
        int leftOver = totalBars - progressBars;
        StringBuilder sb = new StringBuilder();
        sb.append(ChatColor.translateAlternateColorCodes((char)'&', (String)completedColor));
        for (i = 0; i < progressBars; ++i) {
            sb.append(symbol);
        }
        sb.append(ChatColor.translateAlternateColorCodes((char)'&', (String)notCompletedColor));
        for (i = 0; i < leftOver; ++i) {
            sb.append(symbol);
        }
        return sb.toString();
    }

    public static boolean isDouble(String st) {
        if (st == null) {
            return false;
        }
        try {
            double num = Double.parseDouble(st);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public static boolean isInt(String st) {
        if (st == null) {
            return false;
        }
        try {
            int num = Integer.parseInt(st);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public static boolean isLong(String st) {
        if (st == null) {
            return false;
        }
        try {
            Long.parseLong(st);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public static String replaceIgnoreCase(String str, String toReplace, String replaceWith) {
        if (str == null) {
            return "";
        }
        if (toReplace == null || replaceWith == null) {
            return str;
        }
        try {
            return Pattern.compile(toReplace, 2).matcher(str).replaceAll(replaceWith);
        }
        catch (IndexOutOfBoundsException e) {
            return str.replace(toReplace, replaceWith);
        }
    }

    public static String roundDecimals(double num, int decimals) {
        num *= Math.pow(10.0, decimals);
        num = Math.round(num);
        DecimalFormat df = new DecimalFormat("#.00");
        return df.format(num /= Math.pow(10.0, decimals));
    }

    public static void sendJson(Player player, ArrayList<TextComponent> messages) {
        if (player != null && messages != null) {
            ArrayList<BaseComponent> texts = new ArrayList<BaseComponent>();
            TextComponent newLine = new TextComponent(ComponentSerializer.parse((String)"{text: \"\n\"}"));
            for (int i = 0; i < messages.size(); ++i) {
                TextComponent txt = messages.get(i);
                texts.add((BaseComponent)txt);
                if (i + 1 >= messages.size()) continue;
                texts.add((BaseComponent)newLine);
            }
            PlayerUtils.getServerHandle().sendMessage(player, ArrayUtils.convertBaseComponent(texts));
        }
    }

    public static void sendJson(Player player, TextComponent message) {
        if (player != null && message != null) {
            message.setText(message.getText());
            PlayerUtils.getServerHandle().sendMessage(player, (BaseComponent)message);
        }
    }

    public static boolean startsWithIgnoreCase(String str1, String str2) {
        return str1.toLowerCase().startsWith(str2.toLowerCase());
    }

    public static TextComponent stringToComp(String string) {
        TextComponent base = new TextComponent("");
        boolean previousLetter = false;
        ChatColor currentColor = null;
        boolean bold = false;
        boolean italic = false;
        boolean underline = false;
        boolean strike = false;
        boolean magic = false;
        String currentstring = "";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '&') {
                TextComponent newTC;
                if (string.charAt(i + 1) == '#') {
                    String hexColor = "";
                    for (int j = i + 2; j < i + 2 + 6; ++j) {
                        hexColor = hexColor + string.charAt(j);
                    }
                    if (string.charAt(i + 8) != '#') continue;
                    i += 8;
                    previousLetter = false;
                    TextComponent newTC2 = new TextComponent(currentstring);
                    if (currentColor != null) {
                        newTC2.setColor(currentColor);
                    }
                    currentstring = "";
                    newTC2.setBold(Boolean.valueOf(bold));
                    newTC2.setItalic(Boolean.valueOf(italic));
                    newTC2.setUnderlined(Boolean.valueOf(underline));
                    newTC2.setStrikethrough(Boolean.valueOf(strike));
                    newTC2.setObfuscated(Boolean.valueOf(magic));
                    base.addExtra((BaseComponent)newTC2);
                    currentColor = ChatColor.of((String)("#" + hexColor));
                    continue;
                }
                if (string.charAt(i + 1) == 'l') {
                    if (previousLetter) {
                        newTC = new TextComponent(currentstring);
                        if (currentColor != null) {
                            newTC.setColor(currentColor);
                        }
                        newTC.setBold(Boolean.valueOf(bold));
                        newTC.setItalic(Boolean.valueOf(italic));
                        newTC.setUnderlined(Boolean.valueOf(underline));
                        newTC.setStrikethrough(Boolean.valueOf(strike));
                        newTC.setObfuscated(Boolean.valueOf(magic));
                        base.addExtra((BaseComponent)newTC);
                        bold = false;
                        italic = false;
                        underline = false;
                        strike = false;
                        magic = false;
                        currentstring = "";
                        currentColor = null;
                        ++i;
                        previousLetter = false;
                        continue;
                    }
                    bold = true;
                    ++i;
                    continue;
                }
                if (string.charAt(i + 1) == 'k') {
                    if (previousLetter) {
                        newTC = new TextComponent(currentstring);
                        if (currentColor != null) {
                            newTC.setColor(currentColor);
                        }
                        newTC.setBold(Boolean.valueOf(bold));
                        newTC.setItalic(Boolean.valueOf(italic));
                        newTC.setUnderlined(Boolean.valueOf(underline));
                        newTC.setStrikethrough(Boolean.valueOf(strike));
                        newTC.setObfuscated(Boolean.valueOf(magic));
                        base.addExtra((BaseComponent)newTC);
                        bold = false;
                        italic = false;
                        underline = false;
                        strike = false;
                        magic = false;
                        currentstring = "";
                        currentColor = null;
                        ++i;
                        previousLetter = false;
                        continue;
                    }
                    magic = true;
                    ++i;
                    continue;
                }
                if (string.charAt(i + 1) == 'm') {
                    if (previousLetter) {
                        newTC = new TextComponent(currentstring);
                        if (currentColor != null) {
                            newTC.setColor(currentColor);
                        }
                        newTC.setBold(Boolean.valueOf(bold));
                        newTC.setItalic(Boolean.valueOf(italic));
                        newTC.setUnderlined(Boolean.valueOf(underline));
                        newTC.setStrikethrough(Boolean.valueOf(strike));
                        newTC.setObfuscated(Boolean.valueOf(magic));
                        base.addExtra((BaseComponent)newTC);
                        bold = false;
                        italic = false;
                        underline = false;
                        strike = false;
                        magic = false;
                        currentstring = "";
                        currentColor = null;
                        ++i;
                        previousLetter = false;
                        continue;
                    }
                    strike = true;
                    ++i;
                    continue;
                }
                if (string.charAt(i + 1) == 'n') {
                    if (previousLetter) {
                        newTC = new TextComponent(currentstring);
                        if (currentColor != null) {
                            newTC.setColor(currentColor);
                        }
                        newTC.setBold(Boolean.valueOf(bold));
                        newTC.setItalic(Boolean.valueOf(italic));
                        newTC.setUnderlined(Boolean.valueOf(underline));
                        newTC.setStrikethrough(Boolean.valueOf(strike));
                        newTC.setObfuscated(Boolean.valueOf(magic));
                        base.addExtra((BaseComponent)newTC);
                        bold = false;
                        italic = false;
                        underline = false;
                        strike = false;
                        magic = false;
                        currentstring = "";
                        currentColor = null;
                        ++i;
                        previousLetter = false;
                        continue;
                    }
                    underline = true;
                    ++i;
                    continue;
                }
                if (string.charAt(i + 1) == 'o') {
                    if (previousLetter) {
                        newTC = new TextComponent(currentstring);
                        if (currentColor != null) {
                            newTC.setColor(currentColor);
                        }
                        newTC.setBold(Boolean.valueOf(bold));
                        newTC.setItalic(Boolean.valueOf(italic));
                        newTC.setUnderlined(Boolean.valueOf(underline));
                        newTC.setStrikethrough(Boolean.valueOf(strike));
                        newTC.setObfuscated(Boolean.valueOf(magic));
                        base.addExtra((BaseComponent)newTC);
                        bold = false;
                        italic = false;
                        underline = false;
                        strike = false;
                        magic = false;
                        currentstring = "";
                        currentColor = null;
                        ++i;
                        previousLetter = false;
                        continue;
                    }
                    italic = true;
                    ++i;
                    continue;
                }
                if (string.charAt(i + 1) == 'r') {
                    newTC = new TextComponent(currentstring);
                    if (currentColor != null) {
                        newTC.setColor(currentColor);
                    }
                    newTC.setBold(Boolean.valueOf(bold));
                    newTC.setItalic(Boolean.valueOf(italic));
                    newTC.setUnderlined(Boolean.valueOf(underline));
                    newTC.setStrikethrough(Boolean.valueOf(strike));
                    newTC.setObfuscated(Boolean.valueOf(magic));
                    base.addExtra((BaseComponent)newTC);
                    bold = false;
                    italic = false;
                    underline = false;
                    strike = false;
                    magic = false;
                    currentstring = "";
                    currentColor = null;
                    ++i;
                    previousLetter = false;
                    continue;
                }
                if (ChatColor.getByChar((char)string.charAt(i + 1)) != null) {
                    if (previousLetter) {
                        newTC = new TextComponent(currentstring);
                        if (currentColor != null) {
                            newTC.setColor(currentColor);
                        }
                        newTC.setBold(Boolean.valueOf(bold));
                        newTC.setItalic(Boolean.valueOf(italic));
                        newTC.setUnderlined(Boolean.valueOf(underline));
                        newTC.setStrikethrough(Boolean.valueOf(strike));
                        newTC.setObfuscated(Boolean.valueOf(magic));
                        base.addExtra((BaseComponent)newTC);
                        bold = false;
                        italic = false;
                        underline = false;
                        strike = false;
                        magic = false;
                        currentColor = ChatColor.getByChar((char)string.charAt(i + 1));
                        currentstring = "";
                        ++i;
                        previousLetter = false;
                        continue;
                    }
                    currentColor = ChatColor.getByChar((char)string.charAt(i + 1));
                    ++i;
                    continue;
                }
                previousLetter = true;
                currentstring = currentstring + c;
                continue;
            }
            previousLetter = true;
            currentstring = currentstring + c;
        }
        TextComponent newTC = new TextComponent(currentstring);
        if (currentColor != null) {
            newTC.setColor(currentColor);
        }
        newTC.setBold(Boolean.valueOf(bold));
        newTC.setItalic(Boolean.valueOf(italic));
        newTC.setUnderlined(Boolean.valueOf(underline));
        newTC.setStrikethrough(Boolean.valueOf(strike));
        newTC.setObfuscated(Boolean.valueOf(magic));
        base.addExtra((BaseComponent)newTC);
        return base;
    }

    public static String translateHexColorCodes(String startTag, String endTag, String message) {
        Pattern hexPattern = Pattern.compile(startTag + "([A-Fa-f0-9]{6})" + endTag);
        Matcher matcher = hexPattern.matcher(message);
        StringBuffer buffer = new StringBuffer(message.length() + 32);
        while (matcher.find()) {
            String group = matcher.group(1);
            matcher.appendReplacement(buffer, "\u00a7x\u00a7" + group.charAt(0) + '\u00a7' + group.charAt(1) + '\u00a7' + group.charAt(2) + '\u00a7' + group.charAt(3) + '\u00a7' + group.charAt(4) + '\u00a7' + group.charAt(5));
        }
        return matcher.appendTail(buffer).toString();
    }

    @Generated
    public static HoverEventSupport getHoverEventSupport() {
        return hoverEventSupport;
    }
}

