/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.simpleapi.file.velocity;

import com.google.common.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.yaml.YAMLConfigurationLoader;
import org.yaml.snakeyaml.DumperOptions;

public class VelocityYMLFile {
    private ConfigurationNode conf;
    private File file;
    private YAMLConfigurationLoader loader;

    public VelocityYMLFile(File file) {
        this.file = file;
        if (!file.exists()) {
            try {
                file.createNewFile();
                if (file.getParentFile() != null && !file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.loader = ((YAMLConfigurationLoader.Builder)YAMLConfigurationLoader.builder().setFlowStyle(DumperOptions.FlowStyle.BLOCK).setPath(file.toPath())).build();
        try {
            this.conf = this.loader.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean getBoolean(ConfigurationNode node, boolean def) {
        return node.getBoolean(def);
    }

    public ConfigurationNode getData() {
        return this.conf;
    }

    public int getInt(ConfigurationNode node, int def) {
        return node.getInt(def);
    }

    public double getDouble(ConfigurationNode node, double def) {
        return node.getDouble(def);
    }

    public ArrayList<String> getKeys(ConfigurationNode node) {
        ArrayList<String> keys = new ArrayList<String>();
        for (ConfigurationNode key : node.getChildrenMap().values()) {
            keys.add(key.getKey().toString());
        }
        return keys;
    }

    public long getLong(ConfigurationNode node, long def) {
        return node.getLong(def);
    }

    public ConfigurationNode getNode(Object ... path) {
        return this.getData().getNode(path);
    }

    public String getString(ConfigurationNode node, String def) {
        return node.getString(def);
    }

    public List<String> getStringList(ConfigurationNode node, ArrayList<String> def) {
        try {
            return node.getList(TypeToken.of(String.class), def);
        }
        catch (ObjectMappingException e) {
            e.printStackTrace();
            return def;
        }
    }

    public void reload() {
        this.loader = ((YAMLConfigurationLoader.Builder)YAMLConfigurationLoader.builder().setFlowStyle(DumperOptions.FlowStyle.BLOCK).setPath(this.file.toPath())).build();
        try {
            this.conf = this.loader.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save() {
        try {
            this.loader.save(this.conf);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Generated
    public ConfigurationNode getConf() {
        return this.conf;
    }

    @Generated
    public void setConf(ConfigurationNode conf) {
        this.conf = conf;
    }

    @Generated
    public File getFile() {
        return this.file;
    }
}

