/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.simpleapi.file.velocity;

import com.google.common.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.gson.GsonConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;

public class VelocityJSONFile {
    private static final Logger LOG = Logger.getLogger(VelocityJSONFile.class.getName());
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    private ConfigurationNode conf;
    private final Path path;
    private GsonConfigurationLoader loader;

    public VelocityJSONFile(Path path) {
        this.path = path;
        this.ensureFileExists(path);
        this.buildLoader();
        this.loadInternal(true);
    }

    public VelocityJSONFile(File file) {
        this(file.toPath());
    }

    public void reload() {
        this.lock.writeLock().lock();
        try {
            this.buildLoader();
            this.loadInternal(true);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void save() {
        this.lock.writeLock().lock();
        try {
            Path dir = this.path.getParent();
            if (dir != null) {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            this.loader.save(this.conf);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to save JSON config: " + this.path, e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public ConfigurationNode getData() {
        this.lock.readLock().lock();
        try {
            ConfigurationNode configurationNode = this.conf;
            return configurationNode;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public ConfigurationNode getNode(Object ... path) {
        this.lock.readLock().lock();
        try {
            ConfigurationNode configurationNode = this.conf.getNode(path);
            return configurationNode;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean contains(Object ... path) {
        this.lock.readLock().lock();
        try {
            boolean bl = !this.conf.getNode(path).isVirtual();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(ConfigurationNode node, boolean def) {
        this.lock.readLock().lock();
        try {
            boolean bl = node.getBoolean(def);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(ConfigurationNode node, int def) {
        this.lock.readLock().lock();
        try {
            int n = node.getInt(def);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(ConfigurationNode node, long def) {
        this.lock.readLock().lock();
        try {
            long l = node.getLong(def);
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(ConfigurationNode node, String def) {
        this.lock.readLock().lock();
        try {
            String string = node.getString(def);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getKeys(ConfigurationNode node) {
        this.lock.readLock().lock();
        try {
            ArrayList<String> keys = new ArrayList<String>();
            for (Map.Entry e : node.getChildrenMap().entrySet()) {
                keys.add(String.valueOf(e.getKey()));
            }
            ArrayList<String> arrayList = keys;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getStringList(ConfigurationNode node, List<String> def) {
        this.lock.readLock().lock();
        try {
            List list = node.getList(TypeToken.of(String.class), def);
            return list;
        }
        catch (ObjectMappingException e) {
            LOG.log(Level.WARNING, "Failed to read string list at " + this.safeNodePath(node) + ", using default.", e);
            List<String> list = def;
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void set(Object[] path, Object value) {
        this.lock.writeLock().lock();
        try {
            this.conf.getNode(path).setValue(value);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void remove(Object ... path) {
        this.lock.writeLock().lock();
        try {
            this.conf.getNode(path).setValue(null);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void buildLoader() {
        this.loader = ((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().setPath(this.path)).build();
    }

    private void loadInternal(boolean logErrors) {
        this.lock.writeLock().lock();
        try {
            this.conf = this.loader.load();
            if (this.conf == null) {
                this.conf = this.loader.createEmptyNode();
            }
        }
        catch (IOException e) {
            if (logErrors) {
                LOG.log(Level.SEVERE, "Failed to load JSON config: " + this.path, e);
            }
            if (this.conf == null) {
                this.conf = this.loader.createEmptyNode();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void ensureFileExists(Path p) {
        try {
            if (p.getParent() != null) {
                Files.createDirectories(p.getParent(), new FileAttribute[0]);
            }
            if (!Files.exists(p, new LinkOption[0])) {
                Files.createFile(p, new FileAttribute[0]);
                this.buildLoader();
                this.conf = this.loader.createEmptyNode();
                this.save();
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to ensure config file exists: " + p, e);
        }
    }

    private String safeNodePath(ConfigurationNode node) {
        try {
            return node.getPath().toString();
        }
        catch (Throwable t) {
            return "<unknown>";
        }
    }

    @Generated
    public ConfigurationNode getConf() {
        return this.conf;
    }

    @Generated
    public void setConf(ConfigurationNode conf) {
        this.conf = conf;
    }

    @Generated
    public Path getPath() {
        return this.path;
    }
}

