/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.simpleapi.file;

import com.bencodez.votingplugin.simpleapi.scheduler.BukkitScheduler;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class YMLFile {
    private boolean created = false;
    private FileConfiguration data;
    private File dFile;
    private boolean failedToRead = false;
    private JavaPlugin plugin;
    private BukkitScheduler scheduler;

    public YMLFile(JavaPlugin plugin, File file) {
        this.dFile = file;
        this.plugin = plugin;
        this.scheduler = new BukkitScheduler(plugin);
    }

    public YMLFile(JavaPlugin plugin, File file, BukkitScheduler scheduler) {
        this.dFile = file;
        this.plugin = plugin;
        this.scheduler = scheduler;
    }

    public YMLFile(JavaPlugin plugin, File file, BukkitScheduler scheduler, boolean setup) {
        this(plugin, file, scheduler);
        if (setup) {
            this.setup();
        }
    }

    public YMLFile(JavaPlugin plugin, File file, boolean setup) {
        this.dFile = file;
        this.plugin = plugin;
        this.scheduler = new BukkitScheduler(plugin);
        if (setup) {
            this.setup();
        }
    }

    public void createSection(String key) {
        this.getData().createSection(key);
        this.saveData();
    }

    public FileConfiguration getData() {
        return this.data;
    }

    public File getdFile() {
        return this.dFile;
    }

    public boolean isJustCreated() {
        return this.created;
    }

    public void loadValues() {
    }

    public abstract void onFileCreation();

    public void reloadData() {
        try {
            this.data = YamlConfiguration.loadConfiguration((File)this.dFile);
            this.failedToRead = false;
            if (this.data.getConfigurationSection("").getKeys(false).size() == 0) {
                this.failedToRead = true;
            } else {
                this.loadValues();
            }
        }
        catch (Exception e) {
            this.failedToRead = true;
            e.printStackTrace();
            this.plugin.getLogger().severe("Failed to load " + this.dFile.getName());
            this.scheduler.runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    YMLFile.this.plugin.getLogger().severe("Detected failure to load files on startup, see server log for details");
                }
            });
        }
    }

    public void saveData() {
        try {
            this.data.save(this.dFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setData(FileConfiguration data) {
        Map map = data.getConfigurationSection("").getValues(true);
        for (Map.Entry entry : map.entrySet()) {
            this.data.set((String)entry.getKey(), entry.getValue());
        }
    }

    public void setup() {
        this.failedToRead = false;
        this.getdFile().getParentFile().mkdirs();
        if (!this.dFile.exists()) {
            try {
                this.getdFile().createNewFile();
                this.onFileCreation();
                this.created = true;
            }
            catch (IOException e) {
                Bukkit.getServer().getLogger().severe(ChatColor.RED + "Could not create " + this.getdFile().getName() + "!");
            }
        }
        try {
            this.data = YamlConfiguration.loadConfiguration((File)this.dFile);
            if (this.data.getConfigurationSection("").getKeys(false).size() == 0) {
                this.failedToRead = true;
            }
            this.loadValues();
        }
        catch (Exception e) {
            this.failedToRead = true;
            e.printStackTrace();
            this.plugin.getLogger().severe("Failed to load " + this.dFile.getName());
            this.scheduler.runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    YMLFile.this.plugin.getLogger().severe("Detected failure to load files on startup, see server log for details");
                }
            });
        }
    }

    public void setValue(String path, Object value) {
        this.getData().set(path, value);
        this.saveData();
    }

    @Generated
    public boolean isFailedToRead() {
        return this.failedToRead;
    }

    @Generated
    public JavaPlugin getPlugin() {
        return this.plugin;
    }
}

