/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.simpleapi.file;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class BungeeJsonFile {
    private JsonObject conf;
    private File file;
    private Gson gson;

    public BungeeJsonFile(File file) {
        this.file = file;
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        if (!file.exists()) {
            try {
                File parentDir = file.getParentFile();
                if (parentDir != null && !parentDir.exists()) {
                    parentDir.mkdirs();
                }
                file.createNewFile();
                this.conf = new JsonObject();
                this.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try (FileReader reader = new FileReader(file);){
                this.conf = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            }
            catch (JsonSyntaxException e) {
                System.err.println("Error parsing JSON file: " + e.getMessage());
                this.conf = this.attemptPartialRecovery(file);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.conf = new JsonObject();
            }
        }
    }

    private JsonObject attemptPartialRecovery(File file) {
        JsonObject recoveredData = new JsonObject();
        try (FileReader fileReader = new FileReader(file);
             JsonReader jsonReader = new JsonReader((Reader)fileReader);){
            jsonReader.setLenient(true);
            recoveredData = JsonParser.parseReader((JsonReader)jsonReader).getAsJsonObject();
            System.err.println("Partial recovery of JSON data succeeded.");
        }
        catch (Exception ex) {
            System.err.println("Failed to recover JSON data: " + ex.getMessage());
        }
        return recoveredData;
    }

    private JsonObject navigateToNode(String path) {
        String[] parts = path.split("\\.");
        JsonObject current = this.conf;
        if (parts.length == 1) {
            if (current.has(parts[0]) && current.get(parts[0]).isJsonObject()) {
                return current.getAsJsonObject(parts[0]);
            }
            return null;
        }
        for (int i = 0; i < parts.length - 1; ++i) {
            JsonElement element = current.get(parts[i]);
            if (element == null || !element.isJsonObject()) {
                return null;
            }
            current = element.getAsJsonObject();
        }
        return current;
    }

    private JsonObject ensureParentObjectsExist(String path) {
        String[] parts = path.split("\\.");
        JsonObject current = this.conf;
        for (int i = 0; i < parts.length - 1; ++i) {
            if (!current.has(parts[i]) || current.get(parts[i]) == null || !current.get(parts[i]).isJsonObject()) {
                current.add(parts[i], (JsonElement)new JsonObject());
            }
            current = current.getAsJsonObject(parts[i]);
        }
        return current;
    }

    private String getLastPathPart(String path) {
        String[] parts = path.split("\\.");
        return parts[parts.length - 1];
    }

    public boolean getBoolean(String path, boolean def) {
        JsonObject node = this.navigateToNode(path);
        String lastPart = this.getLastPathPart(path);
        return node != null && node.has(lastPart) ? node.get(lastPart).getAsBoolean() : def;
    }

    public int getInt(String path, int def) {
        JsonObject node = this.navigateToNode(path);
        String lastPart = this.getLastPathPart(path);
        return node != null && node.has(lastPart) ? node.get(lastPart).getAsInt() : def;
    }

    public long getLong(String path, long def) {
        JsonObject node = this.navigateToNode(path);
        String lastPart = this.getLastPathPart(path);
        return node != null && node.has(lastPart) ? node.get(lastPart).getAsLong() : def;
    }

    public String getString(String path, String def) {
        JsonObject node = this.navigateToNode(path);
        String lastPart = this.getLastPathPart(path);
        return node != null && node.has(lastPart) ? node.get(lastPart).getAsString() : def;
    }

    public List<String> getStringList(String path, List<String> def) {
        JsonObject node = this.navigateToNode(path);
        String lastPart = this.getLastPathPart(path);
        if (node != null && node.has(lastPart)) {
            ArrayList<String> list = new ArrayList<String>();
            for (JsonElement element : node.getAsJsonArray(lastPart)) {
                list.add(element.getAsString());
            }
            return list;
        }
        return def;
    }

    public List<String> getKeys(String path) {
        JsonObject parentNode = this.navigateToNode(path);
        String lastPart = this.getLastPathPart(path);
        JsonObject node = null;
        if (path.split("\\.").length == 1) {
            node = parentNode;
        } else if (parentNode != null) {
            node = parentNode.getAsJsonObject(lastPart);
        }
        if (node != null) {
            ArrayList<String> keys = new ArrayList<String>();
            for (Map.Entry entry : node.entrySet()) {
                keys.add((String)entry.getKey());
            }
            return keys;
        }
        return new ArrayList<String>();
    }

    public JsonElement getNode(String path) {
        JsonObject parentNode = this.navigateToNode(path);
        String lastPart = this.getLastPathPart(path);
        if (parentNode == null && this.conf.has(lastPart)) {
            return this.conf.get(lastPart);
        }
        if (parentNode != null && parentNode.has(lastPart)) {
            return parentNode.get(lastPart);
        }
        return null;
    }

    public synchronized void setInt(String path, int value) {
        JsonObject node = this.ensureParentObjectsExist(path);
        String lastPart = this.getLastPathPart(path);
        node.addProperty(lastPart, (Number)value);
    }

    public synchronized void setString(String path, String value) {
        JsonObject node = this.ensureParentObjectsExist(path);
        String lastPart = this.getLastPathPart(path);
        node.addProperty(lastPart, value);
    }

    public synchronized void setBoolean(String path, boolean value) {
        JsonObject node = this.ensureParentObjectsExist(path);
        String lastPart = this.getLastPathPart(path);
        node.addProperty(lastPart, Boolean.valueOf(value));
    }

    public synchronized void setLong(String path, long value) {
        JsonObject node = this.ensureParentObjectsExist(path);
        if (node != null) {
            String lastPart = this.getLastPathPart(path);
            node.addProperty(lastPart, (Number)value);
        }
    }

    public synchronized void setStringList(String path, List<String> value) {
        JsonObject node = this.ensureParentObjectsExist(path);
        if (node != null) {
            String lastPart = this.getLastPathPart(path);
            JsonArray jsonArray = new JsonArray();
            for (String item : value) {
                jsonArray.add(item);
            }
            node.add(lastPart, (JsonElement)jsonArray);
        }
    }

    public synchronized void remove(String path) {
        if (!path.contains(".")) {
            this.conf.remove(path);
            return;
        }
        JsonObject node = this.navigateToNode(path);
        if (node != null) {
            String lastPart = this.getLastPathPart(path);
            node.remove(lastPart);
        }
    }

    public void reload() {
        if (this.file.exists()) {
            try (FileReader reader = new FileReader(this.file);){
                this.conf = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void save() {
        try (FileWriter writer = new FileWriter(this.file);){
            this.gson.toJson((JsonElement)this.conf, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Generated
    public JsonObject getConf() {
        return this.conf;
    }

    @Generated
    public void setConf(JsonObject conf) {
        this.conf = conf;
    }

    @Generated
    public File getFile() {
        return this.file;
    }
}

