/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.simpleapi.encryption;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class EncryptionHandler {
    private static Cipher dcipher;
    private static Cipher ecipher;
    private static SecretKey key;

    public EncryptionHandler(String pluginName, File file) {
        try {
            if (file.exists()) {
                this.loadKey(file);
            } else {
                this.generateKey();
                this.save(file);
            }
            ecipher = Cipher.getInstance("AES");
            dcipher = Cipher.getInstance("AES");
            ecipher.init(1, key);
            dcipher.init(2, key);
            String msg = "This is a classified message!";
            String encrypted = this.encrypt(msg);
            String decrypted = this.decrypt(encrypted);
            if (!msg.equals(decrypted)) {
                System.out.println(pluginName + ": Encryption/Decryption failed: " + decrypted);
            }
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("No Such Algorithm:" + e.getMessage());
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            System.out.println("No Such Padding:" + e.getMessage());
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            System.out.println("Invalid Key:" + e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String decrypt(String str) {
        try {
            byte[] dec = Base64.getDecoder().decode(str.getBytes());
            byte[] utf8 = dcipher.doFinal(dec);
            return new String(utf8, "UTF8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String encrypt(String str) {
        try {
            byte[] utf8 = str.getBytes("UTF8");
            byte[] enc = ecipher.doFinal(utf8);
            return Base64.getEncoder().encodeToString(enc);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void generateKey() throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        keyGenerator.init(256);
        key = keyGenerator.generateKey();
    }

    private void loadKey(File file) throws IOException {
        String str = new String(Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0])));
        key = new SecretKeySpec(Base64.getDecoder().decode(str), "AES");
    }

    public void save(File file) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(Base64.getEncoder().withoutPadding().encodeToString(key.getEncoded()));
        fileWriter.close();
    }
}

