/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.simpleapi.command;

import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import com.bencodez.votingplugin.simpleapi.command.CommandHandler;
import com.bencodez.votingplugin.simpleapi.command.TabCompleteHandle;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.bukkit.command.CommandSender;

public class TabCompleteHandler {
    static TabCompleteHandler instance = new TabCompleteHandler();
    private ConcurrentHashMap<String, ArrayList<String>> tabCompleteOptions = new ConcurrentHashMap();
    private ArrayList<String> tabCompleteReplaces = new ArrayList();
    private ConcurrentLinkedQueue<TabCompleteHandle> tabCompletes = new ConcurrentLinkedQueue();

    public static TabCompleteHandler getInstance() {
        return instance;
    }

    public void addTabCompleteOption(String toReplace, ArrayList<String> options) {
        this.addTabCompleteOption(new TabCompleteHandle(toReplace, options){

            @Override
            public void reload() {
            }

            @Override
            public void updateReplacements() {
            }
        });
    }

    public void addTabCompleteOption(String toReplace, String ... options) {
        this.addTabCompleteOption(toReplace, ArrayUtils.convert(options));
    }

    public void addTabCompleteOption(TabCompleteHandle handle) {
        for (TabCompleteHandle h : this.tabCompletes) {
            if (!h.getToReplace().equals(handle.getToReplace())) continue;
            return;
        }
        handle.reload();
        this.tabCompletes.add(handle);
        this.loadTabCompleteOptions();
        ArrayList<String> list = new ArrayList<String>();
        for (TabCompleteHandle h : this.tabCompletes) {
            list.add(h.getToReplace());
            h.updateReplacements();
        }
        this.tabCompleteReplaces.clear();
        this.tabCompleteReplaces.addAll(list);
    }

    public ConcurrentHashMap<String, ArrayList<String>> getTabCompleteOptions() {
        return this.tabCompleteOptions;
    }

    public ArrayList<String> getTabCompleteOptions(ArrayList<CommandHandler> handles, CommandSender sender, String[] args, int argNum) {
        ArrayList<String> tabComplete = new ArrayList<String>();
        ConcurrentHashMap<String, ArrayList<String>> options = this.getTabCompleteOptions();
        for (CommandHandler h : handles) {
            tabComplete.addAll(h.getTabCompleteOptions(sender, args, argNum, options));
        }
        return tabComplete;
    }

    public ArrayList<String> getTabCompleteReplaces() {
        return this.tabCompleteReplaces;
    }

    public void loadTabCompleteOptions() {
        for (TabCompleteHandle h : this.tabCompletes) {
            h.updateReplacements();
        }
        this.tabCompleteOptions.clear();
        for (TabCompleteHandle h : this.tabCompletes) {
            this.tabCompleteOptions.put(h.getToReplace(), h.getReplace());
        }
    }

    public void loadTimer(ScheduledExecutorService timer) {
        timer.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                TabCompleteHandler.this.loadTabCompleteOptions();
            }
        }, 5L, 30L, TimeUnit.MINUTES);
    }

    public void onLogin() {
        for (TabCompleteHandle h : this.tabCompletes) {
            if (!h.isUpdateOnLoginLogout()) continue;
            h.updateReplacements();
        }
        this.tabCompleteOptions.clear();
        for (TabCompleteHandle h : this.tabCompletes) {
            this.tabCompleteOptions.put(h.getToReplace(), h.getReplace());
        }
    }

    public void reload() {
        for (TabCompleteHandle h : this.tabCompletes) {
            h.reload();
        }
    }
}

