/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.simpleapi.command;

import java.util.ArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public abstract class TabCompleteHandle {
    private ArrayList<String> replace = new ArrayList();
    private String toReplace;
    private boolean updateOnLoginLogout = false;

    public TabCompleteHandle(String toReplace) {
        this.toReplace = toReplace;
        this.reload();
    }

    public TabCompleteHandle(String toReplace, ArrayList<String> replace) {
        this.toReplace = toReplace;
        this.replace = replace;
    }

    public abstract void reload();

    public TabCompleteHandle updateEveryXMinutes(ScheduledExecutorService timer, int x) {
        timer.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                TabCompleteHandle.this.updateReplacements();
            }
        }, x, x, TimeUnit.SECONDS);
        return this;
    }

    public TabCompleteHandle updateOnLoginLogout() {
        this.updateOnLoginLogout = true;
        return this;
    }

    public abstract void updateReplacements();

    @Generated
    public ArrayList<String> getReplace() {
        return this.replace;
    }

    @Generated
    public void setReplace(ArrayList<String> replace) {
        this.replace = replace;
    }

    @Generated
    public String getToReplace() {
        return this.toReplace;
    }

    @Generated
    public void setToReplace(String toReplace) {
        this.toReplace = toReplace;
    }

    @Generated
    public boolean isUpdateOnLoginLogout() {
        return this.updateOnLoginLogout;
    }
}

