/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.simpleapi.command;

import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import com.bencodez.votingplugin.simpleapi.command.TabCompleteHandler;
import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import com.bencodez.votingplugin.simpleapi.player.PlayerUtils;
import com.bencodez.votingplugin.simpleapi.scheduler.BukkitScheduler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.regex.Pattern;
import lombok.Generated;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class CommandHandler {
    private boolean advancedCoreCommand = false;
    private boolean allowConsole = true;
    private boolean allowMultiplePermissions = true;
    private String[] args;
    private boolean forceConsole = false;
    private String helpMessage;
    private boolean ignoreNumberCheck = false;
    private String perm = "";
    private JavaPlugin plugin;

    public CommandHandler(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public CommandHandler(JavaPlugin plugin, String[] args, String perm) {
        this.plugin = plugin;
        this.args = args;
        this.perm = perm;
        this.helpMessage = "Unknown Help Message";
    }

    public CommandHandler(JavaPlugin plugin, String[] args, String perm, String helpMessage) {
        this.plugin = plugin;
        this.args = args;
        this.perm = perm;
        this.helpMessage = helpMessage;
    }

    public CommandHandler(JavaPlugin plugin, String[] args, String perm, String helpMessage, boolean allowConsole) {
        this.plugin = plugin;
        this.args = args;
        this.perm = perm;
        this.helpMessage = helpMessage;
        this.allowConsole = allowConsole;
    }

    public CommandHandler(JavaPlugin plugin, String[] args, String perm, String helpMessage, boolean allowConsole, boolean forceConsole) {
        this.plugin = plugin;
        this.args = args;
        this.perm = perm;
        this.helpMessage = helpMessage;
        this.allowConsole = allowConsole;
        this.forceConsole = forceConsole;
    }

    @Deprecated
    public void addTabCompleteOption(String toReplace, ArrayList<String> options) {
        TabCompleteHandler.getInstance().addTabCompleteOption(toReplace, options);
    }

    @Deprecated
    public void addTabCompleteOption(String toReplace, String ... options) {
        this.addTabCompleteOption(toReplace, ArrayUtils.convert(options));
    }

    public boolean argsMatch(String arg, int i) {
        if (i < this.args.length) {
            String[] cmdArgs = this.args[i].split("&");
            for (String cmdArg : cmdArgs) {
                if (arg.equalsIgnoreCase(cmdArg)) {
                    return true;
                }
                for (String str : TabCompleteHandler.getInstance().getTabCompleteReplaces()) {
                    if (!str.equalsIgnoreCase(cmdArg)) continue;
                    return true;
                }
            }
            for (String str : TabCompleteHandler.getInstance().getTabCompleteReplaces()) {
                if (!str.equalsIgnoreCase(this.args[i])) continue;
                return true;
            }
            return false;
        }
        return this.args[this.args.length - 1].equalsIgnoreCase("(list)");
    }

    public abstract void debug(String var1);

    public abstract void execute(CommandSender var1, String[] var2);

    public abstract String formatNoPerms();

    public abstract String formatNotNumber();

    public abstract BukkitScheduler getBukkitScheduler();

    public abstract String getHelpLine();

    public TextComponent getHelpLine(String command) {
        String line = this.getHelpLine();
        String commandText = this.getHelpLineCommand(command);
        line = line.replace("%Command%", commandText);
        if (this.getHelpMessage() != "") {
            line = line.replace("%HelpMessage%", this.getHelpMessage());
        }
        TextComponent txt = MessageAPI.stringToComp(line);
        txt.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, commandText));
        txt.setHoverEvent(MessageAPI.getHoverEventSupport().createHoverEvent(TextComponent.fromLegacyText((String)(ChatColor.AQUA + this.getHelpMessage()))));
        return txt;
    }

    public TextComponent getHelpLine(String command, String line) {
        String commandText = this.getHelpLineCommand(command);
        line = line.replace("%Command%", commandText);
        if (this.getHelpMessage() != "") {
            line = line.replace("%HelpMessage%", this.getHelpMessage());
        }
        TextComponent txt = MessageAPI.stringToComp(line);
        txt.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, commandText));
        txt.setHoverEvent(MessageAPI.getHoverEventSupport().createHoverEvent(TextComponent.fromLegacyText((String)(ChatColor.AQUA + this.getHelpMessage()))));
        return txt;
    }

    public TextComponent getHelpLine(String command, String line, ChatColor hoverColor) {
        String commandText = this.getHelpLineCommand(command);
        line = line.replace("%Command%", commandText);
        if (this.getHelpMessage() != "") {
            line = line.replace("%HelpMessage%", this.getHelpMessage());
        }
        TextComponent txt = MessageAPI.stringToComp(line);
        txt.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, commandText));
        txt.setHoverEvent(MessageAPI.getHoverEventSupport().createHoverEvent(TextComponent.fromLegacyText((String)(hoverColor + this.getHelpMessage()))));
        return txt;
    }

    public String getHelpLineCommand(String command) {
        String commandText = command;
        boolean addSpace = true;
        if (command.isEmpty()) {
            addSpace = false;
        }
        for (String arg1 : this.args) {
            int count = 1;
            for (String arg : arg1.split("&")) {
                if (count == 1) {
                    if (addSpace) {
                        commandText = commandText + " " + arg;
                    } else {
                        commandText = commandText + arg;
                        addSpace = true;
                    }
                } else {
                    commandText = commandText + "/" + arg;
                }
                ++count;
            }
        }
        return commandText;
    }

    public ArrayList<String> getTabCompleteOptions(CommandSender sender, String[] args, int argNum, ConcurrentHashMap<String, ArrayList<String>> tabCompleteOptions) {
        CommandHandler commandHandler;
        String[] cmdArgs;
        HashSet<String> cmds = new HashSet<String>();
        if (this.hasPerm(sender) && (cmdArgs = (commandHandler = this).getArgs()).length > argNum) {
            boolean argsMatch = true;
            for (int i = 0; i < argNum; ++i) {
                if (args.length < i || commandHandler.argsMatch(args[i], i)) continue;
                argsMatch = false;
            }
            if (argsMatch) {
                String[] cmdArgsList;
                for (String arg : cmdArgsList = cmdArgs[argNum].split("&")) {
                    boolean add = true;
                    for (Map.Entry<String, ArrayList<String>> entry : tabCompleteOptions.entrySet()) {
                        if (!arg.equalsIgnoreCase(entry.getKey())) continue;
                        add = false;
                        cmds.addAll((Collection<String>)entry.getValue());
                    }
                    if (cmds.contains(arg) || !add) continue;
                    cmds.add(arg);
                }
            }
        }
        ArrayList<String> options = ArrayUtils.convert(cmds);
        Collections.sort(options, String.CASE_INSENSITIVE_ORDER);
        return options;
    }

    public boolean hasArg(String arg) {
        for (String str : this.getArgs()) {
            if (!str.equalsIgnoreCase(arg)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPerm(CommandSender sender) {
        if (this.getPerm().isEmpty()) {
            return true;
        }
        if (this.allowMultiplePermissions) {
            return PlayerUtils.hasEitherPermission(sender, this.getPerm());
        }
        return sender.hasPermission(this.getPerm().split(Pattern.quote("|"))[0]);
    }

    public CommandHandler ignoreNumberCheck() {
        this.ignoreNumberCheck = true;
        return this;
    }

    public boolean isCommand(String arg) {
        if (this.getArgs().length > 0) {
            for (String str : this.getArgs()[0].split("&")) {
                if (!str.equalsIgnoreCase(arg)) continue;
                return true;
            }
        } else if (arg.isEmpty() && this.getArgs().length == 0) {
            return true;
        }
        return false;
    }

    public boolean isPlayer(CommandSender sender) {
        return sender instanceof Player;
    }

    public CommandHandler noConsole() {
        this.allowConsole = false;
        return this;
    }

    public int parseInt(String arg) {
        return Integer.parseInt(arg);
    }

    public boolean runCommand(final CommandSender sender, String[] args) {
        if (args.length >= this.args.length) {
            if (this.args.length != args.length && !this.hasArg("(list)")) {
                return false;
            }
            block0: for (int i = 0; i < args.length && i < this.args.length; ++i) {
                if (!this.argsMatch(args[i], i)) {
                    return false;
                }
                if (this.args[i].equalsIgnoreCase("(number)")) {
                    if (this.ignoreNumberCheck || MessageAPI.isInt(args[i])) continue;
                    sender.sendMessage(MessageAPI.colorize(this.formatNotNumber().replace("%arg%", args[i])));
                    return true;
                }
                if (!this.args[i].equalsIgnoreCase("(Player)")) continue;
                if (args[i].equalsIgnoreCase("@p")) {
                    args[i] = sender.getName();
                    continue;
                }
                if (args[i].equalsIgnoreCase("@r")) {
                    args[i] = PlayerUtils.getRandomOnlinePlayer().getName();
                    continue;
                }
                Player p = Bukkit.getPlayer((String)args[i]);
                if (p == null) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        String name = player.getName();
                        if (!MessageAPI.containsIgnorecase(name, args[i])) continue;
                        this.debug("Completing name: " + args[i] + " to " + name);
                        args[i] = name;
                        continue block0;
                    }
                    continue;
                }
                if (args[i] == p.getName()) continue;
                args[i] = p.getName();
            }
            if (!(sender instanceof Player) && !this.allowConsole) {
                sender.sendMessage(MessageAPI.colorize("&cMust be a player to do this"));
                return true;
            }
            if (sender instanceof Player && this.forceConsole) {
                sender.sendMessage(MessageAPI.colorize("&cConsole command only"));
                return true;
            }
            if (!this.hasPerm(sender)) {
                if (!this.formatNoPerms().isEmpty()) {
                    sender.sendMessage(MessageAPI.colorize(this.formatNoPerms()));
                }
                this.plugin.getLogger().log(Level.INFO, sender.getName() + " was denied access to command, required permission: " + this.perm);
                return true;
            }
            if (args.length > 0 && args[0].equalsIgnoreCase("AdvancedCore")) {
                String[] list = new String[args.length - 1];
                for (int i = 1; i < args.length; ++i) {
                    list[i - 1] = args[i];
                }
                args = list;
            }
            final String[] argsNew = args;
            this.getBukkitScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    CommandHandler.this.execute(sender, argsNew);
                }
            });
            return true;
        }
        return false;
    }

    public void sendMessage(CommandSender sender, ArrayList<String> msg) {
        sender.sendMessage(ArrayUtils.convert(ArrayUtils.colorize(msg)));
    }

    public void sendMessage(CommandSender sender, String msg) {
        sender.sendMessage(MessageAPI.colorize(msg));
    }

    public void sendMessageJson(CommandSender sender, ArrayList<TextComponent> comp) {
        if (this.isPlayer(sender)) {
            Player player = (Player)sender;
            MessageAPI.sendJson(player, comp);
        } else {
            sender.sendMessage(ArrayUtils.convert(ArrayUtils.comptoString(comp)));
        }
    }

    public void sendMessageJson(CommandSender sender, TextComponent comp) {
        if (this.isPlayer(sender)) {
            Player player = (Player)sender;
            MessageAPI.sendJson(player, comp);
        } else {
            sender.sendMessage(MessageAPI.compToString(comp));
        }
    }

    public CommandHandler withArgs(String ... args) {
        this.args = args;
        return this;
    }

    public CommandHandler withHelpMessage(String helpMessage) {
        this.helpMessage = helpMessage;
        return this;
    }

    public CommandHandler withPerm(String perm) {
        this.perm = !this.perm.isEmpty() ? this.perm + "|" + perm : perm;
        return this;
    }

    public CommandHandler withPerm(String perm, boolean add) {
        if (!add) {
            return this;
        }
        this.perm = !this.perm.isEmpty() ? this.perm + "|" + perm : perm;
        return this;
    }

    @Generated
    public boolean isAdvancedCoreCommand() {
        return this.advancedCoreCommand;
    }

    @Generated
    public void setAdvancedCoreCommand(boolean advancedCoreCommand) {
        this.advancedCoreCommand = advancedCoreCommand;
    }

    @Generated
    public boolean isAllowConsole() {
        return this.allowConsole;
    }

    @Generated
    public void setAllowConsole(boolean allowConsole) {
        this.allowConsole = allowConsole;
    }

    @Generated
    public boolean isAllowMultiplePermissions() {
        return this.allowMultiplePermissions;
    }

    @Generated
    public void setAllowMultiplePermissions(boolean allowMultiplePermissions) {
        this.allowMultiplePermissions = allowMultiplePermissions;
    }

    @Generated
    public String[] getArgs() {
        return this.args;
    }

    @Generated
    public void setArgs(String[] args) {
        this.args = args;
    }

    @Generated
    public boolean isForceConsole() {
        return this.forceConsole;
    }

    @Generated
    public void setForceConsole(boolean forceConsole) {
        this.forceConsole = forceConsole;
    }

    @Generated
    public String getHelpMessage() {
        return this.helpMessage;
    }

    @Generated
    public void setHelpMessage(String helpMessage) {
        this.helpMessage = helpMessage;
    }

    @Generated
    public boolean isIgnoreNumberCheck() {
        return this.ignoreNumberCheck;
    }

    @Generated
    public String getPerm() {
        return this.perm;
    }

    @Generated
    public void setPerm(String perm) {
        this.perm = perm;
    }

    @Generated
    public JavaPlugin getPlugin() {
        return this.plugin;
    }
}

