/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.simpleapi.array;

import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;

public class ArrayUtils {
    public static ArrayList<String> colorize(ArrayList<String> list) {
        if (list == null) {
            return null;
        }
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, MessageAPI.colorize(list.get(i)));
        }
        return list;
    }

    public static List<String> colorize(List<String> list) {
        if (list == null) {
            return null;
        }
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, MessageAPI.colorize(list.get(i)));
        }
        return list;
    }

    public static String[] colorize(String[] list) {
        if (list == null) {
            return null;
        }
        for (int i = 0; i < list.length; ++i) {
            list[i] = MessageAPI.colorize(list[i]);
        }
        return list;
    }

    public static ArrayList<String> comptoString(ArrayList<TextComponent> comps) {
        ArrayList<String> txt = new ArrayList<String>();
        for (TextComponent comp : comps) {
            txt.add(MessageAPI.compToString(comp));
        }
        return txt;
    }

    public static boolean containsIgnoreCase(ArrayList<String> set, String str) {
        str = str.toLowerCase();
        for (String text : set) {
            if (!(text = text.toLowerCase()).equals(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsIgnoreCase(List<String> set, String str) {
        str = str.toLowerCase();
        for (String text : set) {
            if (!(text = text.toLowerCase()).equals(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsIgnoreCase(Set<String> set, String str) {
        str = str.toLowerCase();
        for (String text : set) {
            if (!(text = text.toLowerCase()).equals(str)) continue;
            return true;
        }
        return false;
    }

    public static String[] convert(ArrayList<String> list) {
        if (list == null) {
            return null;
        }
        String[] string = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            string[i] = list.get(i);
        }
        return string;
    }

    public static ArrayList<String> convert(Set<String> set1) {
        HashSet<String> set = new HashSet<String>(set1);
        ArrayList<String> list = new ArrayList<String>();
        for (String st : set) {
            list.add(st);
        }
        return list;
    }

    public static ArrayList<String> convert(String[] list) {
        if (list == null) {
            return null;
        }
        ArrayList<String> newlist = new ArrayList<String>();
        for (String element : list) {
            newlist.add(element);
        }
        if (newlist == null) {
            return null;
        }
        return newlist;
    }

    public static BaseComponent[] convertBaseComponent(ArrayList<BaseComponent> list) {
        if (list == null) {
            return null;
        }
        BaseComponent[] string = new BaseComponent[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            string[i] = list.get(i);
        }
        return string;
    }

    public static ArrayList<BaseComponent> convertBaseComponent(BaseComponent[] list) {
        if (list == null) {
            return null;
        }
        ArrayList<BaseComponent> newlist = new ArrayList<BaseComponent>();
        for (BaseComponent element : list) {
            newlist.add(element);
        }
        return newlist;
    }

    public static ItemStack[] convertItems(Collection<ItemStack> list) {
        if (list == null) {
            return null;
        }
        ItemStack[] string = new ItemStack[list.size()];
        int i = 0;
        Iterator<ItemStack> iterator = list.iterator();
        while (iterator.hasNext()) {
            ItemStack item;
            string[i] = item = iterator.next();
            ++i;
        }
        return string;
    }

    public static ItemStack[] convertItems(List<Item> list) {
        if (list == null) {
            return null;
        }
        ItemStack[] string = new ItemStack[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            string[i] = list.get(i).getItemStack();
        }
        return string;
    }

    public static String[] convertSet(Set<String> set) {
        String[] array = new String[set.size()];
        int i = 0;
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            String item;
            array[i] = item = iterator.next();
            ++i;
        }
        if (array == null) {
            return null;
        }
        return array;
    }

    public static HashMap<String, String> fromString(String str) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (!str.equals("")) {
            for (String entry : str.split("%entry%")) {
                String[] values = entry.split("%pair%");
                if (values.length <= 1) continue;
                String key = values[0];
                String value = values[1];
                map.put(key, value);
            }
        }
        return map;
    }

    public static String makeString(HashMap<String, String> placeholders) {
        String str = "";
        int count = 0;
        if (placeholders != null && !placeholders.isEmpty()) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                str = str + entry.getKey() + "%pair%" + entry.getValue();
                if (++count == placeholders.size()) continue;
                str = str + "%entry%";
            }
        }
        return str;
    }

    public static String makeString(int startIndex, String[] strs) {
        String str = new String();
        for (int i = startIndex; i < strs.length; ++i) {
            str = i == startIndex ? str + strs[i] : str + " " + strs[i];
        }
        return str;
    }

    public static String makeStringList(ArrayList<String> list) {
        if (list == null) {
            return "";
        }
        String string = new String();
        if (list.size() > 1) {
            for (int i = 0; i < list.size(); ++i) {
                string = i == 0 ? string + list.get(i) : string + ", " + list.get(i);
            }
        } else if (list.size() == 1) {
            string = list.get(0);
        }
        return string;
    }

    public static String makeStringList(List<String> list) {
        if (list == null) {
            return "";
        }
        String string = new String();
        if (list.size() > 1) {
            for (int i = 0; i < list.size(); ++i) {
                string = i == 0 ? string + list.get(i) : string + ", " + list.get(i);
            }
        } else if (list.size() == 1) {
            string = list.get(0);
        }
        return string;
    }

    public static String pickRandom(ArrayList<String> list) {
        if (list != null) {
            return list.get(ThreadLocalRandom.current().nextInt(list.size()));
        }
        return "";
    }

    public static ArrayList<String> removeDuplicates(ArrayList<String> list) {
        HashSet<String> set = new HashSet<String>();
        set.addAll(list);
        list.clear();
        list.addAll(set);
        return list;
    }

    public static List<String> replace(List<String> list, String toReplace, String replaceWith) {
        if (list == null) {
            return null;
        }
        if (replaceWith == null || toReplace == null) {
            return list;
        }
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, list.get(i).replace(toReplace, replaceWith));
        }
        return list;
    }

    public static ArrayList<String> replaceIgnoreCase(ArrayList<String> list, String toReplace, String replaceWith) {
        ArrayList<String> newList = new ArrayList<String>();
        for (String msg : list) {
            newList.add(MessageAPI.replaceIgnoreCase(msg, toReplace, replaceWith));
        }
        return newList;
    }

    public static ArrayList<String> sort(ArrayList<String> list) {
        Collections.sort(list, String.CASE_INSENSITIVE_ORDER);
        return list;
    }

    public static ArrayList<String> convertAndRemoveFirst(String[] array) {
        if (array == null || array.length == 0) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(array));
        list.remove(0);
        return list;
    }

    public static HashMap<String, Integer> sortByValuesStr(HashMap<String, Integer> unsortMap, final boolean order) {
        LinkedList<Map.Entry<String, Integer>> list = new LinkedList<Map.Entry<String, Integer>>(unsortMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                if (order) {
                    return o1.getValue().compareTo(o2.getValue());
                }
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        LinkedHashMap<String, Integer> sortedMap = new LinkedHashMap<String, Integer>();
        for (Map.Entry entry : list) {
            sortedMap.put((String)entry.getKey(), (Integer)entry.getValue());
        }
        return sortedMap;
    }

    public static LinkedHashMap<String, ItemStack> sortByValuesStrItem(HashMap<String, ItemStack> unsortMap) {
        ArrayList<String> sortedKeys = ArrayUtils.sort(new ArrayList<String>(unsortMap.keySet()));
        LinkedHashMap<String, ItemStack> sortedMap = new LinkedHashMap<String, ItemStack>();
        for (String key : sortedKeys) {
            sortedMap.put(key, unsortMap.get(key));
        }
        return sortedMap;
    }
}

