/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.signs;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.signs.SignHandler;
import java.util.ArrayList;
import lombok.Generated;
import org.bukkit.Location;

public class Signs {
    private VotingPluginMain plugin;
    private ArrayList<SignHandler> signs;

    public Signs(VotingPluginMain plugin) {
        this.plugin = plugin;
        this.signs = new ArrayList();
    }

    public String getSignFromLocation(Location loc) {
        for (String sign : this.plugin.getServerData().getSigns()) {
            if (!this.plugin.getServerData().getSignLocation(sign).equals((Object)loc)) continue;
            return sign;
        }
        return null;
    }

    public void loadSigns() {
        this.setSigns(new ArrayList<SignHandler>());
        for (String sign : this.plugin.getServerData().getSigns()) {
            this.getSigns().add(new SignHandler(this.plugin, sign, this.plugin.getServerData().getSignLocation(sign), this.plugin.getServerData().getSignSkullLocation(sign), this.plugin.getServerData().getSignData(sign), this.plugin.getServerData().getSignPosition(sign)));
        }
    }

    public void storeSigns() {
        for (SignHandler sign : this.getSigns()) {
            sign.storeSign();
        }
    }

    public void updateSigns() {
        int time = 0;
        for (int i = this.getSigns().size() - 1; i >= 0; --i) {
            if (!this.getSigns().get(i).isValid()) {
                this.plugin.debug("Sign " + i + " invalid, removing from data: " + this.getSigns().get(i).getLocation().toString());
                this.getSigns().get(i).removeSign();
                this.getSigns().remove(i);
                continue;
            }
            this.getSigns().get(i).updateLines();
            this.getSigns().get(i).updateSign(time);
            ++time;
        }
        this.plugin.debug(this.getSigns().size() + " Signs updated");
    }

    @Generated
    public ArrayList<SignHandler> getSigns() {
        return this.signs;
    }

    @Generated
    public void setSigns(ArrayList<SignHandler> signs) {
        this.signs = signs;
    }
}

