/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.signs;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.misc.MiscUtils;
import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import com.bencodez.votingplugin.simpleapi.nms.NMSManager;
import com.bencodez.votingplugin.topvoter.TopVoter;
import com.bencodez.votingplugin.topvoter.TopVoterPlayer;
import java.util.ArrayList;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.Skull;
import org.bukkit.block.data.Directional;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;

public class SignHandler {
    private String data;
    private ArrayList<String> lines;
    private Location location;
    private String playerName;
    private UUID uuid;
    private VotingPluginMain plugin;
    private int position;
    private String sign;
    private Location skullLocation;
    private boolean valid;
    private int votes;

    public SignHandler(VotingPluginMain plugin, String sign, Location location, Location skullLocation, String data, int position) {
        this.plugin = plugin;
        this.setSign(sign);
        this.setLocation(location);
        this.setSkullLocation(skullLocation);
        this.setData(data);
        this.position = position;
        this.setValid(true);
        this.lines = new ArrayList();
        this.checkValidSign();
        this.playerName = "";
    }

    private boolean checkSkull(Block block) {
        if (block.getState() instanceof Skull) {
            if (!this.playerName.equals("No Player")) {
                Skull skull = (Skull)block.getState();
                try {
                    SkullMeta meta = (SkullMeta)this.plugin.getSkullCacheHandler().getSkull(this.uuid, this.playerName).getItemMeta();
                    skull.setOwnerProfile(meta.getOwnerProfile());
                    skull.update(true, false);
                }
                catch (Exception e) {
                    this.plugin.debug("Failed to set skull for " + this.playerName);
                    this.plugin.debug(e);
                    skull.setOwner(this.playerName);
                    skull.update(true, false);
                }
            }
            return true;
        }
        return false;
    }

    public void checkSkulls() {
        if (this.noNameAvailable()) {
            return;
        }
        if (this.skullLocation != null) {
            this.checkSkull(this.skullLocation.getBlock());
            return;
        }
        Location loc = this.location;
        Location loc1 = new Location(loc.getWorld(), (double)(loc.getBlockX() - 1), (double)(loc.getBlockY() - 1), (double)(loc.getBlockZ() - 1));
        Location loc2 = new Location(loc.getWorld(), (double)(loc.getBlockX() + 1), (double)(loc.getBlockY() + 1), (double)(loc.getBlockZ() + 1));
        this.updateSkulls(loc1, loc2);
    }

    public void checkValidSign() {
        this.plugin.getBukkitScheduler().runTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                try {
                    SignHandler.this.setValid(SignHandler.this.getLocation().getBlock().getState() instanceof Sign);
                }
                catch (Exception ex) {
                    SignHandler.this.setValid(false);
                }
            }
        }, this.getLocation());
    }

    public String getRightClickMessage() {
        String msg = this.plugin.getConfigFile().getFormatSignTopVoterSignRightClickMessage();
        msg = msg.replace("%player%", this.playerName);
        msg = msg.replace("%position%", "" + this.position);
        msg = msg.replace("%votes%", "" + this.votes);
        msg = msg.replace("%SiteName%", this.data);
        return msg;
    }

    public boolean isLocationSame(Location loc) {
        return loc.equals((Object)this.getLocation());
    }

    public boolean isSkullSet() {
        return this.skullLocation != null;
    }

    public boolean noNameAvailable() {
        return this.playerName.equalsIgnoreCase("No Player") || this.playerName.equals("");
    }

    public void removeSign() {
        this.plugin.getServerData().removeSign(this.sign);
    }

    public void storeSign() {
        this.plugin.getServerData().setSign(this.sign, this.location, this.skullLocation, this.data, this.position);
    }

    public void updateLines() {
        this.lines = new ArrayList();
        this.checkValidSign();
        if (this.position != 0) {
            String line1 = this.plugin.getConfigFile().getFormatSignTopVoterSignLine1();
            String line2 = this.plugin.getConfigFile().getFormatSignTopVoterSignLine2();
            String line3 = this.plugin.getConfigFile().getFormatSignTopVoterSignLine3();
            String line4 = this.plugin.getConfigFile().getFormatSignTopVoterSignLine4();
            this.lines.add(line1);
            this.lines.add(line2);
            this.lines.add(line3);
            this.lines.add(line4);
            ArrayList<TopVoterPlayer> users = null;
            if (this.data.equalsIgnoreCase("all")) {
                users = this.plugin.convertSet(this.plugin.getTopVoter(TopVoter.AllTime).keySet());
            } else if (this.data.equalsIgnoreCase("monthly")) {
                users = this.plugin.convertSet(this.plugin.getTopVoter(TopVoter.Monthly).keySet());
            } else if (this.data.equalsIgnoreCase("weekly")) {
                users = this.plugin.convertSet(this.plugin.getTopVoter(TopVoter.Weekly).keySet());
            } else if (this.data.equalsIgnoreCase("daily")) {
                users = this.plugin.convertSet(this.plugin.getTopVoter(TopVoter.Daily).keySet());
            }
            if (users != null && users.size() >= this.position) {
                TopVoterPlayer user = users.get(this.position - 1);
                this.playerName = user.getPlayerName();
                this.uuid = user.getUuid();
                this.votes = 0;
                if (this.data.equalsIgnoreCase("all")) {
                    this.votes = this.plugin.getTopVoter(TopVoter.AllTime).get(user);
                } else if (this.data.equalsIgnoreCase("monthly")) {
                    this.votes = this.plugin.getTopVoter(TopVoter.Monthly).get(user);
                } else if (this.data.equalsIgnoreCase("weekly")) {
                    this.votes = this.plugin.getTopVoter(TopVoter.Weekly).get(user);
                } else if (this.data.equalsIgnoreCase("daily")) {
                    this.votes = this.plugin.getTopVoter(TopVoter.Daily).get(user);
                }
                for (int j = 0; j < this.lines.size(); ++j) {
                    this.lines.set(j, this.lines.get(j).replace("%votes%", "" + this.votes).replace("%player%", this.playerName));
                }
            } else {
                this.playerName = "No Player";
                this.votes = 0;
                for (int j = 0; j < this.lines.size(); ++j) {
                    this.lines.set(j, this.lines.get(j).replace("%votes%", "" + this.votes).replace("%player%", this.playerName));
                }
            }
            for (int j = 0; j < this.lines.size(); ++j) {
                this.lines.set(j, this.lines.get(j).replace("%SiteName%", this.data).replace("%position%", "" + this.position));
            }
            this.lines = ArrayUtils.colorize(this.lines);
        }
    }

    public void updateSign(int delay) {
        this.plugin.getBukkitScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                try {
                    BlockState state = SignHandler.this.getLocation().getBlock().getState();
                    if (state instanceof Sign) {
                        Sign s = (Sign)state;
                        for (int j = 0; j < SignHandler.this.lines.size() && j < 4; ++j) {
                            s.setLine(j, (String)SignHandler.this.lines.get(j));
                        }
                        s.update();
                        SignHandler.this.checkSkulls();
                    }
                }
                catch (Exception ex) {
                    SignHandler.this.plugin.debug("Failed to update sign at " + SignHandler.this.getLocation().toString());
                    VotingPluginMain.plugin.debug(ex);
                }
            }
        }, (long)delay, this.getLocation());
    }

    public void updateSkulls(Location loc1, Location loc2) {
        if (!NMSManager.getInstance().isVersion("1.12")) {
            BlockState state = this.getLocation().getBlock().getState();
            if (state instanceof Sign && state.getBlockData() instanceof Directional) {
                Directional s = (Directional)state.getBlockData();
                Block b = this.location.getBlock().getRelative(s.getFacing());
                Block above = b.getRelative(BlockFace.UP);
                if (this.checkSkull(above)) {
                    return;
                }
            }
            for (Block block : MiscUtils.getInstance().getRegionBlocks(this.location.getWorld(), loc1, loc2)) {
                this.checkSkull(block);
            }
        }
    }

    @Generated
    public String getData() {
        return this.data;
    }

    @Generated
    public void setData(String data) {
        this.data = data;
    }

    @Generated
    public Location getLocation() {
        return this.location;
    }

    @Generated
    public void setLocation(Location location) {
        this.location = location;
    }

    @Generated
    public String getSign() {
        return this.sign;
    }

    @Generated
    public void setSign(String sign) {
        this.sign = sign;
    }

    @Generated
    public Location getSkullLocation() {
        return this.skullLocation;
    }

    @Generated
    public void setSkullLocation(Location skullLocation) {
        this.skullLocation = skullLocation;
    }

    @Generated
    public boolean isValid() {
        return this.valid;
    }

    @Generated
    public void setValid(boolean valid) {
        this.valid = valid;
    }
}

