/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.servicesites;

import com.bencodez.votingplugin.VotingPluginMain;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public class ServiceSiteHandler {
    private HashMap<String, String> serviceSites = new HashMap();
    private VotingPluginMain plugin;

    public ServiceSiteHandler(VotingPluginMain plugin) {
        this.plugin = plugin;
        this.loadFromGithub();
        for (Map.Entry<String, String> entry : this.serviceSites.entrySet()) {
            plugin.extraDebug(entry.getKey() + " - " + entry.getValue());
        }
    }

    public boolean contains(String service) {
        for (Map.Entry<String, String> entry : this.serviceSites.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(service)) continue;
            return true;
        }
        return false;
    }

    public void loadFromGithub() {
        try {
            this.readFromWeb("https://github.com/BenCodez/VotingPlugin/wiki/Minecraft-Server-Lists");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String match(String service) {
        for (Map.Entry<String, String> entry : this.serviceSites.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(service)) continue;
            return entry.getValue();
        }
        return service;
    }

    public String matchReverse(String service) {
        for (Map.Entry<String, String> entry : this.serviceSites.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(service)) continue;
            return entry.getKey();
        }
        return service;
    }

    public void readFromWeb(String webURL) throws IOException {
        this.serviceSites.clear();
        URL url = new URL(webURL);
        InputStream is = url.openStream();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
            String line;
            boolean rawFound = false;
            while ((line = br.readLine()) != null) {
                String data;
                String[] split;
                if (line.contains("<ul>")) {
                    rawFound = true;
                    continue;
                }
                if (!line.contains(" - ")) {
                    rawFound = false;
                    continue;
                }
                if (!rawFound || (split = (data = line.replaceAll("<li>", "").replaceAll("</li>", "")).split(" - ")).length <= 0) continue;
                this.serviceSites.put(split[0], split[1]);
            }
        }
        catch (MalformedURLException e) {
            this.plugin.debug(e);
        }
        catch (IOException e) {
            this.plugin.debug(e);
        }
    }

    @Generated
    public HashMap<String, String> getServiceSites() {
        return this.serviceSites;
    }
}

