/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.proxy.velocity;

import com.bencodez.votingplugin.advancedcore.api.time.TimeType;
import com.bencodez.votingplugin.advancedcore.bungeeapi.globaldata.GlobalDataHandlerProxy;
import com.bencodez.votingplugin.advancedcore.bungeeapi.globaldata.GlobalMySQL;
import com.bencodez.votingplugin.bstats.charts.SimplePie;
import com.bencodez.votingplugin.bstats.velocity.Metrics;
import com.bencodez.votingplugin.proxy.BungeeVersion;
import com.bencodez.votingplugin.proxy.ProxyMysqlUserTable;
import com.bencodez.votingplugin.proxy.VotingPluginProxy;
import com.bencodez.votingplugin.proxy.VotingPluginProxyConfig;
import com.bencodez.votingplugin.proxy.velocity.Config;
import com.bencodez.votingplugin.proxy.velocity.NonVotedPlayersCache;
import com.bencodez.votingplugin.proxy.velocity.VoteCache;
import com.bencodez.votingplugin.proxy.velocity.VoteEventVelocity;
import com.bencodez.votingplugin.proxy.velocity.VotingPluginVelocityCommand;
import com.bencodez.votingplugin.simpleapi.file.velocity.VelocityYMLFile;
import com.bencodez.votingplugin.simpleapi.sql.DataType;
import com.bencodez.votingplugin.simpleapi.sql.mysql.config.MysqlConfig;
import com.bencodez.votingplugin.simpleapi.sql.mysql.config.MysqlConfigVelocity;
import com.bencodez.votingplugin.topvoter.TopVoter;
import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.scheduler.ScheduledTask;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.CodeSource;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.yaml.YAMLConfigurationLoader;
import org.slf4j.Logger;

@Plugin(id="votingplugin", name="VotingPlugin", version="1.0", url="https://www.spigotmc.org/resources/votingplugin.15358/", description="VotingPlugin Velocity Version", authors={"BenCodez"}, dependencies={@Dependency(id="nuvotifier", optional=true)})
public class VotingPluginVelocity {
    private ChannelIdentifier CHANNEL;
    private Config config;
    private final Path dataDirectory;
    private final Logger logger;
    private final Metrics.Factory metricsFactory;
    private NonVotedPlayersCache nonVotedPlayersCache;
    private final ProxyServer server;
    private VoteCache voteCacheFile;
    private String version = "";
    private File versionFile;
    private String buildNumber = "NOTSET";
    private ScheduledExecutorService timer;
    public VotingPluginProxy votingPluginProxy;
    private ScheduledTask voteCheckTask;
    private ScheduledTask cacheSaveTask;

    @Inject
    public VotingPluginVelocity(ProxyServer server, Logger logger, Metrics.Factory metricsFactory, @DataDirectory Path dataDirectory) {
        this.server = server;
        this.logger = logger;
        this.dataDirectory = dataDirectory;
        this.metricsFactory = metricsFactory;
        this.timer = Executors.newScheduledThreadPool(1);
    }

    public void debug(String msg) {
        if (this.config.getDebug()) {
            this.logger.info("Debug: " + msg);
        }
    }

    public void debug2(String msg) {
        this.debug(msg);
    }

    public Set<String> getAvailableAllServers() {
        HashSet<String> servers = new HashSet<String>();
        if (this.config.getWhiteListedServers().isEmpty()) {
            for (RegisteredServer s : this.server.getAllServers()) {
                if (this.config.getBlockedServers().contains(s.getServerInfo().getName())) continue;
                servers.add(s.getServerInfo().getName());
            }
        } else {
            for (RegisteredServer s : this.server.getAllServers()) {
                if (!this.config.getWhiteListedServers().contains(s.getServerInfo().getName())) continue;
                servers.add(s.getServerInfo().getName());
            }
        }
        return servers;
    }

    public String getProperPlayerName(String uuid, String currentName) {
        Player p;
        if (this.server.getPlayer(UUID.fromString(uuid)).isPresent() && (p = (Player)this.server.getPlayer(UUID.fromString(uuid)).get()) != null && p.isActive()) {
            return p.getUsername();
        }
        return currentName;
    }

    private void getVersionFile() {
        try {
            CodeSource src = this.getClass().getProtectionDomain().getCodeSource();
            if (src != null) {
                int charVal;
                InputStreamReader defConfigStream;
                String name;
                ZipEntry e;
                URL jar = src.getLocation();
                ZipInputStream zip = null;
                zip = new ZipInputStream(jar.openStream());
                while ((e = zip.getNextEntry()) == null || !(name = e.getName()).equals("votingpluginversion.yml") || (defConfigStream = new InputStreamReader(zip)) == null) {
                }
                this.versionFile = new File(this.dataDirectory.toFile(), "tmp" + File.separator + "votingpluginversion.yml");
                if (!this.versionFile.exists()) {
                    this.versionFile.getParentFile().mkdirs();
                    this.versionFile.createNewFile();
                }
                FileWriter fileWriter = new FileWriter(this.versionFile);
                while ((charVal = ((Reader)defConfigStream).read()) != -1) {
                    fileWriter.append((char)charVal);
                }
                fileWriter.close();
                YAMLConfigurationLoader loader = ((YAMLConfigurationLoader.Builder)YAMLConfigurationLoader.builder().setFile(this.versionFile)).build();
                ((Reader)defConfigStream).close();
                ConfigurationNode node = loader.load();
                if (node != null) {
                    this.version = node.getNode(new Object[]{"version"}).getString("");
                    this.buildNumber = node.getNode(new Object[]{"buildnumber"}).getString("NOTSET");
                }
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadMysql() {
        this.votingPluginProxy.setProxyMySQL(new ProxyMysqlUserTable("VotingPlugin_Users", new MysqlConfigVelocity(this.config), this.config.getDebug()){

            @Override
            public void debug(SQLException e) {
                if (VotingPluginVelocity.this.config.getDebug()) {
                    e.printStackTrace();
                }
            }

            @Override
            public void severe(String str) {
                VotingPluginVelocity.this.getLogger().error(str);
            }

            @Override
            public void logSevere(String string) {
                VotingPluginVelocity.this.logger.error(string);
            }

            @Override
            public void logInfo(String string) {
                VotingPluginVelocity.this.logger.info(string);
            }
        });
        ArrayList<String> servers = new ArrayList<String>();
        for (String s : this.getAvailableAllServers()) {
            servers.add(s);
        }
        if (this.config.getGlobalDataEnabled()) {
            if (this.config.getGlobalDataUseMainMySQL()) {
                this.votingPluginProxy.setGlobalDataHandler(new GlobalDataHandlerProxy(new GlobalMySQL("VotingPlugin_GlobalData", this.getVotingPluginProxy().getProxyMySQL().getMysql()){

                    @Override
                    public void debugEx(Exception e) {
                        if (VotingPluginVelocity.this.config.getDebug()) {
                            e.printStackTrace();
                        }
                    }

                    @Override
                    public void debugLog(String text) {
                        VotingPluginVelocity.this.debug2(text);
                    }

                    @Override
                    public void info(String text) {
                        VotingPluginVelocity.this.logger.info(text);
                    }

                    @Override
                    public void logSevere(String text) {
                        VotingPluginVelocity.this.logger.error(text);
                    }

                    @Override
                    public void warning(String text) {
                        VotingPluginVelocity.this.logger.warn(text);
                    }
                }, servers){

                    @Override
                    public void onTimeChangedFailed(String server, TimeType type) {
                        VotingPluginVelocity.this.getVotingPluginProxy().getGlobalDataHandler().setBoolean(server, type.toString(), false);
                        VotingPluginVelocity.this.getVotingPluginProxy().getGlobalDataHandler().setBoolean(server, "FinishedProcessing", true);
                        VotingPluginVelocity.this.getVotingPluginProxy().getGlobalDataHandler().setBoolean(server, "Processing", false);
                    }

                    @Override
                    public void onTimeChangedFinished(TimeType type) {
                        if (type.equals((Object)TimeType.MONTH)) {
                            VotingPluginVelocity.this.getVotingPluginProxy().getProxyMySQL().copyColumnData(TopVoter.Monthly.getColumnName(), "LastMonthTotal");
                            if (VotingPluginVelocity.this.getVotingPluginProxy().getConfig().getResetMilestonesMonthly()) {
                                VotingPluginVelocity.this.getVotingPluginProxy().getProxyMySQL().wipeColumnData("MilestoneCount", DataType.INTEGER);
                                VotingPluginVelocity.this.getVotingPluginProxy().getProxyMySQL().wipeColumnData("GottenMileStones", DataType.STRING);
                            }
                        }
                        VotingPluginVelocity.this.getVotingPluginProxy().getProxyMySQL().wipeColumnData(TopVoter.of(type).getColumnName(), DataType.INTEGER);
                        if (!VotingPluginVelocity.this.config.getGlobalDataEnabled()) {
                            return;
                        }
                        for (String s : VotingPluginVelocity.this.getAvailableAllServers()) {
                            VotingPluginVelocity.this.getVotingPluginProxy().getGlobalDataHandler().setBoolean(s, "ForceUpdate", true);
                            VotingPluginVelocity.this.getVotingPluginProxy().getGlobalMessageProxyHandler().sendMessage(s, 1, "BungeeTimeChange", "");
                        }
                        VotingPluginVelocity.this.getVotingPluginProxy().processQueue();
                    }
                });
            } else {
                this.votingPluginProxy.setGlobalDataHandler(new GlobalDataHandlerProxy(new GlobalMySQL("VotingPlugin_GlobalData", new MysqlConfigVelocity("GlobalData", this.config)){

                    @Override
                    public void debugEx(Exception e) {
                        if (VotingPluginVelocity.this.config.getDebug()) {
                            e.printStackTrace();
                        }
                    }

                    @Override
                    public void debugLog(String text) {
                        VotingPluginVelocity.this.debug2(text);
                    }

                    @Override
                    public void info(String text) {
                        VotingPluginVelocity.this.logger.info(text);
                    }

                    @Override
                    public void logSevere(String text) {
                        VotingPluginVelocity.this.logger.error(text);
                    }

                    @Override
                    public void warning(String text) {
                        VotingPluginVelocity.this.logger.warn(text);
                    }
                }, servers){

                    @Override
                    public void onTimeChangedFailed(String server, TimeType type) {
                        VotingPluginVelocity.this.getVotingPluginProxy().getGlobalDataHandler().setBoolean(server, type.toString(), false);
                        VotingPluginVelocity.this.getVotingPluginProxy().getGlobalDataHandler().setBoolean(server, "FinishedProcessing", true);
                        VotingPluginVelocity.this.getVotingPluginProxy().getGlobalDataHandler().setBoolean(server, "Processing", false);
                    }

                    @Override
                    public void onTimeChangedFinished(TimeType type) {
                        if (type.equals((Object)TimeType.MONTH)) {
                            VotingPluginVelocity.this.getVotingPluginProxy().getProxyMySQL().copyColumnData(TopVoter.Monthly.getColumnName(), "LastMonthTotal");
                            if (VotingPluginVelocity.this.getVotingPluginProxy().getConfig().getResetMilestonesMonthly()) {
                                VotingPluginVelocity.this.getVotingPluginProxy().getProxyMySQL().wipeColumnData("MilestoneCount", DataType.INTEGER);
                                VotingPluginVelocity.this.getVotingPluginProxy().getProxyMySQL().wipeColumnData("GottenMileStones", DataType.STRING);
                            }
                        }
                        VotingPluginVelocity.this.getVotingPluginProxy().getProxyMySQL().wipeColumnData(TopVoter.of(type).getColumnName(), DataType.INTEGER);
                        if (!VotingPluginVelocity.this.config.getGlobalDataEnabled()) {
                            return;
                        }
                        for (String s : VotingPluginVelocity.this.getAvailableAllServers()) {
                            VotingPluginVelocity.this.getVotingPluginProxy().getGlobalDataHandler().setBoolean(s, "ForceUpdate", true);
                            VotingPluginVelocity.this.getVotingPluginProxy().getGlobalMessageProxyHandler().sendMessage(s, 1, "BungeeTimeChange", "");
                        }
                        VotingPluginVelocity.this.getVotingPluginProxy().processQueue();
                    }
                });
            }
            this.getVotingPluginProxy().getGlobalDataHandler().getGlobalMysql().alterColumnType("IgnoreTime", "VARCHAR(5)");
            this.getVotingPluginProxy().getGlobalDataHandler().getGlobalMysql().alterColumnType("MONTH", "VARCHAR(5)");
            this.getVotingPluginProxy().getGlobalDataHandler().getGlobalMysql().alterColumnType("WEEK", "VARCHAR(5)");
            this.getVotingPluginProxy().getGlobalDataHandler().getGlobalMysql().alterColumnType("DAY", "VARCHAR(5)");
            this.getVotingPluginProxy().getGlobalDataHandler().getGlobalMysql().alterColumnType("FinishedProcessing", "VARCHAR(5)");
            this.getVotingPluginProxy().getGlobalDataHandler().getGlobalMysql().alterColumnType("Processing", "VARCHAR(5)");
            this.getVotingPluginProxy().getGlobalDataHandler().getGlobalMysql().alterColumnType("ForceUpdate", "VARCHAR(5)");
            this.getVotingPluginProxy().getGlobalDataHandler().getGlobalMysql().alterColumnType("LastUpdated", "MEDIUMTEXT");
        }
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("TopVoterIgnore", "VARCHAR(5)");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("CheckWorld", "VARCHAR(5)");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("Reminded", "VARCHAR(5)");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("DisableBroadcast", "VARCHAR(5)");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("LastOnline", "VARCHAR(20)");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("PlayerName", "VARCHAR(30)");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("DailyTotal", "INT DEFAULT '0'");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("WeeklyTotal", "INT DEFAULT '0'");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("DayVoteStreak", "INT DEFAULT '0'");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("BestDayVoteStreak", "INT DEFAULT '0'");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("WeekVoteStreak", "INT DEFAULT '0'");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("BestWeekVoteStreak", "INT DEFAULT '0'");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("VotePartyVotes", "INT DEFAULT '0'");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("MonthVoteStreak", "INT DEFAULT '0'");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("Points", "INT DEFAULT '0'");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("HighestDailyTotal", "INT DEFAULT '0'");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("AllTimeTotal", "INT DEFAULT '0'");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("HighestMonthlyTotal", "INT DEFAULT '0'");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("MilestoneCount", "INT DEFAULT '0'");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("MonthTotal", "INT DEFAULT '0'");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("HighestWeeklyTotal", "INT DEFAULT '0'");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("LastMonthTotal", "INT DEFAULT '0'");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("LastWeeklyTotal", "INT DEFAULT '0'");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("LastDailyTotal", "INT DEFAULT '0'");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("OfflineRewards", "MEDIUMTEXT");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("DayVoteStreakLastUpdate", "MEDIUMTEXT");
        if (this.config.getStoreMonthTotalsWithDate()) {
            this.getVotingPluginProxy().getProxyMySQL().alterColumnType(this.getVotingPluginProxy().getMonthTotalsWithDatePath(LocalDateTime.now()), "INT DEFAULT '0'");
            this.getVotingPluginProxy().getProxyMySQL().alterColumnType(this.getVotingPluginProxy().getMonthTotalsWithDatePath(LocalDateTime.now().plusMonths(1L)), "INT DEFAULT '0'");
            this.getVotingPluginProxy().getProxyMySQL().alterColumnType(this.getVotingPluginProxy().getMonthTotalsWithDatePath(LocalDateTime.now().plusMonths(2L)), "INT DEFAULT '0'");
        }
    }

    @Subscribe
    public void onPluginMessagingReceived(PluginMessageEvent event) {
        if (event.getIdentifier().getId().equals(this.CHANNEL.getId())) {
            event.setResult(PluginMessageEvent.ForwardResult.handled());
            if (!(event.getSource() instanceof ServerConnection)) {
                return;
            }
            ByteArrayInputStream instream = new ByteArrayInputStream(event.getData());
            DataInputStream in = new DataInputStream(instream);
            try {
                this.getVotingPluginProxy().onPluginMessageReceived(in);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Subscribe
    public void onProxyDisable(ProxyShutdownEvent event) {
        this.voteCacheFile.save();
        this.nonVotedPlayersCache.save();
        this.getVotingPluginProxy().onDisable();
        if (this.voteCheckTask != null) {
            this.voteCheckTask.cancel();
        }
        if (this.cacheSaveTask != null) {
            this.cacheSaveTask.cancel();
        }
        this.timer.shutdownNow();
        this.logger.info("VotingPlugin disabled");
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        File configFile = new File(this.dataDirectory.toFile(), "bungeeconfig.yml");
        configFile.getParentFile().mkdirs();
        if (!configFile.exists()) {
            try {
                configFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            InputStream toCopyStream = VotingPluginVelocity.class.getClassLoader().getResourceAsStream("bungeeconfig.yml");
            try (FileOutputStream fos = new FileOutputStream(configFile);){
                int r;
                byte[] buf = new byte[2048];
                while (-1 != (r = toCopyStream.read(buf))) {
                    fos.write(buf, 0, r);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.config = new Config(configFile);
        String[] channel = this.config.getPluginMessageChannel().split(":");
        this.CHANNEL = MinecraftChannelIdentifier.create((String)channel[0].toLowerCase(), (String)channel[1].toLowerCase());
        this.server.getChannelRegistrar().register(new ChannelIdentifier[]{this.CHANNEL});
        CommandMeta meta = this.server.getCommandManager().metaBuilder("votingpluginbungee").aliases(new String[]{"vpb"}).build();
        this.server.getCommandManager().register(meta, (Command)new VotingPluginVelocityCommand(this));
        this.votingPluginProxy = new VotingPluginProxy(){

            @Override
            public void addNonVotedPlayer(String uuid, String playerName) {
                VotingPluginVelocity.this.nonVotedPlayersCache.addPlayer(uuid, playerName);
            }

            @Override
            public void broadcast(String message) {
                VotingPluginVelocity.this.server.getAllPlayers().forEach(player -> player.sendMessage((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(message)));
            }

            @Override
            public void debug(String str) {
                VotingPluginVelocity.this.debug2(str);
            }

            @Override
            public Set<String> getAllAvailableServers() {
                return VotingPluginVelocity.this.getAvailableAllServers();
            }

            @Override
            public VotingPluginProxyConfig getConfig() {
                return VotingPluginVelocity.this.config;
            }

            @Override
            public String getCurrentPlayerServer(String player) {
                if (VotingPluginVelocity.this.server.getPlayer(player).isPresent() && ((Player)VotingPluginVelocity.this.server.getPlayer(player).get()).getCurrentServer().isPresent()) {
                    return ((ServerConnection)((Player)VotingPluginVelocity.this.server.getPlayer(player).get()).getCurrentServer().get()).getServer().getServerInfo().getName();
                }
                return "";
            }

            @Override
            public File getDataFolderPlugin() {
                return VotingPluginVelocity.this.dataDirectory.toFile();
            }

            @Override
            public String getProperName(String uuid, String playerName) {
                return VotingPluginVelocity.this.getProperPlayerName(uuid, playerName);
            }

            @Override
            public String getUUID(String playerName) {
                String str;
                Player p;
                if (!VotingPluginVelocity.this.config.getOnlineMode()) {
                    Player p2;
                    if (VotingPluginVelocity.this.server.getPlayer(playerName).isPresent() && (p2 = (Player)VotingPluginVelocity.this.server.getPlayer(playerName).get()) != null && p2.isActive()) {
                        playerName = p2.getUsername();
                    }
                    for (Map.Entry entry : VotingPluginVelocity.this.getVotingPluginProxy().getUuidPlayerNameCache().entrySet()) {
                        if (!((String)entry.getValue()).equalsIgnoreCase(playerName)) continue;
                        playerName = (String)entry.getValue();
                    }
                    return UUID.nameUUIDFromBytes(("OfflinePlayer:" + playerName).getBytes(StandardCharsets.UTF_8)).toString();
                }
                if (VotingPluginVelocity.this.server.getPlayer(playerName).isPresent() && (p = (Player)VotingPluginVelocity.this.server.getPlayer(playerName).get()) != null && p.isActive()) {
                    return p.getUniqueId().toString();
                }
                for (Map.Entry entry : VotingPluginVelocity.this.getVotingPluginProxy().getUuidPlayerNameCache().entrySet()) {
                    if (!((String)entry.getValue()).equalsIgnoreCase(playerName)) continue;
                    return ((UUID)entry.getKey()).toString();
                }
                if (VotingPluginVelocity.this.getVotingPluginProxy().getProxyMySQL() != null && (str = VotingPluginVelocity.this.getVotingPluginProxy().getProxyMySQL().getUUID(playerName)) != null) {
                    return str;
                }
                if (VotingPluginVelocity.this.nonVotedPlayersCache != null) {
                    return VotingPluginVelocity.this.nonVotedPlayersCache.playerExists(playerName);
                }
                return "";
            }

            @Override
            public String getPluginVersion() {
                return VotingPluginVelocity.this.version;
            }

            @Override
            public int getVoteCacheCurrentVotePartyVotes() {
                return VotingPluginVelocity.this.voteCacheFile.getVotePartyCurrentVotes();
            }

            @Override
            public long getVoteCacheLastUpdated() {
                return VotingPluginVelocity.this.voteCacheFile.getNode("Time", "LastUpdated").getLong();
            }

            @Override
            public int getVoteCachePrevDay() {
                return VotingPluginVelocity.this.voteCacheFile.getNode("Time", "Day").getInt();
            }

            @Override
            public String getVoteCachePrevMonth() {
                return VotingPluginVelocity.this.voteCacheFile.getNode("Time", "Month").getString("");
            }

            @Override
            public int getVoteCachePrevWeek() {
                return VotingPluginVelocity.this.voteCacheFile.getNode("Time", "Week").getInt();
            }

            @Override
            public int getVoteCacheVotePartyIncreaseVotesRequired() {
                return VotingPluginVelocity.this.voteCacheFile.getVotePartyInreaseVotesRequired();
            }

            @Override
            public boolean isPlayerOnline(String playerName) {
                if (playerName == null) {
                    return false;
                }
                if (VotingPluginVelocity.this.server.getPlayer(playerName).isPresent()) {
                    return ((Player)VotingPluginVelocity.this.server.getPlayer(playerName).get()).isActive();
                }
                return false;
            }

            @Override
            public boolean isServerValid(String serverName) {
                return VotingPluginVelocity.this.server.getServer(serverName).isPresent();
            }

            @Override
            public boolean isSomeoneOnlineServer(String serverName) {
                if (VotingPluginVelocity.this.server.getServer(serverName).isPresent()) {
                    return !((RegisteredServer)VotingPluginVelocity.this.server.getServer(serverName).get()).getPlayersConnected().isEmpty();
                }
                return false;
            }

            @Override
            public boolean isVoteCacheIgnoreTime() {
                return VotingPluginVelocity.this.voteCacheFile.getNode("Time", "IgnoreTime").getBoolean();
            }

            @Override
            public void log(String message) {
                VotingPluginVelocity.this.getLogger().info(message);
            }

            @Override
            public void logSevere(String message) {
                VotingPluginVelocity.this.logger.error(message);
            }

            @Override
            public void runAsync(Runnable run) {
                VotingPluginVelocity.this.runAsyncNow(run);
            }

            @Override
            public void runConsoleCommand(String command) {
                VotingPluginVelocity.this.server.getCommandManager().executeAsync((CommandSource)VotingPluginVelocity.this.server.getConsoleCommandSource(), command);
            }

            @Override
            public void saveVoteCacheFile() {
                VotingPluginVelocity.this.voteCacheFile.save();
            }

            @Override
            public void sendPluginMessageData(String serverName, String channel, byte[] data, boolean queue) {
                if (!VotingPluginVelocity.this.server.getServer(serverName).isPresent()) {
                    return;
                }
                RegisteredServer send = (RegisteredServer)VotingPluginVelocity.this.server.getServer(serverName).get();
                send.sendPluginMessage(VotingPluginVelocity.this.CHANNEL, data);
            }

            @Override
            public void setVoteCacheLastUpdated() {
                VotingPluginVelocity.this.voteCacheFile.getNode("Time", "LastUpdated").setValue((Object)System.currentTimeMillis());
                VotingPluginVelocity.this.voteCacheFile.save();
            }

            @Override
            public void setVoteCachePrevDay(int day) {
                VotingPluginVelocity.this.voteCacheFile.getNode("Time", "Day").setValue((Object)day);
                VotingPluginVelocity.this.voteCacheFile.save();
            }

            @Override
            public void setVoteCachePrevMonth(String text) {
                VotingPluginVelocity.this.voteCacheFile.getNode("Time", "Month").setValue((Object)text);
                VotingPluginVelocity.this.voteCacheFile.save();
            }

            @Override
            public void setVoteCachePrevWeek(int week) {
                VotingPluginVelocity.this.voteCacheFile.getNode("Time", "Week").setValue((Object)week);
                VotingPluginVelocity.this.voteCacheFile.save();
            }

            @Override
            public void setVoteCacheVoteCacheIgnoreTime(boolean ignore) {
                VotingPluginVelocity.this.voteCacheFile.getNode("Time", "IgnoreTime").setValue((Object)ignore);
                VotingPluginVelocity.this.voteCacheFile.save();
            }

            @Override
            public void setVoteCacheVotePartyCurrentVotes(int votes) {
                VotingPluginVelocity.this.voteCacheFile.setVotePartyCurrentVotes(votes);
            }

            @Override
            public void setVoteCacheVotePartyIncreaseVotesRequired(int votes) {
                VotingPluginVelocity.this.voteCacheFile.setVotePartyInreaseVotesRequired(votes);
            }

            @Override
            public void warn(String message) {
                VotingPluginVelocity.this.logger.warn(message);
            }

            @Override
            public void reloadCore(boolean mysql) {
                VotingPluginVelocity.this.reloadPlugin(mysql);
            }

            @Override
            public ScheduledExecutorService getScheduler() {
                return VotingPluginVelocity.this.timer;
            }

            @Override
            public MysqlConfig getVoteCacheMySQLConfig() {
                return new MysqlConfigVelocity("VoteCache", VotingPluginVelocity.this.config);
            }
        };
        try {
            Class.forName("com.vexsoftware.votifier.velocity.event.VotifierEvent");
        }
        catch (ClassNotFoundException e) {
            this.getVotingPluginProxy().setVotifierEnabled(false);
        }
        if (this.getVotingPluginProxy().isVotifierEnabled()) {
            try {
                this.server.getEventManager().register((Object)this, (Object)new VoteEventVelocity(this));
            }
            catch (Exception e) {
                this.getVotingPluginProxy().setVotifierEnabled(false);
            }
        }
        boolean mysqlLoaded = true;
        try {
            if (!this.config.getString(this.config.getNode("Host"), "").isEmpty()) {
                this.loadMysql();
            } else {
                mysqlLoaded = false;
                this.logger.error("MySQL settings not set in bungeeconfig.yml");
            }
        }
        catch (Exception e) {
            mysqlLoaded = false;
            e.printStackTrace();
        }
        if (mysqlLoaded) {
            this.voteCacheFile = new VoteCache(new File(this.dataDirectory.toFile(), "votecache.json"));
            File yamlVoteCacheFile = new File(this.dataDirectory.toFile(), "votecache.yml");
            if (yamlVoteCacheFile.exists()) {
                VelocityYMLFile yamlVoteCache = new VelocityYMLFile(yamlVoteCacheFile);
                this.voteCacheFile.setConf(yamlVoteCache.getData());
                yamlVoteCacheFile.renameTo(new File(this.dataDirectory.toFile(), "oldvotecache.yml"));
                VelocityYMLFile oldYamlVoteCache = new VelocityYMLFile(new File(this.dataDirectory.toFile(), "oldvotecache.yml"));
                oldYamlVoteCache.setConf(yamlVoteCache.getData());
                this.voteCacheFile.save();
            }
            this.nonVotedPlayersCache = new NonVotedPlayersCache(new File(this.dataDirectory.toFile(), "nonvotedplayerscache.json"), this);
            File yamlnonVotedPlayersCacheFile = new File(this.dataDirectory.toFile(), "nonvotedplayerscache.yml");
            if (yamlnonVotedPlayersCacheFile.exists()) {
                VelocityYMLFile yamlnonVotedPlayersCache = new VelocityYMLFile(yamlnonVotedPlayersCacheFile);
                this.voteCacheFile.setConf(yamlnonVotedPlayersCache.getData());
                yamlnonVotedPlayersCacheFile.renameTo(new File(this.dataDirectory.toFile(), "oldnonvotedplayerscache.yml"));
                VelocityYMLFile oldYamlnonVotedPlayersCache = new VelocityYMLFile(new File(this.dataDirectory.toFile(), "oldnonvotedplayerscache.yml"));
                oldYamlnonVotedPlayersCache.setConf(yamlnonVotedPlayersCache.getData());
                this.voteCacheFile.save();
            }
            this.getVotingPluginProxy().load(this.voteCacheFile);
            this.voteCheckTask = this.server.getScheduler().buildTask((Object)this, () -> {
                if (this.getVotingPluginProxy().getGlobalDataHandler() == null || !this.getVotingPluginProxy().getGlobalDataHandler().isTimeChangedHappened()) {
                    for (String server : this.getVotingPluginProxy().getVoteCacheHandler().getCachedVotesServers()) {
                        this.getVotingPluginProxy().checkCachedVotes(server);
                    }
                    for (Player player : this.server.getAllPlayers()) {
                        this.getVotingPluginProxy().checkOnlineVotes(player.getUsername(), player.getUniqueId().toString(), null);
                    }
                }
            }).delay(120L, TimeUnit.SECONDS).repeat(60L, TimeUnit.SECONDS).schedule();
            this.cacheSaveTask = this.server.getScheduler().buildTask((Object)this, () -> {
                if (this.nonVotedPlayersCache != null) {
                    this.debug("Checking nonvotedplayerscache.yml...");
                    this.nonVotedPlayersCache.check();
                }
                if (this.voteCacheFile != null) {
                    this.voteCacheFile.save();
                }
            }).delay(1L, TimeUnit.MINUTES).repeat(60L, TimeUnit.MINUTES).schedule();
        }
        try {
            this.getVersionFile();
            if (this.versionFile != null) {
                this.versionFile.delete();
                this.versionFile.getParentFile().delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!(this.getVotingPluginProxy().isVotifierEnabled() || this.getConfig().getMultiProxySupport() && !this.getConfig().getPrimaryServer())) {
            this.getLogger().warn("Votifier event not found, not loading votifier event");
        }
        Metrics metrics = this.metricsFactory.make(this, 11547);
        metrics.addCustomChart(new SimplePie("bungee_method", () -> this.getConfig().getBungeeMethod().toString()));
        metrics.addCustomChart(new SimplePie("sendtoallservers", () -> "" + this.getConfig().getSendVotesToAllServers()));
        metrics.addCustomChart(new SimplePie("allowunjoined", () -> "" + this.getConfig().getAllowUnJoined()));
        metrics.addCustomChart(new SimplePie("pointsonvote", () -> "" + this.getConfig().getPointsOnVote()));
        metrics.addCustomChart(new SimplePie("bungeemanagetotals", () -> "" + this.getConfig().getBungeeManageTotals()));
        metrics.addCustomChart(new SimplePie("waitforuseronline", () -> "" + this.getConfig().getWaitForUserOnline()));
        metrics.addCustomChart(new SimplePie("plugin_version", () -> "" + this.version));
        metrics.addCustomChart(new SimplePie("globaldata_enabled", () -> "" + this.getConfig().getGlobalDataEnabled()));
        if (this.getConfig().getGlobalDataEnabled()) {
            metrics.addCustomChart(new SimplePie("globaldata_usemainmysql", () -> "" + this.getConfig().getGlobalDataUseMainMySQL()));
        }
        metrics.addCustomChart(new SimplePie("multi_proxy_support_enabled", () -> "" + this.getConfig().getMultiProxySupport()));
        if (!this.buildNumber.equals("NOTSET")) {
            metrics.addCustomChart(new SimplePie("dev_build_number", () -> "" + this.buildNumber));
        }
        this.logger.info("VotingPlugin velocity loaded, method: " + this.getVotingPluginProxy().getMethod().toString() + ", PluginMessagingVersion: " + BungeeVersion.getPluginMessageVersion() + ", Internal Jar Version: " + this.version);
        if (!this.buildNumber.equals("NOTSET")) {
            this.logger.info("Detected using dev build number: " + this.buildNumber);
        }
        this.getVotingPluginProxy().sendServerNameMessage();
    }

    public void reloadPlugin(boolean loadMysql) {
        this.config.reload();
        if (loadMysql) {
            try {
                if (!this.config.getString(this.config.getNode("Host"), "").isEmpty()) {
                    this.loadMysql();
                } else {
                    this.logger.error("MySQL settings not set in bungeeconfig.yml");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.getVotingPluginProxy().reload();
    }

    private void runAsyncNow(Runnable runnable) {
        this.server.getScheduler().buildTask((Object)this, runnable).schedule();
    }

    @Generated
    public Config getConfig() {
        return this.config;
    }

    @Generated
    public Logger getLogger() {
        return this.logger;
    }

    @Generated
    public ScheduledExecutorService getTimer() {
        return this.timer;
    }

    @Generated
    public VotingPluginProxy getVotingPluginProxy() {
        return this.votingPluginProxy;
    }
}

