/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.proxy.velocity;

import com.bencodez.votingplugin.proxy.OfflineBungeeVote;
import com.bencodez.votingplugin.proxy.cache.ConfigDataNode;
import com.bencodez.votingplugin.proxy.cache.DataNode;
import com.bencodez.votingplugin.proxy.cache.IVoteCache;
import com.bencodez.votingplugin.simpleapi.file.velocity.VelocityJSONFile;
import com.bencodez.votingplugin.timequeue.VoteTimeQueue;
import java.io.File;
import java.util.Collection;

public class VoteCache
extends VelocityJSONFile
implements IVoteCache {
    public VoteCache(File file) {
        super(file);
    }

    @Override
    public void addTimedVote(int num, VoteTimeQueue voteTimedQueue) {
        this.getNode("TimedVoteCache", String.valueOf(num), "Name").setValue((Object)voteTimedQueue.getName());
        this.getNode("TimedVoteCache", String.valueOf(num), "Service").setValue((Object)voteTimedQueue.getService());
        this.getNode("TimedVoteCache", String.valueOf(num), "Time").setValue((Object)voteTimedQueue.getTime());
    }

    @Override
    public void addVote(String server, int num, OfflineBungeeVote voteData) {
        this.getNode("VoteCache", server, String.valueOf(num), "Name").setValue((Object)voteData.getPlayerName());
        this.getNode("VoteCache", server, String.valueOf(num), "Service").setValue((Object)voteData.getService());
        this.getNode("VoteCache", server, String.valueOf(num), "UUID").setValue((Object)voteData.getUuid());
        this.getNode("VoteCache", server, String.valueOf(num), "Time").setValue((Object)voteData.getTime());
        this.getNode("VoteCache", server, String.valueOf(num), "Real").setValue((Object)voteData.isRealVote());
        this.getNode("VoteCache", server, String.valueOf(num), "Text").setValue((Object)voteData.getText());
    }

    @Override
    public void addVoteOnline(String player, int num, OfflineBungeeVote voteData) {
        this.getNode("OnlineCache", player, String.valueOf(num), "Name").setValue((Object)voteData.getPlayerName());
        this.getNode("OnlineCache", player, String.valueOf(num), "Service").setValue((Object)voteData.getService());
        this.getNode("OnlineCache", player, String.valueOf(num), "UUID").setValue((Object)voteData.getUuid());
        this.getNode("OnlineCache", player, String.valueOf(num), "Time").setValue((Object)voteData.getTime());
        this.getNode("OnlineCache", player, String.valueOf(num), "Real").setValue((Object)voteData.isRealVote());
        this.getNode("OnlineCache", player, String.valueOf(num), "Text").setValue((Object)voteData.getText());
    }

    @Override
    public void clearData() {
        this.getNode("VoteCache").setValue(null);
        this.getNode("OnlineCache").setValue(null);
        this.getNode("TimedVoteCache").setValue(null);
        this.save();
    }

    @Override
    public Collection<String> getOnlineVotes(String name) {
        return this.getKeys(this.getNode("OnlineCache", name));
    }

    @Override
    public ConfigDataNode getOnlineVotes(String name, String num) {
        return new ConfigDataNode(this.getNode("OnlineCache", name, num));
    }

    @Override
    public Collection<String> getPlayers() {
        return this.getKeys(this.getNode("OnlineCache"));
    }

    @Override
    public Collection<String> getServers() {
        return this.getKeys(this.getNode("VoteCache"));
    }

    @Override
    public Collection<String> getServerVotes(String server) {
        return this.getKeys(this.getNode("VoteCache", server));
    }

    @Override
    public ConfigDataNode getServerVotes(String server, String num) {
        return new ConfigDataNode(this.getNode("VoteCache", server, num));
    }

    @Override
    public Collection<String> getTimedVoteCache() {
        return this.getKeys(this.getNode("TimedVoteCache"));
    }

    @Override
    public ConfigDataNode getTimedVoteCache(String key) {
        return new ConfigDataNode(this.getNode("TimedVoteCache", key));
    }

    @Override
    public int getVotePartyCache(String server) {
        return this.getNode("VoteParty", "Cache", server).getInt(0);
    }

    @Override
    public int getVotePartyCurrentVotes() {
        return this.getInt(this.getNode("VoteParty", "CurrentVotes"), 0);
    }

    @Override
    public int getVotePartyInreaseVotesRequired() {
        return this.getInt(this.getNode("VoteParty", "IncreaseVotes"), 0);
    }

    @Override
    public void setVotePartyCache(String server, int amount) {
        this.getNode("VoteParty", "Cache", server).setValue((Object)amount);
    }

    @Override
    public void setVotePartyCurrentVotes(int amount) {
        this.getNode("VoteParty", "CurrentVotes").setValue((Object)amount);
    }

    @Override
    public void setVotePartyInreaseVotesRequired(int amount) {
        this.getNode("VoteParty", "IncreaseVotes").setValue((Object)amount);
    }

    @Override
    public void removeOnlineVotes(String player) {
        this.getNode("OnlineCache", player).setValue(null);
    }

    @Override
    public void removeServerVotes(String server) {
        this.getNode("VoteCache", server).setValue(null);
    }

    @Override
    public void removeServerVote(String server, String uuid) {
        Collection<String> votes = this.getServerVotes(server);
        if (votes == null) {
            return;
        }
        for (String num : votes) {
            String nodeUuid;
            DataNode uuidNode;
            ConfigDataNode node = this.getServerVotes(server, num);
            if (node == null || (uuidNode = node.get("UUID")) == null || (nodeUuid = uuidNode.asString()) == null || !nodeUuid.equals(uuid)) continue;
            this.getNode("VoteCache", server, num).setValue(null);
        }
    }

    @Override
    public void removeVote(String server, OfflineBungeeVote vote) {
        Collection<String> votes = this.getServerVotes(server);
        if (votes == null) {
            return;
        }
        for (String num : votes) {
            ConfigDataNode node = this.getServerVotes(server, num);
            if (node == null) continue;
            DataNode uuidNode = node.get("UUID");
            DataNode serviceNode = node.get("Service");
            DataNode timeNode = node.get("Time");
            if (uuidNode == null || serviceNode == null || timeNode == null) continue;
            String nodeUuid = uuidNode.asString();
            String nodeService = serviceNode.asString();
            Long nodeTime = timeNode.asLong();
            if (nodeUuid == null || nodeService == null || nodeTime == null || !nodeUuid.equals(vote.getUuid()) || !nodeService.equals(vote.getService()) || nodeTime.longValue() != vote.getTime()) continue;
            this.getNode("VoteCache", server, num).setValue(null);
        }
    }

    @Override
    public void removeOnlineVote(OfflineBungeeVote vote) {
        Collection<String> players = this.getPlayers();
        if (players == null) {
            return;
        }
        for (String player : players) {
            Collection<String> onlineVotes = this.getOnlineVotes(player);
            if (onlineVotes == null) continue;
            for (String num : onlineVotes) {
                ConfigDataNode node = this.getOnlineVotes(player, num);
                if (node == null) continue;
                DataNode uuidNode = node.get("UUID");
                DataNode serviceNode = node.get("Service");
                DataNode timeNode = node.get("Time");
                if (uuidNode == null || serviceNode == null || timeNode == null) continue;
                String nodeUuid = uuidNode.asString();
                String nodeService = serviceNode.asString();
                Long nodeTime = timeNode.asLong();
                if (nodeUuid == null || nodeService == null || nodeTime == null || !nodeUuid.equals(vote.getUuid()) || !nodeService.equals(vote.getService()) || nodeTime.longValue() != vote.getTime()) continue;
                this.getNode("OnlineCache", player, num).setValue(null);
            }
        }
    }
}

