/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.proxy.velocity;

import com.bencodez.votingplugin.proxy.velocity.VotingPluginVelocity;
import com.bencodez.votingplugin.simpleapi.file.velocity.VelocityJSONFile;
import com.velocitypowered.api.proxy.Player;
import java.io.File;

public class NonVotedPlayersCache
extends VelocityJSONFile {
    private VotingPluginVelocity plugin;

    public NonVotedPlayersCache(File file, VotingPluginVelocity plugin) {
        super(file);
        this.plugin = plugin;
    }

    public void addPlayer(Player player) {
        if (!this.plugin.getVotingPluginProxy().getProxyMySQL().containsKeyQuery(player.getUniqueId().toString())) {
            this.addPlayer(player.getUniqueId().toString(), player.getUsername());
        }
    }

    public void addPlayer(String uuid, String playerName) {
        this.getNode("NonVotedPlayers", playerName, "UUID").setValue((Object)uuid);
        this.getNode("NonVotedPlayers", playerName, "LastTime").setValue((Object)System.currentTimeMillis());
        this.save();
    }

    public void addPlayerCheck(String uuid, String playerName) {
        if (!this.plugin.getVotingPluginProxy().getProxyMySQL().containsKeyQuery(uuid)) {
            this.addPlayer(uuid, playerName);
        }
    }

    public void check() {
        for (String player : this.getKeys(this.getNode("NonVotedPlayers"))) {
            long time = this.getNode("NonVotedPlayers", player, "LastTime").getLong(0L);
            if (System.currentTimeMillis() - time > 432000000L) {
                this.remove(player);
                continue;
            }
            String uuid = this.getNode("NonVotedPlayers", player, "UUID").getString("");
            if (!uuid.isEmpty()) {
                if (!this.plugin.getVotingPluginProxy().getProxyMySQL().containsKeyQuery(uuid)) continue;
                this.remove(player);
                continue;
            }
            this.remove(player);
        }
        this.save();
    }

    public String playerExists(String playerName) {
        if (!this.getNode("NonVotedPlayers", playerName).isEmpty()) {
            return this.getNode("NonVotedPlayers", playerName, "UUID").getString("");
        }
        return "";
    }

    private void remove(String player) {
        this.plugin.debug("Removing nonvotedplayer: " + player);
        this.getNode("NonVotedPlayers", player).setValue(null);
        this.save();
    }
}

