/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.proxy.velocity;

import com.bencodez.votingplugin.proxy.VotingPluginProxyConfig;
import com.bencodez.votingplugin.simpleapi.file.velocity.VelocityYMLFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ninja.leaping.configurate.ConfigurationNode;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Config
extends VelocityYMLFile
implements VotingPluginProxyConfig {
    public Config(File file) {
        super(file);
    }

    @Override
    public boolean getAllowUnJoined() {
        return this.getBoolean(this.getNode("AllowUnJoined"), false);
    }

    @Override
    public String getBedrockPlayerPrefix() {
        return this.getString(this.getNode("BedrockPlayerPrefix"), ".");
    }

    @Override
    public List<String> getBlockedServers() {
        return this.getStringList(this.getNode("BlockedServers"), new ArrayList<String>());
    }

    @Override
    public boolean getBroadcast() {
        return this.getBoolean(this.getNode("Broadcast"), false);
    }

    @Override
    public String getBungeeHost() {
        return this.getString(this.getNode("BungeeServer", "Host"), "");
    }

    @Override
    public boolean getBungeeManageTotals() {
        return this.getBoolean(this.getNode("BungeeManageTotals"), true);
    }

    @Override
    public String getBungeeMethod() {
        return this.getString(this.getNode("BungeeMethod"), "PLUGINMESSAGING");
    }

    @Override
    public int getBungeePort() {
        return this.getInt(this.getNode("BungeeServer", "Port"), 1297);
    }

    @Override
    public boolean getDebug() {
        return this.getBoolean(this.getNode("Debug"), false);
    }

    @Override
    public String getFallBack() {
        return this.getString(this.getNode("FallBackServer"), "");
    }

    @Override
    public boolean getGlobalDataEnabled() {
        return this.getBoolean(this.getNode("GlobalData", "Enabled"), false);
    }

    @Override
    public boolean getGlobalDataUseMainMySQL() {
        return this.getBoolean(this.getNode("GlobalData", "UseMainMySQL"), true);
    }

    @Override
    public int getLimitVotePoints() {
        return this.getInt(this.getNode("LimitVotePoints"), -1);
    }

    @Override
    public int getMaxAmountOfVotesPerDay() {
        return this.getInt(this.getNode("MaxAmountOfVotesPerDay"), -1);
    }

    @Override
    public String getMultiProxyMethod() {
        return this.getString(this.getNode("MultiProxyMethod"), "SOCKET");
    }

    @Override
    public boolean getMultiProxyOneGlobalReward() {
        return this.getBoolean(this.getNode("MultiProxyOneGlobalReward"), false);
    }

    @Override
    public String getMultiProxyRedisHost() {
        return this.getString(this.getNode("MultiProxyRedis", "Host"), "");
    }

    @Override
    public String getMultiProxyRedisPassword() {
        return this.getString(this.getNode("MultiProxyRedis", "Password"), "");
    }

    @Override
    public int getMultiProxyRedisPort() {
        return this.getInt(this.getNode("MultiProxyRedis", "Port"), 6379);
    }

    @Override
    public boolean getMultiProxyRedisUseExistingConnection() {
        return this.getBoolean(this.getNode("MultiProxyRedis", "UseExistingConnection"), false);
    }

    @Override
    public String getMultiProxyRedisUsername() {
        return this.getString(this.getNode("MultiProxyRedis", "Username"), "");
    }

    public @NonNull List<String> getMultiProxyServers() {
        return this.getChildrenAsList(this.getNode("MultiProxyServers"));
    }

    public List<String> getChildrenAsList(ConfigurationNode config) {
        ArrayList<String> children = new ArrayList<String>();
        if (config != null) {
            for (Map.Entry entry : config.getChildrenMap().entrySet()) {
                children.add(entry.getKey().toString());
            }
        }
        return children;
    }

    @Override
    public Map<String, Object> getMultiProxyServersConfiguration(String s) {
        return this.configToMap(this.getNode("MultiProxyServers", s));
    }

    @Override
    public String getMultiProxySocketHostHost() {
        return this.getString(this.getNode("MultiProxySocketHost", "Host"), "");
    }

    @Override
    public int getMultiProxySocketHostPort() {
        return this.getInt(this.getNode("MultiProxySocketHost", "Port"), 1297);
    }

    @Override
    public boolean getMultiProxySupport() {
        return this.getBoolean(this.getNode("MultiProxySupport"), false);
    }

    public ConfigurationNode getMysqlNode() {
        return this.getNode("MySQL");
    }

    @Override
    public boolean getOnlineMode() {
        return this.getBoolean(this.getNode("OnlineMode"), true);
    }

    @Override
    public int getPointsOnVote() {
        return this.getInt(this.getNode("PointsOnVote"), 1);
    }

    @Override
    public boolean getPrimaryServer() {
        return this.getBoolean(this.getNode("PrimaryServer"), false);
    }

    @Override
    public String getProxyServerName() {
        return this.getString(this.getNode("ProxyServerName"), "SOCKET");
    }

    @Override
    public List<String> getProxyServers() {
        return this.getStringList(this.getNode("ProxyServers"), new ArrayList<String>());
    }

    @Override
    public String getRedisHost() {
        return this.getString(this.getNode("Redis", "Host"), "");
    }

    @Override
    public String getRedisPassword() {
        return this.getString(this.getNode("Redis", "Password"), "");
    }

    @Override
    public int getRedisPort() {
        return this.getInt(this.getNode("Redis", "Port"), 6379);
    }

    @Override
    public String getRedisPrefix() {
        return this.getString(this.getNode("Redis", "Prefix"), "");
    }

    @Override
    public String getRedisUsername() {
        return this.getString(this.getNode("Redis", "Username"), "");
    }

    @Override
    public boolean getSendVotesToAllServers() {
        return this.getBoolean(this.getNode("SendVotesToAllServers"), true);
    }

    @Override
    public Map<String, Object> getSpigotServerConfiguration(String s) {
        return this.configToMap(this.getNode("SpigotServers", s));
    }

    @Override
    public String getMqttClientID() {
        return this.getString(this.getNode("MQTT", "ClientID"), "proxy");
    }

    @Override
    public String getMqttBrokerURL() {
        return this.getString(this.getNode("MQTT", "BrokerURL"), "tcp://localhost:1883");
    }

    @Override
    public String getMqttUsername() {
        return this.getString(this.getNode("MQTT", "Username"), "");
    }

    @Override
    public String getMqttPassword() {
        return this.getString(this.getNode("MQTT", "Password"), "");
    }

    @Override
    public String getMqttPrefix() {
        return this.getString(this.getNode("MQTT", "Prefix"), "");
    }

    public Map<String, Object> configToMap(ConfigurationNode config) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (config != null) {
            for (Map.Entry entry : config.getChildrenMap().entrySet()) {
                map.put(entry.getKey().toString(), ((ConfigurationNode)entry.getValue()).getValue());
            }
        }
        return map;
    }

    public @NonNull List<String> getSpigotServers() {
        return this.getChildrenAsList(this.getNode("SpigotServers"));
    }

    @Override
    public boolean getStoreMonthTotalsWithDate() {
        return this.getBoolean(this.getNode("StoreMonthTotalsWithDate"), false);
    }

    @Override
    public boolean getTimeChangeFailSafeBypass() {
        return this.getBoolean(this.getNode("TimeChangeFailSafeBypass"), false);
    }

    @Override
    public boolean getUseMonthDateTotalsAsPrimaryTotal() {
        return this.getBoolean(this.getNode("UseMonthDateTotalsAsPrimaryTotal"), false);
    }

    @Override
    public boolean getUUIDLookup() {
        return this.getBoolean(this.getNode("UUIDLookup"), true);
    }

    @Override
    public int getVoteCacheTime() {
        return this.getInt(this.getNode("VoteCacheTime"), -1);
    }

    @Override
    public String getVotePartyBroadcast() {
        return this.getString(this.getVotePartyNode().getNode(new Object[]{"Broadcast"}), "");
    }

    @Override
    public List<String> getVotePartyBungeeCommands() {
        return this.getStringList(this.getVotePartyNode().getNode(new Object[]{"BungeeCommands"}), new ArrayList<String>());
    }

    @Override
    public boolean getVotePartyEnabled() {
        return this.getBoolean(this.getVotePartyNode().getNode(new Object[]{"Enabled"}), false);
    }

    @Override
    public int getVotePartyIncreaseVotesRequired() {
        return this.getInt(this.getVotePartyNode().getNode(new Object[]{"IncreaseVotesRequired"}), 0);
    }

    public ConfigurationNode getVotePartyNode() {
        return this.getNode("VoteParty");
    }

    @Override
    public boolean getVotePartySendToAllServers() {
        return this.getBoolean(this.getVotePartyNode().getNode(new Object[]{"SendToAllServers"}), false);
    }

    @Override
    public List<String> getVotePartyServersToSend() {
        return this.getStringList(this.getVotePartyNode().getNode(new Object[]{"ServersToSend"}), new ArrayList<String>());
    }

    @Override
    public int getVotePartyVotesRequired() {
        return this.getInt(this.getVotePartyNode().getNode(new Object[]{"VotesRequired"}), 100);
    }

    @Override
    public boolean getWaitForUserOnline() {
        return this.getBoolean(this.getNode("WaitForUserOnline"), true);
    }

    @Override
    public List<String> getWhiteListedServers() {
        return this.getStringList(this.getNode("WhiteListedServers"), new ArrayList<String>());
    }

    @Override
    public int getTimeHourOffSet() {
        return this.getInt(this.getNode("TimeHourOffSet"), 0);
    }

    @Override
    public String getTimeZone() {
        return this.getString(this.getNode("TimeZone"), "");
    }

    @Override
    public void load() {
    }

    @Override
    public String getPluginMessageChannel() {
        return this.getString(this.getNode("PluginMessageChannel"), "vp:vp");
    }

    @Override
    public boolean getPluginMessageEncryption() {
        return this.getBoolean(this.getNode("PluginMessageEncryption"), false);
    }

    @Override
    public Collection<String> getWaitUntilVoteDelaySites() {
        return this.getChildrenAsList(this.getNode("WaitUntilVoteDelay"));
    }

    @Override
    public String getWaitUntilVoteDelayService(String site) {
        return this.getString(this.getNode("WaitUntilVoteDelay", site, "ServiceSite"), "");
    }

    @Override
    public int getWaitUntilVoteDelayVoteDelay(String site) {
        return this.getInt(this.getNode("WaitUntilVoteDelay", site, "VoteDelay"), 24);
    }

    @Override
    public boolean getWaitUntilVoteDelayVoteDelayDaily(String site) {
        return this.getBoolean(this.getNode("WaitUntilVoteDelay", site, "VoteDelayDaily"), false);
    }

    @Override
    public int getWaitUntilVoteDelayVoteDelayHour(String site) {
        return this.getInt(this.getNode("WaitUntilVoteDelay", site, "VoteDelayDailyHour"), 0);
    }

    @Override
    public int getWaitUntilVoteDelayVoteDelayMin(String site) {
        return this.getInt(this.getNode("WaitUntilVoteDelay", site, "VoteDelayMin"), 0);
    }

    @Override
    public boolean getResetMilestonesMonthly() {
        return this.getBoolean(this.getNode("ResetMilestonesMonthly"), false);
    }

    @Override
    public boolean getVoteCacheUseMySQL() {
        return this.getBoolean(this.getNode("VoteCache", "UseMySQL"), false);
    }

    @Override
    public boolean getVoteCacheUseMainMySQL() {
        return this.getBoolean(this.getNode("VoteCache", "UseMainMySQL"), true);
    }

    @Override
    public int getTimeWeekOffSet() {
        return this.getInt(this.getNode("TimeWeekOffSet"), 0);
    }
}

