/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.proxy.multiproxy;

import com.bencodez.votingplugin.proxy.BungeeMessageData;
import com.bencodez.votingplugin.proxy.multiproxy.MultiProxyMethod;
import com.bencodez.votingplugin.proxy.multiproxy.MultiProxyServerSocketConfiguration;
import com.bencodez.votingplugin.simpleapi.encryption.EncryptionHandler;
import com.bencodez.votingplugin.simpleapi.servercomm.redis.RedisHandler;
import com.bencodez.votingplugin.simpleapi.servercomm.redis.RedisListener;
import com.bencodez.votingplugin.simpleapi.servercomm.sockets.ClientHandler;
import com.bencodez.votingplugin.simpleapi.servercomm.sockets.SocketHandler;
import com.bencodez.votingplugin.simpleapi.servercomm.sockets.SocketReceiver;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;

public abstract class MultiProxyHandler {
    private HashMap<String, ClientHandler> multiproxyClientHandles;
    private SocketHandler multiproxySocketHandler;
    private RedisHandler multiProxyRedis;

    public abstract void addNonVotedPlayerCache(String var1, String var2);

    public abstract void clearVote(String var1);

    public void close() {
        if (this.multiproxySocketHandler != null) {
            this.multiproxySocketHandler.closeConnection();
            this.multiproxySocketHandler = null;
        }
        if (this.multiProxyRedis != null && !this.getMultiProxyRedisUseExistingConnection()) {
            this.multiProxyRedis.close();
        }
    }

    public abstract boolean getDebug();

    public abstract EncryptionHandler getEncryptionHandler();

    public abstract MultiProxyMethod getMultiProxyMethod();

    public abstract String getMultiProxyPassword();

    public abstract String getMultiProxyRedisHost();

    public abstract int getMultiProxyRedisPort();

    public abstract boolean getMultiProxyRedisUseExistingConnection();

    public abstract String getMultiProxyServerName();

    public abstract Collection<String> getMultiProxyServers();

    public abstract MultiProxyServerSocketConfiguration getMultiProxyServersConfiguration(String var1);

    public abstract String getMultiProxySocketHostHost();

    public abstract int getMultiProxySocketHostPort();

    public abstract boolean getMultiProxySupportEnabled();

    public abstract String getMultiProxyUsername();

    public abstract File getPluginDataFolder();

    public abstract boolean getPrimaryServer();

    public abstract List<String> getProxyServers();

    public abstract RedisHandler getRedisHandler();

    public abstract String getVersion();

    public void loadMultiProxySupport() {
        if (this.getMultiProxySupportEnabled()) {
            if (this.getMultiProxyMethod().equals((Object)MultiProxyMethod.SOCKETS)) {
                if (this.getEncryptionHandler() == null) {
                    this.setEncryptionHandler(new EncryptionHandler("VotingPlugin", new File(this.getPluginDataFolder(), "secretkey.key")));
                }
                if (this.multiproxySocketHandler != null) {
                    this.multiproxySocketHandler.closeConnection();
                    this.multiproxySocketHandler = null;
                }
                this.multiproxySocketHandler = new SocketHandler(this.getVersion(), this.getMultiProxySocketHostHost(), this.getMultiProxySocketHostPort(), this.getEncryptionHandler(), this.getDebug()){

                    @Override
                    public void log(String str) {
                        MultiProxyHandler.this.logInfo(str);
                    }
                };
                this.multiproxySocketHandler.add(new SocketReceiver(){

                    @Override
                    public void onReceive(String[] data) {
                        if (data.length > 0) {
                            if (data[0].equalsIgnoreCase("Status")) {
                                MultiProxyHandler.this.logInfo("Multi-proxy status message received");
                            } else if (data[0].equalsIgnoreCase("ClearVote")) {
                                MultiProxyHandler.this.clearVote(data[2]);
                                if (MultiProxyHandler.this.getPrimaryServer()) {
                                    MultiProxyHandler.this.sendMultiProxyServerMessage("ClearVotePrimary", data[1], data[2]);
                                }
                            } else if (data[0].equalsIgnoreCase("ClearVotePrimary")) {
                                MultiProxyHandler.this.clearVote(data[2]);
                            } else if (data[0].equalsIgnoreCase("login")) {
                                MultiProxyHandler.this.addNonVotedPlayerCache(data[1], data[2]);
                            }
                        }
                        if (data.length > 8) {
                            if (data[0].equalsIgnoreCase("Vote")) {
                                MultiProxyHandler.this.triggerVote(data[2], data[3], Boolean.valueOf(data[7]), true, 0L, new BungeeMessageData(data[8]), data[1]);
                            } else if (data[0].equalsIgnoreCase("VoteOnline")) {
                                MultiProxyHandler.this.triggerVote(data[2], data[3], Boolean.valueOf(data[7]), true, 0L, new BungeeMessageData(data[8]), data[1]);
                            }
                        }
                    }
                });
                this.multiproxyClientHandles = new HashMap();
                for (String s : this.getMultiProxyServers()) {
                    MultiProxyServerSocketConfiguration d = this.getMultiProxyServersConfiguration(s);
                    this.multiproxyClientHandles.put(s, new ClientHandler(d.getHost(), d.getPort(), this.getEncryptionHandler(), this.getDebug()));
                }
            } else {
                this.multiProxyRedis = this.getMultiProxyRedisUseExistingConnection() && this.getRedisHandler() != null ? this.getRedisHandler() : new RedisHandler(this.getMultiProxyRedisHost(), this.getMultiProxyRedisPort(), this.getMultiProxyUsername(), this.getMultiProxyPassword()){

                    @Override
                    public void debug(String message) {
                        if (MultiProxyHandler.this.getDebug()) {
                            MultiProxyHandler.this.logInfo("MultiProxyRedis: " + message);
                        }
                    }

                    @Override
                    public void onMessage(String channel, String[] data) {
                        if (data.length > 0) {
                            if (data[0].equalsIgnoreCase("Status")) {
                                MultiProxyHandler.this.logInfo("Multi-proxy status message received");
                            } else if (data[0].equalsIgnoreCase("ClearVote")) {
                                MultiProxyHandler.this.clearVote(data[2]);
                                if (MultiProxyHandler.this.getPrimaryServer()) {
                                    MultiProxyHandler.this.sendMultiProxyServerMessage("ClearVotePrimary", data[1], data[2]);
                                }
                            } else if (data[0].equalsIgnoreCase("ClearVotePrimary")) {
                                MultiProxyHandler.this.clearVote(data[2]);
                            } else if (data[0].equalsIgnoreCase("login")) {
                                MultiProxyHandler.this.addNonVotedPlayerCache(data[1], data[2]);
                            }
                        }
                        if (data.length > 8) {
                            if (data[0].equalsIgnoreCase("Vote")) {
                                MultiProxyHandler.this.triggerVote(data[2], data[3], Boolean.valueOf(data[7]), true, 0L, new BungeeMessageData(data[8]), data[1]);
                            } else if (data[0].equalsIgnoreCase("VoteOnline")) {
                                MultiProxyHandler.this.triggerVote(data[2], data[3], Boolean.valueOf(data[7]), true, 0L, new BungeeMessageData(data[8]), data[1]);
                            }
                        }
                    }
                };
                this.runAsnc(new Runnable(){

                    @Override
                    public void run() {
                        MultiProxyHandler.this.multiProxyRedis.loadListener(new RedisListener(MultiProxyHandler.this.multiProxyRedis, "VotingPluginProxy_" + MultiProxyHandler.this.getMultiProxyServerName()));
                    }
                });
            }
            this.logInfo("Loaded multi-proxy support: " + this.getMultiProxyMethod().toString());
        }
    }

    public void login(String uuid, String playerName) {
        if (!this.getMultiProxySupportEnabled() || this.getPrimaryServer()) {
            return;
        }
        this.sendMultiProxyServerMessage("Login", uuid, playerName);
    }

    public abstract void logInfo(String var1);

    public abstract void runAsnc(Runnable var1);

    public void sendMultiProxyServerMessage(String ... messageData) {
        block3: {
            block2: {
                if (!this.getMultiProxyMethod().equals((Object)MultiProxyMethod.SOCKETS)) break block2;
                for (ClientHandler h : this.multiproxyClientHandles.values()) {
                    h.sendMessage(messageData);
                }
                break block3;
            }
            if (!this.getMultiProxyMethod().equals((Object)MultiProxyMethod.REDIS)) break block3;
            for (String server : this.getProxyServers()) {
                this.multiProxyRedis.sendMessage("VotingPluginProxy_" + server, messageData);
            }
        }
    }

    public abstract void setEncryptionHandler(EncryptionHandler var1);

    public abstract void triggerVote(String var1, String var2, boolean var3, boolean var4, long var5, BungeeMessageData var7, String var8);

    @Generated
    public RedisHandler getMultiProxyRedis() {
        return this.multiProxyRedis;
    }
}

