/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.proxy.cache;

import com.bencodez.votingplugin.proxy.BungeeMessageData;
import com.bencodez.votingplugin.proxy.OfflineBungeeVote;
import com.bencodez.votingplugin.proxy.cache.DataNode;
import com.bencodez.votingplugin.proxy.cache.IVoteCache;
import com.bencodez.votingplugin.proxy.cache.ProxyOnlineVoteCacheTable;
import com.bencodez.votingplugin.proxy.cache.ProxyTimedVoteCacheTable;
import com.bencodez.votingplugin.proxy.cache.ProxyVoteCacheTable;
import com.bencodez.votingplugin.simpleapi.sql.mysql.MySQL;
import com.bencodez.votingplugin.simpleapi.sql.mysql.config.MysqlConfig;
import com.bencodez.votingplugin.timequeue.VoteTimeQueue;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import lombok.Generated;

public abstract class VoteCacheHandler {
    private Queue<VoteTimeQueue> timeChangeQueue = new ConcurrentLinkedQueue<VoteTimeQueue>();
    private ConcurrentHashMap<String, ArrayList<OfflineBungeeVote>> cachedOnlineVotes = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ArrayList<OfflineBungeeVote>> cachedVotes = new ConcurrentHashMap();
    private final boolean useMySQL;
    private ProxyVoteCacheTable voteCacheTable;
    private ProxyTimedVoteCacheTable timedVoteCacheTable;
    private ProxyOnlineVoteCacheTable onlineVoteCacheTable;
    private IVoteCache jsonStorage;

    public boolean hasVotes(String server) {
        return this.cachedVotes.containsKey(server);
    }

    public ArrayList<OfflineBungeeVote> getVotes(String server) {
        return this.cachedVotes.getOrDefault(server, new ArrayList());
    }

    public void addServerVote(String server, OfflineBungeeVote vote) {
        this.cachedVotes.putIfAbsent(server, new ArrayList());
        this.cachedVotes.get(server).add(vote);
        if (this.useMySQL) {
            this.voteCacheTable.insertVote(vote.getUuid(), vote.getPlayerName(), vote.getService(), vote.getTime(), vote.isRealVote(), vote.getText(), server);
        } else {
            this.jsonStorage.addVote(server, this.cachedVotes.get(server).size() - 1, vote);
            this.jsonStorage.save();
        }
    }

    public void removeVote(String server, String uuid) {
        if (this.cachedVotes.containsKey(server)) {
            ArrayList<OfflineBungeeVote> votes = this.cachedVotes.get(server);
            votes.removeIf(vote -> vote.getUuid().equals(uuid));
            if (this.useMySQL) {
                this.voteCacheTable.removeVotesByServerAndUUID(server, uuid);
            } else {
                this.jsonStorage.removeServerVote(server, uuid);
                this.jsonStorage.save();
            }
        }
    }

    public void removeVotes(String server) {
        this.cachedVotes.remove(server);
        if (this.useMySQL) {
            this.voteCacheTable.removeVotesByServer(server);
        } else {
            this.jsonStorage.removeServerVotes(server);
            this.jsonStorage.save();
        }
    }

    public boolean hasOnlineVotes(String uuid) {
        return this.cachedOnlineVotes.containsKey(uuid);
    }

    public ArrayList<OfflineBungeeVote> getOnlineVotes(String uuid) {
        return this.cachedOnlineVotes.getOrDefault(uuid, new ArrayList());
    }

    public void addOnlineVote(String uuid, OfflineBungeeVote vote) {
        this.cachedOnlineVotes.putIfAbsent(uuid, new ArrayList());
        this.cachedOnlineVotes.get(uuid).add(vote);
        if (this.useMySQL) {
            this.onlineVoteCacheTable.insertOnlineVote(vote.getUuid(), vote.getPlayerName(), vote.getService(), vote.getTime(), vote.isRealVote(), vote.getText());
        } else {
            this.jsonStorage.addVoteOnline(uuid, this.cachedOnlineVotes.get(uuid).size() - 1, vote);
            this.jsonStorage.save();
        }
    }

    public void removeOnlineVotes(String uuid) {
        this.cachedOnlineVotes.remove(uuid);
        if (this.useMySQL) {
            this.onlineVoteCacheTable.removeVotesForUUID(uuid);
        } else {
            this.jsonStorage.removeOnlineVotes(uuid);
            this.jsonStorage.save();
        }
    }

    public void checkVoteCacheTime(int voteCacheTime) {
        long cTime = LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        ArrayList<OfflineBungeeVote> expiredOnlineVotes = new ArrayList<OfflineBungeeVote>();
        for (Map.Entry<String, ArrayList<OfflineBungeeVote>> entry : this.cachedOnlineVotes.entrySet()) {
            ArrayList<OfflineBungeeVote> votes = entry.getValue();
            for (OfflineBungeeVote vote : votes) {
                if (vote.getTime() + (long)(voteCacheTime * 24 * 60 * 60 * 1000) >= cTime) continue;
                this.debug1("Removing vote from cache: " + vote.toString());
                expiredOnlineVotes.add(vote);
            }
        }
        this.removeOnlineVotes(expiredOnlineVotes);
        ArrayList<OfflineBungeeVote> expiredServerVotes = new ArrayList<OfflineBungeeVote>();
        for (Map.Entry<String, ArrayList<OfflineBungeeVote>> entry : this.cachedVotes.entrySet()) {
            ArrayList<OfflineBungeeVote> votes = entry.getValue();
            for (OfflineBungeeVote vote : votes) {
                if (vote.getTime() + (long)(voteCacheTime * 24 * 60 * 60 * 1000) >= cTime) continue;
                this.debug1("Removing vote from cache: " + vote.toString());
                expiredServerVotes.add(vote);
            }
        }
        for (String server : this.cachedVotes.keySet()) {
            this.removeServerVotes(server, expiredServerVotes);
        }
    }

    public void resetMilestoneCountInVotes() {
        String updatedText;
        ArrayList<OfflineBungeeVote> votes;
        for (Map.Entry<String, ArrayList<OfflineBungeeVote>> entry : this.cachedOnlineVotes.entrySet()) {
            votes = entry.getValue();
            for (OfflineBungeeVote vote : votes) {
                updatedText = this.updateMilestoneCount(vote.getText());
                vote.setText(updatedText);
            }
        }
        for (Map.Entry<String, ArrayList<OfflineBungeeVote>> entry : this.cachedVotes.entrySet()) {
            votes = entry.getValue();
            for (OfflineBungeeVote vote : votes) {
                updatedText = this.updateMilestoneCount(vote.getText());
                vote.setText(updatedText);
            }
        }
    }

    private String updateMilestoneCount(String text) {
        BungeeMessageData data = new BungeeMessageData(text);
        data.setMilestoneCount(0);
        return data.toString();
    }

    public void saveVoteCache() {
        if (this.useMySQL) {
            if (!this.getTimeChangeQueue().isEmpty()) {
                for (VoteTimeQueue vote : this.getTimeChangeQueue()) {
                    this.timedVoteCacheTable.insertTimedVote(vote.getName(), vote.getService(), vote.getTime());
                }
            }
        } else {
            if (!this.getTimeChangeQueue().isEmpty()) {
                int num = 0;
                for (VoteTimeQueue vote : this.getTimeChangeQueue()) {
                    this.jsonStorage.addTimedVote(num, vote);
                    ++num;
                }
            }
            this.jsonStorage.save();
        }
    }

    public void addTimeVoteToCache(VoteTimeQueue vote) {
        this.timeChangeQueue.add(vote);
    }

    public void load() {
        if (this.useMySQL) {
            this.voteCacheTable.getAllVotes().forEach(voteRow -> {
                OfflineBungeeVote vote = new OfflineBungeeVote(voteRow.getPlayerName(), voteRow.getUuid(), voteRow.getService(), voteRow.getTime(), voteRow.isRealVote(), voteRow.getText());
                String server = voteRow.getServer();
                this.cachedVotes.putIfAbsent(server, new ArrayList());
                this.cachedVotes.get(server).add(vote);
            });
            this.onlineVoteCacheTable.getAllVotes().forEach(voteRow -> {
                OfflineBungeeVote vote = new OfflineBungeeVote(voteRow.getPlayerName(), voteRow.getUuid(), voteRow.getService(), voteRow.getTime(), voteRow.isRealvote(), voteRow.getText());
                String player = vote.getUuid();
                this.cachedOnlineVotes.putIfAbsent(player, new ArrayList());
                this.cachedOnlineVotes.get(player).add(vote);
            });
            ArrayList timedVotes = new ArrayList();
            this.timedVoteCacheTable.getAllVotes().forEach(timedVoteRow -> {
                VoteTimeQueue voteTimeQueue = new VoteTimeQueue(timedVoteRow.getPlayerName(), timedVoteRow.getService(), timedVoteRow.getTime());
                timedVotes.add(voteTimeQueue);
            });
            this.timeChangeQueue.addAll(timedVotes);
            this.timedVoteCacheTable.clearTable();
        } else {
            String text;
            boolean real;
            long time;
            String service;
            String uuid;
            String name;
            ArrayList<OfflineBungeeVote> votes;
            try {
                for (String key : this.jsonStorage.getTimedVoteCache()) {
                    DataNode data = this.jsonStorage.getTimedVoteCache(key);
                    if (data == null || !data.isObject()) continue;
                    String name2 = data.has("Name") ? data.get("Name").asString() : "";
                    String service2 = data.has("Service") ? data.get("Service").asString() : "";
                    long time2 = data.has("Time") ? data.get("Time").asLong() : 0L;
                    this.getTimeChangeQueue().add(new VoteTimeQueue(name2, service2, time2));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                for (String server : this.jsonStorage.getServers()) {
                    votes = new ArrayList<OfflineBungeeVote>();
                    for (String num : this.jsonStorage.getServerVotes(server)) {
                        DataNode data = this.jsonStorage.getServerVotes(server, num);
                        if (data == null || !data.isObject()) continue;
                        name = data.has("Name") ? data.get("Name").asString() : "";
                        uuid = data.has("UUID") ? data.get("UUID").asString() : "";
                        service = data.has("Service") ? data.get("Service").asString() : "";
                        time = data.has("Time") ? data.get("Time").asLong() : 0L;
                        real = data.has("Real") && data.get("Real").asBoolean();
                        text = data.has("Text") ? data.get("Text").asString() : "";
                        votes.add(new OfflineBungeeVote(name, uuid, service, time, real, text));
                    }
                    this.cachedVotes.put(server, votes);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                for (String player : this.jsonStorage.getPlayers()) {
                    votes = new ArrayList();
                    for (String num : this.jsonStorage.getOnlineVotes(player)) {
                        DataNode data = this.jsonStorage.getOnlineVotes(player, num);
                        if (data == null || !data.isObject()) continue;
                        name = data.has("Name") ? data.get("Name").asString() : "";
                        uuid = data.has("UUID") ? data.get("UUID").asString() : "";
                        service = data.has("Service") ? data.get("Service").asString() : "";
                        time = data.has("Time") ? data.get("Time").asLong() : 0L;
                        real = data.has("Real") && data.get("Real").asBoolean();
                        text = data.has("Text") ? data.get("Text").asString() : "";
                        votes.add(new OfflineBungeeVote(name, uuid, service, time, real, text));
                    }
                    this.cachedOnlineVotes.put(player, votes);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.debug1("Loaded " + this.cachedVotes.size() + " server vote caches.");
        int totalServerVotes = this.cachedVotes.values().stream().mapToInt(ArrayList::size).sum();
        this.debug1("Loaded " + totalServerVotes + " total server votes.");
        this.debug1("Loaded " + this.cachedOnlineVotes.size() + " online vote caches.");
        int totalOnlineVotes = this.cachedOnlineVotes.values().stream().mapToInt(ArrayList::size).sum();
        this.debug1("Loaded " + totalOnlineVotes + " total online votes.");
        this.debug1("Loaded " + this.timeChangeQueue.size() + " timed votes.");
    }

    public abstract void logInfo1(String var1);

    public abstract void logSevere1(String var1);

    public abstract void debug1(Exception var1);

    public abstract void debug1(String var1);

    public VoteCacheHandler(MysqlConfig mysqlConfig, boolean useMySQL, boolean useExistingConnection, MySQL mysql, final boolean debug, IVoteCache jsonStorage) {
        this.useMySQL = useMySQL;
        if (useMySQL) {
            if (useExistingConnection) {
                this.voteCacheTable = new ProxyVoteCacheTable(mysql, mysqlConfig.getTablePrefix(), debug){

                    @Override
                    public void logSevere(String string) {
                        VoteCacheHandler.this.logSevere1(string);
                    }

                    @Override
                    public void logInfo(String string) {
                        VoteCacheHandler.this.logInfo1(string);
                    }

                    @Override
                    public void debug(Exception e) {
                        if (debug) {
                            VoteCacheHandler.this.debug1(e);
                        }
                    }
                };
                this.timedVoteCacheTable = new ProxyTimedVoteCacheTable(mysql, mysqlConfig.getTablePrefix(), debug){

                    @Override
                    public void logSevere(String string) {
                        VoteCacheHandler.this.logSevere1(string);
                    }

                    @Override
                    public void logInfo(String string) {
                        VoteCacheHandler.this.logInfo1(string);
                    }

                    @Override
                    public void debug(Exception e) {
                        if (debug) {
                            VoteCacheHandler.this.debug1(e);
                        }
                    }
                };
                this.onlineVoteCacheTable = new ProxyOnlineVoteCacheTable(mysql, mysqlConfig.getTablePrefix(), debug){

                    @Override
                    public void logSevere(String string) {
                        VoteCacheHandler.this.logSevere1(string);
                    }

                    @Override
                    public void logInfo(String string) {
                        VoteCacheHandler.this.logInfo1(string);
                    }

                    @Override
                    public void debug(Exception e) {
                        if (debug) {
                            VoteCacheHandler.this.debug1(e);
                        }
                    }
                };
            } else {
                this.voteCacheTable = new ProxyVoteCacheTable(mysqlConfig, debug){

                    @Override
                    public void logSevere(String string) {
                        VoteCacheHandler.this.logSevere1(string);
                    }

                    @Override
                    public void logInfo(String string) {
                        VoteCacheHandler.this.logInfo1(string);
                    }

                    @Override
                    public void debug(Exception e) {
                        if (debug) {
                            VoteCacheHandler.this.debug1(e);
                        }
                    }
                };
                this.timedVoteCacheTable = new ProxyTimedVoteCacheTable(this.voteCacheTable.getMysql(), mysqlConfig.getTablePrefix(), debug){

                    @Override
                    public void logSevere(String string) {
                        VoteCacheHandler.this.logSevere1(string);
                    }

                    @Override
                    public void logInfo(String string) {
                        VoteCacheHandler.this.logInfo1(string);
                    }

                    @Override
                    public void debug(Exception e) {
                        if (debug) {
                            VoteCacheHandler.this.debug1(e);
                        }
                    }
                };
                this.onlineVoteCacheTable = new ProxyOnlineVoteCacheTable(this.voteCacheTable.getMysql(), mysqlConfig.getTablePrefix(), debug){

                    @Override
                    public void logSevere(String string) {
                        VoteCacheHandler.this.logSevere1(string);
                    }

                    @Override
                    public void logInfo(String string) {
                        VoteCacheHandler.this.logInfo1(string);
                    }

                    @Override
                    public void debug(Exception e) {
                        if (debug) {
                            VoteCacheHandler.this.debug1(e);
                        }
                    }
                };
            }
        } else {
            this.jsonStorage = jsonStorage;
        }
    }

    public String[] getCachedVotesServers() {
        return ((ConcurrentHashMap.CollectionView)((Object)this.cachedVotes.keySet())).toArray(new String[0]);
    }

    public void removeServerVotes(String server, ArrayList<OfflineBungeeVote> removed) {
        for (OfflineBungeeVote vote : removed) {
            for (Map.Entry<String, ArrayList<OfflineBungeeVote>> entry : this.cachedVotes.entrySet()) {
                if (!entry.getKey().equals(server)) continue;
                entry.getValue().removeIf(v -> v.getUuid().equals(vote.getUuid()) && v.getService().equals(vote.getService()) && v.getTime() == vote.getTime());
            }
            if (this.useMySQL) {
                this.voteCacheTable.removeVote(vote, server);
                continue;
            }
            this.jsonStorage.removeVote(server, vote);
            this.jsonStorage.save();
        }
    }

    public void removeOnlineVotes(ArrayList<OfflineBungeeVote> removed) {
        for (OfflineBungeeVote vote : removed) {
            for (Map.Entry<String, ArrayList<OfflineBungeeVote>> entry : this.cachedOnlineVotes.entrySet()) {
                entry.getValue().removeIf(v -> v.getUuid().equals(vote.getUuid()) && v.getService().equals(vote.getService()) && v.getTime() == vote.getTime());
            }
            if (this.useMySQL) {
                this.onlineVoteCacheTable.removeOnlineVote(vote);
                continue;
            }
            this.jsonStorage.removeOnlineVote(vote);
            this.jsonStorage.save();
        }
    }

    @Generated
    public Queue<VoteTimeQueue> getTimeChangeQueue() {
        return this.timeChangeQueue;
    }
}

