/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.proxy.cache;

import com.bencodez.votingplugin.proxy.OfflineBungeeVote;
import com.bencodez.votingplugin.simpleapi.sql.mysql.MySQL;
import com.bencodez.votingplugin.simpleapi.sql.mysql.config.MysqlConfig;
import com.bencodez.votingplugin.simpleapi.sql.mysql.queries.Query;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;

public abstract class ProxyVoteCacheTable {
    private MySQL mysql;
    private final String tableName;

    public abstract void logSevere(String var1);

    public abstract void logInfo(String var1);

    public abstract void debug(Exception var1);

    public ProxyVoteCacheTable(MySQL existingMysql, String tablePrefix, boolean debug) {
        this.tableName = (tablePrefix != null ? tablePrefix : "") + "votingplugin_votecache";
        this.mysql = existingMysql;
        String sql = "CREATE TABLE IF NOT EXISTS `" + this.tableName + "` (id INT AUTO_INCREMENT PRIMARY KEY,uuid VARCHAR(36),playerName VARCHAR(100),service VARCHAR(100),`time` BIGINT,realVote TINYINT(1),`text` TEXT,`server` VARCHAR(100),INDEX idx_server (`server`),INDEX idx_uuid (`uuid`),INDEX idx_time (`time`)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
        try {
            new Query(this.mysql, sql).executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public ProxyVoteCacheTable(MysqlConfig config, final boolean debug) {
        String prefix = config.getTablePrefix() != null ? config.getTablePrefix() : "";
        this.tableName = prefix + "votingplugin_votecache";
        this.mysql = new MySQL(config.getMaxThreads()){

            @Override
            public void debug(SQLException e) {
                if (debug) {
                    e.printStackTrace();
                }
            }

            @Override
            public void severe(String msg) {
                ProxyVoteCacheTable.this.logSevere(msg);
            }

            @Override
            public void debug(String msg) {
                if (debug) {
                    ProxyVoteCacheTable.this.logInfo("MYSQL DEBUG: " + msg);
                }
            }
        };
        if (!this.mysql.connect(config)) {
            this.logSevere("Failed to connect to MySQL for vote cache!");
        }
        try {
            new Query(this.mysql, "USE `" + config.getDatabase() + "`;").executeUpdate();
        }
        catch (SQLException e) {
            this.logSevere("Failed to select database: " + config.getDatabase());
            this.debug(e);
        }
        String sql = "CREATE TABLE IF NOT EXISTS `" + this.tableName + "` (id INT AUTO_INCREMENT PRIMARY KEY,uuid VARCHAR(36),playerName VARCHAR(100),service VARCHAR(100),`time` BIGINT,realVote TINYINT(1),`text` TEXT,`server` VARCHAR(100),INDEX idx_server (`server`),INDEX idx_uuid (`uuid`),INDEX idx_time (`time`)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
        try {
            new Query(this.mysql, sql).executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public void insertVote(String uuid, String playerName, String service, long time, boolean real, String text, String server) {
        String sql = "INSERT INTO `" + this.tableName + "` (uuid, playerName, service, `time`, realVote, `text`, `server`) VALUES (?, ?, ?, ?, ?, ?, ?);";
        try (Connection conn = this.mysql.getConnectionManager().getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, uuid);
            ps.setString(2, playerName);
            ps.setString(3, service);
            ps.setLong(4, time);
            ps.setBoolean(5, real);
            ps.setString(6, text);
            ps.setString(7, server);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public List<VoteRow> getAllVotes() {
        String sql = "SELECT * FROM `" + this.tableName + "`;";
        return this.selectVotes(sql, null);
    }

    public List<VoteRow> getVotesForServer(String server) {
        String sql = "SELECT * FROM `" + this.tableName + "` WHERE `server` = ?;";
        return this.selectVotes(sql, new Object[]{server});
    }

    public VoteRow getVoteById(int id) {
        String sql = "SELECT * FROM `" + this.tableName + "` WHERE id = ?;";
        List<VoteRow> list = this.selectVotes(sql, new Object[]{id});
        return list.isEmpty() ? null : list.get(0);
    }

    public List<VoteRow> getVotesByUUID(String uuid) {
        String sql = "SELECT * FROM `" + this.tableName + "` WHERE uuid = ?;";
        return this.selectVotes(sql, new Object[]{uuid});
    }

    public List<VoteRow> getVotesByPlayerName(String playerName) {
        String sql = "SELECT * FROM `" + this.tableName + "` WHERE playerName = ?;";
        return this.selectVotes(sql, new Object[]{playerName});
    }

    public Set<String> getServers() {
        HashSet<String> servers = new HashSet<String>();
        String sql = "SELECT DISTINCT `server` FROM `" + this.tableName + "` WHERE `server` IS NOT NULL;";
        try (Connection conn = this.mysql.getConnectionManager().getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                String s = rs.getString(1);
                if (s == null) continue;
                servers.add(s);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return servers;
    }

    public void removeVoteById(int id) {
        String sql = "DELETE FROM `" + this.tableName + "` WHERE id = ?;";
        try (Connection conn = this.mysql.getConnectionManager().getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void removeVotesByServerAndUUID(String server, String uuid) {
        String sql = "DELETE FROM `" + this.tableName + "` WHERE `server` = ? AND `uuid` = ?;";
        try (Connection conn = this.mysql.getConnectionManager().getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, server);
            ps.setString(2, uuid);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void removeVote(OfflineBungeeVote vote, String server) {
        String sql = "DELETE FROM `" + this.tableName + "` WHERE `uuid` = ? AND `service` = ? AND `time` = ? AND `server` = ?;";
        try (Connection conn = this.mysql.getConnectionManager().getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, vote.getUuid());
            ps.setString(2, vote.getService());
            ps.setLong(3, vote.getTime());
            ps.setString(4, server);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void removeVotesByServer(String server) {
        String sql = "DELETE FROM `" + this.tableName + "` WHERE `server` = ?;";
        try (Connection conn = this.mysql.getConnectionManager().getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, server);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void clearTable() {
        try {
            new Query(this.mysql, "TRUNCATE TABLE `" + this.tableName + "`;").executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        this.mysql.disconnect();
    }

    private List<VoteRow> selectVotes(String sql, Object[] params) {
        ArrayList<VoteRow> list = new ArrayList<VoteRow>();
        try (Connection conn = this.mysql.getConnectionManager().getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    ps.setObject(i + 1, params[i]);
                }
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    VoteRow v = new VoteRow(rs.getInt("id"), rs.getString("uuid"), rs.getString("playerName"), rs.getString("service"), rs.getLong("time"), rs.getBoolean("realVote"), rs.getString("text"), rs.getString("server"));
                    list.add(v);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    @Generated
    public MySQL getMysql() {
        return this.mysql;
    }

    public static class VoteRow {
        private final int id;
        private final String uuid;
        private final String playerName;
        private final String service;
        private final long time;
        private final boolean realVote;
        private final String text;
        private final String server;

        public VoteRow(int id, String uuid, String playerName, String service, long time, boolean realVote, String text, String server) {
            this.id = id;
            this.uuid = uuid;
            this.playerName = playerName;
            this.service = service;
            this.time = time;
            this.realVote = realVote;
            this.text = text;
            this.server = server;
        }

        public int getId() {
            return this.id;
        }

        public String getUuid() {
            return this.uuid;
        }

        public String getPlayerName() {
            return this.playerName;
        }

        public String getService() {
            return this.service;
        }

        public long getTime() {
            return this.time;
        }

        public boolean isRealVote() {
            return this.realVote;
        }

        public String getText() {
            return this.text;
        }

        public String getServer() {
            return this.server;
        }
    }
}

