/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.proxy.cache;

import com.bencodez.votingplugin.simpleapi.sql.mysql.MySQL;
import com.bencodez.votingplugin.simpleapi.sql.mysql.config.MysqlConfig;
import com.bencodez.votingplugin.simpleapi.sql.mysql.queries.Query;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public abstract class ProxyTimedVoteCacheTable {
    protected MySQL mysql;
    private final String tableName;

    public abstract void logSevere(String var1);

    public abstract void logInfo(String var1);

    public abstract void debug(Exception var1);

    public ProxyTimedVoteCacheTable(MySQL existingMysql, String tablePrefix, boolean debug) {
        this.tableName = (tablePrefix != null ? tablePrefix : "") + "votingplugin_timedvotecache";
        this.mysql = existingMysql;
        String sql = "CREATE TABLE IF NOT EXISTS `" + this.tableName + "` (id INT AUTO_INCREMENT PRIMARY KEY,playerName VARCHAR(100),service VARCHAR(100),time BIGINT,INDEX idx_time (time)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
        try {
            new Query(this.mysql, sql).executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public ProxyTimedVoteCacheTable(MysqlConfig config, final boolean debug) {
        String prefix = config.getTablePrefix() != null ? config.getTablePrefix() : "";
        this.tableName = prefix + "votingplugin_timedvotecache";
        this.mysql = new MySQL(config.getMaxThreads()){

            @Override
            public void debug(SQLException e) {
                if (debug) {
                    e.printStackTrace();
                }
            }

            @Override
            public void severe(String msg) {
                ProxyTimedVoteCacheTable.this.logSevere(msg);
            }

            @Override
            public void debug(String msg) {
                if (debug) {
                    ProxyTimedVoteCacheTable.this.logInfo("MYSQL DEBUG: " + msg);
                }
            }
        };
        if (!this.mysql.connect(config)) {
            this.logSevere("Failed to connect to MySQL for timed vote cache!");
        }
        try {
            new Query(this.mysql, "USE `" + config.getDatabase() + "`;").executeUpdate();
        }
        catch (SQLException e) {
            this.logSevere("Failed to select database: " + config.getDatabase());
            this.debug(e);
        }
        String sql = "CREATE TABLE IF NOT EXISTS `" + this.tableName + "` (id INT AUTO_INCREMENT PRIMARY KEY,playerName VARCHAR(100),service VARCHAR(100),time BIGINT,INDEX idx_time (time)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
        try {
            new Query(this.mysql, sql).executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public void insertTimedVote(String playerName, String service, long time) {
        String sql = "INSERT INTO `" + this.tableName + "` (playerName, service, time) VALUES (?, ?, ?);";
        try (Connection conn = this.mysql.getConnectionManager().getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, playerName);
            ps.setString(2, service);
            ps.setLong(3, time);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public List<TimedVoteRow> getAllVotes() {
        String sql = "SELECT * FROM `" + this.tableName + "`;";
        return this.selectVotes(sql, null);
    }

    public List<TimedVoteRow> getExpiredVotes(long now) {
        String sql = "SELECT * FROM `" + this.tableName + "` WHERE time <= ?;";
        return this.selectVotes(sql, new Object[]{now});
    }

    public void removeVoteById(int id) {
        String sql = "DELETE FROM `" + this.tableName + "` WHERE id = ?;";
        try (Connection conn = this.mysql.getConnectionManager().getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void removeExpiredVotes(long now) {
        String sql = "DELETE FROM `" + this.tableName + "` WHERE time <= ?;";
        try (Connection conn = this.mysql.getConnectionManager().getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setLong(1, now);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void clearTable() {
        try {
            new Query(this.mysql, "TRUNCATE TABLE `" + this.tableName + "`;").executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        this.mysql.disconnect();
    }

    private List<TimedVoteRow> selectVotes(String sql, Object[] params) {
        ArrayList<TimedVoteRow> list = new ArrayList<TimedVoteRow>();
        try (Connection conn = this.mysql.getConnectionManager().getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    ps.setObject(i + 1, params[i]);
                }
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    TimedVoteRow v = new TimedVoteRow(rs.getInt("id"), rs.getString("playerName"), rs.getString("service"), rs.getLong("time"));
                    list.add(v);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static class TimedVoteRow {
        private final int id;
        private final String playerName;
        private final String service;
        private final long time;

        public TimedVoteRow(int id, String playerName, String service, long time) {
            this.id = id;
            this.playerName = playerName;
            this.service = service;
            this.time = time;
        }

        public int getId() {
            return this.id;
        }

        public String getPlayerName() {
            return this.playerName;
        }

        public String getService() {
            return this.service;
        }

        public long getTime() {
            return this.time;
        }
    }
}

