/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.proxy.cache;

import com.bencodez.votingplugin.proxy.OfflineBungeeVote;
import com.bencodez.votingplugin.simpleapi.sql.mysql.MySQL;
import com.bencodez.votingplugin.simpleapi.sql.mysql.config.MysqlConfig;
import com.bencodez.votingplugin.simpleapi.sql.mysql.queries.Query;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public abstract class ProxyOnlineVoteCacheTable {
    protected MySQL mysql;
    private final String tableName;

    public abstract void logSevere(String var1);

    public abstract void logInfo(String var1);

    public abstract void debug(Exception var1);

    public ProxyOnlineVoteCacheTable(MySQL existingMysql, String tablePrefix, boolean debug) {
        this.tableName = (tablePrefix != null ? tablePrefix : "") + "votingplugin_onlinevotecache";
        this.mysql = existingMysql;
        String sql = "CREATE TABLE IF NOT EXISTS `" + this.tableName + "` (id INT AUTO_INCREMENT PRIMARY KEY,uuid VARCHAR(36),playerName VARCHAR(100),service VARCHAR(100),`time` BIGINT,realvote BOOLEAN,text LONGTEXT,INDEX idx_uuid (`uuid`),INDEX idx_time (`time`)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
        try {
            new Query(this.mysql, sql).executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public ProxyOnlineVoteCacheTable(MysqlConfig config, final boolean debug) {
        String prefix = config.getTablePrefix() != null ? config.getTablePrefix() : "";
        this.tableName = prefix + "votingplugin_onlinevotecache";
        this.mysql = new MySQL(config.getMaxThreads()){

            @Override
            public void debug(SQLException e) {
                if (debug) {
                    e.printStackTrace();
                }
            }

            @Override
            public void severe(String msg) {
                ProxyOnlineVoteCacheTable.this.logSevere(msg);
            }

            @Override
            public void debug(String msg) {
                if (debug) {
                    ProxyOnlineVoteCacheTable.this.logInfo("MYSQL DEBUG: " + msg);
                }
            }
        };
        if (!this.mysql.connect(config)) {
            this.logSevere("Failed to connect to MySQL for online vote cache!");
        }
        try {
            new Query(this.mysql, "USE `" + config.getDatabase() + "`;").executeUpdate();
        }
        catch (SQLException e) {
            this.logSevere("Failed to select database: " + config.getDatabase());
            this.debug(e);
        }
        String sql = "CREATE TABLE IF NOT EXISTS `" + this.tableName + "` (id INT AUTO_INCREMENT PRIMARY KEY,uuid VARCHAR(36),playerName VARCHAR(100),service VARCHAR(100),`time` BIGINT,realvote BOOLEAN,text LONGTEXT,INDEX idx_uuid (`uuid`),INDEX idx_time (`time`)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
        try {
            new Query(this.mysql, sql).executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public void insertOnlineVote(String uuid, String playerName, String service, long time, boolean realvote, String text) {
        String sql = "INSERT INTO `" + this.tableName + "` (uuid, playerName, service, `time`, realvote, text) VALUES (?, ?, ?, ?, ?, ?);";
        try (Connection conn = this.mysql.getConnectionManager().getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, uuid);
            ps.setString(2, playerName);
            ps.setString(3, service);
            ps.setLong(4, time);
            ps.setBoolean(5, realvote);
            ps.setString(6, text);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public List<OnlineVoteRow> getAllVotes() {
        String sql = "SELECT * FROM `" + this.tableName + "`;";
        return this.selectVotes(sql, null);
    }

    public List<OnlineVoteRow> getVotesForUUID(String uuid) {
        String sql = "SELECT * FROM `" + this.tableName + "` WHERE `uuid` = ?;";
        return this.selectVotes(sql, new Object[]{uuid});
    }

    public void removeVoteById(int id) {
        String sql = "DELETE FROM `" + this.tableName + "` WHERE id = ?;";
        try (Connection conn = this.mysql.getConnectionManager().getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void removeVotesForUUID(String uuid) {
        String sql = "DELETE FROM `" + this.tableName + "` WHERE uuid = ?;";
        try (Connection conn = this.mysql.getConnectionManager().getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, uuid);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void clearTable() {
        try {
            new Query(this.mysql, "TRUNCATE TABLE `" + this.tableName + "`;").executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        this.mysql.disconnect();
    }

    private List<OnlineVoteRow> selectVotes(String sql, Object[] params) {
        ArrayList<OnlineVoteRow> list = new ArrayList<OnlineVoteRow>();
        try (Connection conn = this.mysql.getConnectionManager().getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    ps.setObject(i + 1, params[i]);
                }
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    OnlineVoteRow v = new OnlineVoteRow(rs.getInt("id"), rs.getString("uuid"), rs.getString("playerName"), rs.getString("service"), rs.getLong("time"), rs.getBoolean("realvote"), rs.getString("text"));
                    list.add(v);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void removeOnlineVote(OfflineBungeeVote vote) {
        String sql = "DELETE FROM `" + this.tableName + "` WHERE `uuid` = ? AND `service` = ? AND `time` = ?;";
        try (Connection conn = this.mysql.getConnectionManager().getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, vote.getUuid());
            ps.setString(2, vote.getService());
            ps.setLong(3, vote.getTime());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static class OnlineVoteRow {
        private final int id;
        private final String uuid;
        private final String playerName;
        private final String service;
        private final long time;
        private final boolean realvote;
        private final String text;

        public OnlineVoteRow(int id, String uuid, String playerName, String service, long time, boolean realvote, String text) {
            this.id = id;
            this.uuid = uuid;
            this.playerName = playerName;
            this.service = service;
            this.time = time;
            this.realvote = realvote;
            this.text = text;
        }

        public int getId() {
            return this.id;
        }

        public String getUuid() {
            return this.uuid;
        }

        public String getPlayerName() {
            return this.playerName;
        }

        public String getService() {
            return this.service;
        }

        public long getTime() {
            return this.time;
        }

        public boolean isRealvote() {
            return this.realvote;
        }

        public String getText() {
            return this.text;
        }
    }
}

