/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.proxy.cache;

import com.bencodez.votingplugin.proxy.cache.DataNode;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;

public class GsonDataNode
implements DataNode {
    private final JsonElement element;

    public GsonDataNode(JsonElement element) {
        this.element = element;
    }

    @Override
    public boolean isObject() {
        return this.element.isJsonObject();
    }

    @Override
    public boolean isArray() {
        return this.element.isJsonArray();
    }

    @Override
    public boolean isPrimitive() {
        return this.element.isJsonPrimitive();
    }

    @Override
    public DataNode get(String key) {
        if (!this.isObject()) {
            return null;
        }
        return new GsonDataNode(this.element.getAsJsonObject().get(key));
    }

    @Override
    public DataNode get(int index) {
        if (!this.isArray()) {
            return null;
        }
        return new GsonDataNode(this.element.getAsJsonArray().get(index));
    }

    @Override
    public void set(String key, Object value) {
        if (!this.isObject()) {
            return;
        }
        this.element.getAsJsonObject().add(key, new Gson().toJsonTree(value));
    }

    @Override
    public void set(int index, Object value) {
        if (!this.isArray()) {
            return;
        }
        this.element.getAsJsonArray().set(index, new Gson().toJsonTree(value));
    }

    @Override
    public long asLong() {
        if (this.element == null || !this.element.isJsonPrimitive()) {
            return 0L;
        }
        JsonPrimitive prim = this.element.getAsJsonPrimitive();
        if (prim.isNumber()) {
            return prim.getAsLong();
        }
        try {
            return Long.parseLong(prim.getAsString());
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    @Override
    public Object asPrimitive() {
        if (!this.isPrimitive()) {
            return null;
        }
        JsonPrimitive prim = this.element.getAsJsonPrimitive();
        if (prim.isBoolean()) {
            return prim.getAsBoolean();
        }
        if (prim.isNumber()) {
            return prim.getAsNumber();
        }
        return prim.getAsString();
    }

    @Override
    public boolean has(String key) {
        return this.isObject() && this.element.getAsJsonObject().has(key);
    }

    @Override
    public boolean has(int index) {
        return this.isArray() && index >= 0 && index < this.element.getAsJsonArray().size();
    }

    @Override
    public String asString() {
        return this.element.getAsString();
    }

    @Override
    public int asInt() {
        return this.element.getAsInt();
    }

    @Override
    public boolean asBoolean() {
        return this.element.getAsBoolean();
    }

    @Override
    public Object toInternal() {
        return this.element;
    }
}

