/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.proxy.bungee;

import com.bencodez.votingplugin.advancedcore.api.time.TimeType;
import com.bencodez.votingplugin.advancedcore.bungeeapi.globaldata.GlobalDataHandlerProxy;
import com.bencodez.votingplugin.advancedcore.bungeeapi.globaldata.GlobalMySQL;
import com.bencodez.votingplugin.proxy.BungeeVersion;
import com.bencodez.votingplugin.proxy.ProxyMysqlUserTable;
import com.bencodez.votingplugin.proxy.VotingPluginProxy;
import com.bencodez.votingplugin.proxy.VotingPluginProxyConfig;
import com.bencodez.votingplugin.proxy.bungee.BStatsMetricsBungee;
import com.bencodez.votingplugin.proxy.bungee.Config;
import com.bencodez.votingplugin.proxy.bungee.NonVotedPlayersCache;
import com.bencodez.votingplugin.proxy.bungee.VoteCache;
import com.bencodez.votingplugin.proxy.bungee.VoteEventBungee;
import com.bencodez.votingplugin.proxy.bungee.VotingPluginBungeeCommand;
import com.bencodez.votingplugin.simpleapi.sql.DataType;
import com.bencodez.votingplugin.simpleapi.sql.mysql.config.MysqlConfig;
import com.bencodez.votingplugin.simpleapi.sql.mysql.config.MysqlConfigBungee;
import com.bencodez.votingplugin.topvoter.TopVoter;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.CodeSource;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import lombok.Generated;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;
import net.md_5.bungee.event.EventHandler;

public class VotingPluginBungee
extends Plugin
implements Listener {
    private Config config;
    private NonVotedPlayersCache nonVotedPlayersCache;
    private VoteCache voteCacheFile;
    private String buildNumber = "NOTSET";
    private VoteEventBungee voteEventBungee;
    private VotingPluginProxy votingPluginProxy;
    private ScheduledExecutorService timer;

    public void debug(String msg) {
        if (this.config.getDebug()) {
            this.getLogger().info("Debug: " + msg);
        }
    }

    public void debug2(String msg) {
        this.debug(msg);
    }

    public Set<String> getAvailableAllServers() {
        HashSet<String> servers = new HashSet<String>();
        if (this.config.getWhiteListedServers().isEmpty()) {
            for (String s : this.getProxy().getServers().keySet()) {
                if (this.config.getBlockedServers().contains(s)) continue;
                servers.add(s);
            }
        } else {
            servers.addAll(this.config.getWhiteListedServers());
        }
        return servers;
    }

    public String getProperPlayerName(String uuid, String currentName) {
        ProxiedPlayer p = this.getProxy().getPlayer(UUID.fromString(uuid));
        if (p != null && p.isConnected()) {
            return p.getName();
        }
        return currentName;
    }

    private Configuration getVersionFile() {
        try {
            CodeSource src = ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource();
            if (src != null) {
                InputStreamReader defConfigStream;
                String name;
                ZipEntry e;
                URL jar = src.getLocation();
                ZipInputStream zip = null;
                zip = new ZipInputStream(jar.openStream());
                while ((e = zip.getNextEntry()) == null || !(name = e.getName()).equals("votingpluginversion.yml") || (defConfigStream = new InputStreamReader(zip)) == null) {
                }
                Configuration conf = ConfigurationProvider.getProvider(YamlConfiguration.class).load((Reader)defConfigStream);
                ((Reader)defConfigStream).close();
                return conf;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public boolean isOnline(ProxiedPlayer p) {
        if (p != null) {
            return p.isConnected();
        }
        return false;
    }

    private void loadMysql() {
        this.votingPluginProxy.setProxyMySQL(new ProxyMysqlUserTable("VotingPlugin_Users", new MysqlConfigBungee(this.config.getData()), this.config.getDebug()){

            @Override
            public void debug(SQLException e) {
                if (VotingPluginBungee.this.config.getDebug()) {
                    e.printStackTrace();
                }
            }

            @Override
            public void logSevere(String string) {
                VotingPluginBungee.this.getLogger().severe(string);
            }

            @Override
            public void logInfo(String string) {
                VotingPluginBungee.this.getLogger().info(string);
            }

            @Override
            public void severe(String string) {
                VotingPluginBungee.this.getLogger().severe(string);
            }
        });
        ArrayList<String> servers = new ArrayList<String>();
        for (String s : this.getAvailableAllServers()) {
            servers.add(s);
        }
        if (this.config.getGlobalDataEnabled()) {
            if (this.config.getGlobalDataUseMainMySQL()) {
                this.votingPluginProxy.setGlobalDataHandler(new GlobalDataHandlerProxy(new GlobalMySQL("VotingPlugin_GlobalData", this.getVotingPluginProxy().getProxyMySQL().getMysql()){

                    @Override
                    public void debugEx(Exception e) {
                        if (VotingPluginBungee.this.config.getDebug()) {
                            e.printStackTrace();
                        }
                    }

                    @Override
                    public void debugLog(String text) {
                        VotingPluginBungee.this.debug2(text);
                    }

                    @Override
                    public void info(String text) {
                        VotingPluginBungee.this.getLogger().info(text);
                    }

                    @Override
                    public void logSevere(String text) {
                        VotingPluginBungee.this.getLogger().severe(text);
                    }

                    @Override
                    public void warning(String text) {
                        VotingPluginBungee.this.getLogger().warning(text);
                    }
                }, servers){

                    @Override
                    public void onTimeChangedFailed(String server, TimeType type) {
                        VotingPluginBungee.this.getVotingPluginProxy().getGlobalDataHandler().setBoolean(server, type.toString(), false);
                        VotingPluginBungee.this.getVotingPluginProxy().getGlobalDataHandler().setBoolean(server, "FinishedProcessing", true);
                        VotingPluginBungee.this.getVotingPluginProxy().getGlobalDataHandler().setBoolean(server, "Processing", false);
                    }

                    @Override
                    public void onTimeChangedFinished(TimeType type) {
                        if (type.equals((Object)TimeType.MONTH)) {
                            VotingPluginBungee.this.getVotingPluginProxy().getProxyMySQL().copyColumnData(TopVoter.Monthly.getColumnName(), "LastMonthTotal");
                            if (VotingPluginBungee.this.getVotingPluginProxy().getConfig().getResetMilestonesMonthly()) {
                                VotingPluginBungee.this.getVotingPluginProxy().getProxyMySQL().wipeColumnData("MilestoneCount", DataType.INTEGER);
                                VotingPluginBungee.this.getVotingPluginProxy().getProxyMySQL().wipeColumnData("GottenMileStones", DataType.STRING);
                            }
                        }
                        VotingPluginBungee.this.getVotingPluginProxy().getProxyMySQL().wipeColumnData(TopVoter.of(type).getColumnName(), DataType.INTEGER);
                        if (!VotingPluginBungee.this.config.getGlobalDataEnabled()) {
                            return;
                        }
                        for (String s : VotingPluginBungee.this.getAvailableAllServers()) {
                            VotingPluginBungee.this.getVotingPluginProxy().getGlobalDataHandler().setBoolean(s, "ForceUpdate", true);
                            VotingPluginBungee.this.getVotingPluginProxy().getGlobalMessageProxyHandler().sendMessage(s, 1, "BungeeTimeChange", "");
                        }
                        VotingPluginBungee.this.getVotingPluginProxy().processQueue();
                    }
                });
            } else {
                this.votingPluginProxy.setGlobalDataHandler(new GlobalDataHandlerProxy(new GlobalMySQL("VotingPlugin_GlobalData", new MysqlConfigBungee(this.config.getData().getSection("GlobalData"))){

                    @Override
                    public void debugEx(Exception e) {
                        if (VotingPluginBungee.this.config.getDebug()) {
                            e.printStackTrace();
                        }
                    }

                    @Override
                    public void debugLog(String text) {
                        VotingPluginBungee.this.debug2(text);
                    }

                    @Override
                    public void info(String text) {
                        VotingPluginBungee.this.getLogger().info(text);
                    }

                    @Override
                    public void logSevere(String text) {
                        VotingPluginBungee.this.getLogger().severe(text);
                    }

                    @Override
                    public void warning(String text) {
                        VotingPluginBungee.this.getLogger().warning(text);
                    }
                }, servers){

                    @Override
                    public void onTimeChangedFailed(String server, TimeType type) {
                        VotingPluginBungee.this.getVotingPluginProxy().getGlobalDataHandler().setBoolean(server, type.toString(), false);
                        VotingPluginBungee.this.getVotingPluginProxy().getGlobalDataHandler().setBoolean(server, "FinishedProcessing", true);
                        VotingPluginBungee.this.getVotingPluginProxy().getGlobalDataHandler().setBoolean(server, "Processing", false);
                    }

                    @Override
                    public void onTimeChangedFinished(TimeType type) {
                        if (type.equals((Object)TimeType.MONTH)) {
                            VotingPluginBungee.this.getVotingPluginProxy().getProxyMySQL().copyColumnData(TopVoter.Monthly.getColumnName(), "LastMonthTotal");
                            if (VotingPluginBungee.this.getVotingPluginProxy().getConfig().getResetMilestonesMonthly()) {
                                VotingPluginBungee.this.getVotingPluginProxy().getProxyMySQL().wipeColumnData("MilestoneCount", DataType.INTEGER);
                                VotingPluginBungee.this.getVotingPluginProxy().getProxyMySQL().wipeColumnData("GottenMileStones", DataType.STRING);
                            }
                        }
                        VotingPluginBungee.this.getVotingPluginProxy().getProxyMySQL().wipeColumnData(TopVoter.of(type).getColumnName(), DataType.INTEGER);
                        if (!VotingPluginBungee.this.config.getGlobalDataEnabled()) {
                            return;
                        }
                        for (String s : VotingPluginBungee.this.getAvailableAllServers()) {
                            VotingPluginBungee.this.getVotingPluginProxy().getGlobalDataHandler().setBoolean(s, "ForceUpdate", true);
                            VotingPluginBungee.this.getVotingPluginProxy().getGlobalMessageProxyHandler().sendMessage(s, 1, "BungeeTimeChange", "");
                        }
                        VotingPluginBungee.this.getVotingPluginProxy().processQueue();
                    }
                });
            }
            this.getVotingPluginProxy().getGlobalDataHandler().getGlobalMysql().alterColumnType("IgnoreTime", "VARCHAR(5)");
            this.getVotingPluginProxy().getGlobalDataHandler().getGlobalMysql().alterColumnType("MONTH", "VARCHAR(5)");
            this.getVotingPluginProxy().getGlobalDataHandler().getGlobalMysql().alterColumnType("WEEK", "VARCHAR(5)");
            this.getVotingPluginProxy().getGlobalDataHandler().getGlobalMysql().alterColumnType("DAY", "VARCHAR(5)");
            this.getVotingPluginProxy().getGlobalDataHandler().getGlobalMysql().alterColumnType("FinishedProcessing", "VARCHAR(5)");
            this.getVotingPluginProxy().getGlobalDataHandler().getGlobalMysql().alterColumnType("Processing", "VARCHAR(5)");
            this.getVotingPluginProxy().getGlobalDataHandler().getGlobalMysql().alterColumnType("ForceUpdate", "VARCHAR(5)");
            this.getVotingPluginProxy().getGlobalDataHandler().getGlobalMysql().alterColumnType("LastUpdated", "MEDIUMTEXT");
        }
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("TopVoterIgnore", "VARCHAR(5)");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("CheckWorld", "VARCHAR(5)");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("Reminded", "VARCHAR(5)");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("DisableBroadcast", "VARCHAR(5)");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("LastOnline", "VARCHAR(20)");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("PlayerName", "VARCHAR(30)");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("DailyTotal", "INT DEFAULT '0'");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("WeeklyTotal", "INT DEFAULT '0'");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("DayVoteStreak", "INT DEFAULT '0'");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("BestDayVoteStreak", "INT DEFAULT '0'");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("WeekVoteStreak", "INT DEFAULT '0'");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("BestWeekVoteStreak", "INT DEFAULT '0'");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("VotePartyVotes", "INT DEFAULT '0'");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("MonthVoteStreak", "INT DEFAULT '0'");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("Points", "INT DEFAULT '0'");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("HighestDailyTotal", "INT DEFAULT '0'");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("AllTimeTotal", "INT DEFAULT '0'");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("HighestMonthlyTotal", "INT DEFAULT '0'");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("MilestoneCount", "INT DEFAULT '0'");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("MonthTotal", "INT DEFAULT '0'");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("HighestWeeklyTotal", "INT DEFAULT '0'");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("LastMonthTotal", "INT DEFAULT '0'");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("LastWeeklyTotal", "INT DEFAULT '0'");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("LastDailyTotal", "INT DEFAULT '0'");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("OfflineRewards", "MEDIUMTEXT");
        this.getVotingPluginProxy().getProxyMySQL().alterColumnType("DayVoteStreakLastUpdate", "MEDIUMTEXT");
        if (this.config.getStoreMonthTotalsWithDate()) {
            this.getVotingPluginProxy().getProxyMySQL().alterColumnType(this.getVotingPluginProxy().getMonthTotalsWithDatePath(LocalDateTime.now()), "INT DEFAULT '0'");
            this.getVotingPluginProxy().getProxyMySQL().alterColumnType(this.getVotingPluginProxy().getMonthTotalsWithDatePath(LocalDateTime.now().plusMonths(1L)), "INT DEFAULT '0'");
            this.getVotingPluginProxy().getProxyMySQL().alterColumnType(this.getVotingPluginProxy().getMonthTotalsWithDatePath(LocalDateTime.now().plusMonths(2L)), "INT DEFAULT '0'");
        }
    }

    public void loadVersionFile() {
        Configuration conf = this.getVersionFile();
        if (conf != null) {
            this.buildNumber = (String)conf.get("buildnumber", (Object)"NOTSET");
        }
    }

    public void login(ProxiedPlayer p) {
        if (p != null && p.getServer() != null && p.getServer().getInfo() != null) {
            final ProxiedPlayer proxiedPlayer = p;
            this.getProxy().getScheduler().schedule((Plugin)this, new Runnable(){

                @Override
                public void run() {
                    VotingPluginBungee.this.getVotingPluginProxy().login(proxiedPlayer.getName(), proxiedPlayer.getUniqueId().toString(), proxiedPlayer.getServer().getInfo().getName());
                }
            }, 1L, TimeUnit.SECONDS);
        }
    }

    public void onDisable() {
        this.getVotingPluginProxy().onDisable();
        this.voteCacheFile.save();
        this.nonVotedPlayersCache.save();
        this.timer.shutdownNow();
        this.getLogger().info("VotingPlugin disabled");
    }

    public void onEnable() {
        this.timer = Executors.newScheduledThreadPool(1);
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)this);
        this.config = new Config(this);
        this.config.load();
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new VotingPluginBungeeCommand(this));
        this.votingPluginProxy = new VotingPluginProxy(){

            @Override
            public void addNonVotedPlayer(String uuid, String playerName) {
                VotingPluginBungee.this.nonVotedPlayersCache.addPlayer(uuid, playerName);
            }

            @Override
            public void broadcast(String message) {
                VotingPluginBungee.this.getProxy().broadcast((BaseComponent)new TextComponent(ChatColor.translateAlternateColorCodes((char)'&', (String)message)));
            }

            @Override
            public void debug(String str) {
                VotingPluginBungee.this.debug2(str);
            }

            @Override
            public Set<String> getAllAvailableServers() {
                return VotingPluginBungee.this.getAvailableAllServers();
            }

            @Override
            public VotingPluginProxyConfig getConfig() {
                return VotingPluginBungee.this.config;
            }

            @Override
            public String getCurrentPlayerServer(String player) {
                return VotingPluginBungee.this.getProxy().getPlayer(player).getServer().getInfo().getName();
            }

            @Override
            public File getDataFolderPlugin() {
                return VotingPluginBungee.this.getDataFolder();
            }

            @Override
            public String getProperName(String uuid, String playerName) {
                return VotingPluginBungee.this.getProperPlayerName(uuid, playerName);
            }

            @Override
            public String getUUID(String playerName) {
                String str;
                if (!VotingPluginBungee.this.config.getOnlineMode()) {
                    ProxiedPlayer p = VotingPluginBungee.this.getProxy().getPlayer(playerName);
                    if (p != null && p.isConnected()) {
                        playerName = p.getName();
                    }
                    return UUID.nameUUIDFromBytes(("OfflinePlayer:" + playerName).getBytes(StandardCharsets.UTF_8)).toString();
                }
                ProxiedPlayer p = VotingPluginBungee.this.getProxy().getPlayer(playerName);
                if (p != null && p.isConnected()) {
                    return p.getUniqueId().toString();
                }
                for (Map.Entry<UUID, String> entry : VotingPluginBungee.this.getVotingPluginProxy().getUuidPlayerNameCache().entrySet()) {
                    if (!entry.getValue().equalsIgnoreCase(playerName)) continue;
                    return entry.getKey().toString();
                }
                if (VotingPluginBungee.this.getVotingPluginProxy().getProxyMySQL() != null && (str = VotingPluginBungee.this.getVotingPluginProxy().getProxyMySQL().getUUID(playerName)) != null) {
                    return str;
                }
                if (VotingPluginBungee.this.nonVotedPlayersCache != null) {
                    return VotingPluginBungee.this.nonVotedPlayersCache.playerExists(playerName);
                }
                return "";
            }

            @Override
            public String getPluginVersion() {
                return VotingPluginBungee.this.getDescription().getVersion();
            }

            @Override
            public int getVoteCacheCurrentVotePartyVotes() {
                return VotingPluginBungee.this.voteCacheFile.getVotePartyCurrentVotes();
            }

            @Override
            public long getVoteCacheLastUpdated() {
                return VotingPluginBungee.this.voteCacheFile.getLong("Time.LastUpdated", 0L);
            }

            @Override
            public int getVoteCachePrevDay() {
                return VotingPluginBungee.this.voteCacheFile.getInt("Time.Day", 0);
            }

            @Override
            public String getVoteCachePrevMonth() {
                return VotingPluginBungee.this.voteCacheFile.getString("Time.Month", "");
            }

            @Override
            public int getVoteCachePrevWeek() {
                return VotingPluginBungee.this.voteCacheFile.getInt("Time.Week", 0);
            }

            @Override
            public int getVoteCacheVotePartyIncreaseVotesRequired() {
                return VotingPluginBungee.this.voteCacheFile.getVotePartyInreaseVotesRequired();
            }

            @Override
            public boolean isPlayerOnline(String playerName) {
                ProxiedPlayer player = VotingPluginBungee.this.getProxy().getPlayer(playerName);
                return player != null && player.isConnected();
            }

            @Override
            public boolean isServerValid(String server) {
                return VotingPluginBungee.this.getProxy().getServerInfo(server) != null;
            }

            @Override
            public boolean isSomeoneOnlineServer(String server) {
                return !VotingPluginBungee.this.getProxy().getServerInfo(server).getPlayers().isEmpty();
            }

            @Override
            public boolean isVoteCacheIgnoreTime() {
                return VotingPluginBungee.this.voteCacheFile.getBoolean("Time.IgnoreTime", false);
            }

            @Override
            public void log(String message) {
                VotingPluginBungee.this.getLogger().info(message);
            }

            @Override
            public void logSevere(String message) {
                VotingPluginBungee.this.getLogger().severe(message);
            }

            @Override
            public void runAsync(Runnable run) {
                VotingPluginBungee.this.runAsyncNow(run);
            }

            @Override
            public void runConsoleCommand(String command) {
                VotingPluginBungee.this.getProxy().getPluginManager().dispatchCommand(VotingPluginBungee.this.getProxy().getConsole(), command);
            }

            @Override
            public void saveVoteCacheFile() {
                VotingPluginBungee.this.voteCacheFile.save();
            }

            @Override
            public void sendPluginMessageData(String server, String channel, byte[] data, boolean queue) {
                VotingPluginBungee.this.getProxy().getServerInfo(server).sendData(channel, data, queue);
            }

            @Override
            public void setVoteCacheLastUpdated() {
                VotingPluginBungee.this.voteCacheFile.setLong("Time.LastUpdated", System.currentTimeMillis());
                VotingPluginBungee.this.voteCacheFile.save();
            }

            @Override
            public void setVoteCachePrevDay(int day) {
                VotingPluginBungee.this.voteCacheFile.setInt("Time.Day", day);
                VotingPluginBungee.this.voteCacheFile.save();
            }

            @Override
            public void setVoteCachePrevMonth(String text) {
                VotingPluginBungee.this.voteCacheFile.setString("Time.Month", text);
                VotingPluginBungee.this.voteCacheFile.save();
            }

            @Override
            public void setVoteCachePrevWeek(int week) {
                VotingPluginBungee.this.voteCacheFile.setInt("Time.Week", week);
                VotingPluginBungee.this.voteCacheFile.save();
            }

            @Override
            public void setVoteCacheVoteCacheIgnoreTime(boolean ignore) {
                VotingPluginBungee.this.voteCacheFile.setBoolean("Time.IgnoreTime", ignore);
                VotingPluginBungee.this.voteCacheFile.save();
            }

            @Override
            public void setVoteCacheVotePartyCurrentVotes(int votes) {
                VotingPluginBungee.this.voteCacheFile.setVotePartyCurrentVotes(votes);
            }

            @Override
            public void setVoteCacheVotePartyIncreaseVotesRequired(int votes) {
                VotingPluginBungee.this.voteCacheFile.setVotePartyInreaseVotesRequired(votes);
            }

            @Override
            public void warn(String message) {
                VotingPluginBungee.this.getLogger().warning(message);
            }

            @Override
            public void reloadCore(boolean mysql) {
                VotingPluginBungee.this.reloadPlugin(mysql);
            }

            @Override
            public ScheduledExecutorService getScheduler() {
                return VotingPluginBungee.this.timer;
            }

            @Override
            public MysqlConfig getVoteCacheMySQLConfig() {
                return new MysqlConfigBungee(VotingPluginBungee.this.config.getData().getSection("VoteCache"));
            }
        };
        try {
            Class.forName("com.vexsoftware.votifier.bungee.events.VotifierEvent");
        }
        catch (ClassNotFoundException e) {
            this.getVotingPluginProxy().setVotifierEnabled(false);
        }
        if (this.getVotingPluginProxy().isVotifierEnabled()) {
            try {
                this.voteEventBungee = new VoteEventBungee(this);
                this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)this.voteEventBungee);
            }
            catch (Exception e) {
                this.getVotingPluginProxy().setVotifierEnabled(false);
            }
        }
        boolean mysqlLoaded = true;
        try {
            if (!this.config.getData().getString("Host", "").isEmpty()) {
                this.loadMysql();
            } else {
                mysqlLoaded = false;
                this.getLogger().severe("MySQL settings not set in bungeeconfig.yml");
            }
        }
        catch (Exception e) {
            mysqlLoaded = false;
            e.printStackTrace();
        }
        this.getProxy().registerChannel(this.getConfig().getPluginMessageChannel());
        if (mysqlLoaded) {
            this.voteCacheFile = new VoteCache(this);
            this.nonVotedPlayersCache = new NonVotedPlayersCache(this);
            this.getVotingPluginProxy().load(this.voteCacheFile);
            this.getProxy().getScheduler().schedule((Plugin)this, new Runnable(){

                @Override
                public void run() {
                    for (String server : VotingPluginBungee.this.getVotingPluginProxy().getVoteCacheHandler().getCachedVotesServers()) {
                        VotingPluginBungee.this.getVotingPluginProxy().checkCachedVotes(server);
                    }
                    for (ProxiedPlayer player : VotingPluginBungee.this.getProxy().getPlayers()) {
                        VotingPluginBungee.this.getVotingPluginProxy().checkOnlineVotes(player.getName(), player.getUniqueId().toString(), null);
                    }
                }
            }, 120L, 60L, TimeUnit.SECONDS);
            this.getProxy().getScheduler().schedule((Plugin)this, new Runnable(){

                @Override
                public void run() {
                    if (VotingPluginBungee.this.nonVotedPlayersCache != null) {
                        VotingPluginBungee.this.debug("Checking nonvotedplayers.yml...");
                        VotingPluginBungee.this.nonVotedPlayersCache.check();
                    }
                    if (VotingPluginBungee.this.voteCacheFile != null) {
                        VotingPluginBungee.this.voteCacheFile.save();
                    }
                }
            }, 1L, 60L, TimeUnit.MINUTES);
        }
        if (!(this.getVotingPluginProxy().isVotifierEnabled() || this.getConfig().getMultiProxySupport() && !this.getConfig().getPrimaryServer())) {
            this.getLogger().warning("Votifier event not found, not loading votifier event");
        }
        BStatsMetricsBungee metrics = new BStatsMetricsBungee(this, 9453);
        metrics.addCustomChart(new BStatsMetricsBungee.SimplePie("bungee_method", () -> this.getConfig().getBungeeMethod().toString()));
        metrics.addCustomChart(new BStatsMetricsBungee.SimplePie("sendtoallservers", () -> "" + this.getConfig().getSendVotesToAllServers()));
        metrics.addCustomChart(new BStatsMetricsBungee.SimplePie("allowunjoined", () -> "" + this.getConfig().getAllowUnJoined()));
        metrics.addCustomChart(new BStatsMetricsBungee.SimplePie("pointsonvote", () -> "" + this.getConfig().getPointsOnVote()));
        metrics.addCustomChart(new BStatsMetricsBungee.SimplePie("bungeemanagetotals", () -> "" + this.getConfig().getBungeeManageTotals()));
        metrics.addCustomChart(new BStatsMetricsBungee.SimplePie("waitforuseronline", () -> "" + this.getConfig().getWaitForUserOnline()));
        metrics.addCustomChart(new BStatsMetricsBungee.SimplePie("globaldata_enabled", () -> "" + this.getConfig().getGlobalDataEnabled()));
        if (this.getConfig().getGlobalDataEnabled()) {
            metrics.addCustomChart(new BStatsMetricsBungee.SimplePie("globaldata_usemainmysql", () -> "" + this.getConfig().getGlobalDataUseMainMySQL()));
        }
        metrics.addCustomChart(new BStatsMetricsBungee.SimplePie("multi_proxy_support_enabled", () -> "" + this.getConfig().getMultiProxySupport()));
        if (!this.buildNumber.equals("NOTSET")) {
            metrics.addCustomChart(new BStatsMetricsBungee.SimplePie("dev_build_number", () -> "" + this.buildNumber));
        }
        this.loadVersionFile();
        this.getLogger().info("VotingPlugin loaded, using method: " + this.getVotingPluginProxy().getMethod().toString() + ", PluginMessagingVersion: " + BungeeVersion.getPluginMessageVersion());
        if (!this.buildNumber.equals("NOTSET")) {
            this.getLogger().info("Detected using dev build number: " + this.buildNumber);
        }
        this.getVotingPluginProxy().sendServerNameMessage();
    }

    @EventHandler
    public void onPluginMessage(PluginMessageEvent ev) {
        if (!ev.getTag().equals(this.getConfig().getPluginMessageChannel().toLowerCase())) {
            return;
        }
        ev.setCancelled(true);
        if (!(ev.getSender() instanceof Server)) {
            this.debug("Ignore plugin message");
            return;
        }
        ByteArrayInputStream instream = new ByteArrayInputStream(ev.getData());
        DataInputStream in = new DataInputStream(instream);
        try {
            this.getVotingPluginProxy().onPluginMessageReceived(in);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void reloadPlugin(boolean loadMysql) {
        this.config.load();
        if (loadMysql) {
            try {
                if (!this.config.getData().getString("Host", "").isEmpty()) {
                    this.loadMysql();
                } else {
                    this.getLogger().severe("MySQL settings not set in bungeeconfig.yml");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.getVotingPluginProxy().reload();
    }

    private void runAsyncNow(Runnable runnable) {
        this.getProxy().getScheduler().runAsync((Plugin)this, runnable);
    }

    @Generated
    public Config getConfig() {
        return this.config;
    }

    @Generated
    public VotingPluginProxy getVotingPluginProxy() {
        return this.votingPluginProxy;
    }

    @Generated
    public ScheduledExecutorService getTimer() {
        return this.timer;
    }
}

