/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.proxy.bungee;

import com.bencodez.votingplugin.proxy.OfflineBungeeVote;
import com.bencodez.votingplugin.proxy.bungee.VotingPluginBungee;
import com.bencodez.votingplugin.proxy.cache.DataNode;
import com.bencodez.votingplugin.proxy.cache.GsonDataNode;
import com.bencodez.votingplugin.proxy.cache.IVoteCache;
import com.bencodez.votingplugin.simpleapi.file.BungeeJsonFile;
import com.bencodez.votingplugin.timequeue.VoteTimeQueue;
import java.io.File;
import java.util.Collection;

public class VoteCache
extends BungeeJsonFile
implements IVoteCache {
    private VotingPluginBungee bungee;

    public VoteCache(VotingPluginBungee bungee) {
        super(new File(bungee.getDataFolder(), "votecache.json"));
        this.bungee = bungee;
        this.initialize();
    }

    private void initialize() {
        if (!this.bungee.getDataFolder().exists()) {
            this.bungee.getDataFolder().mkdir();
        }
        this.reload();
    }

    @Override
    public void addTimedVote(int num, VoteTimeQueue voteTimedQueue) {
        String path = "TimedVoteCache." + num;
        this.setString(path + ".Name", voteTimedQueue.getName());
        this.setString(path + ".Service", voteTimedQueue.getService());
        this.setLong(path + ".Time", voteTimedQueue.getTime());
    }

    @Override
    public void addVote(String server, int num, OfflineBungeeVote voteData) {
        String path = "VoteCache." + server + "." + num;
        this.setString(path + ".Name", voteData.getPlayerName());
        this.setString(path + ".Service", voteData.getService());
        this.setString(path + ".UUID", voteData.getUuid());
        this.setLong(path + ".Time", voteData.getTime());
        this.setBoolean(path + ".Real", voteData.isRealVote());
        this.setString(path + ".Text", voteData.getText());
    }

    @Override
    public void addVoteOnline(String player, int num, OfflineBungeeVote voteData) {
        String path = "OnlineCache." + player + "." + num;
        this.setString(path + ".Name", voteData.getPlayerName());
        this.setString(path + ".Service", voteData.getService());
        this.setString(path + ".UUID", voteData.getUuid());
        this.setLong(path + ".Time", voteData.getTime());
        this.setBoolean(path + ".Real", voteData.isRealVote());
        this.setString(path + ".Text", voteData.getText());
    }

    @Override
    public void clearData() {
        this.setString("VoteCache", null);
        this.setString("OnlineCache", null);
        this.setString("TimedVoteCache", null);
        this.save();
    }

    @Override
    public Collection<String> getOnlineVotes(String name) {
        return this.getKeys("OnlineCache." + name);
    }

    @Override
    public GsonDataNode getOnlineVotes(String name, String num) {
        return new GsonDataNode(this.getNode("OnlineCache." + name + "." + num));
    }

    @Override
    public Collection<String> getPlayers() {
        return this.getKeys("OnlineCache");
    }

    @Override
    public Collection<String> getServers() {
        return this.getKeys("VoteCache");
    }

    @Override
    public Collection<String> getServerVotes(String server) {
        return this.getKeys("VoteCache." + server);
    }

    @Override
    public GsonDataNode getServerVotes(String server, String num) {
        return new GsonDataNode(this.getNode("VoteCache." + server + "." + num));
    }

    @Override
    public Collection<String> getTimedVoteCache() {
        return this.getKeys("TimedVoteCache");
    }

    @Override
    public DataNode getTimedVoteCache(String key) {
        return new GsonDataNode(this.getNode("TimedVoteCache." + key));
    }

    @Override
    public int getVotePartyCache(String server) {
        return this.getInt("VoteParty.Cache." + server, 0);
    }

    @Override
    public int getVotePartyCurrentVotes() {
        return this.getInt("VoteParty.CurrentVotes", 0);
    }

    @Override
    public int getVotePartyInreaseVotesRequired() {
        return this.getInt("VoteParty.IncreaseVotes", 0);
    }

    @Override
    public void setVotePartyCache(String server, int amount) {
        this.setInt("VoteParty.Cache." + server, amount);
    }

    @Override
    public void setVotePartyCurrentVotes(int amount) {
        this.setInt("VoteParty.CurrentVotes", amount);
    }

    @Override
    public void setVotePartyInreaseVotesRequired(int amount) {
        this.setInt("VoteParty.IncreaseVotes", amount);
    }

    @Override
    public void save() {
        super.save();
    }

    @Override
    public void reload() {
        super.reload();
    }

    @Override
    public void removeOnlineVotes(String player) {
        this.setString("OnlineCache." + player, null);
    }

    @Override
    public void removeServerVotes(String server) {
        this.setString("VoteCache." + server, null);
    }

    @Override
    public void removeServerVote(String server, String uuid) {
        Collection<String> votes = this.getServerVotes(server);
        if (votes == null) {
            return;
        }
        for (String num : votes) {
            String nodeUuid;
            DataNode uuidNode;
            GsonDataNode node = this.getServerVotes(server, num);
            if (node == null || (uuidNode = node.get("UUID")) == null || (nodeUuid = uuidNode.asString()) == null || !nodeUuid.equals(uuid)) continue;
            this.setString("VoteCache." + server + "." + num, null);
        }
    }

    @Override
    public void removeVote(String server, OfflineBungeeVote vote) {
        Collection<String> votes = this.getServerVotes(server);
        if (votes == null) {
            return;
        }
        for (String num : votes) {
            GsonDataNode node = this.getServerVotes(server, num);
            if (node == null) continue;
            DataNode uuidNode = node.get("UUID");
            DataNode serviceNode = node.get("Service");
            DataNode timeNode = node.get("Time");
            if (uuidNode == null || serviceNode == null || timeNode == null) continue;
            String nodeUuid = uuidNode.asString();
            String nodeService = serviceNode.asString();
            Long nodeTime = timeNode.asLong();
            if (nodeUuid == null || nodeService == null || nodeTime == null || !nodeUuid.equals(vote.getUuid()) || !nodeService.equals(vote.getService()) || nodeTime.longValue() != vote.getTime()) continue;
            this.setString("VoteCache." + server + "." + num, null);
        }
    }

    @Override
    public void removeOnlineVote(OfflineBungeeVote vote) {
        Collection<String> players = this.getPlayers();
        if (players == null) {
            return;
        }
        for (String player : players) {
            Collection<String> onlineVotes = this.getOnlineVotes(player);
            if (onlineVotes == null) continue;
            for (String num : onlineVotes) {
                GsonDataNode node = this.getOnlineVotes(player, num);
                if (node == null) continue;
                DataNode uuidNode = node.get("UUID");
                DataNode serviceNode = node.get("Service");
                DataNode timeNode = node.get("Time");
                if (uuidNode == null || serviceNode == null || timeNode == null) continue;
                String nodeUuid = uuidNode.asString();
                String nodeService = serviceNode.asString();
                Long nodeTime = timeNode.asLong();
                if (nodeUuid == null || nodeService == null || nodeTime == null || !nodeUuid.equals(vote.getUuid()) || !nodeService.equals(vote.getService()) || nodeTime.longValue() != vote.getTime()) continue;
                this.setString("OnlineCache." + player + "." + num, null);
            }
        }
    }
}

