/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.proxy.bungee;

import com.bencodez.votingplugin.proxy.bungee.VotingPluginBungee;
import com.bencodez.votingplugin.simpleapi.file.BungeeJsonFile;
import com.velocitypowered.api.proxy.Player;
import java.io.File;
import lombok.Generated;
import net.md_5.bungee.config.Configuration;

public class NonVotedPlayersCache
extends BungeeJsonFile {
    private VotingPluginBungee plugin;
    private Configuration data;

    public NonVotedPlayersCache(VotingPluginBungee plugin) {
        super(new File(plugin.getDataFolder(), "nonvotedplayerscache.json"));
        this.plugin = plugin;
    }

    public void addPlayer(Player player) {
        if (!this.plugin.getVotingPluginProxy().getProxyMySQL().containsKeyQuery(player.getUniqueId().toString())) {
            this.addPlayer(player.getUniqueId().toString(), player.getUsername());
        }
    }

    public void addPlayer(String uuid, String playerName) {
        this.setString("NonVotedPlayers." + playerName + ".UUID", uuid);
        this.setLong("NonVotedPlayers." + playerName + ".LastTime", System.currentTimeMillis());
        this.save();
    }

    public void addPlayerCheck(String uuid, String playerName) {
        if (!this.plugin.getVotingPluginProxy().getProxyMySQL().containsKeyQuery(uuid)) {
            this.addPlayer(uuid, playerName);
        }
    }

    public void check() {
        for (String player : this.getKeys("NonVotedPlayers")) {
            long time = this.getLong("NonVotedPlayers." + player + ".LastTime", 0L);
            if (System.currentTimeMillis() - time > 432000000L) {
                this.removePlayer(player);
                continue;
            }
            String uuid = this.getString("NonVotedPlayers." + player + ".UUID", "");
            if (!uuid.isEmpty()) {
                if (!this.plugin.getVotingPluginProxy().getProxyMySQL().containsKeyQuery(uuid)) continue;
                this.removePlayer(player);
                continue;
            }
            this.removePlayer(player);
        }
        this.save();
    }

    public String playerExists(String playerName) {
        String uuid = this.getString("NonVotedPlayers." + playerName + ".UUID", "");
        if (!uuid.isEmpty()) {
            return uuid;
        }
        return "";
    }

    private void removePlayer(String player) {
        this.plugin.debug("Removing nonvotedplayer: " + player);
        this.remove("NonVotedPlayers." + player);
        this.save();
    }

    @Generated
    public Configuration getData() {
        return this.data;
    }
}

