/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.proxy.bungee;

import com.bencodez.votingplugin.proxy.VotingPluginProxyConfig;
import com.bencodez.votingplugin.proxy.bungee.VotingPluginBungee;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class Config
implements VotingPluginProxyConfig {
    private VotingPluginBungee bungee;
    private Configuration data;

    public Config(VotingPluginBungee bungee) {
        this.bungee = bungee;
    }

    public Map<String, Object> configToMap(Configuration config) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (config != null) {
            config.getKeys().forEach(key -> map.put((String)key, config.get(key)));
        }
        return map;
    }

    @Override
    public boolean getAllowUnJoined() {
        return this.getData().getBoolean("AllowUnJoined", false);
    }

    @Override
    public String getBedrockPlayerPrefix() {
        return this.getData().getString("BedrockPlayerPrefix", ".");
    }

    @Override
    public List<String> getBlockedServers() {
        return this.getData().getStringList("BlockedServers");
    }

    @Override
    public boolean getBroadcast() {
        return this.getData().getBoolean("Broadcast", false);
    }

    @Override
    public String getBungeeHost() {
        return this.getData().getString("BungeeServer.Host", "");
    }

    @Override
    public boolean getBungeeManageTotals() {
        return this.getData().getBoolean("BungeeManageTotals", true);
    }

    @Override
    public String getBungeeMethod() {
        return this.getData().getString("BungeeMethod", "SOCKETS");
    }

    @Override
    public int getBungeePort() {
        return this.getData().getInt("BungeeServer.Port", 1297);
    }

    @Override
    public boolean getDebug() {
        return this.getData().getBoolean("Debug", false);
    }

    @Override
    public String getFallBack() {
        return this.getData().getString("FallBackServer", "");
    }

    @Override
    public boolean getGlobalDataEnabled() {
        return this.getData().getBoolean("GlobalData.Enabled", false);
    }

    @Override
    public boolean getGlobalDataUseMainMySQL() {
        return this.getData().getBoolean("GlobalData.UseMainMySQL", true);
    }

    @Override
    public int getLimitVotePoints() {
        return this.getData().getInt("LimitVotePoints", -1);
    }

    @Override
    public int getMaxAmountOfVotesPerDay() {
        return this.getData().getInt("MaxAmountOfVotesPerDay", -1);
    }

    @Override
    public String getMultiProxyMethod() {
        return this.getData().getString("MultiProxyMethod", "SOCKET");
    }

    @Override
    public boolean getMultiProxyOneGlobalReward() {
        return this.getData().getBoolean("MultiProxyOneGlobalReward", false);
    }

    @Override
    public String getMultiProxyRedisHost() {
        return this.getData().getString("MultiProxyRedis.Host", "");
    }

    @Override
    public String getMultiProxyRedisPassword() {
        return this.getData().getString("MultiProxyRedis.Password", "");
    }

    @Override
    public int getMultiProxyRedisPort() {
        return this.getData().getInt("MultiProxyRedis.Port", 6379);
    }

    @Override
    public boolean getMultiProxyRedisUseExistingConnection() {
        return this.getData().getBoolean("MultiProxyRedis.UseExistingConnection", false);
    }

    @Override
    public String getMultiProxyRedisUsername() {
        return this.getData().getString("MultiProxyRedis.Username", "");
    }

    @Override
    public Collection<String> getMultiProxyServers() {
        return this.getData().getSection("MultiProxyServers").getKeys();
    }

    @Override
    public Map<String, Object> getMultiProxyServersConfiguration(String s) {
        return this.configToMap(this.getData().getSection("MultiProxyServers." + s));
    }

    @Override
    public String getMultiProxySocketHostHost() {
        return this.getData().getString("MultiProxySocketHost.Host", "");
    }

    @Override
    public int getMultiProxySocketHostPort() {
        return this.getData().getInt("MultiProxySocketHost.Port", 1297);
    }

    @Override
    public boolean getMultiProxySupport() {
        return this.getData().getBoolean("MultiProxySupport", false);
    }

    @Override
    public boolean getOnlineMode() {
        return this.getData().getBoolean("OnlineMode", true);
    }

    @Override
    public int getPointsOnVote() {
        return this.getData().getInt("PointsOnVote", 1);
    }

    @Override
    public boolean getPrimaryServer() {
        return this.getData().getBoolean("PrimaryServer", false);
    }

    @Override
    public String getProxyServerName() {
        return this.getData().getString("ProxyServerName", "SOCKET");
    }

    @Override
    public List<String> getProxyServers() {
        return this.getData().getStringList("ProxyServers");
    }

    @Override
    public String getRedisHost() {
        return this.getData().getString("Redis.Host", "");
    }

    @Override
    public String getRedisPassword() {
        return this.getData().getString("Redis.Password", "");
    }

    @Override
    public int getRedisPort() {
        return this.getData().getInt("Redis.Port", 6379);
    }

    @Override
    public String getRedisPrefix() {
        return this.getData().getString("Redis.Prefix", "");
    }

    @Override
    public String getRedisUsername() {
        return this.getData().getString("Redis.Username", "");
    }

    @Override
    public boolean getSendVotesToAllServers() {
        return this.getData().getBoolean("SendVotesToAllServers");
    }

    @Override
    public Map<String, Object> getSpigotServerConfiguration(String s) {
        return this.configToMap(this.getData().getSection("SpigotServers." + s));
    }

    @Override
    public Collection<String> getSpigotServers() {
        return this.getData().getSection("SpigotServers").getKeys();
    }

    @Override
    public boolean getStoreMonthTotalsWithDate() {
        return this.getData().getBoolean("StoreMonthTotalsWithDate", false);
    }

    @Override
    public boolean getTimeChangeFailSafeBypass() {
        return this.getData().getBoolean("TimeChangeFailSafeBypass", false);
    }

    @Override
    public int getTimeHourOffSet() {
        return this.getData().getInt("TimeHourOffSet");
    }

    @Override
    public String getTimeZone() {
        return this.getData().getString("TimeZone", "");
    }

    @Override
    public boolean getUseMonthDateTotalsAsPrimaryTotal() {
        return this.getData().getBoolean("UseMonthDateTotalsAsPrimaryTotal", false);
    }

    @Override
    public boolean getUUIDLookup() {
        return this.getData().getBoolean("UUIDLookup", true);
    }

    @Override
    public int getVoteCacheTime() {
        return this.getData().getInt("VoteCacheTime", -1);
    }

    @Override
    public String getVotePartyBroadcast() {
        return this.getData().getString("VoteParty.Broadcast", "");
    }

    @Override
    public List<String> getVotePartyBungeeCommands() {
        return this.getData().getStringList("VoteParty.BungeeCommands");
    }

    @Override
    public boolean getVotePartyEnabled() {
        return this.getData().getBoolean("VoteParty.Enabled", false);
    }

    @Override
    public int getVotePartyIncreaseVotesRequired() {
        return this.getData().getInt("VoteParty.IncreaseVotesRequired", 0);
    }

    @Override
    public boolean getVotePartySendToAllServers() {
        return this.getData().getBoolean("VoteParty.SendToAllServers", true);
    }

    @Override
    public List<String> getVotePartyServersToSend() {
        return this.getData().getStringList("VoteParty.ServersToSend");
    }

    @Override
    public int getVotePartyVotesRequired() {
        return this.getData().getInt("VoteParty.VotesRequired", 100);
    }

    @Override
    public boolean getWaitForUserOnline() {
        return this.getData().getBoolean("WaitForUserOnline", true);
    }

    @Override
    public List<String> getWhiteListedServers() {
        return this.getData().getStringList("WhiteListedServers");
    }

    @Override
    public String getMqttClientID() {
        return this.getData().getString("MQTT.ClientID", "proxy");
    }

    @Override
    public String getMqttBrokerURL() {
        return this.getData().getString("MQTT.BrokerURL", "tcp://localhost:1883");
    }

    @Override
    public String getMqttUsername() {
        return this.getData().getString("MQTT.Username", "");
    }

    @Override
    public String getMqttPassword() {
        return this.getData().getString("MQTT.Password", "");
    }

    @Override
    public String getMqttPrefix() {
        return this.getData().getString("MQTT.Prefix", "");
    }

    @Override
    public void load() {
        File file;
        if (!this.bungee.getDataFolder().exists()) {
            this.bungee.getDataFolder().mkdir();
        }
        if (!(file = new File(this.bungee.getDataFolder(), "bungeeconfig.yml")).exists()) {
            try (InputStream in = this.bungee.getResourceAsStream("bungeeconfig.yml");){
                Files.copy(in, file.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            this.data = ConfigurationProvider.getProvider(YamlConfiguration.class).load(new File(this.bungee.getDataFolder(), "bungeeconfig.yml"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void save() {
        try {
            ConfigurationProvider.getProvider(YamlConfiguration.class).save(this.data, new File(this.bungee.getDataFolder(), "bungeeconfig.yml"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getPluginMessageChannel() {
        return this.getData().getString("PluginMessageChannel", "vp:vp");
    }

    @Override
    public boolean getPluginMessageEncryption() {
        return this.getData().getBoolean("PluginMessageEncryption", false);
    }

    @Override
    public Collection<String> getWaitUntilVoteDelaySites() {
        return this.getData().getSection("WaitUntilVoteDelay").getKeys();
    }

    @Override
    public String getWaitUntilVoteDelayService(String site) {
        return this.getData().getString("WaitUntilVoteDelay." + site + ".ServiceSite", "");
    }

    @Override
    public int getWaitUntilVoteDelayVoteDelay(String site) {
        return this.getData().getInt("WaitUntilVoteDelay." + site + ".VoteDelay", 24);
    }

    @Override
    public boolean getWaitUntilVoteDelayVoteDelayDaily(String site) {
        return this.getData().getBoolean("WaitUntilVoteDelay." + site + ".VoteDelayDaily", false);
    }

    @Override
    public int getWaitUntilVoteDelayVoteDelayHour(String site) {
        return this.getData().getInt("WaitUntilVoteDelay." + site + ".VoteDelayDailyHour", 0);
    }

    @Override
    public int getWaitUntilVoteDelayVoteDelayMin(String site) {
        return this.getData().getInt("WaitUntilVoteDelay." + site + ".VoteDelayMin", 0);
    }

    @Override
    public boolean getResetMilestonesMonthly() {
        return this.getData().getBoolean("ResetMilestonesMonthly", false);
    }

    @Override
    public boolean getVoteCacheUseMySQL() {
        return this.getData().getBoolean("VoteCache.UseMySQL", false);
    }

    @Override
    public boolean getVoteCacheUseMainMySQL() {
        return this.getData().getBoolean("VoteCache.UseMainMySQL", true);
    }

    @Override
    public int getTimeWeekOffSet() {
        return this.getData().getInt("TimeWeekOffSet");
    }

    @Generated
    public Configuration getData() {
        return this.data;
    }
}

