/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.proxy;

import com.bencodez.votingplugin.advancedcore.api.time.TimeType;
import com.bencodez.votingplugin.proxy.BungeeMethod;
import com.bencodez.votingplugin.proxy.VotingPluginProxy;

public class VotingPluginProxyCommand {
    private VotingPluginProxy plugin;

    public VotingPluginProxyCommand(VotingPluginProxy plugin) {
        this.plugin = plugin;
    }

    public String execute(String[] args) {
        if (args.length == 0) {
            return "&cPlease provide a valid command. Use 'help' to view all commands.";
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                this.plugin.reloadCore(false);
                return "&aReloading VotingPlugin";
            }
            case "reloadmysql": {
                this.plugin.reloadCore(true);
                return "&aReloading VotingPlugin including MySQL";
            }
            case "vote": {
                if (args.length >= 3) {
                    String user = args[1];
                    String site = args[2];
                    this.plugin.vote(user, site, false, true, 0L, null, null);
                    return "&aVote sent for " + user + " on " + site;
                }
                return "&cUsage: vote <player> <site>";
            }
            case "forcetimechange": {
                if (args.length >= 2) {
                    this.plugin.getBungeeTimeChecker().forceChanged(TimeType.getTimeType(args[1]));
                    return "&aTriggered time change to " + args[1];
                }
                return "&cUsage: forcetimechange <TimeType>";
            }
            case "status": {
                return this.handleStatusCommand();
            }
            case "multiproxystatus": {
                this.plugin.getMultiProxyHandler().sendMultiProxyServerMessage("Status");
                return "&aSent status message across multi-proxy";
            }
            case "help": {
                return this.getHelpMessage();
            }
            case "voteparty": {
                return this.handleVotePartyCommand(args);
            }
        }
        return "&cUnknown command. Use 'help' to view all commands.";
    }

    private String handleStatusCommand() {
        BungeeMethod method = this.plugin.getMethod();
        switch (method) {
            case SOCKETS: {
                this.plugin.status();
                return "&aChecking status via sockets. Check console for details.";
            }
            case PLUGINMESSAGING: 
            case MYSQL: 
            case REDIS: {
                this.plugin.status();
                this.plugin.sendServerNameMessage();
                return "&aChecking status with method: " + method.toString().toLowerCase();
            }
        }
        return "&cStatus command unavailable for the current connection method.";
    }

    private String handleVotePartyCommand(String[] args) {
        if (args.length > 1) {
            if ("force".equalsIgnoreCase(args[1])) {
                this.plugin.setCurrentVotePartyVotes(this.plugin.getCurrentVotePartyVotesRequired());
                this.plugin.checkVoteParty();
                return "&aVote party forced";
            }
            if ("setvotecount".equalsIgnoreCase(args[1]) && args.length > 2 && this.isInt(args[2])) {
                this.plugin.setCurrentVotePartyVotes(Integer.parseInt(args[2]));
                return "&aSet current vote party votes to " + args[2];
            }
            return "&cInvalid usage. Use 'help' for correct syntax.";
        }
        return "&cUsage: voteparty <force/setvotecount>";
    }

    private String getHelpMessage() {
        StringBuilder helpBuilder = new StringBuilder("&aVotingPlugin Commands:\n");
        helpBuilder.append("/votingplugin reload - Reload the plugin\n");
        helpBuilder.append("/votingplugin reloadmysql - Reload the plugin including MySQL\n");
        helpBuilder.append("/votingplugin vote <player> <site> - Send a vote\n");
        helpBuilder.append("/votingplugin forcetimechange <TimeType> - Force a time change\n");
        helpBuilder.append("/votingplugin status - Check connection status\n");
        helpBuilder.append("/votingplugin multiproxystatus - Send status message across proxies\n");
        helpBuilder.append("/votingplugin voteparty <force/setvotecount> - Trigger or modify vote party\n");
        return helpBuilder.toString();
    }

    private boolean isInt(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

