/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.proxy;

import com.bencodez.votingplugin.advancedcore.api.time.TimeType;
import com.bencodez.votingplugin.advancedcore.bungeeapi.globaldata.GlobalDataHandlerProxy;
import com.bencodez.votingplugin.advancedcore.bungeeapi.time.BungeeTimeChecker;
import com.bencodez.votingplugin.proxy.BungeeMessageData;
import com.bencodez.votingplugin.proxy.BungeeMethod;
import com.bencodez.votingplugin.proxy.BungeeVersion;
import com.bencodez.votingplugin.proxy.OfflineBungeeVote;
import com.bencodez.votingplugin.proxy.ProxyMysqlUserTable;
import com.bencodez.votingplugin.proxy.VotingPluginProxyConfig;
import com.bencodez.votingplugin.proxy.cache.IVoteCache;
import com.bencodez.votingplugin.proxy.cache.VoteCacheHandler;
import com.bencodez.votingplugin.proxy.multiproxy.MultiProxyHandler;
import com.bencodez.votingplugin.proxy.multiproxy.MultiProxyMethod;
import com.bencodez.votingplugin.proxy.multiproxy.MultiProxyServerSocketConfiguration;
import com.bencodez.votingplugin.proxy.multiproxy.MultiProxyServerSocketConfigurationBungee;
import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import com.bencodez.votingplugin.simpleapi.encryption.EncryptionHandler;
import com.bencodez.votingplugin.simpleapi.json.JsonParser;
import com.bencodez.votingplugin.simpleapi.servercomm.global.GlobalMessageListener;
import com.bencodez.votingplugin.simpleapi.servercomm.global.GlobalMessageProxyHandler;
import com.bencodez.votingplugin.simpleapi.servercomm.mqtt.MqttHandler;
import com.bencodez.votingplugin.simpleapi.servercomm.mqtt.MqttServerComm;
import com.bencodez.votingplugin.simpleapi.servercomm.mysql.ProxyMessenger;
import com.bencodez.votingplugin.simpleapi.servercomm.redis.RedisHandler;
import com.bencodez.votingplugin.simpleapi.servercomm.redis.RedisListener;
import com.bencodez.votingplugin.simpleapi.servercomm.sockets.ClientHandler;
import com.bencodez.votingplugin.simpleapi.servercomm.sockets.SocketHandler;
import com.bencodez.votingplugin.simpleapi.servercomm.sockets.SocketReceiver;
import com.bencodez.votingplugin.simpleapi.sql.Column;
import com.bencodez.votingplugin.simpleapi.sql.data.DataValue;
import com.bencodez.votingplugin.simpleapi.sql.data.DataValueBoolean;
import com.bencodez.votingplugin.simpleapi.sql.data.DataValueInt;
import com.bencodez.votingplugin.simpleapi.sql.data.DataValueString;
import com.bencodez.votingplugin.simpleapi.sql.mysql.config.MysqlConfig;
import com.bencodez.votingplugin.timequeue.VoteTimeQueue;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import lombok.Generated;
import org.eclipse.paho.client.mqttv3.MqttException;

public abstract class VotingPluginProxy {
    private int votePartyVotes = 0;
    private int currentVotePartyVotesRequired = 0;
    private ProxyMysqlUserTable proxyMySQL;
    private EncryptionHandler encryptionHandler;
    private HashMap<String, ClientHandler> clientHandles;
    private SocketHandler socketHandler;
    private boolean votifierEnabled = true;
    private ConcurrentHashMap<UUID, String> uuidPlayerNameCache = new ConcurrentHashMap();
    private GlobalDataHandlerProxy globalDataHandler;
    private RedisHandler redisHandler;
    private boolean enabled = true;
    private MultiProxyHandler multiProxyHandler;
    private BungeeTimeChecker bungeeTimeChecker = new BungeeTimeChecker(this.getConfig().getTimeZone(), this.getConfig().getTimeHourOffSet(), this.getConfig().getTimeWeekOffSet()){

        @Override
        public void debug(String text) {
            VotingPluginProxy.this.debug2(text);
        }

        @Override
        public long getLastUpdated() {
            return VotingPluginProxy.this.getVoteCacheLastUpdated();
        }

        @Override
        public int getPrevDay() {
            return VotingPluginProxy.this.getVoteCachePrevDay();
        }

        @Override
        public String getPrevMonth() {
            return VotingPluginProxy.this.getVoteCachePrevMonth();
        }

        @Override
        public int getPrevWeek() {
            return VotingPluginProxy.this.getVoteCachePrevWeek();
        }

        @Override
        public void info(String text) {
            VotingPluginProxy.this.log(text);
        }

        @Override
        public boolean isEnabled() {
            return VotingPluginProxy.this.enabled;
        }

        @Override
        public boolean isIgnoreTime() {
            return VotingPluginProxy.this.isVoteCacheIgnoreTime();
        }

        @Override
        public void setIgnoreTime(boolean ignore) {
            VotingPluginProxy.this.setVoteCacheVoteCacheIgnoreTime(ignore);
        }

        @Override
        public void setLastUpdated() {
            VotingPluginProxy.this.setVoteCacheLastUpdated();
        }

        @Override
        public void setPrevDay(int day) {
            VotingPluginProxy.this.setVoteCachePrevDay(day);
        }

        @Override
        public void setPrevMonth(String text) {
            VotingPluginProxy.this.setVoteCachePrevMonth(text);
        }

        @Override
        public void setPrevWeek(int week) {
            VotingPluginProxy.this.setVoteCachePrevWeek(week);
        }

        @Override
        public void timeChanged(TimeType type, boolean fake, boolean pre, boolean post) {
            if (type.equals((Object)TimeType.MONTH) && VotingPluginProxy.this.getConfig().getResetMilestonesMonthly()) {
                this.debug("Resetting milestones for month change");
                VotingPluginProxy.this.getVoteCacheHandler().resetMilestoneCountInVotes();
            }
            if (VotingPluginProxy.this.getConfig().getVoteCacheTime() > 0) {
                VotingPluginProxy.this.getVoteCacheHandler().checkVoteCacheTime(VotingPluginProxy.this.getConfig().getVoteCacheTime());
            }
            if (!VotingPluginProxy.this.getConfig().getGlobalDataEnabled()) {
                VotingPluginProxy.this.warn("Global data not enabled, ignoring time change event");
                return;
            }
            int delay = 1;
            for (String s : VotingPluginProxy.this.getAllAvailableServers()) {
                if (VotingPluginProxy.this.getGlobalDataHandler().getGlobalMysql().containsKey(s)) {
                    String lastOnlineStr = VotingPluginProxy.this.getGlobalDataHandler().getString(s, "LastOnline");
                    long lastOnline = 0L;
                    try {
                        lastOnline = Long.valueOf(lastOnlineStr);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (LocalDateTime.now().atZone(ZoneOffset.UTC).toInstant().toEpochMilli() - lastOnline < 43200000L) {
                        HashMap<String, DataValue> dataToSet = new HashMap<String, DataValue>();
                        dataToSet.put("LastUpdated", new DataValueString("" + LocalDateTime.now().atZone(ZoneOffset.UTC).toInstant().toEpochMilli()));
                        dataToSet.put("FinishedProcessing", new DataValueBoolean(false));
                        dataToSet.put(type.toString(), new DataValueBoolean(true));
                        VotingPluginProxy.this.getGlobalDataHandler().setData(s, dataToSet);
                        VotingPluginProxy.this.globalMessageProxyHandler.sendMessage(s, delay, "BungeeTimeChange", "");
                        ++delay;
                        continue;
                    }
                    VotingPluginProxy.this.warn("Server " + s + " hasn't been online recently");
                    continue;
                }
                VotingPluginProxy.this.warn("Server " + s + " global data handler disabled?");
            }
            VotingPluginProxy.this.globalDataHandler.onTimeChange(type);
        }

        @Override
        public void warning(String text) {
            VotingPluginProxy.this.warn(text);
        }
    };
    private BungeeMethod method;
    private MqttHandler mqttHandler;
    private GlobalMessageProxyHandler globalMessageProxyHandler;
    private ProxyMessenger proxyMysqlMessenger;
    private VoteCacheHandler voteCacheHandler;

    public void addCurrentVotePartyVotes(int amount) {
        this.votePartyVotes += amount;
        this.setVoteCacheVotePartyCurrentVotes(this.votePartyVotes);
        this.debug("Current vote party total: " + this.votePartyVotes);
    }

    public abstract void addNonVotedPlayer(String var1, String var2);

    public void addVoteParty() {
        if (this.getConfig().getVotePartyEnabled()) {
            this.addCurrentVotePartyVotes(1);
            this.checkVoteParty();
        }
    }

    public abstract void broadcast(String var1);

    public synchronized void checkCachedVotes(String server) {
        int delay = 1;
        if (this.isServerValid(server)) {
            if (this.isSomeoneOnlineServer(server)) {
                if (this.getVoteCacheHandler().hasVotes(server) && !this.getConfig().getBlockedServers().contains(server)) {
                    ArrayList<OfflineBungeeVote> c = this.getVoteCacheHandler().getVotes(server);
                    ArrayList<OfflineBungeeVote> removed = new ArrayList<OfflineBungeeVote>();
                    if (!c.isEmpty()) {
                        int num = 1;
                        int numberOfVotes = c.size();
                        for (OfflineBungeeVote cache : c) {
                            boolean toSend = true;
                            if (this.getConfig().getWaitForUserOnline()) {
                                if (!this.isPlayerOnline(cache.getPlayerName())) {
                                    toSend = false;
                                } else if (this.isPlayerOnline(cache.getPlayerName()) && !this.getCurrentPlayerServer(cache.getPlayerName()).equals(server)) {
                                    toSend = false;
                                }
                            }
                            if (toSend) {
                                this.globalMessageProxyHandler.sendMessage(server, delay, "Vote", cache.getPlayerName(), cache.getUuid(), cache.getService(), "" + cache.getTime(), Boolean.FALSE.toString(), "" + cache.isRealVote(), cache.getText(), "" + this.getConfig().getBungeeManageTotals(), "" + BungeeVersion.getPluginMessageVersion(), "" + this.getConfig().getBroadcast(), "" + num, "" + numberOfVotes);
                                ++delay;
                                ++num;
                                removed.add(cache);
                                continue;
                            }
                            this.debug("Not sending vote because user isn't on server " + server + ": " + cache.toString());
                        }
                        this.getVoteCacheHandler().removeServerVotes(server, removed);
                    } else {
                        this.debug("No cached votes for server: " + server);
                    }
                } else {
                    this.debug("No cached votes for server: " + server);
                }
            }
        } else {
            this.debug("Server not valid: " + server);
        }
    }

    public synchronized void checkOnlineVotes(String player, String uuid, String server) {
        ArrayList<OfflineBungeeVote> c;
        int delay = 1;
        if (this.isPlayerOnline(player) && this.getVoteCacheHandler().hasOnlineVotes(uuid) && !(c = this.getVoteCacheHandler().getOnlineVotes(uuid)).isEmpty()) {
            if (server == null) {
                server = this.getCurrentPlayerServer(player);
            }
            if (!this.getConfig().getBlockedServers().contains(server)) {
                int num = 1;
                int numberOfVotes = c.size();
                for (OfflineBungeeVote cache : c) {
                    this.globalMessageProxyHandler.sendMessage(server, delay, "VoteOnline", cache.getPlayerName(), cache.getUuid(), cache.getService(), "" + cache.getTime(), Boolean.FALSE.toString(), "" + cache.isRealVote(), cache.getText(), "" + this.getConfig().getBungeeManageTotals(), "" + BungeeVersion.getPluginMessageVersion(), "" + this.getConfig().getBroadcast(), "" + num, "" + numberOfVotes);
                    ++delay;
                    ++num;
                }
                this.getVoteCacheHandler().removeOnlineVotes(uuid);
                if (this.getConfig().getMultiProxySupport() && this.getConfig().getMultiProxyOneGlobalReward()) {
                    this.multiProxyHandler.sendMultiProxyServerMessage("ClearVote", player, uuid);
                }
            }
        }
    }

    public void checkVoteParty() {
        if (this.getConfig().getVotePartyEnabled()) {
            if (this.votePartyVotes >= this.currentVotePartyVotesRequired) {
                this.debug("Vote party reached");
                this.addCurrentVotePartyVotes(-this.currentVotePartyVotesRequired);
                this.currentVotePartyVotesRequired += this.getConfig().getVotePartyIncreaseVotesRequired();
                this.setVoteCacheVotePartyIncreaseVotesRequired(this.getVoteCacheVotePartyIncreaseVotesRequired() + this.getConfig().getVotePartyIncreaseVotesRequired());
                if (!this.getConfig().getVotePartyBroadcast().isEmpty()) {
                    this.broadcast(this.getConfig().getVotePartyBroadcast());
                }
                for (String command : this.getConfig().getVotePartyBungeeCommands()) {
                    this.runConsoleCommand(command);
                }
                if (this.getConfig().getVotePartySendToAllServers()) {
                    for (String server : this.getAllAvailableServers()) {
                        this.sendVoteParty(server);
                    }
                } else {
                    for (String server : this.getConfig().getVotePartyServersToSend()) {
                        this.sendVoteParty(server);
                    }
                }
            }
            this.saveVoteCacheFile();
        }
    }

    public abstract void debug(String var1);

    private void debug2(String message) {
        this.debug(message);
    }

    public UUID fetchUUID(String playerName) throws Exception {
        if (playerName == null || playerName.equalsIgnoreCase("null")) {
            return null;
        }
        URL url = new URL("https://api.mojang.com/users/profiles/minecraft/" + playerName);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.connect();
        if (connection.getResponseCode() == 400) {
            this.log("There is no player with the name \"" + playerName + "\"!");
            return null;
        }
        InputStream inputStream = connection.getInputStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        JsonElement element = JsonParser.parseReader(bufferedReader);
        JsonObject object = element.getAsJsonObject();
        String uuidAsString = object.get("id").getAsString();
        return this.parseUUIDFromString(uuidAsString);
    }

    public abstract Set<String> getAllAvailableServers();

    public abstract VotingPluginProxyConfig getConfig();

    public abstract String getCurrentPlayerServer(String var1);

    public abstract File getDataFolderPlugin();

    public String getMonthTotalsWithDatePath() {
        LocalDateTime cTime = this.getBungeeTimeChecker().getTime();
        return this.getMonthTotalsWithDatePath(cTime);
    }

    public String getMonthTotalsWithDatePath(LocalDateTime cTime) {
        return "MonthTotal-" + cTime.getMonth().toString() + "-" + cTime.getYear();
    }

    public abstract String getProperName(String var1, String var2);

    public abstract String getUUID(String var1);

    private int getValue(ArrayList<Column> cols, String column, int toAdd) {
        for (Column d : cols) {
            if (!d.getName().equalsIgnoreCase(column)) continue;
            DataValue value = d.getValue();
            int num = 0;
            if (value.isInt()) {
                num = value.getInt();
            } else if (value.isString()) {
                try {
                    num = Integer.parseInt(value.getString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return num + toAdd;
        }
        return toAdd;
    }

    public abstract String getPluginVersion();

    public abstract int getVoteCacheCurrentVotePartyVotes();

    public abstract long getVoteCacheLastUpdated();

    public abstract int getVoteCachePrevDay();

    public abstract String getVoteCachePrevMonth();

    public abstract int getVoteCachePrevWeek();

    public abstract int getVoteCacheVotePartyIncreaseVotesRequired();

    public abstract boolean isPlayerOnline(String var1);

    public abstract boolean isServerValid(String var1);

    public abstract boolean isSomeoneOnlineServer(String var1);

    public abstract boolean isVoteCacheIgnoreTime();

    public abstract MysqlConfig getVoteCacheMySQLConfig();

    public void load(IVoteCache jsonStorage) {
        this.uuidPlayerNameCache = this.getProxyMySQL().getRowsUUIDNameQuery();
        this.bungeeTimeChecker.setTimeChangeFailSafeBypass(this.getConfig().getTimeChangeFailSafeBypass());
        this.bungeeTimeChecker.loadTimer();
        this.voteCacheHandler = new VoteCacheHandler(this.getVoteCacheMySQLConfig(), this.getConfig().getVoteCacheUseMySQL(), this.getConfig().getVoteCacheUseMainMySQL(), this.getProxyMySQL().getMysql(), this.getConfig().getDebug(), jsonStorage){

            @Override
            public void logInfo1(String msg) {
                VotingPluginProxy.this.logInfo(msg);
            }

            @Override
            public void logSevere1(String msg) {
                VotingPluginProxy.this.logSevere(msg);
            }

            @Override
            public void debug1(Exception e) {
                if (VotingPluginProxy.this.getConfig().getDebug()) {
                    e.printStackTrace();
                }
            }

            @Override
            public void debug1(String msg) {
                if (VotingPluginProxy.this.getConfig().getDebug()) {
                    VotingPluginProxy.this.debug(msg);
                }
            }
        };
        this.voteCacheHandler.load();
        this.method = BungeeMethod.getByName(this.getConfig().getBungeeMethod());
        if (this.getMethod() == null) {
            this.method = BungeeMethod.PLUGINMESSAGING;
        }
        if (this.method.equals((Object)BungeeMethod.MYSQL)) {
            try {
                this.proxyMysqlMessenger = new ProxyMessenger("VotingPlugin", this.getProxyMySQL().getMysql().getConnectionManager().getDataSource(), msg -> {
                    this.debug("Got from " + msg.sourceServerId + ": " + msg.payload);
                    String[] data = msg.payload.split(Pattern.quote("%l%"));
                    this.globalMessageProxyHandler.onMessage(data[0], ArrayUtils.convertAndRemoveFirst(data));
                });
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else if (this.method.equals((Object)BungeeMethod.PLUGINMESSAGING)) {
            if (this.getConfig().getPluginMessageEncryption()) {
                this.encryptionHandler = new EncryptionHandler("VotingPlugin", new File(this.getDataFolderPlugin(), "secretkey.key"));
            }
        } else if (this.method.equals((Object)BungeeMethod.SOCKETS)) {
            this.encryptionHandler = new EncryptionHandler("VotingPlugin", new File(this.getDataFolderPlugin(), "secretkey.key"));
            this.socketHandler = new SocketHandler(this.getPluginVersion(), this.getConfig().getBungeeHost(), this.getConfig().getBungeePort(), this.encryptionHandler, this.getConfig().getDebug()){

                @Override
                public void log(String str) {
                    VotingPluginProxy.this.logInfo(str);
                }
            };
            this.socketHandler.add(new SocketReceiver(){

                @Override
                public void onReceive(String[] data) {
                    if (data.length > 1) {
                        VotingPluginProxy.this.globalMessageProxyHandler.onMessage(data[0].toLowerCase(), ArrayUtils.convertAndRemoveFirst(data));
                    }
                }
            });
            this.clientHandles = new HashMap();
            List<String> l = this.getConfig().getBlockedServers();
            for (String s : this.getConfig().getSpigotServers()) {
                if (l.contains(s)) continue;
                Map<String, Object> d = this.getConfig().getSpigotServerConfiguration(s);
                String host = "";
                if (d.containsKey("Host")) {
                    host = (String)d.get("Host");
                }
                int port = 1298;
                if (d.containsKey("Port")) {
                    port = (Integer)d.get("Port");
                }
                this.clientHandles.put(s, new ClientHandler(host, port, this.encryptionHandler, this.getConfig().getDebug()));
            }
        } else if (this.method.equals((Object)BungeeMethod.REDIS)) {
            this.redisHandler = new RedisHandler(this.getConfig().getRedisHost(), this.getConfig().getRedisPort(), this.getConfig().getRedisUsername(), this.getConfig().getRedisPassword()){

                @Override
                public void debug(String message) {
                    VotingPluginProxy.this.debug2(message);
                }

                @Override
                protected void onMessage(String channel, String[] message) {
                    if (message.length > 0 && message.length > 0) {
                        VotingPluginProxy.this.globalMessageProxyHandler.onMessage(message[0].toLowerCase(), ArrayUtils.convertAndRemoveFirst(message));
                    }
                }
            };
            this.runAsync(new Runnable(){

                @Override
                public void run() {
                    VotingPluginProxy.this.redisHandler.loadListener(new RedisListener(VotingPluginProxy.this.redisHandler, VotingPluginProxy.this.getConfig().getRedisPrefix() + "VotingPlugin"));
                }
            });
        } else if (this.method.equals((Object)BungeeMethod.MQTT)) {
            try {
                this.mqttHandler = new MqttHandler(new MqttServerComm(this.getConfig().getMqttClientID(), this.getConfig().getMqttBrokerURL(), this.getConfig().getMqttUsername(), this.getConfig().getMqttPassword()), 2);
                this.mqttHandler.subscribe(this.getConfig().getMqttPrefix() + "votingplugin/servers/proxy", new MqttHandler.MessageHandler(){

                    @Override
                    public void onMessage(String topic, String payload) {
                        VotingPluginProxy.this.debug("Received mqtt message: " + topic + " - " + payload);
                        String[] message = payload.split(":");
                        if (message.length > 0) {
                            VotingPluginProxy.this.globalMessageProxyHandler.onMessage(message[0].toLowerCase(), ArrayUtils.convertAndRemoveFirst(message));
                        }
                    }
                });
            }
            catch (MqttException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.currentVotePartyVotesRequired = this.getConfig().getVotePartyVotesRequired() + this.getVoteCacheVotePartyIncreaseVotesRequired();
        this.votePartyVotes = this.getVoteCacheCurrentVotePartyVotes();
        this.globalMessageProxyHandler = new GlobalMessageProxyHandler(){

            @Override
            public void sendMessage(String server, int delay, String channel, String ... messageData) {
                switch (VotingPluginProxy.this.method) {
                    case MQTT: {
                        VotingPluginProxy.this.sendMqttMessageServer(server, channel, messageData);
                        break;
                    }
                    case MYSQL: {
                        try {
                            VotingPluginProxy.this.proxyMysqlMessenger.sendToBackend(server, channel + "%l%" + String.join((CharSequence)"%l%", messageData));
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    case PLUGINMESSAGING: {
                        VotingPluginProxy.this.sendPluginMessageServer(server, delay, channel, messageData);
                        break;
                    }
                    case REDIS: {
                        VotingPluginProxy.this.sendRedisMessageServer(server, channel, messageData);
                        break;
                    }
                    case SOCKETS: {
                        ArrayList<String> data = new ArrayList<String>();
                        data.add(channel);
                        data.addAll(ArrayUtils.convert(messageData));
                        VotingPluginProxy.this.sendServerMessageServer(server, ArrayUtils.convert(data));
                        break;
                    }
                }
            }
        };
        this.globalMessageProxyHandler.addListener(new GlobalMessageListener("login"){

            @Override
            public void onReceive(ArrayList<String> message) {
                if (message.size() < 2) {
                    VotingPluginProxy.this.logSevere("Invalid login message received: " + message);
                    return;
                }
                String player = message.get(0);
                String uuid = message.get(1);
                String server = "";
                if (message.size() > 2) {
                    server = message.get(2);
                }
                VotingPluginProxy.this.debug("Login: " + player + "/" + uuid + " " + server);
                VotingPluginProxy.this.login(player, uuid, server);
            }
        });
        this.globalMessageProxyHandler.addListener(new GlobalMessageListener("statusokay"){

            @Override
            public void onReceive(ArrayList<String> message) {
                String server = message.get(0);
                VotingPluginProxy.this.log("Status okay for " + server);
            }
        });
        this.globalMessageProxyHandler.addListener(new GlobalMessageListener("voteupdate"){

            @Override
            public void onReceive(ArrayList<String> message) {
                int delay = 1;
                for (String send : VotingPluginProxy.this.getAllAvailableServers()) {
                    VotingPluginProxy.this.globalMessageProxyHandler.sendMessage(send, delay, "VoteUpdate", ArrayUtils.convert(message));
                    ++delay;
                }
            }
        });
        this.loadMultiProxySupport();
    }

    public void loadMultiProxySupport() {
        if (this.multiProxyHandler != null) {
            this.multiProxyHandler.close();
        }
        this.multiProxyHandler = new MultiProxyHandler(){

            @Override
            public void addNonVotedPlayerCache(String uuid, String player) {
                VotingPluginProxy.this.addNonVotedPlayer(uuid, player);
            }

            @Override
            public void clearVote(String string) {
                VotingPluginProxy.this.getVoteCacheHandler().removeOnlineVotes(string);
            }

            @Override
            public boolean getDebug() {
                return VotingPluginProxy.this.getConfig().getDebug();
            }

            @Override
            public EncryptionHandler getEncryptionHandler() {
                return VotingPluginProxy.this.encryptionHandler;
            }

            @Override
            public MultiProxyMethod getMultiProxyMethod() {
                return MultiProxyMethod.getByName(VotingPluginProxy.this.getConfig().getMultiProxyMethod());
            }

            @Override
            public String getMultiProxyPassword() {
                return VotingPluginProxy.this.getConfig().getMultiProxyRedisPassword();
            }

            @Override
            public String getMultiProxyRedisHost() {
                return VotingPluginProxy.this.getConfig().getMultiProxyRedisHost();
            }

            @Override
            public int getMultiProxyRedisPort() {
                return VotingPluginProxy.this.getConfig().getMultiProxyRedisPort();
            }

            @Override
            public boolean getMultiProxyRedisUseExistingConnection() {
                return VotingPluginProxy.this.getConfig().getMultiProxyRedisUseExistingConnection();
            }

            @Override
            public String getMultiProxyServerName() {
                return VotingPluginProxy.this.getConfig().getProxyServerName();
            }

            @Override
            public Collection<String> getMultiProxyServers() {
                return VotingPluginProxy.this.getConfig().getMultiProxyServers();
            }

            @Override
            public MultiProxyServerSocketConfiguration getMultiProxyServersConfiguration(String s) {
                return new MultiProxyServerSocketConfigurationBungee(s, VotingPluginProxy.this.getConfig().getMultiProxyServersConfiguration(s));
            }

            @Override
            public String getMultiProxySocketHostHost() {
                return VotingPluginProxy.this.getConfig().getMultiProxySocketHostHost();
            }

            @Override
            public int getMultiProxySocketHostPort() {
                return VotingPluginProxy.this.getConfig().getMultiProxySocketHostPort();
            }

            @Override
            public boolean getMultiProxySupportEnabled() {
                return VotingPluginProxy.this.getConfig().getMultiProxySupport();
            }

            @Override
            public String getMultiProxyUsername() {
                return VotingPluginProxy.this.getConfig().getMultiProxyRedisUsername();
            }

            @Override
            public File getPluginDataFolder() {
                return VotingPluginProxy.this.getDataFolderPlugin();
            }

            @Override
            public boolean getPrimaryServer() {
                return VotingPluginProxy.this.getConfig().getPrimaryServer();
            }

            @Override
            public List<String> getProxyServers() {
                return VotingPluginProxy.this.getConfig().getProxyServers();
            }

            @Override
            public RedisHandler getRedisHandler() {
                return VotingPluginProxy.this.redisHandler;
            }

            @Override
            public String getVersion() {
                return VotingPluginProxy.this.getPluginVersion();
            }

            @Override
            public void logInfo(String msg) {
                VotingPluginProxy.this.log(msg);
            }

            @Override
            public void runAsnc(Runnable runnable) {
                VotingPluginProxy.this.runAsync(runnable);
            }

            @Override
            public void setEncryptionHandler(EncryptionHandler encryptionHandler1) {
                VotingPluginProxy.this.encryptionHandler = encryptionHandler1;
            }

            @Override
            public void triggerVote(String player, String service, boolean realVote, boolean timeQueue, long queueTime, BungeeMessageData text, String uuid) {
                VotingPluginProxy.this.vote(player, service, realVote, timeQueue, queueTime, text, uuid);
            }
        };
        this.multiProxyHandler.loadMultiProxySupport();
    }

    public abstract void log(String var1);

    public void login(String playerName, String uuid, String serverName) {
        if (this.getConfig().getOnlineMode()) {
            this.addNonVotedPlayer(uuid, playerName);
        }
        if (this.isPlayerOnline(playerName)) {
            if (this.getConfig().getGlobalDataEnabled() && this.getGlobalDataHandler().isTimeChangedHappened()) {
                this.getGlobalDataHandler().checkForFinishedTimeChanges();
            }
            this.checkCachedVotes(serverName);
            this.checkOnlineVotes(playerName, uuid, serverName);
            this.multiProxyHandler.login(uuid, playerName);
        }
    }

    private void logInfo(String msg) {
        this.log(msg);
    }

    public abstract void logSevere(String var1);

    public void onDisable() {
        this.getVoteCacheHandler().saveVoteCache();
        if (this.getProxyMysqlMessenger() != null) {
            this.getProxyMysqlMessenger().shutdown();
        }
        if (this.getProxyMySQL() != null) {
            this.getProxyMySQL().shutdown();
        }
        if (this.multiProxyHandler != null) {
            this.multiProxyHandler.close();
        }
        if (this.socketHandler != null) {
            this.socketHandler.closeConnection();
        }
        if (this.redisHandler != null) {
            this.redisHandler.close();
        }
        this.bungeeTimeChecker.shutdown();
        if (this.getGlobalDataHandler() != null) {
            this.getGlobalDataHandler().shutdown();
        }
        this.enabled = false;
    }

    public void onPluginMessageReceived(final DataInputStream in) {
        this.runAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    String[] list;
                    String subchannel = "";
                    subchannel = VotingPluginProxy.this.getConfig().getPluginMessageEncryption() && VotingPluginProxy.this.encryptionHandler != null ? VotingPluginProxy.this.encryptionHandler.decrypt(in.readUTF()) : in.readUTF();
                    int size = in.readInt();
                    VotingPluginProxy.this.debug("Received plugin message, processing..." + subchannel + " " + size);
                    String data = "";
                    if (size > 0) {
                        data = VotingPluginProxy.this.getConfig().getPluginMessageEncryption() && VotingPluginProxy.this.encryptionHandler != null ? VotingPluginProxy.this.encryptionHandler.decrypt(in.readUTF()) : in.readUTF();
                    }
                    if ((list = data.split("/a/")).length > 0) {
                        VotingPluginProxy.this.globalMessageProxyHandler.onMessage(subchannel.toLowerCase(), ArrayUtils.convert(list));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private UUID parseUUIDFromString(String uuidAsString) {
        String[] parts = new String[]{"0x" + uuidAsString.substring(0, 8), "0x" + uuidAsString.substring(8, 12), "0x" + uuidAsString.substring(12, 16), "0x" + uuidAsString.substring(16, 20), "0x" + uuidAsString.substring(20, 32)};
        long mostSigBits = Long.decode(parts[0]);
        mostSigBits <<= 16;
        mostSigBits |= Long.decode(parts[1]).longValue();
        mostSigBits <<= 16;
        long leastSigBits = Long.decode(parts[3]);
        leastSigBits <<= 48;
        return new UUID(mostSigBits |= Long.decode(parts[2]).longValue(), leastSigBits |= Long.decode(parts[4]).longValue());
    }

    public void processQueue() {
        while (this.getVoteCacheHandler().getTimeChangeQueue().size() > 0) {
            VoteTimeQueue vote = this.getVoteCacheHandler().getTimeChangeQueue().remove();
            this.vote(vote.getName(), vote.getService(), true, false, vote.getTime(), null, null);
        }
    }

    public void reload() {
        this.method = BungeeMethod.getByName(this.getConfig().getBungeeMethod());
        if (this.getMethod() == null) {
            this.method = BungeeMethod.PLUGINMESSAGING;
        }
        this.setCurrentVotePartyVotesRequired(this.getConfig().getVotePartyVotesRequired() + this.getVoteCacheVotePartyIncreaseVotesRequired());
        this.loadMultiProxySupport();
    }

    public abstract void runAsync(Runnable var1);

    public abstract void runConsoleCommand(String var1);

    public abstract void saveVoteCacheFile();

    public abstract void reloadCore(boolean var1);

    public abstract void sendPluginMessageData(String var1, String var2, byte[] var3, boolean var4);

    public void sendPluginMessageServer(final String server, int delay, final String channel, final String ... messageData) {
        this.getScheduler().schedule(new Runnable(){

            @Override
            public void run() {
                ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
                DataOutputStream out = new DataOutputStream(byteOutStream);
                try {
                    if (VotingPluginProxy.this.getConfig().getPluginMessageEncryption() && VotingPluginProxy.this.encryptionHandler != null) {
                        out.writeUTF(VotingPluginProxy.this.encryptionHandler.encrypt(channel));
                    } else {
                        out.writeUTF(channel);
                    }
                    out.writeInt(messageData.length);
                    String data = "";
                    for (String message : messageData) {
                        data = data + message + "/a/";
                    }
                    if (VotingPluginProxy.this.getConfig().getPluginMessageEncryption() && VotingPluginProxy.this.encryptionHandler != null) {
                        out.writeUTF(VotingPluginProxy.this.encryptionHandler.encrypt(data));
                    } else {
                        out.writeUTF(data);
                    }
                    if (VotingPluginProxy.this.isSomeoneOnlineServer(server)) {
                        VotingPluginProxy.this.sendPluginMessageData(server, VotingPluginProxy.this.getConfig().getPluginMessageChannel().toLowerCase(), byteOutStream.toByteArray(), false);
                    }
                    out.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                VotingPluginProxy.this.debug("Sending plugin message " + server + " " + channel + " " + ArrayUtils.makeStringList(ArrayUtils.convert(messageData)));
            }
        }, (long)(delay * 5), TimeUnit.MILLISECONDS);
    }

    public void sendRedisMessageServer(String server, String channel, String ... messageData) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(channel);
        list.addAll(ArrayUtils.convert(messageData));
        this.redisHandler.sendMessage(this.getConfig().getRedisPrefix() + "VotingPlugin_" + server, ArrayUtils.convert(list));
    }

    public void sendMqttMessageServer(String server, String channel, String ... messageData) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(channel);
        list.addAll(ArrayUtils.convert(messageData));
        try {
            this.mqttHandler.publish(this.getConfig().getMqttPrefix() + "votingplugin/servers/" + server, String.join((CharSequence)":", list));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendServerMessage(String ... messageData) {
        for (ClientHandler h : this.clientHandles.values()) {
            h.sendMessage(messageData);
        }
    }

    public void sendServerMessageServer(String server, String ... messageData) {
        if (this.clientHandles.containsKey(server)) {
            this.clientHandles.get(server).sendMessage(messageData);
        }
    }

    public void sendServerNameMessage() {
        if (this.method.equals((Object)BungeeMethod.PLUGINMESSAGING)) {
            for (String s : this.getAllAvailableServers()) {
                this.sendPluginMessageServer(s, 1, "ServerName", s);
            }
        }
    }

    public void sendVoteParty(String server) {
        if (this.isSomeoneOnlineServer(server)) {
            this.globalMessageProxyHandler.sendMessage(server, 1, "VotePartyBungee", "");
        }
    }

    public void setCurrentVotePartyVotes(int amount) {
        this.votePartyVotes = amount;
        this.setVoteCacheVotePartyCurrentVotes(amount);
        this.debug("Current vote party total: " + this.votePartyVotes);
    }

    public abstract void setVoteCacheLastUpdated();

    public abstract void setVoteCachePrevDay(int var1);

    public abstract void setVoteCachePrevMonth(String var1);

    public abstract void setVoteCachePrevWeek(int var1);

    public abstract void setVoteCacheVoteCacheIgnoreTime(boolean var1);

    public abstract void setVoteCacheVotePartyCurrentVotes(int var1);

    public abstract void setVoteCacheVotePartyIncreaseVotesRequired(int var1);

    public void status() {
        for (String s : this.getAllAvailableServers()) {
            if (!this.isSomeoneOnlineServer(s)) {
                this.log("No players on server " + s + " to send test status message, please retest with someone online");
                continue;
            }
            this.log("Sending request for status message on " + s);
            this.globalMessageProxyHandler.sendMessage(s, 1, "Status", s);
        }
    }

    public String getWaitUntilDelaySiteFromService(String service) {
        for (String site : this.getConfig().getWaitUntilVoteDelaySites()) {
            if (!this.getConfig().getWaitUntilVoteDelayService(site).equalsIgnoreCase(service)) continue;
            return site;
        }
        return "";
    }

    private long getLastVotesTime(String uuid, ArrayList<Column> cols, String site, String service) {
        long mostRecentTime = 0L;
        if (this.getVoteCacheHandler().hasOnlineVotes(uuid)) {
            ArrayList<OfflineBungeeVote> onlineVotes = this.getVoteCacheHandler().getOnlineVotes(uuid);
            for (OfflineBungeeVote offlineBungeeVote : onlineVotes) {
                if (!offlineBungeeVote.getService().equalsIgnoreCase(service)) continue;
                mostRecentTime = Math.max(mostRecentTime, offlineBungeeVote.getTime());
            }
        }
        for (String server : this.getAllAvailableServers()) {
            for (OfflineBungeeVote vote : this.getVoteCacheHandler().getVotes(server)) {
                if (!vote.getUuid().equals(uuid) || !vote.getService().equalsIgnoreCase(service)) continue;
                mostRecentTime = Math.max(mostRecentTime, vote.getTime());
            }
        }
        for (Column d : cols) {
            String[] list;
            if (!d.getName().equalsIgnoreCase("LastVotes")) continue;
            DataValue dataValue = d.getValue();
            for (String str : list = dataValue.getString().split("%line%")) {
                String[] data = str.split("//");
                if (!data[0].equalsIgnoreCase(site)) continue;
                mostRecentTime = Math.max(mostRecentTime, Long.valueOf(data[1]));
            }
        }
        return mostRecentTime;
    }

    public boolean checkVoteDelay(String uuid, String service, ArrayList<Column> data) {
        String site = this.getWaitUntilDelaySiteFromService(service);
        if (site.isEmpty()) {
            this.debug("No service site set for " + service + ", skipping vote delay check");
            return true;
        }
        int voteDelay = this.getConfig().getWaitUntilVoteDelayVoteDelay(site);
        int voteDelayMin = this.getConfig().getWaitUntilVoteDelayVoteDelayMin(site);
        long lastVote = this.getLastVotesTime(uuid, data, site, service);
        if (lastVote == 0L) {
            this.debug("No last vote time found for " + uuid + "/" + service + ", skipping vote delay check");
            return true;
        }
        try {
            LocalDateTime now = this.getBungeeTimeChecker().getTime();
            LocalDateTime lastVoteTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(lastVote), ZoneId.systemDefault()).plusHours(this.getConfig().getTimeHourOffSet());
            if (!this.getConfig().getWaitUntilVoteDelayVoteDelayDaily(site)) {
                if (voteDelay == 0 && voteDelayMin == 0) {
                    this.debug("Vote delay is 0 for " + site + ", skipping vote delay check");
                    return true;
                }
                LocalDateTime nextvote = lastVoteTime.plusHours(voteDelay).plusMinutes(voteDelayMin);
                return now.isAfter(nextvote);
            }
            LocalDateTime resetTime = lastVoteTime.withHour(this.getConfig().getWaitUntilVoteDelayVoteDelayHour(site)).withMinute(0).withSecond(0);
            LocalDateTime resetTimeTomorrow = resetTime.plusHours(24L);
            if (lastVoteTime.isBefore(resetTime)) {
                if (now.isAfter(resetTime)) {
                    this.debug("Vote delay is met for " + uuid + "/" + service + ", vote can be processed");
                    return true;
                }
            } else if (now.isAfter(resetTimeTomorrow)) {
                this.debug("Vote delay is met for " + uuid + "/" + service + ", vote can be processed");
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.debug("Vote delay is not met for " + uuid + "/" + service + ", skipping vote");
        return false;
    }

    public synchronized void vote(String player, String service, boolean realVote, boolean timeQueue, long queueTime, BungeeMessageData text, String uuid) {
        try {
            String uuid1;
            if (player == null || player.isEmpty()) {
                this.log("No name from vote on " + service);
                return;
            }
            if (this.getConfig().getGlobalDataEnabled() && this.getGlobalDataHandler().isTimeChangedHappened()) {
                this.getGlobalDataHandler().checkForFinishedTimeChanges();
                if (timeQueue && this.getGlobalDataHandler().isTimeChangedHappened()) {
                    this.getVoteCacheHandler().getTimeChangeQueue().add(new VoteTimeQueue(player, service, LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli()));
                    this.log("Cachcing vote from " + player + "/" + service + " because time change is happening right now");
                    return;
                }
            }
            if (!(uuid != null && !uuid.isEmpty() || !(uuid = this.getUUID(player)).isEmpty() || this.getConfig().getBedrockPlayerPrefix().isEmpty() || player.startsWith(this.getConfig().getBedrockPlayerPrefix()) || (uuid1 = this.getUUID(this.getConfig().getBedrockPlayerPrefix() + player)).isEmpty())) {
                this.debug("Detected bedrock player without prefix, adjusting...");
                player = this.getConfig().getBedrockPlayerPrefix() + player;
                uuid = uuid1;
            }
            if (uuid.isEmpty()) {
                UUID u;
                block41: {
                    if (player.startsWith(this.getConfig().getBedrockPlayerPrefix())) {
                        this.log("Ignoring vote since unable to get UUID of bedrock player");
                        return;
                    }
                    if (!this.getConfig().getAllowUnJoined()) {
                        this.log("Ignoring vote from " + player + " since player hasn't joined before");
                        return;
                    }
                    if (!this.getConfig().getUUIDLookup()) {
                        this.log("Failed to get uuid for " + player);
                        return;
                    }
                    this.debug("Fetching UUID online, since allowunjoined is enabled");
                    u = null;
                    try {
                        if (this.getConfig().getOnlineMode()) {
                            u = this.fetchUUID(player);
                        }
                    }
                    catch (Exception e) {
                        if (!this.getConfig().getDebug()) break block41;
                        e.printStackTrace();
                    }
                }
                if (u == null) {
                    this.debug("Failed to get uuid for " + player);
                    return;
                }
                uuid = u.toString();
            }
            player = this.getProperName(uuid, player);
            this.addVoteParty();
            if (this.getConfig().getPrimaryServer() || !this.getConfig().getMultiProxySupport()) {
                if (this.getConfig().getBungeeManageTotals()) {
                    LocalDateTime cTime;
                    int days;
                    ArrayList<Column> data;
                    if (this.getProxyMySQL() == null) {
                        this.logSevere("Mysql is not loaded correctly, stopping vote processing");
                        return;
                    }
                    if (!this.getProxyMySQL().getUuids().contains(uuid)) {
                        this.getProxyMySQL().update(uuid, "PlayerName", new DataValueString(player));
                    }
                    if (!this.checkVoteDelay(uuid, service, data = this.getProxyMySQL().getExactQuery(new Column("uuid", new DataValueString(uuid))))) {
                        this.log("Vote delay is not met for " + player + "/" + service + ", skipping vote");
                        return;
                    }
                    int allTimeTotal = this.getValue(data, "AllTimeTotal", 1);
                    int monthTotal = this.getValue(data, "MonthTotal", 1);
                    int dateMonthTotal = -1;
                    if (this.getConfig().getStoreMonthTotalsWithDate()) {
                        dateMonthTotal = this.getConfig().getUseMonthDateTotalsAsPrimaryTotal() ? this.getValue(data, this.getMonthTotalsWithDatePath(), 1) : monthTotal;
                    }
                    int weeklyTotal = this.getValue(data, "WeeklyTotal", 1);
                    int dailyTotal = this.getValue(data, "DailyTotal", 1);
                    int points = this.getValue(data, "Points", this.getConfig().getPointsOnVote());
                    int milestoneCount = this.getValue(data, "MilestoneCount", 1);
                    int maxVotes = this.getConfig().getMaxAmountOfVotesPerDay();
                    if (maxVotes > 0 && monthTotal > (days = (cTime = this.getBungeeTimeChecker().getTime()).getDayOfMonth()) * maxVotes) {
                        monthTotal = days * maxVotes;
                    }
                    if (this.getConfig().getLimitVotePoints() > 0 && points > this.getConfig().getLimitVotePoints()) {
                        points = this.getConfig().getLimitVotePoints();
                    }
                    text = new BungeeMessageData(allTimeTotal, monthTotal, weeklyTotal, dailyTotal, points, milestoneCount, this.votePartyVotes, this.currentVotePartyVotesRequired, dateMonthTotal);
                    ArrayList<Column> update = new ArrayList<Column>();
                    update.add(new Column("AllTimeTotal", new DataValueInt(allTimeTotal)));
                    update.add(new Column("MonthTotal", new DataValueInt(monthTotal)));
                    if (this.getConfig().getStoreMonthTotalsWithDate()) {
                        update.add(new Column(this.getMonthTotalsWithDatePath(), new DataValueInt(dateMonthTotal)));
                    }
                    update.add(new Column("WeeklyTotal", new DataValueInt(weeklyTotal)));
                    update.add(new Column("DailyTotal", new DataValueInt(dailyTotal)));
                    update.add(new Column("Points", new DataValueInt(points)));
                    update.add(new Column("MilestoneCount", new DataValueInt(milestoneCount)));
                    this.debug("Setting totals " + text.toString());
                    this.getProxyMySQL().update(uuid, update);
                } else {
                    text = new BungeeMessageData(0, 0, 0, 0, 0, 0, this.votePartyVotes, this.currentVotePartyVotesRequired, 0);
                }
            }
            long time = LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
            if (queueTime != 0L) {
                time = queueTime;
            }
            if (this.getConfig().getSendVotesToAllServers()) {
                for (String s : this.getAllAvailableServers()) {
                    boolean forceCache = false;
                    if (!this.isPlayerOnline(player) && this.getConfig().getWaitForUserOnline()) {
                        forceCache = true;
                        this.debug("Forcing vote to cache");
                    }
                    if (this.getConfig().getBroadcast()) {
                        this.globalMessageProxyHandler.sendMessage(s, 1, "VoteBroadcast", uuid, player, service);
                    }
                    if (!this.isSomeoneOnlineServer(s) && this.method.requiresPlayerOnline() || forceCache) {
                        this.getVoteCacheHandler().addServerVote(s, new OfflineBungeeVote(player, uuid, service, time, realVote, text.toString()));
                        this.debug("Caching vote for " + player + " on " + service + " for " + s);
                        continue;
                    }
                    this.globalMessageProxyHandler.sendMessage(s, 2, "Vote", player, uuid, service, "" + time, Boolean.TRUE.toString(), "" + realVote, text.toString(), "" + this.getConfig().getBungeeManageTotals(), "" + BungeeVersion.getPluginMessageVersion(), "" + this.getConfig().getBroadcast(), "1", "1");
                }
            } else {
                if (this.isPlayerOnline(player) && this.getAllAvailableServers().contains(this.getCurrentPlayerServer(player))) {
                    this.globalMessageProxyHandler.sendMessage(this.getCurrentPlayerServer(player), 1, "VoteOnline", player, uuid, service, "" + time, Boolean.TRUE.toString(), "" + realVote, text.toString(), "" + this.getConfig().getBungeeManageTotals(), "" + BungeeVersion.getPluginMessageVersion(), "" + this.getConfig().getBroadcast(), "1", "1");
                    if (this.getConfig().getMultiProxySupport() && this.getConfig().getMultiProxyOneGlobalReward()) {
                        this.multiProxyHandler.sendMultiProxyServerMessage("ClearVote", player, uuid);
                    }
                } else {
                    this.getVoteCacheHandler().addOnlineVote(uuid, new OfflineBungeeVote(player, uuid, service, time, realVote, text.toString()));
                    this.debug("Caching online vote for " + player + " on " + service);
                }
                int delay = 2;
                for (String s : this.getAllAvailableServers()) {
                    if (this.getConfig().getBroadcast()) {
                        this.globalMessageProxyHandler.sendMessage(s, delay, "VoteBroadcast", uuid, player, service);
                    }
                    this.globalMessageProxyHandler.sendMessage(s, delay + 1, "VoteUpdate", uuid, "" + this.votePartyVotes, "" + this.currentVotePartyVotesRequired, text.toString(), service, "" + time);
                    delay += 2;
                }
            }
            if (this.getConfig().getMultiProxySupport() && this.getConfig().getPrimaryServer()) {
                if (!this.getConfig().getMultiProxyOneGlobalReward()) {
                    this.debug("Seending global proxy vote message");
                    this.multiProxyHandler.sendMultiProxyServerMessage("Vote", uuid, player, service, "" + this.votePartyVotes, "" + this.currentVotePartyVotesRequired, "" + time, "" + realVote, text.toString());
                } else if (!this.isPlayerOnline(player) || this.getConfig().getBlockedServers().contains(this.getCurrentPlayerServer(player))) {
                    this.debug("Sending global proxy voteonline message");
                    this.multiProxyHandler.sendMultiProxyServerMessage("VoteOnline", uuid, player, service, "" + this.votePartyVotes, "" + this.currentVotePartyVotesRequired, "" + time, "" + realVote, text.toString());
                } else {
                    this.debug("Not sending global proxy message for voteonline, player already got reward");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public abstract void warn(String var1);

    public abstract ScheduledExecutorService getScheduler();

    @Generated
    public int getVotePartyVotes() {
        return this.votePartyVotes;
    }

    @Generated
    public void setVotePartyVotes(int votePartyVotes) {
        this.votePartyVotes = votePartyVotes;
    }

    @Generated
    public int getCurrentVotePartyVotesRequired() {
        return this.currentVotePartyVotesRequired;
    }

    @Generated
    public void setCurrentVotePartyVotesRequired(int currentVotePartyVotesRequired) {
        this.currentVotePartyVotesRequired = currentVotePartyVotesRequired;
    }

    @Generated
    public ProxyMysqlUserTable getProxyMySQL() {
        return this.proxyMySQL;
    }

    @Generated
    public void setProxyMySQL(ProxyMysqlUserTable proxyMySQL) {
        this.proxyMySQL = proxyMySQL;
    }

    @Generated
    public boolean isVotifierEnabled() {
        return this.votifierEnabled;
    }

    @Generated
    public void setVotifierEnabled(boolean votifierEnabled) {
        this.votifierEnabled = votifierEnabled;
    }

    @Generated
    public ConcurrentHashMap<UUID, String> getUuidPlayerNameCache() {
        return this.uuidPlayerNameCache;
    }

    @Generated
    public GlobalDataHandlerProxy getGlobalDataHandler() {
        return this.globalDataHandler;
    }

    @Generated
    public void setGlobalDataHandler(GlobalDataHandlerProxy globalDataHandler) {
        this.globalDataHandler = globalDataHandler;
    }

    @Generated
    public RedisHandler getRedisHandler() {
        return this.redisHandler;
    }

    @Generated
    public MultiProxyHandler getMultiProxyHandler() {
        return this.multiProxyHandler;
    }

    @Generated
    public void setMultiProxyHandler(MultiProxyHandler multiProxyHandler) {
        this.multiProxyHandler = multiProxyHandler;
    }

    @Generated
    public BungeeTimeChecker getBungeeTimeChecker() {
        return this.bungeeTimeChecker;
    }

    @Generated
    public BungeeMethod getMethod() {
        return this.method;
    }

    @Generated
    public void setMethod(BungeeMethod method) {
        this.method = method;
    }

    @Generated
    public MqttHandler getMqttHandler() {
        return this.mqttHandler;
    }

    @Generated
    public GlobalMessageProxyHandler getGlobalMessageProxyHandler() {
        return this.globalMessageProxyHandler;
    }

    @Generated
    public ProxyMessenger getProxyMysqlMessenger() {
        return this.proxyMysqlMessenger;
    }

    @Generated
    public VoteCacheHandler getVoteCacheHandler() {
        return this.voteCacheHandler;
    }
}

