/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.proxy;

import com.bencodez.votingplugin.simpleapi.sql.Column;
import com.bencodez.votingplugin.simpleapi.sql.DataType;
import com.bencodez.votingplugin.simpleapi.sql.data.DataValue;
import com.bencodez.votingplugin.simpleapi.sql.data.DataValueInt;
import com.bencodez.votingplugin.simpleapi.sql.data.DataValueString;
import com.bencodez.votingplugin.simpleapi.sql.mysql.MySQL;
import com.bencodez.votingplugin.simpleapi.sql.mysql.config.MysqlConfig;
import com.bencodez.votingplugin.simpleapi.sql.mysql.queries.Query;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

public abstract class ProxyMysqlUserTable {
    private List<String> columns = Collections.synchronizedList(new ArrayList());
    private List<String> intColumns = new ArrayList<String>();
    private MySQL mysql;
    private String name;
    private Object object2 = new Object();
    private Object object3 = new Object();
    private Object object4 = new Object();
    private Set<String> uuids = Collections.synchronizedSet(new HashSet());

    public abstract void logSevere(String var1);

    public abstract void logInfo(String var1);

    public ProxyMysqlUserTable(String tableName, MysqlConfig config, final boolean debug) {
        if (config.hasTableNameSet()) {
            tableName = config.getTableName();
        }
        this.name = tableName;
        if (config.getTablePrefix() != null) {
            this.name = config.getTablePrefix() + tableName;
        }
        if (config.getPoolName().isEmpty()) {
            config.setPoolName("VotingPlugin-" + tableName);
        }
        this.mysql = new MySQL(config.getMaxThreads()){

            @Override
            public void debug(SQLException e) {
                if (debug) {
                    e.printStackTrace();
                }
            }

            @Override
            public void severe(String string) {
                ProxyMysqlUserTable.this.logSevere(string);
            }

            @Override
            public void debug(String msg) {
                if (debug) {
                    ProxyMysqlUserTable.this.logInfo("MYSQL DEBUG: " + msg);
                }
            }
        };
        if (!this.mysql.connect(config)) {
            // empty if block
        }
        try {
            Query q = new Query(this.mysql, "USE `" + config.getDatabase() + "`;");
            q.executeUpdateAsync();
        }
        catch (SQLException e) {
            this.severe("Failed to send use database query: " + config.getDatabase() + " Error: " + e.getMessage());
            this.debug(e);
        }
        String sql = "CREATE TABLE IF NOT EXISTS " + this.getName() + " (";
        sql = sql + "uuid VARCHAR(37),";
        sql = sql + "PRIMARY KEY ( uuid )";
        sql = sql + ");";
        try {
            Query query = new Query(this.mysql, sql);
            query.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.loadData();
        this.alterColumnType("uuid", "VARCHAR(37)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addColumn(String column, DataType dataType) {
        Object object = this.object3;
        synchronized (object) {
            String sql = "ALTER TABLE " + this.getName() + " ADD COLUMN `" + column + "` text;";
            try {
                Query query = new Query(this.mysql, sql);
                query.executeUpdate();
                this.getColumns().add(column);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void alterColumnType(String column, String newType) {
        this.checkColumn(column, DataType.STRING);
        try {
            new Query(this.mysql, "ALTER TABLE " + this.getName() + " MODIFY `" + column + "` " + newType + ";").executeUpdateAsync();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (newType.contains("INT") && !this.intColumns.contains(column)) {
            this.intColumns.add(column);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkColumn(String column, DataType dataType) {
        Object object = this.object4;
        synchronized (object) {
            if (!this.getColumns().contains(column) && !this.getColumnsQueury().contains(column)) {
                this.addColumn(column, dataType);
            }
        }
    }

    public void clearCache() {
        this.clearCacheBasic();
    }

    public void clearCacheBasic() {
        this.columns.clear();
        this.columns.addAll(this.getColumnsQueury());
        this.uuids.clear();
        this.uuids.addAll(this.getUuidsQuery());
    }

    public void close() {
        this.mysql.disconnect();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean containsKeyQuery(String index) {
        String sqlStr = "SELECT uuid FROM " + this.getName() + ";";
        try (Connection conn = this.mysql.getConnectionManager().getConnection();
             PreparedStatement sql = conn.prepareStatement(sqlStr);){
            ResultSet rs = sql.executeQuery();
            while (rs.next()) {
                if (!rs.getString("uuid").equals(index)) continue;
                rs.close();
                boolean bl = true;
                return bl;
            }
            rs.close();
            return false;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public void copyColumnData(String columnFromName, String columnToName) {
        this.checkColumn(columnFromName, DataType.STRING);
        this.checkColumn(columnToName, DataType.STRING);
        String sql = "UPDATE `" + this.getName() + "` SET `" + columnToName + "` = `" + columnFromName + "`;";
        try {
            Query query = new Query(this.mysql, sql);
            query.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public abstract void debug(SQLException var1);

    public List<String> getColumns() {
        if (this.columns == null || this.columns.size() == 0) {
            this.loadData();
        }
        return this.columns;
    }

    public ArrayList<String> getColumnsQueury() {
        ArrayList<String> columns = new ArrayList<String>();
        try (Connection conn = this.mysql.getConnectionManager().getConnection();
             PreparedStatement sql = conn.prepareStatement("SHOW COLUMNS FROM `" + this.getName() + "`;");){
            ResultSet rs = sql.executeQuery();
            while (rs.next()) {
                String columnName = rs.getString(1);
                columns.add(columnName);
            }
            rs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return columns;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ArrayList<Column> getExactQuery(Column column) {
        ArrayList<Column> result = new ArrayList<Column>();
        String query = "SELECT * FROM " + this.getName() + " WHERE `" + column.getName() + "`='" + column.getValue().getString() + "';";
        try (Connection conn = this.mysql.getConnectionManager().getConnection();){
            ArrayList<Column> throwable2;
            block20: {
                PreparedStatement sql222 = conn.prepareStatement(query);
                try {
                    ResultSet rs = sql222.executeQuery();
                    if (rs.next()) {
                        for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                            String columnName = rs.getMetaData().getColumnLabel(i);
                            Column rCol = null;
                            if (this.intColumns.contains(columnName)) {
                                rCol = new Column(columnName, DataType.INTEGER);
                                rCol.setValue(new DataValueInt(rs.getInt(i)));
                            } else {
                                rCol = new Column(columnName, DataType.STRING);
                                rCol.setValue(new DataValueString(rs.getString(i)));
                            }
                            result.add(rCol);
                        }
                    }
                    rs.close();
                    throwable2 = result;
                    if (sql222 == null) break block20;
                }
                catch (Throwable throwable3) {
                    if (sql222 != null) {
                        try {
                            sql222.close();
                        }
                        catch (Throwable throwable) {
                            throwable3.addSuppressed(throwable);
                        }
                    }
                    throw throwable3;
                }
                sql222.close();
            }
            return throwable2;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        for (String col : this.getColumns()) {
            result.add(new Column(col, DataType.STRING));
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public ArrayList<String> getNamesQuery() {
        ArrayList<String> uuids = new ArrayList<String>();
        this.checkColumn("PlayerName", DataType.STRING);
        ArrayList<Column> rows = this.getRowsNameQuery();
        if (rows != null) {
            for (Column c : rows) {
                if (!c.getValue().isString()) continue;
                uuids.add(c.getValue().getString());
            }
        }
        return uuids;
    }

    public ArrayList<Column> getRowsNameQuery() {
        ArrayList<Column> result = new ArrayList<Column>();
        String sqlStr = "SELECT PlayerName FROM " + this.getName() + ";";
        try (Connection conn = this.mysql.getConnectionManager().getConnection();
             PreparedStatement sql = conn.prepareStatement(sqlStr);){
            ResultSet rs = sql.executeQuery();
            while (rs.next()) {
                Column rCol = new Column("PlayerName", new DataValueString(rs.getString("PlayerName")));
                result.add(rCol);
            }
            sql.close();
            conn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return result;
    }

    public ArrayList<Column> getRowsQuery() {
        ArrayList<Column> result = new ArrayList<Column>();
        String sqlStr = "SELECT uuid FROM " + this.getName() + ";";
        try (Connection conn = this.mysql.getConnectionManager().getConnection();
             PreparedStatement sql = conn.prepareStatement(sqlStr);){
            ResultSet rs = sql.executeQuery();
            while (rs.next()) {
                Column rCol = new Column("uuid", new DataValueString(rs.getString("uuid")));
                result.add(rCol);
            }
            rs.close();
        }
        catch (SQLException e) {
            return null;
        }
        return result;
    }

    public ConcurrentHashMap<UUID, String> getRowsUUIDNameQuery() {
        ConcurrentHashMap<UUID, String> uuidNames = new ConcurrentHashMap<UUID, String>();
        String sqlStr = "SELECT UUID, PlayerName FROM " + this.getName() + ";";
        try (Connection conn = this.mysql.getConnectionManager().getConnection();
             PreparedStatement sql = conn.prepareStatement(sqlStr);){
            ResultSet rs = sql.executeQuery();
            while (rs.next()) {
                String uuid = rs.getString("uuid");
                String playerName = rs.getString("PlayerName");
                if (uuid == null || uuid.isEmpty() || uuid.equals("null") || playerName == null) continue;
                uuidNames.put(UUID.fromString(uuid), playerName);
            }
            sql.close();
            conn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return uuidNames;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getUUID(String playerName) {
        String query = "SELECT uuid FROM " + this.getName() + " WHERE PlayerName='" + playerName + "';";
        try (Connection conn = this.mysql.getConnectionManager().getConnection();
             PreparedStatement sql = conn.prepareStatement(query);){
            String uuid;
            ResultSet rs = sql.executeQuery();
            if (rs.next() && (uuid = rs.getString("uuid")) != null && !uuid.isEmpty()) {
                rs.close();
                String string = uuid;
                return string;
            }
            rs.close();
            return null;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    public Set<String> getUuids() {
        if (this.uuids == null || this.uuids.size() == 0) {
            this.uuids.clear();
            this.uuids.addAll(this.getUuidsQuery());
            return this.uuids;
        }
        return this.uuids;
    }

    public ArrayList<String> getUuidsQuery() {
        ArrayList<String> uuids = new ArrayList<String>();
        ArrayList<Column> rows = this.getRowsQuery();
        for (Column c : rows) {
            if (!c.getValue().isString()) continue;
            uuids.add(c.getValue().getString());
        }
        return uuids;
    }

    public void insert(String index, String column, DataValue value) {
        this.insertQuery(index, Arrays.asList(new Column(column, value)));
    }

    public void insertQuery(String index, List<Column> cols) {
        String query = "INSERT IGNORE " + this.getName() + " ";
        query = query + "set uuid='" + index + "', ";
        for (int i = 0; i < cols.size(); ++i) {
            Column col = cols.get(i);
            if (i == cols.size() - 1) {
                if (col.getValue().isString()) {
                    query = query + "`" + col.getName() + "`='" + col.getValue().getString() + "';";
                    continue;
                }
                if (col.getValue().isBoolean()) {
                    query = query + "`" + col.getName() + "`='" + col.getValue().getBoolean() + "';";
                    continue;
                }
                if (!col.getValue().isInt()) continue;
                query = query + "`" + col.getName() + "`='" + col.getValue().getInt() + "';";
                continue;
            }
            if (col.getValue().isString()) {
                query = query + "`" + col.getName() + "`='" + col.getValue().getString() + "', ";
                continue;
            }
            if (col.getValue().isBoolean()) {
                query = query + "`" + col.getName() + "`='" + col.getValue().getBoolean() + "', ";
                continue;
            }
            if (!col.getValue().isInt()) continue;
            query = query + "`" + col.getName() + "`='" + col.getValue().getInt() + "', ";
        }
        try {
            this.uuids.add(index);
            new Query(this.mysql, query).executeUpdateAsync();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public boolean isIntColumn(String key) {
        return this.intColumns.contains(key);
    }

    public void loadData() {
        this.columns = this.getColumnsQueury();
    }

    public abstract void severe(String var1);

    public void shutdown() {
        this.mysql.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String index, List<Column> cols) {
        for (Column col : cols) {
            this.checkColumn(col.getName(), col.getDataType());
        }
        if (this.getUuids().contains(index)) {
            Object object = this.object2;
            synchronized (object) {
                String query = "UPDATE " + this.getName() + " SET ";
                for (int i = 0; i < cols.size(); ++i) {
                    Column col = cols.get(i);
                    if (i == cols.size() - 1) {
                        if (col.getValue().isString()) {
                            query = query + "`" + col.getName() + "`='" + col.getValue().getString() + "'";
                            continue;
                        }
                        if (col.getValue().isBoolean()) {
                            query = query + "`" + col.getName() + "`='" + col.getValue().getBoolean() + "'";
                            continue;
                        }
                        if (!col.getValue().isInt()) continue;
                        query = query + "`" + col.getName() + "`='" + col.getValue().getInt() + "'";
                        continue;
                    }
                    if (col.getValue().isString()) {
                        query = query + "`" + col.getName() + "`='" + col.getValue().getString() + "', ";
                        continue;
                    }
                    if (col.getValue().isBoolean()) {
                        query = query + "`" + col.getName() + "`='" + col.getValue().getBoolean() + "', ";
                        continue;
                    }
                    if (!col.getValue().isInt()) continue;
                    query = query + "`" + col.getName() + "`='" + col.getValue().getInt() + "', ";
                }
                query = query + " WHERE `uuid`=";
                query = query + "'" + index + "';";
                try {
                    Query q = new Query(this.mysql, query);
                    q.executeUpdateAsync();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        this.insertQuery(index, cols);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String index, String column, DataValue value) {
        this.checkColumn(column, value.getType());
        if (this.getUuids().contains(index)) {
            Object object = this.object2;
            synchronized (object) {
                String query = "UPDATE " + this.getName() + " SET ";
                if (value.isString()) {
                    query = query + column + "='" + value.getString() + "'";
                } else if (value.isBoolean()) {
                    query = query + column + "='" + value.getBoolean() + "'";
                } else if (value.isInt()) {
                    query = query + column + "='" + value.getInt() + "'";
                }
                query = query + " WHERE `uuid`=";
                query = query + "'" + index + "';";
                try {
                    Query q = new Query(this.mysql, query);
                    q.executeUpdate();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        this.insert(index, column, value);
    }

    public void wipeColumnData(String columnName, DataType dataType) {
        this.checkColumn(columnName, dataType);
        String sql = "UPDATE " + this.getName() + " SET " + columnName + " = " + dataType.getNoValue() + ";";
        try {
            Query query = new Query(this.mysql, sql);
            query.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Generated
    public MySQL getMysql() {
        return this.mysql;
    }
}

