/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.placeholders;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.messages.PlaceholderUtils;
import com.bencodez.votingplugin.advancedcore.api.placeholder.CalculatingPlaceholder;
import com.bencodez.votingplugin.advancedcore.api.placeholder.NonPlayerPlaceHolder;
import com.bencodez.votingplugin.advancedcore.api.placeholder.PlaceHolder;
import com.bencodez.votingplugin.advancedcore.api.user.AdvancedCoreUser;
import com.bencodez.votingplugin.advancedcore.api.user.UserDataChanged;
import com.bencodez.votingplugin.objects.VoteSite;
import com.bencodez.votingplugin.placeholders.PlaceholderCacheLevel;
import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import com.bencodez.votingplugin.topvoter.TopVoter;
import com.bencodez.votingplugin.topvoter.TopVoterPlayer;
import com.bencodez.votingplugin.user.VotingPluginUser;
import java.text.NumberFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.TemporalField;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class PlaceHolders {
    private ArrayList<NonPlayerPlaceHolder<VotingPluginUser>> nonPlayerPlaceholders = new ArrayList();
    private ArrayList<PlaceHolder<VotingPluginUser>> placeholders = new ArrayList();
    private VotingPluginMain plugin;
    private ArrayList<String> cachedPlaceholders = new ArrayList();
    private ConcurrentLinkedQueue<String> placeholdersToSetCacheOn = new ConcurrentLinkedQueue();
    private PlaceholderCacheLevel cacheLevel;

    public PlaceHolders(VotingPluginMain plugin) {
        this.plugin = plugin;
        this.cacheLevel = plugin.getConfigFile().getPlaceholderCacheLevel();
    }

    public void checkNonCachedPlaceholders() {
        while (!this.placeholdersToSetCacheOn.isEmpty()) {
            String toCache = this.placeholdersToSetCacheOn.poll().toLowerCase();
            if (toCache.startsWith("votingplugin")) {
                toCache = toCache.substring("votingplugin_".length());
            }
            for (PlaceHolder<VotingPluginUser> placeholder : this.placeholders) {
                if (!placeholder.matches(toCache)) continue;
                placeholder.setUseCache(true, toCache);
                this.cachedPlaceholders.add(toCache);
                this.plugin.getServerData().addAutoCachedPlaceholder(toCache);
                this.plugin.extraDebug("Auto Caching placeholder " + toCache);
            }
        }
    }

    public String getPlaceHolder(OfflinePlayer p, String identifier) {
        return this.getPlaceHolder(p, identifier, true);
    }

    public String getPlaceHolder(OfflinePlayer p, String identifier1, boolean javascript) {
        boolean forceProcess = false;
        boolean useCache = true;
        String identifier = identifier1.toLowerCase();
        boolean custom = false;
        if (identifier.endsWith("_process")) {
            forceProcess = true;
            identifier = identifier.replaceAll("_process", "");
        }
        if (identifier.endsWith("_nocache")) {
            useCache = false;
            identifier = identifier.replaceAll("_nocache", "");
        }
        if (this.getCacheLevel().equals((Object)PlaceholderCacheLevel.NONE)) {
            useCache = false;
        }
        if (identifier.startsWith("custom_")) {
            custom = true;
            identifier = identifier.replaceAll("custom_", "");
        }
        if (!custom || !this.plugin.getConfigFile().getCustomPlaceholderReturns().contains(identifier)) {
            return this.getPlaceholderValue(p, identifier, javascript, forceProcess, useCache);
        }
        String str = this.getPlaceholderValue(p, identifier, javascript, true, useCache);
        String returnStr = this.plugin.getConfigFile().getCustomPlaceholderReturns(identifier, str);
        if (!returnStr.isEmpty()) {
            return returnStr;
        }
        return str;
    }

    public String getPlaceHolder(Player p, String identifier) {
        if (this.plugin.getConfigFile().isUseJavascriptPlaceholders()) {
            identifier = PlaceholderUtils.replaceJavascript(p, identifier);
        }
        return this.getPlaceHolder((OfflinePlayer)p, identifier, false);
    }

    public String getPlaceholderValue(OfflinePlayer p, String identifier, boolean javascript, boolean forceProcess, boolean useCache) {
        if (this.plugin.getConfigFile().isUseJavascriptPlaceholders() && javascript && p != null) {
            identifier = PlaceholderUtils.replaceJavascript(p, identifier);
        }
        if (!identifier.toLowerCase().endsWith("position")) {
            for (NonPlayerPlaceHolder<VotingPluginUser> placeholder : this.nonPlayerPlaceholders) {
                String string;
                if (!placeholder.matches(identifier) || (string = placeholder.placeholderRequest(identifier)) == null) continue;
                return string;
            }
        }
        if (p == null) {
            return "no player";
        }
        VotingPluginUser user = this.plugin.getVotingPluginUserManager().getVotingPluginUser(p);
        if (useCache && !this.cachedPlaceholders.contains(identifier) && !forceProcess) {
            for (PlaceHolder placeHolder : this.placeholders) {
                if (!placeHolder.matches(identifier)) continue;
                if (this.getCacheLevel().shouldCache() && !this.placeholdersToSetCacheOn.contains(identifier)) {
                    this.placeholdersToSetCacheOn.add(identifier);
                    this.schedulePlaceholderCheck(user);
                }
                return "..";
            }
            return "Not a valid placeholder";
        }
        if (this.plugin.getConfigFile().isUsePrimaryAccountForPlaceholders() && user.hasPrimaryAccount()) {
            user = this.plugin.getVotingPluginUserManager().getVotingPluginUser(user.getPrimaryAccount());
        }
        UUID uuid = user.getJavaUUID();
        for (PlaceHolder<VotingPluginUser> placeholder : this.placeholders) {
            try {
                if (!placeholder.matches(identifier)) continue;
                if (placeholder instanceof CalculatingPlaceholder) {
                    if (!useCache) {
                        return placeholder.placeholderRequest(user, identifier);
                    }
                    CalculatingPlaceholder cPlaceholder = (CalculatingPlaceholder)placeholder;
                    if (placeholder.isUsesCache() && placeholder.isCached(identifier)) {
                        ConcurrentHashMap<UUID, String> cache = placeholder.getCache().get(identifier);
                        if (cache.containsKey(uuid)) {
                            if (cPlaceholder.getCacheData().containsKey(uuid)) {
                                return cPlaceholder.placeholderRequest(user, identifier);
                            }
                            return cache.get(uuid);
                        }
                        if (!forceProcess) {
                            this.schedulePlaceholderCheck(user);
                            return "...";
                        }
                    }
                    if (forceProcess) {
                        if (this.getCacheLevel().shouldCache() && !this.placeholdersToSetCacheOn.contains(identifier) && !this.cachedPlaceholders.contains(identifier)) {
                            this.placeholdersToSetCacheOn.add(identifier);
                            this.schedulePlaceholderCheck(user);
                        }
                        return placeholder.placeholderRequest(user, identifier);
                    }
                    if (this.getCacheLevel().shouldCache() && !this.placeholdersToSetCacheOn.contains(identifier) && !this.cachedPlaceholders.contains(identifier)) {
                        this.placeholdersToSetCacheOn.add(identifier);
                        this.schedulePlaceholderCheck(user);
                    }
                    return ".";
                }
                if (!useCache) {
                    return placeholder.placeholderRequest(user, identifier);
                }
                if (placeholder.isUsesCache() && placeholder.isCached(identifier)) {
                    ConcurrentHashMap<UUID, String> cache = placeholder.getCache().get(identifier);
                    if (cache.containsKey(uuid)) {
                        return cache.get(uuid);
                    }
                    if (!forceProcess) {
                        this.schedulePlaceholderCheck(user);
                        return "...";
                    }
                }
                if (forceProcess) {
                    if (this.getCacheLevel().shouldCache() && !this.placeholdersToSetCacheOn.contains(identifier) && !this.cachedPlaceholders.contains(identifier)) {
                        this.placeholdersToSetCacheOn.add(identifier);
                        this.schedulePlaceholderCheck(user);
                    }
                    return placeholder.placeholderRequest(user, identifier);
                }
                if (this.getCacheLevel().shouldCache() && !this.placeholdersToSetCacheOn.contains(identifier) && !this.cachedPlaceholders.contains(identifier)) {
                    this.placeholdersToSetCacheOn.add(identifier);
                    this.schedulePlaceholderCheck(user);
                }
                return ".";
            }
            catch (Exception e) {
                this.plugin.debug(e);
                return "Error";
            }
        }
        return "Not a valid placeholder";
    }

    public void load() {
        this.placeholders.clear();
        this.nonPlayerPlaceholders.clear();
        this.placeholders.add(new PlaceHolder<VotingPluginUser>("total"){

            @Override
            public String placeholderRequest(VotingPluginUser user, String identifier) {
                return Integer.toString(user.getTotal(TopVoter.Monthly));
            }
        }.withDescription("Month total").updateDataKey("MonthTotal"));
        this.placeholders.add(new PlaceHolder<VotingPluginUser>("alltimetotal"){

            @Override
            public String placeholderRequest(VotingPluginUser user, String identifier) {
                return Integer.toString(user.getTotal(TopVoter.AllTime));
            }
        }.withDescription("Alltime total").updateDataKey("AllTimeTotal"));
        this.placeholders.add(new PlaceHolder<VotingPluginUser>("lastmonthtotal"){

            @Override
            public String placeholderRequest(VotingPluginUser user, String identifier) {
                return Integer.toString(user.getLastMonthTotal());
            }
        }.withDescription("Last month total").updateDataKey("LastMonthTotal"));
        this.placeholders.add(new PlaceHolder<VotingPluginUser>("DisableBroadcast"){

            @Override
            public String placeholderRequest(VotingPluginUser user, String identifier) {
                return "" + user.getDisableBroadcast();
            }
        }.withDescription("Returns true/false if user has broadcast disabled").updateDataKey("DisableBroadcast"));
        this.placeholders.add(new PlaceHolder<VotingPluginUser>("DisableReminders"){

            @Override
            public String placeholderRequest(VotingPluginUser user, String identifier) {
                if (PlaceHolders.this.plugin.getVoteReminding().getRemindersEnabled().containsKey(user.getJavaUUID()) && !PlaceHolders.this.plugin.getVoteReminding().getRemindersEnabled().get(user.getJavaUUID()).booleanValue()) {
                    return "True";
                }
                return "False";
            }
        }.withDescription("Returns true/false if user has reminders disabled"));
        this.placeholders.add(new PlaceHolder<VotingPluginUser>("MilestoneCount"){

            @Override
            public String placeholderRequest(VotingPluginUser user, String identifier) {
                return "" + user.getMilestoneCount();
            }
        }.withDescription("User milestonecount").updateDataKey("MilestoneCount"));
        Set<String> mVotes = this.plugin.getSpecialRewardsConfig().getMilestoneVotes();
        for (String vote : mVotes) {
            if (!MessageAPI.isInt(vote)) continue;
            final int num = Integer.parseInt(vote);
            if (!this.plugin.getSpecialRewardsConfig().getMilestoneRewardEnabled(num)) continue;
            this.placeholders.add(new PlaceHolder<VotingPluginUser>("milestone_numberofvotesuntil_" + num){

                @Override
                public String placeholderRequest(VotingPluginUser user, String identifier) {
                    int toGo = num - user.getMilestoneCount();
                    if (toGo >= 0) {
                        return "" + toGo;
                    }
                    return "0";
                }
            }.withDescription("Get number of votes until milestone").updateDataKey("MilestoneCount"));
        }
        this.placeholders.add(new PlaceHolder<VotingPluginUser>("nextmilestone_votes_required"){

            @Override
            public String placeholderRequest(VotingPluginUser user, String identifier) {
                return "" + user.getNextAvailableMileStone();
            }
        }.withDescription("Get number of votes required for next available milestone").updateDataKey("MilestoneCount"));
        this.placeholders.add(new PlaceHolder<VotingPluginUser>("nextmilestone_votes_until"){

            @Override
            public String placeholderRequest(VotingPluginUser user, String identifier) {
                int toGo = user.getNextAvailableMileStone() - user.getMilestoneCount();
                if (toGo >= 0) {
                    return "" + toGo;
                }
                return "0";
            }
        }.withDescription("Get number of votes until next available milestone").updateDataKey("MilestoneCount"));
        this.placeholders.add(new PlaceHolder<VotingPluginUser>("lastmilestone_votes_since"){

            @Override
            public String placeholderRequest(VotingPluginUser user, String identifier) {
                int toGo = user.getMilestoneCount() - user.getLastGottenMilestone();
                if (toGo >= 0) {
                    return "" + toGo;
                }
                return "0";
            }
        }.withDescription("Get number of votes since last milestone").updateDataKey("MilestoneCount"));
        for (final String identifier : this.plugin.getShopFile().getShopIdentifiers()) {
            if (this.plugin.getShopFile().getShopIdentifierLimit(identifier) <= 0) continue;
            this.placeholders.add(new PlaceHolder<VotingPluginUser>("VoteShopLimit_" + identifier){

                @Override
                public String placeholderRequest(VotingPluginUser user, String ident) {
                    return "" + user.getVoteShopIdentifierLimit(identifier);
                }
            }.withDescription("User voteshop limit for " + identifier).updateDataKey("VoteShopLimit" + identifier));
        }
        for (final TopVoter top : TopVoter.values()) {
            this.placeholders.add(new PlaceHolder<VotingPluginUser>("Total_" + top.toString()){

                @Override
                public String placeholderRequest(VotingPluginUser user, String identifier) {
                    return Integer.toString(user.getTotal(top));
                }
            }.withDescription("User total for " + top.getName()).updateDataKey(top.getColumnName()));
        }
        this.placeholders.add(new PlaceHolder<VotingPluginUser>("BestDailyTotal"){

            @Override
            public String placeholderRequest(VotingPluginUser user, String identifier) {
                return Integer.toString(user.getHighestDailyTotal());
            }
        }.withDescription("Best daily total").updateDataKey("HighestDailyTotal"));
        this.placeholders.add(new PlaceHolder<VotingPluginUser>("BestWeeklyTotal"){

            @Override
            public String placeholderRequest(VotingPluginUser user, String identifier) {
                return Integer.toString(user.getHighestWeeklyTotal());
            }
        }.withDescription("Best weekly total").updateDataKey("HighestWeeklyTotal"));
        this.placeholders.add(new PlaceHolder<VotingPluginUser>("BestMonthlyTotal"){

            @Override
            public String placeholderRequest(VotingPluginUser user, String identifier) {
                return Integer.toString(user.getHighestMonthlyTotal());
            }
        }.withDescription("Best monthly total").updateDataKey("HighestMonthlyTotal"));
        this.placeholders.add(new PlaceHolder<VotingPluginUser>("DailyVoteStreak"){

            @Override
            public String placeholderRequest(VotingPluginUser user, String identifier) {
                return Integer.toString(user.getDayVoteStreak());
            }
        }.withDescription("Current daily votestreak").updateDataKey("DayVoteStreak"));
        this.placeholders.add(new PlaceHolder<VotingPluginUser>("WeeklyVoteStreak"){

            @Override
            public String placeholderRequest(VotingPluginUser user, String identifier) {
                return Integer.toString(user.getWeekVoteStreak());
            }
        }.withDescription("Current weekly votestreak").updateDataKey("WeekVoteStreak"));
        this.placeholders.add(new PlaceHolder<VotingPluginUser>("MonthVoteStreak"){

            @Override
            public String placeholderRequest(VotingPluginUser user, String identifier) {
                return Integer.toString(user.getMonthVoteStreak());
            }
        }.withDescription("Current month votestreak").updateDataKey("MonthVoteStreak"));
        this.placeholders.add(new PlaceHolder<VotingPluginUser>("BestDailyVoteStreak"){

            @Override
            public String placeholderRequest(VotingPluginUser user, String identifier) {
                return Integer.toString(user.getBestDayVoteStreak());
            }
        }.withDescription("Best daily votestreak").updateDataKey("BestDayVoteStreak"));
        this.placeholders.add(new PlaceHolder<VotingPluginUser>("BestWeeklyVoteStreak"){

            @Override
            public String placeholderRequest(VotingPluginUser user, String identifier) {
                return Integer.toString(user.getBestWeekVoteStreak());
            }
        }.withDescription("Best weekly votestreak").updateDataKey("BestWeekVoteStreak"));
        this.placeholders.add(new PlaceHolder<VotingPluginUser>("BestMonthVoteStreak"){

            @Override
            public String placeholderRequest(VotingPluginUser user, String identifier) {
                return Integer.toString(user.getBestMonthVoteStreak());
            }
        }.withDescription("Best month votestreak").updateDataKey("BestMonthVoteStreak"));
        this.placeholders.add(new PlaceHolder<VotingPluginUser>("Points"){

            @Override
            public String placeholderRequest(VotingPluginUser user, String identifier) {
                return Integer.toString(user.getPoints());
            }
        }.withDescription("User points").updateDataKey("Points"));
        this.placeholders.add(new PlaceHolder<VotingPluginUser>("Points_Format"){

            @Override
            public String placeholderRequest(VotingPluginUser user, String identifier) {
                NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
                return numberFormat.format(user.getPoints());
            }
        }.withDescription("User points").updateDataKey("Points"));
        this.placeholders.add(new PlaceHolder<VotingPluginUser>("CanVote"){

            @Override
            public String placeholderRequest(VotingPluginUser user, String identifier) {
                return Boolean.toString(user.canVoteAll());
            }
        }.withDescription("Return true/false if player can vote on all sites").updateDataKey("LastVotes"));
        this.placeholders.add(new PlaceHolder<VotingPluginUser>("CanVoteSites"){

            @Override
            public String placeholderRequest(VotingPluginUser user, String identifier) {
                return "" + user.getSitesNotVotedOn();
            }
        }.withDescription("Return number of votesites available").updateDataKey("LastVotes"));
        this.placeholders.add(new PlaceHolder<VotingPluginUser>("Next_AnySite"){

            @Override
            public String placeholderRequest(VotingPluginUser user, String identifier) {
                if (user.canVoteAny()) {
                    return PlaceHolders.this.plugin.getConfigFile().getFormatCommandsVoteNextInfoCanVote();
                }
                long smallest = -1L;
                HashMap<Long, VoteSite> times = new HashMap<Long, VoteSite>();
                for (VoteSite voteSite : PlaceHolders.this.plugin.getVoteSitesEnabled()) {
                    long t = user.voteNextDurationTime(voteSite);
                    if (smallest == -1L) {
                        smallest = t;
                    }
                    if (t < smallest) {
                        smallest = t;
                    }
                    times.put(t, voteSite);
                }
                for (Map.Entry entry : times.entrySet()) {
                    if ((Long)entry.getKey() != smallest) continue;
                    return user.voteCommandNextInfo((VoteSite)entry.getValue());
                }
                return "Error";
            }
        }.withDescription("How long until user can vote on anysite").updateDataKey("LastVotes"));
        this.placeholders.add(new PlaceHolder<VotingPluginUser>("SitesAvailable"){

            @Override
            public String placeholderRequest(VotingPluginUser user, String identifier) {
                return "" + user.getSitesNotVotedOn();
            }
        }.withDescription("Get number of sites available to be voted on").updateDataKey("LastVotes"));
        this.placeholders.add(new PlaceHolder<VotingPluginUser>("SitesAvailableTotal"){

            @Override
            public String placeholderRequest(VotingPluginUser user, String identifier) {
                return "" + user.getTotalNumberOfSites();
            }
        }.withDescription("Get total number of sites available to be voted on"));
        for (final VoteSite voteSite : this.plugin.getVoteSitesEnabled()) {
            this.placeholders.add(new CalculatingPlaceholder<VotingPluginUser>("Next_" + voteSite.getKey()){

                @Override
                public String placeholderDataRequest(VotingPluginUser user, String identifier) {
                    long time = user.getTime(voteSite);
                    return "" + time;
                }

                @Override
                public String placeholderRequest(VotingPluginUser user, String identifier) {
                    String data;
                    if (this.getCacheData().containsKey(user.getJavaUUID()) && !(data = this.getCacheData().get(user.getJavaUUID())).isEmpty()) {
                        long time = Long.valueOf(data);
                        return user.voteCommandNextInfo(voteSite, time);
                    }
                    return user.voteCommandNextInfo(voteSite);
                }
            }.withDescription("How long until user can vote on " + voteSite.getKey()).updateDataKey("LastVotes"));
            this.placeholders.add(new PlaceHolder<VotingPluginUser>("Last_" + voteSite.getKey()){

                @Override
                public String placeholderRequest(VotingPluginUser user, String identifier) {
                    return user.voteCommandLastDuration(voteSite);
                }
            }.withDescription("How long ago user voted on " + voteSite.getKey()).updateDataKey("LastVotes"));
            this.placeholders.add(new PlaceHolder<VotingPluginUser>("CanVote_" + voteSite.getKey()){

                @Override
                public String placeholderRequest(VotingPluginUser user, String identifier) {
                    return "" + user.canVoteSite(voteSite);
                }
            }.withDescription("Whether or not player can vote on " + voteSite.getKey()).updateDataKey("LastVotes"));
        }
        this.placeholders.add(new PlaceHolder<VotingPluginUser>("Top_All_Position"){

            @Override
            public String placeholderRequest(VotingPluginUser user, String identifier) {
                int num = 1;
                UUID toMatch = UUID.fromString(user.getUUID());
                for (Map.Entry<TopVoterPlayer, Integer> entry : PlaceHolders.this.plugin.getTopVoter(TopVoter.AllTime).entrySet()) {
                    if (entry.getKey().getUuid().equals(toMatch)) {
                        return "" + num;
                    }
                    ++num;
                }
                return "";
            }
        }.withDescription("Get user top voter position"));
        this.placeholders.add(new PlaceHolder<VotingPluginUser>("EnoughPoints_"){

            @Override
            public String placeholderRequest(VotingPluginUser user, String identifier) {
                if (!MessageAPI.isInt(identifier.split("_")[1])) {
                    return "invalid";
                }
                int number = Integer.parseInt(identifier.split("_")[1]);
                if (user.getPoints() >= number) {
                    return "true";
                }
                return "false";
            }
        }.withDescription("Return true/false if player has said points").updateDataKey("Points").useStartsWith());
        this.nonPlayerPlaceholders.add(new NonPlayerPlaceHolder<VotingPluginUser>("Top_AllVotes_"){

            @Override
            public String placeholderRequest(String identifier) {
                int num = 1;
                int number = Integer.parseInt(identifier.split("_")[2]);
                for (Map.Entry<TopVoterPlayer, Integer> entry : PlaceHolders.this.plugin.getTopVoter(TopVoter.AllTime).entrySet()) {
                    if (num == number) {
                        return "" + entry.getValue();
                    }
                    ++num;
                }
                return "";
            }
        }.useStartsWith().withDescription("Get user votes at position in top voter"));
        this.nonPlayerPlaceholders.add(new NonPlayerPlaceHolder<VotingPluginUser>("Top_All_"){

            @Override
            public String placeholderRequest(String identifier) {
                if (!MessageAPI.isInt(identifier.split("_")[2])) {
                    return "invalid";
                }
                int num = 1;
                int number = Integer.parseInt(identifier.split("_")[2]);
                for (Map.Entry<TopVoterPlayer, Integer> entry : PlaceHolders.this.plugin.getTopVoter(TopVoter.AllTime).entrySet()) {
                    if (num == number) {
                        return entry.getKey().getPlayerName();
                    }
                    ++num;
                }
                return "";
            }
        }.useStartsWith().withDescription("Get username at postion in top voter"));
        this.placeholders.add(new PlaceHolder<VotingPluginUser>("Top_Month_Position"){

            @Override
            public String placeholderRequest(VotingPluginUser user, String identifier) {
                int num = 1;
                UUID toMatch = UUID.fromString(user.getUUID());
                for (Map.Entry<TopVoterPlayer, Integer> entry : PlaceHolders.this.plugin.getTopVoter(TopVoter.Monthly).entrySet()) {
                    if (entry.getKey().getUuid().equals(toMatch)) {
                        return "" + num;
                    }
                    ++num;
                }
                return "";
            }
        }.withDescription("Get user's current top voter position"));
        if (this.plugin.getGui().isLastMonthGUI()) {
            this.placeholders.add(new PlaceHolder<VotingPluginUser>("Top_LastMonth_Position"){

                @Override
                public String placeholderRequest(VotingPluginUser user, String identifier) {
                    int num = 1;
                    UUID toMatch = UUID.fromString(user.getUUID());
                    for (Map.Entry<TopVoterPlayer, Integer> entry : PlaceHolders.this.plugin.getLastMonthTopVoter().entrySet()) {
                        if (entry.getKey().getUuid().equals(toMatch)) {
                            return "" + num;
                        }
                        ++num;
                    }
                    return "";
                }
            }.withDescription("Get user top voter position for lastmonth"));
            this.nonPlayerPlaceholders.add(new NonPlayerPlaceHolder<VotingPluginUser>("Top_LastMonth_"){

                @Override
                public String placeholderRequest(String identifier) {
                    if (!MessageAPI.isInt(identifier.split("_")[2])) {
                        return "invalid";
                    }
                    int num = 1;
                    int number = Integer.parseInt(identifier.split("_")[2]);
                    for (Map.Entry<TopVoterPlayer, Integer> entry : PlaceHolders.this.plugin.getLastMonthTopVoter().entrySet()) {
                        if (num == number) {
                            return entry.getKey().getPlayerName();
                        }
                        ++num;
                    }
                    return "";
                }
            }.useStartsWith().withDescription("Get user at position in last month top voter"));
            this.nonPlayerPlaceholders.add(new NonPlayerPlaceHolder<VotingPluginUser>("Top_LastMonthVotes_"){

                @Override
                public String placeholderRequest(String identifier) {
                    int num = 1;
                    int number = Integer.parseInt(identifier.split("_")[2]);
                    for (Map.Entry<TopVoterPlayer, Integer> entry : PlaceHolders.this.plugin.getLastMonthTopVoter().entrySet()) {
                        if (num == number) {
                            return "" + entry.getValue();
                        }
                        ++num;
                    }
                    return "";
                }
            }.useStartsWith().withDescription("Get user votes at position in last month top voter"));
        }
        this.nonPlayerPlaceholders.add(new NonPlayerPlaceHolder<VotingPluginUser>("Top_Month_"){

            @Override
            public String placeholderRequest(String identifier) {
                if (!MessageAPI.isInt(identifier.split("_")[2])) {
                    return "invalid";
                }
                int num = 1;
                int number = Integer.parseInt(identifier.split("_")[2]);
                for (Map.Entry<TopVoterPlayer, Integer> entry : PlaceHolders.this.plugin.getTopVoter(TopVoter.Monthly).entrySet()) {
                    if (num == number) {
                        return entry.getKey().getPlayerName();
                    }
                    ++num;
                }
                return "";
            }
        }.useStartsWith().withDescription("Get username at position in top voter"));
        this.nonPlayerPlaceholders.add(new NonPlayerPlaceHolder<VotingPluginUser>("Top_MonthVotes_"){

            @Override
            public String placeholderRequest(String identifier) {
                int num = 1;
                int number = Integer.parseInt(identifier.split("_")[2]);
                for (Map.Entry<TopVoterPlayer, Integer> entry : PlaceHolders.this.plugin.getTopVoter(TopVoter.Monthly).entrySet()) {
                    if (num == number) {
                        return "" + entry.getValue();
                    }
                    ++num;
                }
                return "";
            }
        }.useStartsWith().withDescription("Get user votes at position in top voter"));
        this.placeholders.add(new PlaceHolder<VotingPluginUser>("Top_Week_Position"){

            @Override
            public String placeholderRequest(VotingPluginUser user, String identifier) {
                int num = 1;
                UUID toMatch = UUID.fromString(user.getUUID());
                for (Map.Entry<TopVoterPlayer, Integer> entry : PlaceHolders.this.plugin.getTopVoter(TopVoter.Weekly).entrySet()) {
                    if (entry.getKey().getUuid().equals(toMatch)) {
                        return "" + num;
                    }
                    ++num;
                }
                return "";
            }
        }.withDescription("Get user top voter position"));
        this.nonPlayerPlaceholders.add(new NonPlayerPlaceHolder<VotingPluginUser>("Top_Week_"){

            @Override
            public String placeholderRequest(String identifier) {
                if (!MessageAPI.isInt(identifier.split("_")[2])) {
                    return "invalid";
                }
                int num = 1;
                int number = Integer.parseInt(identifier.split("_")[2]);
                for (Map.Entry<TopVoterPlayer, Integer> entry : PlaceHolders.this.plugin.getTopVoter(TopVoter.Weekly).entrySet()) {
                    if (num == number) {
                        return entry.getKey().getPlayerName();
                    }
                    ++num;
                }
                return "";
            }
        }.useStartsWith().withDescription("Get username at postion in top voter"));
        this.nonPlayerPlaceholders.add(new NonPlayerPlaceHolder<VotingPluginUser>("Top_WeekVotes_"){

            @Override
            public String placeholderRequest(String identifier) {
                int num = 1;
                int number = Integer.parseInt(identifier.split("_")[2]);
                for (Map.Entry<TopVoterPlayer, Integer> entry : PlaceHolders.this.plugin.getTopVoter(TopVoter.Weekly).entrySet()) {
                    if (num == number) {
                        return "" + entry.getValue();
                    }
                    ++num;
                }
                return "";
            }
        }.useStartsWith().withDescription("Get user votes at position in top voter"));
        this.placeholders.add(new PlaceHolder<VotingPluginUser>("Top_Daily_Position"){

            @Override
            public String placeholderRequest(VotingPluginUser user, String identifier) {
                int num = 1;
                UUID toMatch = UUID.fromString(user.getUUID());
                for (Map.Entry<TopVoterPlayer, Integer> entry : PlaceHolders.this.plugin.getTopVoter(TopVoter.Daily).entrySet()) {
                    if (entry.getKey().getUuid().equals(toMatch)) {
                        return "" + num;
                    }
                    ++num;
                }
                return "";
            }
        }.withDescription("Get user top voter position"));
        this.nonPlayerPlaceholders.add(new NonPlayerPlaceHolder<VotingPluginUser>("Top_Daily_"){

            @Override
            public String placeholderRequest(String identifier) {
                if (!MessageAPI.isInt(identifier.split("_")[2])) {
                    return "invalid";
                }
                int num = 1;
                int number = Integer.parseInt(identifier.split("_")[2]);
                for (Map.Entry<TopVoterPlayer, Integer> entry : PlaceHolders.this.plugin.getTopVoter(TopVoter.Daily).entrySet()) {
                    if (num == number) {
                        return entry.getKey().getPlayerName();
                    }
                    ++num;
                }
                return "";
            }
        }.useStartsWith().withDescription("Get username at postion in top voter"));
        this.placeholders.add(new PlaceHolder<VotingPluginUser>("VotePartyContributedVotes"){

            @Override
            public String placeholderRequest(VotingPluginUser user, String identifier) {
                return "" + user.getVotePartyVotes();
            }
        }.useStartsWith().withDescription("See vote party placeholders contributed").updateDataKey("VotePartyVotes"));
        this.nonPlayerPlaceholders.add(new NonPlayerPlaceHolder<VotingPluginUser>("Top_DailyVotes_"){

            @Override
            public String placeholderRequest(String identifier) {
                int num = 1;
                int number = Integer.parseInt(identifier.split("_")[2]);
                for (Map.Entry<TopVoterPlayer, Integer> entry : PlaceHolders.this.plugin.getTopVoter(TopVoter.Daily).entrySet()) {
                    if (num == number) {
                        return "" + entry.getValue();
                    }
                    ++num;
                }
                return "";
            }
        }.useStartsWith().withDescription("Get user votes at position in top voter"));
        this.nonPlayerPlaceholders.add(new NonPlayerPlaceHolder<VotingPluginUser>("VotePartyVotesCurrent"){

            @Override
            public String placeholderRequest(String identifier) {
                return Integer.toString(PlaceHolders.this.plugin.getVoteParty().getTotalVotes());
            }
        }.withDescription("Current amount of voteparty votes"));
        this.nonPlayerPlaceholders.add(new NonPlayerPlaceHolder<VotingPluginUser>("VotePartyVotesNeeded"){

            @Override
            public String placeholderRequest(String identifier) {
                return Integer.toString(PlaceHolders.this.plugin.getVoteParty().getNeededVotes());
            }
        }.withDescription("Voteparty votes needed"));
        this.nonPlayerPlaceholders.add(new NonPlayerPlaceHolder<VotingPluginUser>("VotePartyVotesRequired"){

            @Override
            public String placeholderRequest(String identifier) {
                return Integer.toString(PlaceHolders.this.plugin.getVoteParty().getVotesRequired());
            }
        }.withDescription("Amount of votes needed for voteparty"));
        this.nonPlayerPlaceholders.add(new NonPlayerPlaceHolder<VotingPluginUser>("BungeeVotePartyVotesCurrent"){

            @Override
            public String placeholderRequest(String identifier) {
                if (PlaceHolders.this.plugin.getBungeeHandler() != null) {
                    return Integer.toString(PlaceHolders.this.plugin.getBungeeHandler().getBungeeVotePartyCurrent());
                }
                return "-1";
            }
        }.withDescription("Current amount of bungee voteparty votes"));
        this.nonPlayerPlaceholders.add(new NonPlayerPlaceHolder<VotingPluginUser>("BungeeVotePartyVotesNeeded"){

            @Override
            public String placeholderRequest(String identifier) {
                if (PlaceHolders.this.plugin.getBungeeHandler() != null) {
                    return Integer.toString(PlaceHolders.this.plugin.getBungeeHandler().getBungeeVotePartyRequired() - PlaceHolders.this.plugin.getBungeeHandler().getBungeeVotePartyCurrent());
                }
                return "-1";
            }
        }.withDescription("Voteparty bungee votes needed"));
        this.nonPlayerPlaceholders.add(new NonPlayerPlaceHolder<VotingPluginUser>("BungeeVotePartyVotesRequired"){

            @Override
            public String placeholderRequest(String identifier) {
                if (PlaceHolders.this.plugin.getBungeeHandler() != null) {
                    return Integer.toString(PlaceHolders.this.plugin.getBungeeHandler().getBungeeVotePartyRequired());
                }
                return "-1";
            }
        }.withDescription("Amount of votes needed for bungee  voteparty"));
        this.nonPlayerPlaceholders.add(new NonPlayerPlaceHolder<VotingPluginUser>("GlobalMonthTotal"){

            @Override
            public String placeholderRequest(String identifier) {
                int total = 0;
                for (int num : VotingPluginMain.plugin.getTopVoter(TopVoter.Monthly).values()) {
                    total += num;
                }
                return Integer.toString(total);
            }
        }.withDescription("Global month total"));
        this.nonPlayerPlaceholders.add(new NonPlayerPlaceHolder<VotingPluginUser>("GlobalAllTimeTotal"){

            @Override
            public String placeholderRequest(String identifier) {
                int total = 0;
                for (int num : VotingPluginMain.plugin.getTopVoter(TopVoter.AllTime).values()) {
                    total += num;
                }
                return Integer.toString(total);
            }
        }.withDescription("Global alltime total"));
        this.nonPlayerPlaceholders.add(new NonPlayerPlaceHolder<VotingPluginUser>("GlobalWeeklyTotal"){

            @Override
            public String placeholderRequest(String identifier) {
                int total = 0;
                for (int num : VotingPluginMain.plugin.getTopVoter(TopVoter.Weekly).values()) {
                    total += num;
                }
                return Integer.toString(total);
            }
        }.withDescription("Global weekly total"));
        this.nonPlayerPlaceholders.add(new NonPlayerPlaceHolder<VotingPluginUser>("GlobalDailyTotal"){

            @Override
            public String placeholderRequest(String identifier) {
                int total = 0;
                for (int num : VotingPluginMain.plugin.getTopVoter(TopVoter.Daily).values()) {
                    total += num;
                }
                return Integer.toString(total);
            }
        }.withDescription("Global daily total"));
        this.nonPlayerPlaceholders.add(new NonPlayerPlaceHolder<VotingPluginUser>("TimeUntilDayReset"){

            @Override
            public String placeholderRequest(String identifier) {
                LocalDateTime now = PlaceHolders.this.plugin.getTimeChecker().getTime();
                LocalDateTime offsetoclocktoday = PlaceHolders.this.plugin.getTimeChecker().getTime().withHour(0).withMinute(0);
                LocalDateTime offsetoclocktomorrow = PlaceHolders.this.plugin.getTimeChecker().getTime().plusDays(1L).withHour(0).withMinute(0);
                String timeMsg = "%hours% Hours %minutes% Minutes";
                Duration dur = null;
                dur = !now.isBefore(offsetoclocktoday) ? Duration.between(now, offsetoclocktomorrow) : Duration.between(now, offsetoclocktoday);
                int diffHours = (int)(dur.getSeconds() / 3600L);
                long diffMinutes = dur.getSeconds() / 60L - (long)(diffHours * 60);
                if (diffHours < 0) {
                    diffHours *= -1;
                }
                if (diffHours >= 24) {
                    diffHours -= 24;
                }
                if (diffMinutes < 0L) {
                    diffMinutes *= -1L;
                }
                timeMsg = MessageAPI.replaceIgnoreCase(timeMsg, "%hours%", Integer.toString(diffHours));
                timeMsg = MessageAPI.replaceIgnoreCase(timeMsg, "%minutes%", Long.toString(diffMinutes));
                return timeMsg;
            }
        }.withDescription("Time until plugin time day changes"));
        this.nonPlayerPlaceholders.add(new NonPlayerPlaceHolder<VotingPluginUser>("TimeUntilWeekReset"){

            @Override
            public String placeholderRequest(String identifier) {
                int weekNumber;
                LocalDateTime now = PlaceHolders.this.plugin.getTimeChecker().getTime().plusDays(PlaceHolders.this.plugin.getOptions().getTimeWeekOffSet());
                LocalDateTime newWeek = PlaceHolders.this.plugin.getTimeChecker().getTime().withHour(0).withMinute(0);
                TemporalField woy = WeekFields.of(Locale.getDefault()).weekOfWeekBasedYear();
                int newWeekNumber = weekNumber = newWeek.get(woy);
                while (weekNumber == newWeekNumber) {
                    newWeek = newWeek.plusDays(1L);
                    newWeekNumber = newWeek.get(woy);
                }
                String timeMsg = "%days% Days %hours% Hours %minutes% Minutes";
                Duration dur = Duration.between(now, newWeek);
                int diffDays = (int)(dur.getSeconds() / 86400L);
                int diffHours = (int)(dur.getSeconds() / 3600L - (long)(diffDays * 24));
                long diffMinutes = dur.getSeconds() / 60L - (long)(diffHours * 60) - (long)(diffDays * 24 * 60);
                if (diffHours < 0) {
                    diffHours *= -1;
                }
                if (diffHours >= 24) {
                    diffHours -= 24;
                }
                if (diffMinutes < 0L) {
                    diffMinutes *= -1L;
                }
                timeMsg = MessageAPI.replaceIgnoreCase(timeMsg, "%days%", Integer.toString(diffDays));
                timeMsg = MessageAPI.replaceIgnoreCase(timeMsg, "%hours%", Integer.toString(diffHours));
                timeMsg = MessageAPI.replaceIgnoreCase(timeMsg, "%minutes%", Long.toString(diffMinutes));
                return timeMsg;
            }
        }.withDescription("Time until plugin time week changes"));
        this.nonPlayerPlaceholders.add(new NonPlayerPlaceHolder<VotingPluginUser>("TimeUntilMonthReset"){

            @Override
            public String placeholderRequest(String identifier) {
                LocalDateTime now = PlaceHolders.this.plugin.getTimeChecker().getTime();
                LocalDateTime newMonth = PlaceHolders.this.plugin.getTimeChecker().getTime().plusMonths(1L).withDayOfMonth(1).withHour(0).withMinute(0);
                String timeMsg = "%days% Days %hours% Hours %minutes% Minutes";
                Duration dur = Duration.between(now, newMonth);
                int diffDays = (int)(dur.getSeconds() / 86400L);
                int diffHours = (int)(dur.getSeconds() / 3600L - (long)(diffDays * 24));
                long diffMinutes = dur.getSeconds() / 60L - (long)(diffHours * 60) - (long)(diffDays * 24 * 60);
                if (diffHours < 0) {
                    diffHours *= -1;
                }
                if (diffHours >= 24) {
                    diffHours -= 24;
                }
                if (diffMinutes < 0L) {
                    diffMinutes *= -1L;
                }
                timeMsg = MessageAPI.replaceIgnoreCase(timeMsg, "%days%", Integer.toString(diffDays));
                timeMsg = MessageAPI.replaceIgnoreCase(timeMsg, "%hours%", Integer.toString(diffHours));
                timeMsg = MessageAPI.replaceIgnoreCase(timeMsg, "%minutes%", Long.toString(diffMinutes));
                return timeMsg;
            }
        }.withDescription("Time until plugin time month changes"));
        HashSet<String> placeholdersSet = new HashSet<String>();
        placeholdersSet.addAll(this.plugin.getConfigFile().getCachedPlaceholders());
        if (this.getCacheLevel().equals((Object)PlaceholderCacheLevel.AUTO)) {
            placeholdersSet.addAll(this.plugin.getServerData().getAutoCachedPlaceholder());
        }
        for (String toCache : placeholdersSet) {
            if (toCache.startsWith("votingplugin")) {
                toCache = toCache.substring("votingplugin_".length());
            }
            for (NonPlayerPlaceHolder<VotingPluginUser> nonPlayerPlaceHolder : this.nonPlayerPlaceholders) {
                if (!nonPlayerPlaceHolder.matches(toCache)) continue;
                nonPlayerPlaceHolder.setUseCache(true, toCache);
                this.cachedPlaceholders.add(toCache);
                this.plugin.extraDebug("Caching placeholder " + toCache);
            }
            for (PlaceHolder placeHolder : this.placeholders) {
                if (!placeHolder.matches(toCache)) continue;
                placeHolder.setUseCache(true, toCache);
                this.cachedPlaceholders.add(toCache);
                this.plugin.extraDebug("Caching placeholder " + toCache);
            }
        }
        this.plugin.getUserManager().getUserDataChange().add(new UserDataChanged(){

            @Override
            public void onChange(AdvancedCoreUser user, String ... keys) {
                VotingPluginUser vpUser = PlaceHolders.this.plugin.getVotingPluginUserManager().getVotingPluginUser(user);
                if (!vpUser.isCached()) {
                    vpUser.dontCache();
                }
                for (PlaceHolder placeholder : PlaceHolders.this.placeholders) {
                    if (!placeholder.isUsesCache() || !placeholder.isCached(placeholder.getIdentifier(), user.getJavaUUID()) && PlaceHolders.this.getCacheLevel().onlineOnly() && !user.isOnline()) continue;
                    if (placeholder instanceof CalculatingPlaceholder) {
                        CalculatingPlaceholder cPlaceholder = (CalculatingPlaceholder)placeholder;
                        if (!placeholder.isUsesCache()) continue;
                        String[] stringArray = keys;
                        int n = stringArray.length;
                        for (int i = 0; i < n; ++i) {
                            String key = stringArray[i];
                            if (!placeholder.getUpdateDataKey().equalsIgnoreCase(key)) continue;
                            for (String ident : placeholder.getCache().keySet()) {
                                String value = placeholder.placeholderRequest(vpUser, ident);
                                cPlaceholder.getCacheData().put(user.getJavaUUID(), cPlaceholder.placeholderDataRequest(vpUser, ident));
                                placeholder.getCache().get(ident).put(vpUser.getJavaUUID(), value);
                                PlaceHolders.this.plugin.devDebug("Updated calculating placeholder cache for " + vpUser.getUUID() + " on " + key + " with " + value);
                            }
                        }
                        continue;
                    }
                    if (!placeholder.isUsesCache()) continue;
                    for (String key : keys) {
                        if (!placeholder.getUpdateDataKey().equalsIgnoreCase(key)) continue;
                        for (String ident : placeholder.getCache().keySet()) {
                            String value = placeholder.placeholderRequest(vpUser, ident);
                            placeholder.getCache().get(ident).put(vpUser.getJavaUUID(), value);
                            PlaceHolders.this.plugin.devDebug("Updated placeholder cache for " + vpUser.getUUID() + " on " + key + " with " + value);
                        }
                    }
                }
            }
        });
    }

    public void onBungeeVotePartyUpdate() {
    }

    public void onLogout(VotingPluginUser user) {
        if (this.plugin.getPlaceholders().getCacheLevel().onlineOnly()) {
            for (PlaceHolder<VotingPluginUser> placeholder : this.placeholders) {
                if (!placeholder.isUsesCache()) continue;
                placeholder.clearCachePlayer(user.getJavaUUID());
            }
        }
    }

    public void onUpdate() {
        this.checkNonCachedPlaceholders();
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.onUpdate(this.plugin.getVotingPluginUserManager().getVotingPluginUser(p), true);
        }
    }

    public void onUpdate(VotingPluginUser user, boolean login) {
        for (PlaceHolder<VotingPluginUser> placeholder : this.placeholders) {
            if (!placeholder.isUsesCache() || !placeholder.isCached(placeholder.getIdentifier(), user.getJavaUUID()) && !login) continue;
            if (placeholder instanceof CalculatingPlaceholder) {
                CalculatingPlaceholder cPlaceholder = (CalculatingPlaceholder)placeholder;
                if (!placeholder.isUsesCache()) continue;
                for (String ident : placeholder.getCache().keySet()) {
                    cPlaceholder.getCacheData().put(user.getJavaUUID(), cPlaceholder.placeholderDataRequest(user, ident));
                    placeholder.getCache().get(ident).put(user.getJavaUUID(), placeholder.placeholderRequest(user, ident));
                }
                continue;
            }
            if (!placeholder.isUsesCache()) continue;
            for (String ident : placeholder.getCache().keySet()) {
                placeholder.getCache().get(ident).put(user.getJavaUUID(), placeholder.placeholderRequest(user, ident));
            }
        }
    }

    public void onVotePartyUpdate() {
    }

    public void reload() {
        this.cacheLevel = this.plugin.getConfigFile().getPlaceholderCacheLevel();
        this.onUpdate();
        if (!this.cacheLevel.equals((Object)PlaceholderCacheLevel.NONE)) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.onUpdate(this.plugin.getVotingPluginUserManager().getVotingPluginUser(player), player.isOnline());
            }
        }
    }

    public void schedulePlaceholderCheck(final VotingPluginUser user) {
        this.plugin.getTimer().execute(new Runnable(){

            @Override
            public void run() {
                PlaceHolders.this.checkNonCachedPlaceholders();
                PlaceHolders.this.onUpdate(user, user.isOnline());
            }
        });
    }

    @Generated
    public ArrayList<NonPlayerPlaceHolder<VotingPluginUser>> getNonPlayerPlaceholders() {
        return this.nonPlayerPlaceholders;
    }

    @Generated
    public ArrayList<PlaceHolder<VotingPluginUser>> getPlaceholders() {
        return this.placeholders;
    }

    @Generated
    public PlaceholderCacheLevel getCacheLevel() {
        return this.cacheLevel;
    }
}

