/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.objects;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.item.ItemBuilder;
import com.bencodez.votingplugin.advancedcore.api.messages.PlaceholderUtils;
import com.bencodez.votingplugin.advancedcore.api.misc.MiscUtils;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardBuilder;
import com.bencodez.votingplugin.advancedcore.api.user.AdvancedCoreUser;
import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import com.bencodez.votingplugin.user.VotingPluginUser;
import java.util.ArrayList;
import java.util.HashMap;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class VoteSite {
    private String displayName;
    private boolean enabled;
    private boolean giveOffline;
    private boolean hidden;
    private boolean ignoreCanVote;
    private ConfigurationSection item;
    private String key;
    private VotingPluginMain plugin;
    private int priority;
    private String serviceSite;
    private int voteDelayDailyHour;
    private double voteDelay;
    private boolean voteDelayDaily;
    private double voteDelayMin;
    private String voteURL;
    private String permissionToView;
    private boolean waitUntilVoteDelay;

    public VoteSite(VotingPluginMain plugin, String siteName) {
        this.plugin = plugin;
        this.key = siteName.replace(".", "_");
        this.init();
    }

    public void broadcastVote(VotingPluginUser user) {
        this.broadcastVote(user, true);
    }

    public void broadcastVote(VotingPluginUser user, boolean checkBungee) {
        if (this.plugin.getConfigFile().isFormatAlternateBroadcastEnabled()) {
            return;
        }
        if (this.isHidden()) {
            this.plugin.debug("Not broadcasting for " + user.getPlayerName() + ", site is hidden");
            return;
        }
        if (!user.isVanished()) {
            String playerName = user.getPlayerName();
            if (this.plugin.getConfigFile().getVotingBroadcastBlacklist().contains(playerName)) {
                this.plugin.getLogger().info("Not broadcasting for " + playerName + ", in blacklist");
                return;
            }
            if (checkBungee && this.plugin.getBungeeSettings().isBungeeBroadcast() && this.plugin.getBungeeSettings().isUseBungeecoord()) {
                String uuid = user.getUUID();
                String service = this.getServiceSite();
                this.plugin.getBungeeHandler().getGlobalMessageHandler().sendMessage("VoteBroadcast", uuid, service);
            } else {
                String bc = MessageAPI.colorize(this.plugin.getConfigFile().getFormatBroadCastMsg());
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("player", playerName);
                placeholders.put("nickname", user.getPlayer() != null ? user.getPlayer().getDisplayName() : user.getPlayerName());
                placeholders.put("sitename", this.getDisplayName());
                placeholders.put("servicesite", this.getServiceSite());
                placeholders.put("votesrequired", "" + this.plugin.getVoteParty().getVotesRequired());
                placeholders.put("neededvotes", "" + this.plugin.getVoteParty().getNeededVotes());
                bc = PlaceholderUtils.replacePlaceHolder(bc, placeholders);
                bc = PlaceholderUtils.replacePlaceHolders(user.getOfflinePlayer(), bc);
                ArrayList<Player> players = new ArrayList<Player>();
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (this.plugin.getVotingPluginUserManager().getVotingPluginUser(p).getDisableBroadcast()) continue;
                    players.add(p);
                }
                MiscUtils.getInstance().broadcast(bc, players);
            }
        } else {
            this.plugin.debug(user.getPlayerName() + " is vanished, not broadcasting");
        }
    }

    public ItemBuilder getItem() {
        if (this.item == null) {
            this.plugin.getLogger().warning("Invalid display item section in site: " + this.key);
            return new ItemBuilder(Material.STONE, 1).setName("&cInvalid display item for site: " + this.key).setLore("&cInvalid display item for site: " + this.key);
        }
        return new ItemBuilder(this.item);
    }

    public ConfigurationSection getSiteData() {
        return this.plugin.getConfigVoteSites().getData(this.key);
    }

    public String getVoteURL() {
        return this.getVoteURL(true);
    }

    public String getVoteURL(boolean json) {
        if (!this.plugin.getConfigFile().isFormatCommandsVoteForceLinks() || !json || MessageAPI.containsJson(this.voteURL)) {
            return this.voteURL;
        }
        if (!this.voteURL.startsWith("http")) {
            return "[Text=\"" + this.voteURL + "\",url=\"http://" + this.voteURL + "\"]";
        }
        return "[Text=\"" + this.voteURL + "\",url=\"" + this.voteURL + "\"]";
    }

    public String getVoteURLJsonStrip() {
        String url = ChatColor.stripColor((String)MessageAPI.colorize(PlaceholderUtils.parseJson(this.getVoteURL(false)).toPlainText()));
        if (!url.startsWith("http")) {
            url = !url.startsWith("www.") ? "https://www." + url : "https://" + url;
        }
        return url;
    }

    public void giveRewards(VotingPluginUser user, boolean online, boolean bungee) {
        new RewardBuilder((ConfigurationSection)this.plugin.getConfigVoteSites().getData(), this.plugin.getConfigVoteSites().getEverySiteRewardPath()).setOnline(online).withPlaceHolder("ServiceSite", this.getServiceSite()).withPlaceHolder("SiteName", this.getDisplayName()).withPlaceHolder("VoteDelay", "" + this.getVoteDelay()).withPlaceHolder("VoteURL", this.getVoteURL()).setServer(bungee).send((AdvancedCoreUser)user);
        new RewardBuilder((ConfigurationSection)this.plugin.getConfigVoteSites().getData(), this.plugin.getConfigVoteSites().getRewardsPath(this.key)).setOnline(online).withPlaceHolder("ServiceSite", this.getServiceSite()).withPlaceHolder("SiteName", this.getDisplayName()).withPlaceHolder("VoteDelay", "" + this.getVoteDelay()).withPlaceHolder("VoteURL", this.getVoteURL()).setServer(bungee).send((AdvancedCoreUser)user);
    }

    public boolean hasRewards() {
        return this.plugin.getRewardHandler().hasRewards(this.plugin.getConfigVoteSites().getData(), this.plugin.getConfigVoteSites().getRewardsPath(this.key));
    }

    public void init() {
        this.setVoteURL(this.plugin.getConfigVoteSites().getVoteURL(this.key));
        this.setServiceSite(this.plugin.getConfigVoteSites().getServiceSite(this.key));
        this.setVoteDelay(this.plugin.getConfigVoteSites().getVoteDelay(this.key));
        this.setVoteDelayMin(this.plugin.getConfigVoteSites().getVoteDelayMin(this.key));
        this.setEnabled(this.plugin.getConfigVoteSites().getVoteSiteEnabled(this.key));
        this.setPriority(this.plugin.getConfigVoteSites().getPriority(this.key));
        this.displayName = this.plugin.getConfigVoteSites().getDisplayName(this.key);
        if (this.displayName == null || this.displayName.equals("")) {
            this.displayName = this.key;
        }
        this.item = this.plugin.getConfigVoteSites().getItem(this.key);
        this.voteDelayDaily = this.plugin.getConfigVoteSites().getVoteSiteResetVoteDelayDaily(this.key);
        this.giveOffline = this.plugin.getConfigVoteSites().getVoteSiteGiveOffline(this.key);
        this.waitUntilVoteDelay = this.plugin.getConfigVoteSites().getWaitUntilVoteDelay(this.key);
        this.voteDelayDailyHour = this.plugin.getConfigVoteSites().getVoteDelayDailyHour(this.key);
        this.hidden = this.plugin.getConfigVoteSites().getVoteSiteHidden(this.key);
        this.ignoreCanVote = this.plugin.getConfigVoteSites().getVoteSiteIgnoreCanVote(this.key);
        this.permissionToView = this.plugin.getConfigVoteSites().getPermissionToView(this.key);
    }

    public boolean isVaidServiceSite() {
        return ArrayUtils.containsIgnoreCase(this.plugin.getServerData().getServiceSites(), this.getServiceSite());
    }

    public String loadingDebug() {
        String str = "Loading votesite key: " + this.key;
        str = str + ", Displayname: " + this.displayName;
        str = str + ", VoteDelay: " + this.getVoteDelay();
        str = str + ", VoteDelayMin: " + this.getVoteDelayMin();
        str = str + ", VoteDelayDaily: " + this.isVoteDelayDaily();
        str = str + ", IsWaitUntilVoteDelay: " + this.isWaitUntilVoteDelay();
        str = str + ", ServiceSite: " + this.getServiceSite();
        str = str + ", VoteDelayDailyHour:" + this.getVoteDelayDailyHour();
        str = str + ", Url: " + this.getVoteURL();
        str = str + ", IgnoreCanVote: " + this.isIgnoreCanVote();
        str = str + ", Hidden: " + this.isHidden();
        return str;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public boolean isGiveOffline() {
        return this.giveOffline;
    }

    @Generated
    public void setGiveOffline(boolean giveOffline) {
        this.giveOffline = giveOffline;
    }

    @Generated
    public boolean isHidden() {
        return this.hidden;
    }

    @Generated
    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Generated
    public boolean isIgnoreCanVote() {
        return this.ignoreCanVote;
    }

    @Generated
    public void setIgnoreCanVote(boolean ignoreCanVote) {
        this.ignoreCanVote = ignoreCanVote;
    }

    @Generated
    public void setItem(ConfigurationSection item) {
        this.item = item;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public int getPriority() {
        return this.priority;
    }

    @Generated
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Generated
    public String getServiceSite() {
        return this.serviceSite;
    }

    @Generated
    public void setServiceSite(String serviceSite) {
        this.serviceSite = serviceSite;
    }

    @Generated
    public int getVoteDelayDailyHour() {
        return this.voteDelayDailyHour;
    }

    @Generated
    public void setVoteDelayDailyHour(int voteDelayDailyHour) {
        this.voteDelayDailyHour = voteDelayDailyHour;
    }

    @Generated
    public double getVoteDelay() {
        return this.voteDelay;
    }

    @Generated
    public void setVoteDelay(double voteDelay) {
        this.voteDelay = voteDelay;
    }

    @Generated
    public boolean isVoteDelayDaily() {
        return this.voteDelayDaily;
    }

    @Generated
    public void setVoteDelayDaily(boolean voteDelayDaily) {
        this.voteDelayDaily = voteDelayDaily;
    }

    @Generated
    public double getVoteDelayMin() {
        return this.voteDelayMin;
    }

    @Generated
    public void setVoteDelayMin(double voteDelayMin) {
        this.voteDelayMin = voteDelayMin;
    }

    @Generated
    public void setVoteURL(String voteURL) {
        this.voteURL = voteURL;
    }

    @Generated
    public String getPermissionToView() {
        return this.permissionToView;
    }

    @Generated
    public void setPermissionToView(String permissionToView) {
        this.permissionToView = permissionToView;
    }

    @Generated
    public boolean isWaitUntilVoteDelay() {
        return this.waitUntilVoteDelay;
    }

    @Generated
    public void setWaitUntilVoteDelay(boolean waitUntilVoteDelay) {
        this.waitUntilVoteDelay = waitUntilVoteDelay;
    }
}

