/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.listeners;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.events.PlayerVoteEvent;
import com.bencodez.votingplugin.proxy.BungeeMethod;
import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import com.vexsoftware.votifier.model.Vote;
import com.vexsoftware.votifier.model.VotifierEvent;
import java.util.ArrayList;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class VotiferEvent
implements Listener {
    private VotingPluginMain plugin;

    public VotiferEvent(VotingPluginMain plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onVotiferEvent(VotifierEvent event) {
        Vote vote = event.getVote();
        String str = vote.getServiceName();
        if (str.isEmpty()) {
            str = "Empty";
        }
        final String voteSite = str;
        String IP = vote.getAddress();
        final String voteUsername = vote.getUsername().trim();
        if (IP.equals("VotingPlugin")) {
            return;
        }
        if (voteUsername.length() == 0) {
            this.plugin.getLogger().warning("No name from vote on " + voteSite);
            return;
        }
        this.plugin.getLogger().info("Received a vote from service site '" + voteSite + "' by player '" + voteUsername + "'!");
        this.plugin.debug("PlayerUsername: " + voteUsername);
        this.plugin.debug("VoteSite: " + voteSite);
        this.plugin.debug("IP: " + IP);
        this.plugin.getVoteTimer().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    VotiferEvent.this.plugin.getServerData().addServiceSite(voteSite);
                    if (VotiferEvent.this.plugin.getBungeeSettings().isUseBungeecoord() && !VotiferEvent.this.plugin.getBungeeSettings().isVotifierBypass() && (VotiferEvent.this.plugin.getBungeeHandler().getMethod().equals((Object)BungeeMethod.PLUGINMESSAGING) || VotiferEvent.this.plugin.getBungeeHandler().getMethod().equals((Object)BungeeMethod.SOCKETS) || VotiferEvent.this.plugin.getBungeeHandler().getMethod().equals((Object)BungeeMethod.MQTT) || VotiferEvent.this.plugin.getBungeeHandler().getMethod().equals((Object)BungeeMethod.REDIS))) {
                        VotiferEvent.this.plugin.getLogger().severe("Ignoring vote from votifier since pluginmessaging, socket, redis, or mqtt bungee method is enabled, this means you aren't setup correctly for those methods, please check: https://github.com/BenCodez/VotingPlugin/wiki/Bungeecord-Setups");
                        return;
                    }
                    String matchSite = "";
                    if (VotiferEvent.this.plugin.getConfigFile().isAdvancedServiceSiteHandling() && VotiferEvent.this.plugin.getServiceSiteHandler() != null) {
                        matchSite = VotiferEvent.this.plugin.getServiceSiteHandler().matchReverse(voteSite);
                    }
                    String voteSiteNameStr = VotiferEvent.this.plugin.getVoteSiteName(false, voteSite, matchSite);
                    ArrayList<String> sites = VotiferEvent.this.plugin.getConfigVoteSites().getVoteSitesNames(false);
                    boolean createSite = false;
                    if (sites != null) {
                        if (!ArrayUtils.containsIgnoreCase(sites, voteSiteNameStr)) {
                            createSite = true;
                        }
                    } else {
                        createSite = true;
                    }
                    String serviceSite = voteSite;
                    if (VotiferEvent.this.plugin.getConfigFile().isAutoCreateVoteSites() && createSite) {
                        VotiferEvent.this.plugin.getLogger().warning("VoteSite with service site '" + voteSiteNameStr + "' does not exist, attempting to generate...");
                        VotiferEvent.this.plugin.getConfigVoteSites().generateVoteSite(voteSiteNameStr);
                        VotiferEvent.this.plugin.getLogger().info("Current known service sites: " + ArrayUtils.makeStringList(VotiferEvent.this.plugin.getServerData().getServiceSites()));
                    }
                    if (VotiferEvent.this.plugin.getTimeChecker().isActiveProcessing() && VotiferEvent.this.plugin.getConfigFile().isQueueVotesDuringTimeChange()) {
                        VotiferEvent.this.plugin.debug("Adding vote to time queue " + voteUsername + "/" + voteSite);
                        VotiferEvent.this.plugin.getTimeQueueHandler().addVote(voteUsername, voteSite);
                        return;
                    }
                    String voteSiteName = VotiferEvent.this.plugin.getVoteSiteName(true, serviceSite, matchSite);
                    PlayerVoteEvent voteEvent = new PlayerVoteEvent(VotiferEvent.this.plugin.getVoteSite(voteSiteName, true), voteUsername, voteSite, true);
                    VotiferEvent.this.plugin.getServer().getPluginManager().callEvent((Event)voteEvent);
                    if (voteEvent.isCancelled()) {
                        VotiferEvent.this.plugin.debug("Vote cancelled");
                        return;
                    }
                }
                catch (Exception e) {
                    VotiferEvent.this.plugin.getLogger().severe("Error occured during vote processing");
                    e.printStackTrace();
                }
            }
        });
    }
}

