/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.listeners;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.bedrock.BedrockNameResolver;
import com.bencodez.votingplugin.advancedcore.api.misc.PlayerManager;
import com.bencodez.votingplugin.events.PlayerPostVoteEvent;
import com.bencodez.votingplugin.events.PlayerVoteEvent;
import com.bencodez.votingplugin.listeners.BungeeVotifierEvent;
import com.bencodez.votingplugin.objects.VoteSite;
import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import com.bencodez.votingplugin.topvoter.TopVoter;
import com.bencodez.votingplugin.user.VotingPluginUser;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class PlayerVoteListener
implements Listener {
    private VotingPluginMain plugin;

    public PlayerVoteListener(VotingPluginMain plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onplayerVote(PlayerVoteEvent event) {
        Player p;
        VoteSite voteSite;
        if (!this.plugin.isEnabled()) {
            this.plugin.getLogger().warning("Plugin disabled, ignoring vote");
            return;
        }
        String playerName = event.getPlayer();
        this.plugin.debug("Processing PlayerVoteEvent: " + playerName + "/" + event.getServiceSite());
        String properName = this.plugin.getUserManager().getProperName(playerName);
        BedrockNameResolver.Result rn = this.plugin.getBedrockHandle().resolve(properName);
        String creditedName = rn.finalName;
        this.plugin.debug("Vote name resolved: " + properName + " -> " + creditedName + " (" + rn.rationale + ")");
        boolean allowUnJoinedCheckServer = this.plugin.getConfigFile().isAllowUnJoinedCheckServer();
        boolean isValid = PlayerManager.getInstance().isValidUser(creditedName, allowUnJoinedCheckServer);
        if (!isValid && !this.plugin.getConfigFile().isAllowUnjoined()) {
            this.plugin.getLogger().warning("Player " + creditedName + " has not joined before, disregarding vote. Set AllowUnjoined to true to accept.");
            if (event.isBungee() && this.plugin.getBungeeSettings().isRemoveInvalidUsers()) {
                this.plugin.getVotingPluginUserManager().getVotingPluginUser(creditedName).remove();
            }
            return;
        }
        playerName = creditedName;
        if (playerName.isEmpty()) {
            this.plugin.getLogger().warning("Empty player name from vote, ignoring");
            return;
        }
        if (event.isBungee()) {
            this.plugin.debug("BungeePlayerVote forcebungee: " + event.isForceBungee() + ", bungeetotals: " + event.getBungeeTextTotals());
            if (this.plugin.getBungeeSettings().isTriggerVotifierEvent()) {
                new BungeeVotifierEvent().send(this.plugin, event);
            }
        }
        if ((voteSite = event.getVoteSite()) == null) {
            voteSite = this.plugin.getVoteSite(this.plugin.getVoteSiteName(true, event.getServiceSite()), true);
        }
        if (voteSite == null) {
            if (!this.plugin.getConfigFile().isDisableNoServiceSiteMessage()) {
                this.plugin.getLogger().warning("No voting site with the service site: '" + event.getServiceSite() + "'");
                ArrayList<String> services = new ArrayList<String>();
                for (VoteSite site : this.plugin.getVoteSites()) {
                    services.add(site.getServiceSite());
                }
                this.plugin.getLogger().warning("Currently set service sites: " + ArrayUtils.makeStringList(services));
            }
            return;
        }
        if (!voteSite.isEnabled()) {
            this.plugin.debug("Votesite: " + voteSite.getKey() + " is not enabled");
            return;
        }
        VotingPluginUser user = null;
        user = event.getVotingPluginUser() != null ? event.getVotingPluginUser() : ((p = Bukkit.getPlayerExact((String)playerName)) != null ? this.plugin.getVotingPluginUserManager().getVotingPluginUser(p) : this.plugin.getVotingPluginUserManager().getVotingPluginUser(playerName));
        if (voteSite.isWaitUntilVoteDelay() && !user.canVoteSite(voteSite)) {
            if (!event.isRealVote()) {
                this.plugin.getLogger().info(user.getPlayerName() + " did a not real vote, bypassing WaitUntilVoteDelay");
            } else {
                if (!user.hasPermission("VotingPlugin.BypassWaitUntilVoteDelay")) {
                    this.plugin.getLogger().info(user.getPlayerName() + " must wait until votedelay is over, ignoring vote");
                    return;
                }
                this.plugin.getLogger().info(user.getPlayerName() + " has bypass permission for WaitUntilVoteDelay, bypassing");
            }
        }
        String uuid = user.getUUID();
        user.cache();
        user.updateName(true);
        this.plugin.getVoteParty().vote(user, event.isRealVote(), event.isForceBungee());
        if (!(!event.isBroadcast() || this.plugin.getBungeeSettings().isDisableBroadcast() || !this.plugin.getConfigFile().isBroadcastVotesEnabled() || !this.plugin.getBungeeSettings().isBungeeBroadcast() && event.isBungee() || this.plugin.getConfigFile().isFormatBroadcastWhenOnline() && !user.isOnline())) {
            voteSite.broadcastVote(user);
        }
        if (this.plugin.getBroadcastHandler() != null) {
            this.plugin.getBroadcastHandler().onVote(playerName);
        }
        long voteTime = 0L;
        if (event.getTime() != 0L) {
            user.setTime(voteSite, event.getTime());
            voteTime = event.getTime();
        } else {
            user.setTime(voteSite);
            voteTime = LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        }
        if (this.plugin.getConfigFile().isLogVotesToFile()) {
            try {
                this.plugin.logVote(LocalDateTime.now().atZone(ZoneId.systemDefault()).toLocalDateTime(), playerName, voteSite.getKey());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.plugin.getSpecialRewards().checkFirstVote(user, event.isForceBungee());
        this.plugin.getSpecialRewards().checkFirstVoteToday(user, event.isForceBungee());
        if (user.isReminded() && this.plugin.getConfigFile().isVoteRemindingRemindOnlyOnce()) {
            user.setReminded(false);
        }
        if ((user.isOnline() || voteSite.isGiveOffline()) && this.plugin.getOptions().isProcessRewards() || event.isBungee()) {
            boolean online = true;
            if (event.isBungee()) {
                online = event.isWasOnline();
            }
            user.playerVote(voteSite, online, false, event.isForceBungee());
            if (event.getVoteNumber() == 1) {
                user.sendVoteEffects(online);
            }
            if (this.plugin.getConfigFile().isCloseInventoryOnVote()) {
                user.closeInv();
            }
        } else if (!this.plugin.getConfigFile().isOfflineVotesLimitEnabled() || user.getNumberOfOfflineVotes(voteSite) <= this.plugin.getConfigFile().getOfflineVotesLimitAmount()) {
            user.addOfflineVote(voteSite.getKey());
            this.plugin.debug("Offline vote set for " + playerName + " (" + user.getUUID() + ") on " + voteSite.getKey());
        } else {
            this.plugin.debug("Not setting offline vote, offline vote limit reached");
        }
        if ((this.plugin.getConfigFile().isCountFakeVotes() || event.isRealVote()) && event.isAddTotals()) {
            if (this.plugin.getConfigFile().isAddTotals() && (this.plugin.getConfigFile().isAddTotalsOffline() || user.isOnline())) {
                user.addTotal();
                user.addTotalDaily();
                user.addTotalWeekly();
            }
            user.addPoints();
        }
        user.checkDayVoteStreak(event.isForceBungee());
        if (this.plugin.getConfigFile().isLimitMonthlyVotes()) {
            int value = 0;
            value = event.isBungee() ? event.getBungeeTextTotals().getMonthTotal() : user.getTotal(TopVoter.Monthly);
            LocalDateTime cTime = this.plugin.getTimeChecker().getTime();
            int days = cTime.getDayOfMonth();
            this.plugin.extraDebug("Current day of month: " + days + " Current total: " + value);
            if (value >= days * this.plugin.getVoteSitesEnabled().size()) {
                this.plugin.debug("Detected higher month total, changing. Current Total: " + value + " Days: " + days + " New Total: " + days * this.plugin.getVoteSitesEnabled().size());
                user.setTotal(TopVoter.Monthly, days * this.plugin.getVoteSitesEnabled().size());
            }
        }
        this.plugin.getSpecialRewards().checkAllSites(user, event.isForceBungee());
        this.plugin.getSpecialRewards().checkAlmostAllSites(user, event.isForceBungee());
        this.plugin.getSpecialRewards().checkCumualativeVotes(user, event.getBungeeTextTotals(), event.isForceBungee());
        this.plugin.getSpecialRewards().checkMilestone(user, event.getBungeeTextTotals(), event.isForceBungee());
        this.plugin.getCoolDownCheck().vote(user, voteSite);
        PlayerPostVoteEvent postVoteEvent = new PlayerPostVoteEvent(voteSite, user, event.isRealVote(), event.isForceBungee(), voteTime);
        this.plugin.getServer().getPluginManager().callEvent((Event)postVoteEvent);
        if (user.isOnline()) {
            this.plugin.getPlaceholders().onUpdate(user, true);
        }
        if (!user.isOnline()) {
            user.clearCache();
        }
        this.plugin.setUpdate(true);
        this.plugin.extraDebug("Finished vote processing: " + playerName + "/" + uuid);
    }
}

