/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.listeners;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.listeners.AdvancedCoreLoginEvent;
import com.bencodez.votingplugin.user.VotingPluginUser;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlayerJoinEvent
implements Listener {
    private VotingPluginMain plugin;

    public PlayerJoinEvent(VotingPluginMain plugin) {
        this.plugin = plugin;
    }

    private void login(Player player) {
        VotingPluginUser user = this.plugin.getVotingPluginUserManager().getVotingPluginUser(player);
        if (player.isOp() && this.plugin.isYmlError()) {
            user.sendMessage("&cVotingPlugin: Detected yml error, please check console for details");
        }
        boolean data = user.getData().hasData();
        user.loginMessage();
        if (data) {
            user.offVote();
        } else {
            this.plugin.debug("No data detected for " + player.getUniqueId().toString() + "/" + player.getName());
        }
        user.loginRewards();
        this.plugin.getPlaceholders().onUpdate(user, true);
        if (this.plugin.getBungeeSettings().isUseBungeecoord()) {
            this.plugin.getBungeeHandler().getGlobalMessageHandler().sendMessage("Login", user.getPlayerName(), user.getUUID(), this.plugin.getBungeeSettings().getServer());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerLogin(AdvancedCoreLoginEvent event) {
        if (event.getPlayer() == null || !this.plugin.isMySQLOkay()) {
            return;
        }
        this.login(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (this.plugin != null && this.plugin.isEnabled()) {
            final Player player = event.getPlayer();
            this.plugin.getLoginTimer().execute(new Runnable(){

                @Override
                public void run() {
                    VotingPluginMain.plugin.getAdvancedTab().remove(player.getUniqueId());
                    VotingPluginUser user = PlayerJoinEvent.this.plugin.getVotingPluginUserManager().getVotingPluginUser(player);
                    user.dontCache();
                    user.logoutRewards();
                    PlayerJoinEvent.this.plugin.getPlaceholders().onLogout(user);
                }
            });
        }
    }
}

