/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.listeners;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.misc.PlayerManager;
import com.bencodez.votingplugin.signs.SignHandler;
import com.bencodez.votingplugin.simpleapi.player.PlayerUtils;
import org.bukkit.block.Sign;
import org.bukkit.block.Skull;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;

public class PlayerInteract
implements Listener {
    private VotingPluginMain plugin;

    public PlayerInteract(VotingPluginMain plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (this.plugin.getConfigFile().isDisableInteractEvent()) {
            return;
        }
        if (this.plugin.getSigns().getSigns().size() > 0) {
            Player player = event.getPlayer();
            if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
                Object ob;
                if (event.getClickedBlock().getState() instanceof Sign) {
                    for (SignHandler sign : this.plugin.getSigns().getSigns()) {
                        if (!sign.isLocationSame(event.getClickedBlock().getLocation())) continue;
                        this.plugin.getVotingPluginUserManager().getVotingPluginUser(player).sendMessage(sign.getRightClickMessage());
                        if (sign.isSkullSet() || !PlayerManager.getInstance().hasServerPermission(event.getPlayer().getName(), "VotingPlugin.Sign.Create") && !PlayerManager.getInstance().hasServerPermission(event.getPlayer().getName(), "VotingPlugin.Admin")) continue;
                        player.sendMessage("Skull not set, click to set skull");
                        PlayerUtils.setPlayerMeta(this.plugin, player, "skullset", sign.getSign());
                    }
                } else if (event.getClickedBlock().getState() instanceof Skull && (ob = PlayerUtils.getPlayerMeta(this.plugin, player, "skullset")) != null) {
                    String sign1 = (String)ob;
                    for (SignHandler sign : this.plugin.getSigns().getSigns()) {
                        if (!sign.getSign().equals(sign1)) continue;
                        sign.setSkullLocation(event.getClickedBlock().getLocation());
                        sign.storeSign();
                        sign.checkSkulls();
                        player.sendMessage("Skull set");
                    }
                    PlayerUtils.setPlayerMeta(this.plugin, player, "skullset", null);
                }
            }
        }
    }
}

